	subroutine addSource
	implicit integer (a-z)
c++
c	subroutine addSource
c
c  Adds new source definition to tables, replacing any source
c  that is defined.
c--
	call deleteSource
	call new_record ('SRC',0,0)
	return
	end

	subroutine addOe (req_oe,oe)
	implicit integer (a-z)
c++
c	subroutine addOe (req_oe,oe)
c
c  this adds a new optical element at the position specified
c  if the optical element exists then all the optical elements
c  are moved up one position and the element is inserted with the
c  specified number
c
c  if the user specified zero or an oe that doesn't exist it is put
c  at the end of the sequence
c
c	req_oe		- input/integer
c			  where to place OE in the oe sequence
c
c	oe		- actual position assigned
c--
c
c  does the specified oe exist ?
c
	call lastone (0,number)
	if (req_oe .lt. 1 .or. req_oe .gt. number) then
c
c  this is being added at the end
c
	  oe=number+1
	  call new_record ('OE',oe,0)
	else
c
c  relocate the existing OE to create a gap
c
	  do i=number,req_oe,-1
	    call renumberOe (i,i+1)
	  enddo
	  call new_record ('OE',req_oe,0)
	  oe=req_oe
	endif
c
	return
	end

	subroutine addScr (oe,req_scr,scr)
	implicit integer (a-z)
c++
c	subroutine addScr (oe,req_scr,scr)
c
c  this adds a new screen for a given optical element at the position
c  specified.  If the screen already exists then the other screens are
c  moved down in order to make room.  If the optical element specified
c  does not exist it is considered a fatal error.
c
c  if the user specified zero or a screen that doesn't exist it is put
c  at the end of the sequence
c
c	oe		- input/integer
c			  where to place OE in the oe sequence
c	req_scr		- input/integer
c			  where to place SCR in the scr sequence
c
c	scr		- output/integer
c			  position actually assigned to screen
c--
c
c  does the specified oe exist ?
c
	call lastone (oe,number)
	if (req_scr .lt. 1 .or. req_scr .gt. number) then
c
c  this is being added at the end of the screens for this oe
c
	  scr=number+1
	  call new_record ('SCR',oe,scr)
	else
c
c  relocate the existing screens to create a gap
c
	  do i=number,req_scr,-1
	    call renumberScr (oe,i,i+1)
	  enddo
	  call new_record ('SCR',oe,req_scr)
	  scr=req_scr
	endif
c
	return
	end

	subroutine deleteAllOe
	implicit integer (a-z)
c++
c	subroutine deleteAllOe
c
c  deletes all optical elements and their screens
c
c--
	call nl_delete_wild ('OE',' ',-1,-1)
	call nl_delete_wild ('SCR',' ',-1,-1)
	return
	end

	subroutine deleteOe (oe)
	implicit integer (a-z)
c++
c	subroutine deleteOe (oe)
c
c  deletes an optical element and all associated screens
c
c	oe	- input/integer
c		  number of oe to be deleted
c--
c
c  does this sucker exist
c
	call lastone (0,number)
	if (oe .gt. 0 .and. oe .le. number) then
c
c  delete this particular element
c
	  call nl_delete_wild ('OE',' ',oe,-1)
	  call nl_delete_wild ('SCR',' ',oe,-1)
c
c  renumber all the ones following
c
	  do i=oe+1,number
	    call renumberOe (i,i-1)
	  enddo
	endif
	return
	end

	subroutine deleteScr (oe,scr)
	implicit integer (a-z)
c++
c	subroutine deleteScr (oe,scr)
c
c  deletes screen belonging to an optical element
c  it also renumbers all screens that follow for that optical element
c
c	oe		- input/integer
c			  optical element
c
c	scr		- input/integer
c			  screen
c--
c
	call lastone (oe,number)
	if (scr .gt. 0 .and. scr .le. number) then
	  call nl_delete_wild ('SCR',' ',oe,scr)
	  do i=scr+1,number
	    call renumberScr (oe,i,i-1)
	  enddo
	endif
	return
	end

	subroutine deleteSource
	implicit integer (a-z)
c++
c	subroutine deleteSource
c
c  deletes all source data
c
c--
	call nl_delete_wild ('SRC',' ',-1,-1)
	return
	end

	subroutine renumberOe (old_oe,new_oe)
	implicit integer (a-z)
c++
c	subroutine renumberOe (old_oe,new_oe)
c
c  Renumber an oe.  Assumes that new oe does not yet exist.  Doesn't
c  worry about clobbering anything.
c
c	old_oe		- input/integer
c			  old oe number
c
c	new_oe		- input/integer
c			  new oe number
c--
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "nldata.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'nldata.inc'
#endif
c
c  find all optical element data for the old oe
c  then change the owner1 field
c
	key=0
 10	call nl_find (key,'OE',' ',old_oe,-1)
	if (key .eq. 0) goto 20
	nl_own1=new_oe
	call nl_pack (key)
	goto 10
c
c  change the special field OE_NUMBER whose Value is the oe number
c
 20	call store_i ('OE','OE_NUMBER',new_oe,0,new_oe)
c
c  find all screen data and renumber it by changing
c  the owner1 field
c
	key=0
 25	call nl_find (key,'SCR',' ',old_oe,-1)
	if (key .eq. 0) goto 30
	nl_own1=new_oe
	call nl_pack (key)
	goto 25
c
 30	return
	end

	subroutine renumberScr (oe,old_scr,new_scr)
	implicit integer (a-z)
c++
c	subroutine renumberScr (oe,old_scr,new_scr)
c
c  Renumber the screens for a given optical element.
c  Assumes the program has checked to avoid collisions
c  Can only change screen numbers, not oe and screen numbers together
c
c	oe		- input/integer
c			  optical element number
c
c	old_scr		- input/integer
c			  old screen number
c
c	new_scr		- input/integer
c			  new screen number
c--
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "nldata.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'nldata.inc'
#endif
c
c  find the records that have to be changed
c  change them by changing the owner2 field
c
	key=0
 10	call nl_find (key,'SCR',' ',oe,old_scr)
	if (key .eq. 0) goto 20
	nl_own2=new_scr
	call nl_pack (key)
	goto 10
c
c  change the variable SCR_NUMBER whose Value is the screen number
c
 20	call store_i ('SCR','SCR_NUMBER',oe,new_scr,new_scr)
	return
	end

	subroutine LastOne (oe,number)
	implicit integer (a-z)
c++
c	subroutine LastOne (oe,number)
c
c  Find out the highest numbered optical element (or screen) in use.
c
c	oe		- input/integer
c			  if zero then find highest oe
c			  if non-zero find highest numbered screen for
c				that oe
c
c	number		- output/integer
c			  highest one found or zero if not found
c--
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "nldata.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'nldata.inc'
#endif
c
c  assume failure
c
	number=0
c
c  oe or screen search
c
	if (oe .eq. 0) then
	  key=0
 10	  call nl_find (key,'OE','OE_NUMBER',-1,-1)
	  if (key .eq. 0) goto 90
	  number=max (number,nl_own1)
	  goto 10
	else
	  key=0
 20	  call nl_find (key,'SCR','SCR_NUMBER',oe,-1)
	  if (key .eq. 0) goto 90
	  number=max (number,nl_own2)
	  goto 20
	endif
c
 90	return
	end

	subroutine new_record (record_type,req_own1,req_own2)
	implicit integer (a-z)
c++
c	subroutine new_record (record_type,req_own1,req_own2)
c
c--
#if defined(unix) || HAVE_F77_CPP
#       include "io.inc"
#elif defined(vms)
	include 'io.inc'
#endif
c
	character*(*) record_type
c
	rewind (unit=menu_unit)
	call new_record1 (record_type,req_own1,req_own2)
	return
	end

