C +++
C
C Source: src/source/id/undul_cdf.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	undul_cdf.F
C Revision 1.9  92/02/11  21:28:01  khan
C unroll read/write implicit loops and what not ...
C 
C Revision 1.8  1992/02/11  14:07:59  cwelnak
C loop unrolling attempt
C
C Revision 1.7  92/01/22  21:35:01  cwelnak
C VMS devel changes/B. Lai
C 
C Revision 1.6  1992/01/21  17:29:17  cwelnak
C 6000 changes
C
C Revision 1.5  91/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C 
C Revision 1.4  90/10/30  00:01:44  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.3  90/07/18  19:40:16  khan
C Using Unix environment variable SHADOW_ENV_FILE and others to communicate
C with the shell script. 
C 
C Revision 1.2  90/07/17  23:08:25  khan
C Fix File OPEN=NEW to UNKNOWN for Unix.
C Replace the use of VMS LOGICALS to communicate with the driver script
C with "known" exit codes. Depending on the particular exit code, the
C driver (make_id, undul, etc) takes appropriate action. Caveat is,
C of course, that the exit code used in the programs MUST be kept the
C same as the ones used in the driver scripts.
C 
C Revision 1.1  90/07/17  15:36:37  khan
C Initial revision
C 
C 
C ---


C+++
C
C	PROGRAM		UNDUL_CDF
C
C	PURPOSE		This is the main calling program to
C			a) read in the # of photon
C			b) build the CDFs
C			c) invert the CDFs or write them out
C
C---
	PROGRAM		UNDUL_CDF
	IMPLICIT	REAL*8	(A-H,O-Z)
C
#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif


C
C For unix, we cannot set symbol for the parent process to communicate
C as in VMS, so we pull the classic BSD kludge of writing the environment
C strings to a temporary file and then source'ing the file in the driver
C to script to export to the parent environment. The temporary file is
C given by SHADOW_ENV_FILE environment variable, and must be set before
C this program is called. This is usually set in the driver script that
C calls this program.
C
#ifndef vms
	CHARACTER*133	ENV_FILE
#endif
C
	NAMELIST	/PARAIN/	NCOMP,RCURR,ICOMP,BPASS,
     $					IANGLE,IAPERTURE,IEXTERNAL,
     $					FOUT,FIN,FTRAJ,EMIN,EMAX,
     $					THEMIN,THEMAX,PHIMIN,PHIMAX,
     $					NE,NT,NP,NCHECK,IOPT,ITER,IPASS,
     $					I_EDIV,EDIVX,EDIVY,FINT,IINT

	DIMENSION	UPHI(31,31,51),UTHETA(31,51),UENER(51)
	DIMENSION	RN0(31,31,51),RN1(31,51),RN2(51)
	DIMENSION	POL_DEG(31,31,51)
	DIMENSION	CDF0(31,31,51),CDF1(31,51),CDF2(51)
	DIMENSION	APHI(31,31,51),ATHETA(31,51),AENER(51)

C
C Read in the parameters from namelist file
C
#ifdef vms
	OPEN	(21, FILE='UPHOT.PAR', STATUS='OLD', READONLY)
#else
	OPEN	(21, FILE='uphot.par', STATUS='OLD')
#endif
	READ	(21, NML=PARAIN)
	CLOSE	(21)
C
C Read in the arrays
C
#ifdef vms
	OPEN	(40, FILE='UPHOT.DAT', STATUS='OLD', FORM='UNFORMATTED',
     $		READONLY)
#else
	OPEN	(40, FILE='uphot.dat', STATUS='OLD', FORM='UNFORMATTED')
#endif
	READ	(40)	NE, NT, NP

	DO 99 K = 1, NE
 99	    READ (40)	UENER(K)

	DO 199 K = 1, NE
	    DO 199 J = 1, NT
 199		READ (40) UTHETA(J,K)

	DO 299 K = 1, NE
	    DO 299 J = 1, NT
		DO 299 I = 1, NP
 299		    READ (40) UPHI(I,J,K)

  
D	READ	(40)	(UENER(K), K = 1, NE)
D	READ	(40)	((UTHETA(J,K), J = 1, NT), K = 1, NE)
D	READ	(40)	(((UPHI(I,J,K), I = 1, NP), J = 1, NT), K = 1, NE)

	DO 399 K = 1, NE
	    DO 399 J = 1, NT
		DO 399 I = 1, NP
 399		    READ (40) RN0(I,J,K)

D	READ	(40)	(((RN0(I,J,K), I = 1, NP), J = 1, NT), K = 1, NE)

	DO 499 K = 1, NE
	    DO 499 J = 1, NT
		DO 499 I = 1, NP
 499		    READ (40) POL_DEG(I,J,K)

D	READ	(40)	(((POL_DEG(I,J,K), I = 1, NP), J = 1, NT), K = 1, NE)
	CLOSE	(40)
C
C Integrate RN0 to get RN1 and RN2
C		
	CALL	RNS	(RN0,RN1,RN2,UPHI,UTHETA,UENER)
C
C Generate the 3 CDFs
C
	CALL	UCDF	(RN0,RN1,RN2,CDF0,CDF1,CDF2,UPHI,UTHETA,UENER)
C
C Check if the user want to write out RNs
C
	IF (IPASS.EQ.0) THEN
	  CALL	UWRITE	(RN0,RN1,RN2,POL_DEG,CDF0,CDF1,CDF2,
     $			UPHI,UTHETA,UENER)
C
C See if the no. of times of optimization is finished
C
	  IF (ITER.EQ.IOPT)	THEN
#ifdef vms
	    IRET	= LIB$SET_SYMBOL ('FINISH','YES')
#else
C
C Write the environment strings to a file, so the driver script can source
C it. If tset can use this kludge, so can I. 
C                       **GROSS HACK ALERT**
C
	    CALL GETENV ('SHADOW_ENV_FILE', ENV_FILE)
	    IF (ENV_FILE(1:10).EQ.'          ') THEN
		WRITE (*,*) 
     $         'UNDUL_CDF: Must set SHADOW_ENV_FILE environment string'
		CALL EXIT (1)
	    ENDIF
	    OPEN (11, FILE=ENV_FILE, STATUS='UNKNOWN')
	    REWIND (11)
	    WRITE (11,*) 'setenv FINISH YES'
	    CLOSE (11)
#endif
	
	    CALL EXIT (0)
	  END IF
	END IF
C
C Invert the CDFs so that they are equal space in probability (Y-axis). A new 
C set of (energy, theta, phi) is created.
C
	  CALL	UINVERT	
     $		  (CDF0,CDF1,CDF2,UPHI,UTHETA,UENER,APHI,ATHETA,AENER)

     	 IF (IPASS.EQ.0) THEN
	  DO 115 K = 1, NE
	    UENER(K)		= AENER(K)
	    DO 115 J = 1, NT
	      UTHETA(J,K)	= ATHETA(J,K)
	      DO 115 I = 1, NP
		UPHI(I,J,K)	= APHI(I,J,K)
115	  CONTINUE
     	  IPASS = IPASS + 1
     	 ELSE IF (IPASS.EQ.1) THEN
	  DO 125 K = 1, NE
	    DO 125 J = 1, NT
	      UTHETA(J,K)	= ATHETA(J,K)
	      DO 125 I = 1, NP
		UPHI(I,J,K)	= APHI(I,J,K)
125 	  CONTINUE
     	  IPASS = IPASS + 1
     	 ELSE IF (IPASS.EQ.2) THEN
	  DO 135 K = 1, NE
	    DO 135 J = 1, NT
	      DO 135 I = 1, NP
		UPHI(I,J,K)	= APHI(I,J,K)
135 	  CONTINUE
     	   IPASS = 0
	   ITER = ITER + 1
     	 END IF
C
C Write the new (energy, theta, phi) array
C
#ifdef vms
	OPEN	(45, FILE='UPHOT.DAT', STATUS='NEW', 
     $		FORM='UNFORMATTED')
#else
	OPEN	(45, FILE='uphot.dat', STATUS='UNKNOWN', 
     $		FORM='UNFORMATTED')
	REWIND	(45)
#endif
	WRITE	(45)	NE, NT, NP
D	WRITE	(45)	(UENER(K), K = 1, NE)
D	WRITE	(45)	((UTHETA(J,K), J = 1, NT), K = 1, NE)
D	WRITE	(45)	(((UPHI(I,J,K), I = 1, NP), J = 1, NT), K = 1, NE)

	DO 599 K = 1, NE
 599	    WRITE (45)	UENER(K)

	DO 699 K = 1, NE
	    DO 699 J = 1, NT
 699		WRITE (45) UTHETA(J,K)

	DO 799 K = 1, NE
	    DO 799 J = 1, NT
		DO 799 I = 1, NP
 799		    WRITE (45) UPHI(I,J,K)

	CLOSE	(45)
C
C Write out the parameters to namelist file
C
#ifdef vms
	OPEN	(31, FILE='UPHOT.PAR', STATUS='NEW')
#else
	OPEN	(31, FILE='uphot.par', STATUS='UNKNOWN')
	REWIND	(31)
#endif
	WRITE	(31, NML=PARAIN)
	CLOSE	(31)

	END
