C +++
C
C Source: src/lib/message.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: message.F
C Revision 1.7  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.6  91/04/05  13:54:28  cwelnak
C changed quotes on #include
C 
C Revision 1.5  91/03/25  10:29:17  cwelnak
C SUN version - INC to #inc
C 
C Revision 1.4  90/11/13  14:04:57  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/20  22:05:14  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.2  90/07/15  15:31:03  khan
C All public include files (common.blk, etc) are now in ./../../include dir.
C 
C Revision 1.1  90/07/10  14:56:30  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	MSSG	(TEXT1,TEXT2,IFLAG)
C
C	PURPOSE		Outputs an error message to the screen and
C			to a file
C
C	ARGUEMNTS	TEXT1 : Tipically, the calling routine name
C			TEXT2 : A file name, or a message
C			TEXT3 : A flag or an IOSTAT value.
C
C---
     	SUBROUTINE	MSSG (T1, T2, IFLAG)
     	CHARACTER *(*)	T1, T2
     	WRITE(6,*)'SHADOW-E-Error: '
     	WRITE(6,*)'Module     : ', T1
     	WRITE(6,*)'Message    : ', T2
     	WRITE(6,*)'Error flag : ', IFLAG
     	WRITE (33, 100) T1(1:IBLANK(T1))
     	WRITE (33, 100) T2(1:IBLANK(T2))
     	WRITE (33, 110) IFLAG
100	FORMAT (1X,'>',A)
110	FORMAT (1X,I5)
     	RETURN
     	END
