C +++
C
C Source: src/utils/post/graphics/old-graphics/plotspace.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	plotspace.F
C  Revision 1.1  91/03/11  13:08:20  v_white
C  Initial revision
C Revision 1.2  91/01/25  16:47:34  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:44  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		PLOTSPACE
C
C	PURPOSE		To generate a plottable file from any two or 
C			three rows of unformatted data.
C
C	Link using GRA:GRALIB.LNK or GRA:TDSHARE.LNK
C---
     	PROGRAM 	PREPLOT
	IMPLICIT        REAL*8          (A-E,G-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
C
C CHECK/FIXME:
C The X and Y vectors need to "REAL" for VMS for the Topdrawer calls,
C but REAL*8 for Unix and the rest of the civilized world.
C
	REAL		X, X1, Z, Z1
#endif
C
     	REAL*8		RAY(18,N_DIM)
	DIMENSION	X(N_DIM),X1(N_DIM)
	DIMENSION	Z(N_DIM),Z1(N_DIM),TEST(4)
     	CHARACTER*80 	FILEIN,FILEOUT
	CHARACTER*16	TITLE1, TITLE2, TITLE3, TITLE4
     	INTEGER		CHECK
     	LOGICAL		LTEST
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	CHARACTER*80	RSTRING
     	EXTERNAL	RSTRING

#ifndef vms
	CHARACTER*1024	PRIMVS
	CHARACTER*1024	PRIMVSPATH
#endif
C
     	FILEIN	=   RSTRING ('PREPLOT> Input file ? ')
     	CALL	RBEAM18	(FILEIN,RAY,NCOL,NPOINT,IFLAG,IERR)
        IF (IERR.NE.0)	THEN
         STOP 'Error in reading input ray file.'
	ELSE
	 WRITE(6,*)'Read         ',NPOINT,' rays.'
	 WRITE(6,*)'Each ray has ',NCOL,' entries.'
	END IF
	WRITE(6,*)'Options --- Enter'
     	WRITE(6,*)'0 for excluding the losses'
     	WRITE(6,*)'1 for including losses at a particular O.E.'
     	WRITE(6,*)'2 for plotting all the rays .'
     	WRITE(6,*)'3 for plotting ONLY the losses (all of them)'
     	WRITE(6,*)'4 for plotting ONLY the losses at a given O.E.'
	KLOSS	=   IRINT ('PREPLOT> Then ? ')
     	IF (KLOSS.EQ.1.OR.KLOSS.EQ.4) THEN
     	CHECK = 
     $IRINT ('Flag value ( -11000 first O.E., -22000 sec O.E., etc.) ?')
     	ELSE
     	END IF
C
       KOUNT	=   0
     	DO 11 I=1,NPOINT
     	IF (RAY(10,I).LT.0.0) KOUNT = KOUNT + 1
11     	CONTINUE
c  100     CONTINUE
     	WRITE(6,*)'***********'
	WRITE(6,*)'Found ',(NPOINT-KOUNT),' good points out of',NPOINT
C
C Give the user the choice of phase space to plot
C
	WRITE(6,*) 'Please specify the phase space to plot:'
	WRITE(6,*) 'for     X - Z   enter 0'
	WRITE(6,*) '        X - Y         1'
	WRITE(6,*) '        Y - Z         2'
	IPHASE = IRINT ('Phase space: ')
	IF (IPHASE.EQ.0) THEN
	  KX	= 1
	  KX1	= 4
	  KY	= 3
	  KY1	= 6
#if !defined (vms)
	  TITLE1 = 'X vs Z'
	  TITLE2 = 'X vs Xprime'
	  TITLE3 = 'Zprime vs Z'
	  TITLE4 = 'Zprime vs Xprime'
#endif
	ELSE IF (IPHASE.EQ.1) THEN
	  KX	= 1
	  KX1	= 4
	  KY	= 2
	  KY1	= 5
#if !defined (vms)
	  TITLE1 = 'X vs Y'
	  TITLE2 = 'X vs Xprime'
	  TITLE3 = 'Yprime vs Y'
	  TITLE4 = 'Yprime vs Xprime'
#endif
	ELSE IF (IPHASE.EQ.2) THEN
	  KX	= 2
	  KX1	= 5
	  KY	= 3
	  KY1	= 6
#if !defined (vms)
	  TITLE1 = 'Y vs Z'
	  TITLE2 = 'Y vs Yprime'
	  TITLE3 = 'Zprime vs Z'
	  TITLE4 = 'Zprime vs Yprime'
#endif
	END IF
	  
	NOUT	= 0
     	DO 300 I=1,NPOINT
	 IF (KLOSS.EQ.0) THEN
	  IF (RAY(10,I).LT.0.0D0)   GO TO 300
	 ELSE IF (KLOSS.EQ.1) THEN
     	  IF (RAY(10,I).LT.0.0D0.AND.NINT(RAY(10,I)).NE.CHECK) GO TO 300
          ELSE IF (KLOSS.EQ.3) THEN
           IF (RAY(10,I).GE.0.0D0) GO TO 300
	  ELSE IF (KLOSS.EQ.4) THEN
	   IF (RAY(10,I).LT.0.0D0.AND.NINT(RAY(10,I)).EQ.CHECK) THEN
           ELSE 
           GO TO 300
     	   END IF
     	 ELSE
     	 END IF
	NOUT	= NOUT + 1
	X(NOUT)	= RAY(KX,I)
	X1(NOUT)	= RAY(KX1,I)
	Z(NOUT)	= RAY(KY,I)
	Z1(NOUT)	= RAY(KY1,I)
300     CONTINUE

     	WRITE(6,*)'Read ',NOUT,' good rays. Plot all ? '
     	IPLOT = IYES ('> ')

     	IF (IPLOT.NE.1) THEN
     	  NOUT = IRINT ('Plot how many rays? ')
     	END IF
#if defined(vms)
	WRITE(6,*) 'Enter 0 to save to file (TopDrawer)'
	WRITE(6,*) '      1 to plot to screen'
	WRITE(6,*) '      2 for both'
	ISAVE = IRINT('> ')
	IF (ISAVE.EQ.0.OR.ISAVE.EQ.2) THEN
	  FILEOUT = RSTRING('Output file: ')
	  OPEN(22,FILE=FILEOUT,STATUS='NEW')
	  WRITE(22,*) 'LABELS ALL OFF BOTTOM ON LEFT ON; '
	  WRITE(22,*) 'TICKS SIZE 0.04; '
	  WRITE(22,*) 'WINDOW X 1 5 Y 1 5; '
	  DO 220 I = 1, NOUT
	    IF (MOD(I,1000).EQ.0)     WRITE   (22,*)  'PLOT'
	    WRITE(22,*) X(I),Z(I)
220	  CONTINUE
 	  WRITE(22,*) 'PLOT'
	  WRITE(22,*) 'LABELS ALL OFF LEFT ON TOP ON; '
	  WRITE(22,*) 'TICKS SIZE 0.04; '
	  WRITE(22,*) 'WINDOW X 1 5 Y 5 9; '
	  DO 230 I = 1, NOUT
	    IF (MOD(I,1000).EQ.0) WRITE   (22,*) 'PLOT'
	    WRITE(22,*) X(I),X1(I)
230       CONTINUE
          WRITE(22,*) 'PLOT'
	  WRITE(22,*) 'LABELS ALL OFF BOTTOM ON RIGHT ON; '
	  WRITE(22,*) 'TICKS SIZE 0.04; '
	  WRITE(22,*) 'WINDOW X 5 9 Y 1 5; '
	  DO 240 I = 1, NOUT
	    IF (MOD(I,1000).EQ.0)     WRITE   (22,*)  'PLOT'
	    WRITE(22,*) Z1(I),Z(I)
240 	  CONTINUE
          WRITE(22,*) 'PLOT'
	  WRITE(22,*) 'LABELS ALL OFF TOP ON RIGHT ON; '
	  WRITE(22,*) 'TICKS SIZE 0.04; '
	  WRITE(22,*) 'WINDOW X 5 9 Y 5 9; '
	  DO 250 I = 1, NOUT
	    IF (MOD(I,1000).EQ.0)     WRITE   (22,*)  'PLOT'
	    WRITE(22,*) Z1(I),X1(I)
250 	  CONTINUE
	  WRITE(22,*) 'PLOT'
          WRITE(22,*) 'END'
	ENDIF
#else

C
        WRITE(6,*) 'Display type:'
#if HAVE_XWINDOWS
	WRITE(6,*) '  [ 0 ] Xwindow'
#endif
	WRITE(6,*) '  [ 1 ] Tektronix'
	WRITE(6,*) '  [ 2 ] Postscript file'
	ITERM = IRINT ('Terminal type:  ')
#if !HAVE_XWINDOWS
	IF (ITERM.EQ.0) THEN
	    WRITE (*,*) 'No X Windows support. Using Postscript file'
	    ITERM=2
	ENDIF
#endif
	IF (ITERM.LT.0 .OR. ITERM.GT.2) THEN
	    WRITE (*,*) 'Invalid device Id. Using Postscript file'
	    ITERM=2
	ENDIF
C
C find plot limits for primvs
C
        XMIN = 1.0E20
	XMAX = -1.0E20
        X1MIN = 1.0E20
	X1MAX = -1.0E20
	ZMIN = 1.0E20
	ZMAX = -1.0E20
	Z1MIN = 1.0E20
	Z1MAX = -1.0E20
	DO 1019 I = 1,NOUT
	  TEST(1) = X(I)
	  TEST(2) = X1(I)
	  TEST(3) = Z(I)
	  TEST(4) = Z1(I)
	  XMIN = MIN(XMIN,TEST(1))
	  XMAX = MAX(XMAX,TEST(1))
	  X1MIN = MIN(X1MIN,TEST(2))
	  X1MAX = MAX(X1MAX,TEST(2))
	  ZMIN = MIN(ZMIN,TEST(3))
	  ZMAX = MAX(ZMAX,TEST(3))
	  Z1MIN = MIN(Z1MIN,TEST(4))
	  Z1MAX = MAX(Z1MAX,TEST(4))
1019 	CONTINUE
	DELX = XMAX - XMIN
	DELX1 = X1MAX - X1MIN
	DELZ = ZMAX - ZMIN
	DELZ1 = Z1MAX - Z1MIN
	XCEN = (XMAX + XMIN)/2.0
	X1CEN = (X1MAX + X1MIN)/2.0
        ZCEN = (ZMAX + ZMIN)/2.0
        Z1CEN = (Z1MAX + Z1MIN)/2.0
	XLOW = XCEN - 0.6125*DELX
    	XUPP = XCEN + 0.6125*DELX
	X1LOW = X1CEN - 0.6125*DELX1
    	X1UPP = X1CEN + 0.6125*DELX1
	ZLOW = ZCEN - 0.6125*DELZ
	ZUPP = ZCEN + 0.6125*DELZ
	Z1LOW = Z1CEN - 0.6125*DELZ1
	Z1UPP = Z1CEN + 0.6125*DELZ1
#endif

C
C Ready for output.
C
C
#if defined(vms)
	IF (ISAVE.EQ.1.OR.ISAVE.EQ.2) THEN
	  CALL	SET_SCREEN	('PREPLOT>',0,ITERM)
C
	  CALL TDNEWP
     	  CALL TDSET (%REF('LABELS ALL OFF BOTTOM ON LEFT ON; '))
     	  CALL TDSET (%REF('TICKS SIZE 0.04; '))

     	  CALL TDSET (%REF('WINDOW X 1 5 Y 1 5; '))
	  CALL TDPLOT (NOUT,X,Z)
     	  CALL TDSET (%REF('LABELS ALL OFF LEFT ON TOP ON; '))
     	  CALL TDSET (%REF('TICKS SIZE 0.04; '))

     	  CALL TDSET (%REF('WINDOW X 1 5 Y 5 9; '))
     	  CALL TDSET (%REF('TICKS SIZE 0.04; '))
	  CALL TDPLOT (NOUT,X,X1)
     	  CALL TDSET (%REF('LABELS ALL OFF BOTTOM ON RIGHT ON; '))
     	  CALL TDSET (%REF('TICKS SIZE 0.04; '))

     	  CALL TDSET (%REF('WINDOW X 5 9 Y 1 5; '))
	  CALL TDPLOT (NOUT,Z1,Z)
     	  CALL TDSET (%REF('LABELS ALL OFF TOP ON RIGHT ON; '))
     	  CALL TDSET (%REF('TICKS SIZE 0.04; '))

     	  CALL TDSET (%REF('WINDOW X 5 9 Y 5 9; '))
	  CALL TDPLOT (NOUT,Z1,X1)
	  CALL SET_SCREEN	(' ',1,ITERM)
	END IF
#else /*!vms*/
C
C start writing data files
C
	OPEN(22,FILE='plotspace.dat',STATUS='UNKNOWN',FORM='FORMATTED')
        DO 15 I=1,NOUT
	  WRITE (22,*)      X(I),X1(I),Z(I),Z1(I)
15 	CONTINUE
        CLOSE (22)
C
C now write out primvs command file.
C
	OPEN (26,FILE='plotspace.prm',STATUS='UNKNOWN',FORM='FORMATTED')
	WRITE (26,*) '# Primvs command file to plot output of PLOTSPACE'
	IF      (ITERM.EQ.0) THEN
	  WRITE (26,*) '# Initialize Xwindow display'
	  WRITE (26,*) ' '
 	  WRITE (26,*) 'initpage(xwin)'
	ELSE IF (ITERM.EQ.1) THEN
	  WRITE (26,*) '# Initialize Tektronix display'
	  WRITE (26,*) ' '
	  WRITE (26,*) 'initpage(tekt)'
	ELSE IF (ITERM.EQ.2) THEN
	  WRITE (26,*) '# Initialize postscript file'
	  WRITE (26,*) ' '
	  WRITE (26,*) 'setcolor(0)'
	  WRITE (26,*) 'initpage(ps,"plotspace.ps")'
	END IF
	WRITE (26,*) 'symbol(1)'
	WRITE (26,*) '#'
	WRITE (26,*) '# Set plot window for lower left corner of page'
	WRITE (26,*) '# '
	WRITE (26,*) 'regionr(0.05,0.05,0.5,0.45,1.0)'
	WRITE (26,3030) XLOW,XUPP,ZLOW,ZUPP
	WRITE (26,*) 'color(green)'
	WRITE (26,*) '#'
	WRITE (26,*) '# Choose columns 1 and 3 (X,Z) from file'
	WRITE (26,*) '#'
	WRITE (26,*) 'format(x:1,y:3)'
	WRITE (26,*) 'scalechr(0.8)'
	WRITE (26,*) '# Plot points'
	WRITE (26,*) 'plotp("plotspace.dat")'
	WRITE (26,*) 'box("bcnst",0,0,"bcnstv",0,0)'
	WRITE (26,*) 'label("","","',TITLE1,'")'
	WRITE (26,*) '#'
	WRITE (26,*) '# Set plot window for upper left corner of page'
	WRITE (26,*) '# '
	WRITE (26,*) 'regionr(0.05,0.55,0.5,0.95,1.0)'
	WRITE (26,3030) XLOW,XUPP,X1LOW,X1UPP
	WRITE (26,*) '#'
	WRITE (26,*) '# Choose columns 1 and 2 (X,Xprime) from file'
	WRITE (26,*) '#'
	WRITE (26,*) 'format(x:1,y:2)'
	WRITE (26,*) '# Plot points'
	WRITE (26,*) 'plotp("plotspace.dat")'
	WRITE (26,*) 'box("bcnst",0,0,"bcnstv",0,0)'
	WRITE (26,*) 'label("","","',TITLE2,'")'
	WRITE (26,*) '#'
	WRITE (26,*) '# Set plot window for lower right corner of page'
	WRITE (26,*) '# '
	WRITE (26,*) 'regionr(0.5,0.05,0.95,0.45,1.0)'
	WRITE (26,3030) Z1LOW,Z1UPP,ZLOW,ZUPP
	WRITE (26,*) '#'
	WRITE (26,*) '# Choose columns 4 and 3 (Zprime,Z) from file'
	WRITE (26,*) '#'
	WRITE (26,*) 'format(x:4,y:3)'
	WRITE (26,*) '# Plot points'
	WRITE (26,*) 'plotp("plotspace.dat")'
	WRITE (26,*) 'box("bcnst",0,0,"bcnstv",0,0)'
	WRITE (26,*) 'label("","","',TITLE3,'")'
	WRITE (26,*) '#'
	WRITE (26,*) '# Set plot window for upper right corner of page'
	WRITE (26,*) '# '
	WRITE (26,*) 'regionr(0.5,0.55,0.95,0.95,1.0)'
	WRITE (26,3030) Z1LOW,Z1UPP,X1LOW,X1UPP
	WRITE (26,*) '#'
	WRITE (26,*) '# Choose cols 4 and 2 (Zprime,Xprime) from file'
	WRITE (26,*) '#'
	WRITE (26,*) 'format(x:4,y:2)'
	WRITE (26,*) '# Plot points'
	WRITE (26,*) 'plotp("plotspace.dat")'
	WRITE (26,*) 'box("bcnst",0,0,"bcnstv",0,0)'
	WRITE (26,*) 'label("","","',TITLE4,'")'
	WRITE (26,*) 'closepage'
	WRITE (26,*) 'exit'
	CLOSE (26)

3030 	FORMAT ('xyrange(',E15.8,',',E15.8,',',E15.8,',',E15.8,')')

	IFLAG = 0
	CALL PROGPATH ('primvs', PRIMVS, IFLAG)
	PRIMVSPATH = PRIMVS(1:IBLANK(PRIMVS)) // ' -i plotspace.prm'
	WRITE(*,*) 'Executing program: ' // 
     $		PRIMVSPATH(1:IBLANK(PRIMVSPATH))
#if !defined(_WIN32)
	CALL SYSTEM (PRIMVSPATH)
#else
	IFLAG = 0
	CALL RUNPRIMVS(PRIMVS(1:IBLANK(PRIMVS)),'plotspace.prm',iflag)
#endif

#endif /*unix*/

     	END
