C +++
C
C Source: src/trace/input_oe.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	input_oe.F
C Revision 1.18  94/12/16  13:56:04  cwelnak
C workaround for HP added 
C 
C Revision 1.17  94/10/21  19:48:07  cwelnak
C segmented mirrors et al.
C 
C Revision 1.16  92/09/22  15:35:42  cwelnak
C facet and komakhov questions.
C g.j.chen
C 
C Revision 1.15  92/08/26  20:24:03  sanchez
C Roughness changes. Laue Crystals model
C 
C Revision 1.14  1992/08/26  14:02:28  cwelnak
C latest 6000 changes.
C
C Revision 1.13  1991/12/06  20:30:35  cwelnak
C added ifndef SCATTER around surface roughness prompt
C
C Revision 1.12  1991/07/06  20:07:29  khan
C Mirror roughness model by Singh
C
C Revision 1.11  91/04/05  15:05:49  cwelnak
C changed quotes on #includes
C 
C Revision 1.10  91/03/21  16:21:05  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.9  91/02/14  11:37:02  khan
C Latest VMS version (and a new bug...)
C 
C Revision 1.8  90/11/13  14:01:49  khan
C Cleanup and SAVE statements
C 
C Revision 1.7  90/07/20  22:19:12  khan
C Added #if unix ... to make it work on both unix and vms
C 
C Revision 1.6  90/07/19  21:37:50  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.5  90/07/15  16:33:16  khan
C SHADOW Version file is moved to ./../include/ dir.
C 
C Revision 1.4  90/07/14  22:51:09  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.3  90/07/14  15:33:19  khan
C Hardcode the VERSION file.
C 
C Revision 1.2  90/07/14  12:11:15  khan
C Substituted LIB$ERASE_PAGE calls with system("clear"). Temporary solution.
C Also substituted START for SYS$START as in VMS.
C 
C Revision 1.1  90/07/10  14:56:16  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	INPUT_OE
C
C	PURPOSE		Reads in the parameters of the optical element
C
C       Inputs:         I_OENUM: The OE we're dealing with
C
C---
	SUBROUTINE INPUT_OE (I_OENUM)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
C
     	CHARACTER*80	MSSG,MSSG2,TEXT,RSTRING
	CHARACTER*132 	VERSION
C
     	WRITE(6,*)'Call to INPUT_OE'
C#if unix
C	CALL	SYSTEM ('clear')
C#elif vms
C     	CALL	LIB$ERASE_PAGE(1,1)
C    	CALL	LIB$SET_SCROLL (5,24)
C#endif
	CALL CLSCREEN
C		       123456789 123456789 123456789 123456789 1
     	MSSG (1:40) = '--------------------------------- S H A '
        MSSG (41:80)= ' D O W  -------------------------------'
     	WRITE (6,'(1X,A)')  MSSG
C
C Get the data file path using either SHADOW$DATA or Unix SHADOW_DATA_DIR
C environment variable. Also, check for existence in the routine itself.
C
	IFLAG = 1
	CALL DATAPATH ('VERSION', VERSION, IFLAG) 
	IF (IFLAG.NE.0) THEN
	    CALL LEAVE ('INPUT_OE', 'VERSION file not found', IFLAG)
	ENDIF
#ifndef vms
    	OPEN (11, FILE=VERSION, STATUS='OLD')
#elif defined(vms)
    	OPEN (11, FILE=VERSION, STATUS='OLD', READONLY)
#endif
     	READ (11,*) I1,I1,I1
     	READ (11,'(1X,A)') MSSG2
     	CLOSE(11)
     	WRITE (6,'(1X,A)') MSSG2
	IF (I_OENUM.EQ.1) THEN
	  WRITE(6,*)' '
     	  WRITE(6,*)'When prompted for a yes/no answer, you may enter:'
     	  WRITE(6,*)'for   YES  answer      Y, 1'
     	  WRITE(6,*)'for   NO   answer      anything else'
	  WRITE(6,*)' '
	END IF
     	WRITE (6,2222) I_OENUM
2222	FORMAT (1X,/,1X,'Defining Optical Element: ', I2)
     	I_MIR	=   I_OENUM
#ifndef vms
     	TEXT	=   
     $		RSTRING('Continue ? [ EXIT to terminate OS ] ')
     	IF (TEXT(1:5).EQ.'EXIT'.OR.TEXT(1:5).EQ.'exit') THEN
     	  WRITE(6,*)'End of session'
     	  STOP
     	END IF
#elif defined(vms)
     	TEXT	=   
     $		RSTRING('Continue ? [ ^Z or %EXIT to terminate OS ] ')
     	IF ((TEXT(1:2).EQ.'^Z').OR.(TEXT(1:5).EQ.'%EXIT')) THEN
     	  WRITE(6,*)'End of session'
     	  STOP
     	END IF
#endif
     	WRITE (6,'(1X,///)')
     	IVERB = 
     $IYES ('Do you want a verbose [ 1 ] or terse [ 0 ] output ?')
     	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)'You may save disk space by not writing out the ',
     $'intermediate STAR or MIRR data files. In general you will not',
     $'need them unless you have specific needs (footprints, etc.) '
     	END IF
     	WRITE(6,*)' '
     	WRITE(6,*)'Files to write out. Options: '
     	WRITE(6,*)'All............................ [ 0 ] '
     	WRITE(6,*)'Mirror only.....................[ 1 ] '
     	WRITE(6,*)'Image at CP only................[ 2 ] '
     	WRITE(6,*)'None............................[ 3 ] '
     	FWRITE = IRINT (' Then ? ')
**---------------------------------------------------------------------
C#if unix
C	CALL	SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1) ! Inquires about the nominal geometry
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)

**---------------------------------------------------------------------
     	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)	
     $ '	Let''s define the optical or central axis of the system'
     $,'for this particular optical element.'
     $,'	By this I mean a "virtual" line that runs throughout'
     $,'the optical system. Along this line are located the '
     $,'"continuation" planes, where the OS is subdivided in the'
     $,'individual OE. This line does not have to coincide with the'
     $,'true optical axis, as it is used mainly for bookeeping the'
     $,'data, but it helps greatly in the data analysis if this'
     $,'identity is preserved as everything in the program is referred'
     $,'to it.'
     $,'	Once established, you still have complete freedom of'
     $,'"moving" around the mirrors.'
     $,' '
     $,'In the case of a grating, you will have several choices. The '
     $,'program may override your specifications for the central axis '
     $,'and locate the source and image at the "best" position. '
     $,'You will be prompted later for this option.'

     	WRITE(6,*)
     $'It is recommended to use CM as units. This is not critical for',
     $' most cases, but it is in the case of diffraction elements.'
     	END IF
     	 WRITE(6,*)'Optical Element definition:'
     	T_INCIDENCE = RNUMBER ('Incidence Angle ? ')
     	T_SOURCE    = RNUMBER ('Source Distance ? ')
     	T_REFLECTION= RNUMBER ('Reflection Angle? ')
     	T_IMAGE     = RNUMBER ('Image Distance  ? ')
     	F_REFRAC    = IRINT   ('Reflector [ 0 ] or refractor [ 1 ] ? ')
**---------------------------------------------------------------------
C#if unix
C	CALL	SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1)  ! Mirror parameters.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
**---------------------------------------------------------------------
C 
C        IF (IVERB.EQ.1) THEN
C        WRITE(6,*)'You can store the angle between the ray and ',
C     $   'mirror normal vector '
C        ENDIF
C 
C        F_INC_MNOR_ANG =  IYES('Store incident angle information?')
C 
C
C------------------------------------------------------------
C Segmented Mirror  question
C Added by G.J. 4/17/93
C
        IF (IVERB.EQ.1) THEN
        WRITE(6,*)'A segmented mirror is formed by M by N ',
     $  'independent  mirrors'
        endif
 
        F_SEGMENT = IYES('Is this a segmented mirror system?')
 
        IF (F_SEGMENT.EQ.1) THEN
        FILE_SEGMENT = RSTRING
     $    ('File describing the orientation of the mirrors?')
 
        FILE_SEGP = RSTRING
     $    ('File with the polynomial describing the mirror?')
 
        WRITE(6,*)'Size and  number of the mirrors ?'
        SEG_LENX =RNUMBER(' x-length ?')
        SEG_LENY =RNUMBER(' y-length ?')
 
C       type *,'seg length',seg_lenx,seg_leny
 
        ISEG_XNUM =IRINT(' Number of rows(x- odd integer) ?')
        ISEG_YNUM =IRINT(' Number of columns(y- odd integer) ?')
 
        FMIRR = 5
        ELSE

C
C------------------------------------------------------------
c KOMAKOFU  question
c Added by G.J. 8/7/92
C

	IF (IVERB.EQ.1) THEN
	WRITE(6,*)'Kumakhov lens are formed from tube arrays ',
     $   'their packing pattern are Wigner-Seitz type cell.'
	WRITE(6,*) 'A capillary would be the central tube of ',
     $   'a kumakhov lens.'
        ENDIF

	F_KOMA = IYES('Is this a Kumakhov system?')

	IF (F_KOMA.EQ.1) THEN
C	   F_INC_MNOR_ANG = 0
	   
	   IF (IVERB.EQ.1) THEN
	   WRITE(6,*) 'For multiple reflection calculations, you may',
     $    'want to store the intercepts of each bounce.'
	   ENDIF
	   F_KOMA_BOUNCE = IYES('Store (X,Y,Z) for each bounce? ')

	   IF (IVERB.EQ.1) THEN
	   WRITE(6,*) 'Normally, the tube radii are specified as r(z).'
	   WRITE(6,*) 'You may also specify r(z)^2.'
	   ENDIF
	   F_KOMA_CA = IYES ('Specify as r(z)^2 ? (Y/N) ')

	   IF (F_KOMA_CA.NE.1) THEN

          IF (IVERB.EQ.1) THEN
             WRITE(6,*)'Modified means that you could change each ',
     $         'tube length as a function of position.'
          ENDIF
          F_EXIT_SHAPE = IYES('B: Is  this a modified exit plane?')

C	      F_EXIT_SHAPE = 0
	      FILE_KOMA= RSTRING('File with the parameters?')
	   ELSE
	      FILE_KOMA_CA = RSTRING('File with the parameters? ')
	      F_EXIT_SHAPE = 0
	   ENDIF

	   FMIRR = 5

	ELSE
C
C------------------------------------------------------------************
C Facet question
C Added by G.J. 5/12/92
C

	IF (IVERB.EQ.1) THEN
	 WRITE(6,*) 'Compound mirrors ( or lenses) are formed',
     $   'by several smaller mirrors ( facets) combined',
     $   'together.'
	END IF
        F_FACET = IYES('A: Is this mirror faceted [Y/N] ?')
	IF (F_FACET.EQ.1) THEN
	FILE_FAC = RSTRING
     $	  ('B: File with the polynomial describing the facet?')
	IF (IVERB.EQ.1) THEN
	WRITE(6,*) 'We need to define which side of the surface',
     $  'to use (see demo for further explanation).'
        END IF
        F_POLSEL=0
	WRITE(6,*)' 3      closest'
	WRITE(6,*)' 2      ...'
	WRITE(6,*)' 1      ...'
	WRITE(6,*)' 4      farthest'
	F_POLSEL = IRINT('Choice[1-4]?')
	WRITE(6,*)'Size of the Facet?'
	RFAC_LENX =RNUMBER(' x-length ?')
	RFAC_LENY =RNUMBER(' y-length ?')
	ENDIF
C#endif

     	IF (IVERB.EQ.1) THEN
C#ifdef FACET
	 IF(F_FACET.EQ.1) THEN
	  WRITE(6,*)'Choose the baseline for facet'
         ENDIF
C#endif
     	WRITE(6,*)
     $'Lets define the mirror. I may compute its parameters, like the'
     $,'radius or the axes. This will not affect the rest of the calcu'
     $,'lations; all the geometrical parameters may be modified later.'
     $,'Or, you may wish to specify the mirror parameters yourself.'
	WRITE (6,30)
30    FORMAT (//,1X,'What kind of surface are we dealing with ?',/,1X,
     $  'spherical    = 1',/,1X,
     $	'elliptical   = 2',/,1X,
     $	'toroidal     = 3',/,1X,
     $  'paraboloid   = 4',/,1X,
     $	'plane        = 5',/,1X,
     $	'Codling slit = 6',/,1X,
     $  'hyperbolical = 7',/,1X,
     $  'cone	      = 8',/,1X,
     $  'polynomial   = 9',/)
     	END IF
     	FMIRR	=   IRINT ('Mirror surface [ 1-9] ? ')
       	IF (FMIRR.NE.9) THEN
     	 IF (FMIRR.EQ.4) THEN
     	WRITE(6,*)'Paraboloid Selected.'
     	WRITE(6,*)'Enter 0 (1) if the image (source) is at infinity.'
     $,'The inputs for the relative positions are disregarded.'
     	F_SIDE = IRINT ('Focus location ? ')
	 ELSE IF (FMIRR.EQ.3) THEN
C#ifdef FACET
	IF (F_FACET.EQ.1) THEN
	   WRITE(6,*)'In facet, only selection 0 has been developed'
      	   WRITE(6,*)'Do not use Angle=0 0 The R_MAJ will be 0'
	END IF
C#endif

	WRITE(6,*)'Toroidal Selected.'
	WRITE(6,*)'Enter 0, if mirror pole is at the lower outer ',
     $'torus (usual case)'
	WRITE(6,*)'      1,                          lower inner'
	WRITE(6,*)'      2,                          upper inner'      
	WRITE(6,*)'      3,                          upper outer'
	F_TORUS	= IRINT ('Mirror pole location ? ')
     	 END IF
	 IF (FMIRR.EQ.8) THEN
	  F_EXT = 1
	 ELSE IF (FMIRR.NE.5.AND.FMIRR.NE.6) THEN
	  F_EXT = 
     $    IYES ('Do you want to specify the mirror parameters ?')
	 END IF
     	  FCYL 	= IYES ('Is the mirror Cylindrical ? ')
     	 IF (FCYL.EQ.1) THEN
     	   CIL_ANG =
     $	   RNUMBER ('Angle of cylinder axis from x axis [ 0 ] ?')
     	 END IF
       	ELSE
       	FILE_MIR = RSTRING ('File with polynomial coefficients ? ')
       	END IF

C
C end of the Komakofu IF block
C
C#ifdef FACET
	ENDIF
C#endif
C
C end of the segmented mirror IF block
C
        ENDIF
 

     	FZP = IYES('Is this optical element a Fresnel Zone Plate ? ')
	IF (FZP.EQ.1) THEN
	  F_GRATING	= 1
	ELSE
     	  F_GRATING=IYES ('Are we dealing with a Grating ? ')
	END IF
     	 IF (F_GRATING.EQ.1) THEN
**-------------------------------------------------------------------
C#if unix
C	CALL	SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1)  ! Grating parameters.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
**-------------------------------------------------------------------
     	IF (FZP.EQ.1) THEN
     	  WRITE(6,*)' For a Fresnel Zone Plate select the appropriate ',
     $' HOLOGRAPHIC case.'
     	END IF
     	WRITE(6,*)'Type of ruling.'
     	WRITE(6,*)
     $'0    ruling density constant on the X-Y plane'
     	WRITE(6,*)
     $'1    for ruling density constant onto the mirror surface.'
     	WRITE(6,*)
     $'2    for an holographic grating.'
        WRITE(6,*)
     $'3    for an oriental-fan type'
	WRITE(6,*)
     $'4    reserved'
	WRITE(6,*)
     $'5    polynomial line density'
     	F_RULING = IRINT ('Then: ')
     	  IF (F_RULING.EQ.0.OR.F_RULING.EQ.1) THEN
     	RULING	=   RNUMBER ('Lines per CM ? ')
     	  ELSE IF (F_RULING.EQ.2) THEN
     	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)'Hologram Recording Parameters.'
     	WRITE(6,*)'The angles are positive if the source is on the'
     $,' side of the Y-axis.'
     	WRITE(6,*)'"EnS" means Entrance Slit Side Source'
     	WRITE(6,*)'"Rotation" refers to rotation around Z'
     	WRITE(6,*)'Distances [ cm! ] and angles [ degrees ] refer ',
     $'to hologram.'
     	END IF
     	HOLO_R1	=  RNUMBER('EnS distance: ')
     	HOLO_DEL=  RNUMBER('EnS incidence angle:    ')
     	HOLO_RT1=  RNUMBER('EnS rotation  angle:    ')
     	HOLO_R2	=  RNUMBER('ExS distance: ')
     	HOLO_GAM=  RNUMBER('ExS incidence angle:    ')
     	HOLO_RT2=  RNUMBER('ExS rotation  angle:    ')
     	HOLO_W  =  RNUMBER('Recording Wavelength [ Angs ] ? ')
     	WRITE(6,*)'Type of recording sources. We have the choices: '
     	WRITE(6,*)'Both    SPHERICAL                    0'
     	WRITE(6,*)'Source  PLANE,     image SPHERICAL   1'
     	WRITE(6,*)'Source  SPHERICAL, image PLANE       2'
     	WRITE(6,*)'Source  PLANE,     image PLANE       3'
     	F_PW	=  IRINT ('Source type [ 0-3 ]. Then ? ')
     	WRITE(6,*)'The SPHERICAL source can also be specified to be ',
     $'CYLINDRICAL, with axis perpendicular to recording plane.'
      	WRITE(6,*)'Use: '
     	WRITE(6,*)'None   Cylindrical                    0'
     	WRITE(6,*)'Source Cylindrical, image Spherical   1'
     	WRITE(6,*)'Source Spherical,   image Cylindrical 2'
     	WRITE(6,*)'Both   Cylindrical                    3'
     	F_PW_C	=  IRINT ('Cylindrical [ 0-3 ] ? ')
     	WRITE(6,*)'Sources REAL/ VIRTUAL: '
     	WRITE(6,*)'EnS real,    ExS real		0'
     	WRITE(6,*)'EnS real,    ExS virtual: 	1'
     	WRITE(6,*)'EnS virtual, ExS real:  	2'
     	WRITE(6,*)'EnS virtual, ExS virtual 	3'
     	F_VIRTUAL = IRINT ('Then ? ')
     	WRITE(6,*)' '
     	  ELSE IF (F_RULING.EQ.3) THEN
       	WRITE(6,*)' Position of ruling focus on mirror plane.'
       	AZIM_FAN = 
     $		RNUMBER ('Angle from Y axis         [ deg, CCW ] ? ')
       	DIST_FAN = 
     $		RNUMBER ('Distance from grating center    [ cm ] ? ')
       	COMA_FAC = 
     $		RNUMBER ('Coma correction factor  [ 0 for none ] ? ')
       	RULING   = 
     $		RNUMBER ('Line density at grat. cent.   [ l/cm ] ? ')
	  ELSE IF (F_RULING.EQ.5) THEN
	WRITE(6,*)'Degree of polynomial is 4 :'
	WRITE(6,*)'   density = a0 + a1*w + a2*w^2 + a3*w^3 + a4*w^4'
	WRITE(6,*)
     $       'NOTICE : for a0, please enter the LINE DENSITY AT ORIGIN'
	WRITE(6,*)'units of density is LINES/CM'
	WRITE(6,*)'Please enter coefficients :'
	RULING	= RNUMBER ('a0 : ')
	RUL_A1	= RNUMBER ('a1 : ')
	RUL_A2	= RNUMBER ('a2 : ')
	RUL_A3	= RNUMBER ('a3 : ')
	RUL_A4	= RNUMBER ('a4 : ')
     	WRITE(6,*)'Use ABSOLUTE [ 0 ] or SIGNED [ 1 ] from origin ? '
     	F_RUL_ABS = IRINT ('Then ? ')
	WRITE(6,*)'All set then.'
     	  END IF
     	IF (IVERB.EQ.1) 
     $ WRITE(6,*)
     $ 'We follow the European convention. NEGATIVE orders are inside.'
     	ORDER	=  RNUMBER('Diffraction Order ? ')
     	IF (IVERB.EQ.1) WRITE(6,*)
     $'Enter 1 if you want me to position the grating at the correct'
     $,'wavelength, 0 to leave everything as it is.'
     	F_CENTRAL =  IRINT ('Auto Tuning of Grating [ Y/N ] ? ')
     	  IF (F_CENTRAL.EQ.1) THEN
     	IF (IVERB.EQ.1) WRITE(6,*)
     $'You must then supply the wavelength (or photon energy) at ',
     $'which you want the grating tuned.'
        F_PHOT_CENT = 
     $IRINT ('Energy, in eV, [ 0 ] or wavelength, in Angs., [ 1 ] ? ')
     	IF (F_PHOT_CENT.EQ.0) PHOT_CENT = RNUMBER ('Photon Energy ? ')
     	IF (F_PHOT_CENT.EQ.1) R_LAMBDA  = RNUMBER ('Wavelength    ? ')
     	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)	
     $ 'SHADOW recognizes several types of Grating mounts and/or '
     $,'monochromators. '
     $,'We have several choices, depending on what kind of mount you '
     $,'are using. They are :'
     	WRITE(6,*)
     $'	TGM/SEYA  mount (constant included angle).',
     $' In this case the source/image distances are not changed from',
     $' the one already specified and the grating is rotated to match',
     $' the diffraction conditions.'
     	WRITE(6,*)
     $' ERG/GRASSHOPPER (constant incidence angle). The image'
     $,' plane is positioned on the Rowland circle at the appropriate'
     $,' diffraction angle.'
     	WRITE(6,*)
     $' CONSTANT INCIDENCE ANGLE and image plane at the'
     $,'position already specified. Only the diffraction angle is',
     $' modified.'
     	WRITE(6,*)
     $' CONSTANT DIFFRACTION ANGLE. The incidence angle',
     $' is modified to match the diffraction conditions. The planes',
     $' are not moved.'
     	WRITE(6,*)
     $' for a CONSTANT BLAZE mount (Hunter type)'
     	END IF
     	WRITE(6,*)'TGM/SEYA    0'
     	WRITE(6,*)'ERG         1'
     	WRITE(6,*)'Con Inc Ang 2'
     	WRITE(6,*)'Con Dif Ang 3'
     	WRITE(6,*)'Hunter      4'
     	F_MONO	=   IRINT ('Mount type ? ')
     	   IF (F_MONO.EQ.4) THEN
     	BLAZE	=   RNUMBER ('Blaze Angle [ Deg ] ? ')
     	HUNT_L  =   RNUMBER ('Monochromator Length ? ')
     	HUNT_H	=   RNUMBER 
     $('Monochr. Height (Distance between Beams) ')
     	F_HUNT  =   IRINT ('First [ 1 ] or Second [ 2 ] grating ? ')
     	   END IF
     	  ELSE
     	  END IF
     	END IF
**------------------------------------------------------------------
C#if unix
C	CALL	SYSTEM ('clear')
C#elif vms
C     	CALL	LIB$ERASE_PAGE(5,1)
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
**------------------------------------------------------------------
     	IF (F_GRATING.EQ.0) THEN
     	F_CRYSTAL = IYES ('Are we dealing with a crystal [ Y/N ] ? ')
	    IF (F_REFRAC.EQ.1.and.f_crystal.ne.1) THEN     !lens
C#if unix
C	      CALL	SYSTEM ('clear')
C#elif vms
C	      CALL	LIB$ERASE_PAGE(5,1)
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
	      WRITE(6,*)
     $'Enter the index of refraction in OBJECT space:'
	      R_IND_OBJ = RNUMBER ('Object space: ')
	      WRITE(6,*)
     $'Enter the index of refraction in IMAGE space:'
	      R_IND_IMA = RNUMBER ('Image space: ')
	    END IF

     	 IF (F_CRYSTAL.EQ.1) THEN
     	   WRITE(6,*) 'File containing crystal parameters ?'
     	   READ	(5,111)	FILE_REFL
     	   F_MOSAIC = IYES ('Is it a mosaic crystal [ Y/N ] ? ')
	   if (f_mosaic.eq.1.or.f_refrac.eq.1) 
     $  THICKNESS  = RNUMBER ('What is the crystal thickness [cm] ? ')
	   IF (F_MOSAIC.EQ.1) THEN
     	IF (IVERB.EQ.1) WRITE(6,*) 
     $'I assume that the mosaic crystal small blocks follow a gaussian',
     $'distribution of a given FWHM spread.This spread must be much',
     $'larger than the rock curve width. I suposse that the distance',
     $'between intercepts on the mosaic surface will be larger enough',
     $'than the small mosaic block size.I use a random seed to gene-',
     $'rate the gaussian distribution of the blocks around the sur-',
     $'face normal.I also need the thickness of the whole crystal',
     $'(faces must be parallel) for the reflectivity calculation.',
     $'Mosaic crystal force us to use cm as unit.'
	SPREAD_MOS = RNUMBER ('What is the mosaic spread FWHM [deg] ? ')
	MOSAIC_SEED  = IRINT ('Give me a random seed [odd, integer] ? ')
	   ELSE IF (F_MOSAIC.NE.1) THEN
     	     F_BRAGG_A = IYES ('Is the crystal asymmetric [ Y/N ] ? ')
     	     IF (F_BRAGG_A.EQ.1) THEN
     	IF (IVERB.EQ.1) THEN
     	 WRITE(6,*) 'Enter the angle formed by the crystal planes with',
     $' the crystal surface. Use a positive value if the plane normal',
     $' lies along the +Y direction (focusing), negative otherwise.'
     	END IF
     	       A_BRAGG = RNUMBER('Planes angle [ deg ] ? ')

            if (f_refrac.eq.1) then
          WRITE(6,*) 'For the Laue case: is the beam arriving onto the',
     $' bragg planes [0] , or under the bragg planes [1] ?'
              f_planes = iyes(' <?> ')
              if (f_planes.eq.1) then 
               order = -1
              else
               order = +1
              endif
            endif

     	     END IF
	     F_JOHANSSON = IYES 
     $('Are we working in Johansson geometry [Y/N] ? ')
	     IF (F_JOHANSSON.EQ.1) THEN
     	IF (IVERB.EQ.1) WRITE(6,*) 
     $'Johansson geometry is when you grind a crystal plate with a',
     $'spherical shape of a given radius (Johansson radius),and then,',
     $'the crystal is bent again with another different radius',
     $'(surface radius). For the optimal curvature, the surface must',
     $'lie on the Rowland circle and the Johansson radius should be', 
     $'twice the Rowland circle radius. Both are calculated automati-',
     $'cally if you have chosen automatic parameters calculation in',
     $'a spherical shape surface.    '  
		IF (F_EXT.EQ.1) THEN
		     R_JOHANSSON = RNUMBER ('Johansson radius  ? ')
		END IF
	     END IF
	  END IF
     	   F_CENTRAL = IYES ('Automatic Tuning of Crystal [ Y/N ] ?')
     	  IF (F_CENTRAL.EQ.1) THEN
     	IF (IVERB.EQ.1) WRITE(6,*) 
     $'You must then supply the wavelength (or photon energy) at ',
     $'which you want the crystal tuned.'
        F_PHOT_CENT = 
     $ IRINT ('Energy, in eV, [ 0 ] or wavelength, in Angs., [ 1 ] ? ')
     	IF (F_PHOT_CENT.EQ.0) PHOT_CENT = RNUMBER ('Photon Energy ? ')
     	IF (F_PHOT_CENT.EQ.1) R_LAMBDA  = RNUMBER ('Wavelength    ? ')
C     	D_SPACING = RNUMBER ('Interplanar Distance [ Angs ] ? ')
     	  END IF
     	 END IF
     	END IF
C
C---------------------------------------------------------------------
C
     	F_CONVEX =  IYES ('Is the mirror convex [ Y/N ] ? ')
     	IF (F_REFRAC.EQ.0) THEN
	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)
     $'Reflectivity of Surface. SHADOW may solve the Fresnel equations',
     $'locally. Available options:',
     $'No reflectivity              .......... 0 ',
     $'Full polarization dependence .......... 1 ',
     $'No        "           "      .......... 2 '
     	END IF
     	F_REFLEC  =  IRINT ('Reflectivity mode [ 0,1,2 ] ? ')
     	IF (F_REFLEC.NE.0) THEN
C#if unix
CC	CALL	SYSTEM ('clear')
C#elif vms
C    	CALL	LIB$ERASE_PAGE(5,1)
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
     	IF (IVERB.EQ.1) THEN
     	  WRITE(6,*)
     $'Optical constants from file  ( for multi-line source ) ..... 0',
     $'Optical constants from keyboard  (single-line source ) ..... 1',
     $'Define multilayer from file                            ..... 2'
     	END IF
     	F_REFL = IRINT 
     $	('Optical Constant Source: [file=0,tt:=1], multilayer [2] ?')
	   IF (F_REFL.EQ.1) THEN
     	WRITE(6,*)
     $'Please enter the complex dielectric constant. ',
     $'The form I use is :',
     $'           Epsilon  = ( 1 - ALPHA) + i*GAMMA'
	ALFA = RNUMBER ('ALPHA = ')
     	GAMMA= RNUMBER ('GAMMA = ')
     	   ELSE IF (F_REFL.EQ.0) THEN
     	WRITE(6,*)
     $'File with optical constants ?'
     	READ (5,111)	FILE_REFL
     	   ELSE
	WRITE(6,*)
     $'File with thicknesses and refractive indices of multilayer ?'
	READ (5,111)	FILE_REFL
	F_THICK = IYES 
     $('Vary thicknesses as the cosine of the angle from the pole? ')
	   END IF 
     	ELSE
     	END IF
	END IF
C------------------------------------------------------------------------
C#if unix
CC	CALL	SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1)  ! Mirror parameters.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
C---------------------------------------------------------------------
     	IF (IVERB.EQ.1) THEN
	WRITE (6,60)
60	FORMAT (1X,
     $/,1X,'Mirror orientation angle. Angles are measured CCW, in deg,'
     $/,1X,'referring to the mirror normal. Alpha=0 is the mirror'
     $/,1X,'sitting at the origin, facing up. Alpha = 90 is the '
     $/,1X,'mirror standing at your right and facing left when you '
     $/,1x,'look along the beam STANDING ON THE PREVIOUS MIRROR and so', 
     $' on.')
     	END IF
     	ALPHA = RNUMBER ('Orientation Angle [ Alpha ] ? ')
C----------------------------------------------------------------------
C#if unix
C	CALL	SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1)  ! Mirror parameters.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
C----------------------------------------------------------------------
     	FHIT_C = IYES ('Mirror Dimensions finite [ Y/N ] ?')
     	IF (FHIT_C.EQ.1) THEN
     	 IF (IVERB.EQ.1) THEN
     	  WRITE(6,*)'Mirror shape. Options:'
     	  WRITE(6,*)'         rectangular :    1'
     	  WRITE(6,*)'   full  elliptical  :    2'
     	  WRITE(6,*)'  "hole" elliptical  :    3'
     	 END IF
     	FSHAPE = IRINT ('Shape: [ 1, 2, 3] ?')
     	   IF (FSHAPE.EQ.1) THEN
     	RWIDX1 =
     $	 RNUMBER ('Mirror half-width x(+) ? ')
     	RWIDX2 =
     $	 RNUMBER ('Mirror half-width x(-) ? ')
     	RLEN1  =
     $	 RNUMBER ('Mirror half-length y(+) ? ')
     	RLEN2  =
     $	 RNUMBER ('Mirror half-length y(-) ? ')
     	   ELSE 
     	RWIDX2	= RNUMBER ('External Outline Major axis ( x ) ? ')
        RLEN2	= RNUMBER ('External Outline Minor axis ( y ) ? ')
     	    IF (FSHAPE.EQ.3) THEN
     	RWIDX1	= RNUMBER ('Internal Outline Major axis ( x ) ? ')
     	RLEN1	= RNUMBER ('Internal Outline Minor axis ( y ) ? ')
     	    END IF
     	   END IF
     	END IF
*----------------------------------------------------------------------
C#if unix
C	CALL	SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1)  ! Mirror parameters.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
*----------------------------------------------------------------------
     	 IF (FMIRR.EQ.6)	THEN
     	COD_LEN = RNUMBER ('Codling Slit Length [ Sagittal ] ? ')
     	COD_WID = RNUMBER 
     $('Codling Slit Width  [ Effective, Tangential] ? ')
	GO TO 5001
     	 END IF
       	IF (FMIRR.EQ.9.OR.FMIRR.EQ.5) GO TO 5001
* Inquires about the mirror optical parameters.
     	IF (F_EXT.EQ.0) THEN
     	 IF (IVERB.EQ.1) THEN
     	WRITE(6,*)
     $'The mirror will be computed from the optical parameters',
     $'that you supply. For example,in the case of a spherical mirror',
     $'I will compute the radius of the mirror to satisfy the equation'
     $,'	1/p + 1/q = 2/(R*cos(theta))	'
     $,' given p,q and theta.'
     $,'This will NOT affect in any way the placement of the mirror in'
     $,'the optical element.'
     	 END IF
     	F_DEFAULT = 
     $IYES ('Focii placed at continuation planes [ Y/N ] ? ')
     	IF (F_DEFAULT.EQ.0) THEN
     	 IF (IVERB.EQ.1) THEN
     	WRITE(6,*)
     $'The mirror parameters will be specified by using either polar'
     $,'or cartesian coordinates for the source position. Then? '
     	 END IF
C
C Using polar coordinates.
C
     	SSOUR	= RNUMBER
     $('Object Focus to Mirror Pole Distance: ')
     	THETA	= RNUMBER
     $('Incidence Angle [ degrees ] ? ')
     	SIMAG	=  RNUMBER ('Mirror pole to Image Focus Distance ? ')
     	ELSE
     	END IF
     	END IF
	IF (F_EXT.EQ.1) THEN
		IF (FMIRR.EQ.1) THEN
     	RMIRR	=   RNUMBER ('Spherical Mirror Radius ? ')
		ELSE IF (FMIRR.EQ.2) THEN
     	AXMAJ	= RNUMBER ('Elliptical Mirror Semi-Major Axis ? ')
     	AXMIN	= RNUMBER ('Elliptical Mirror Semi-Minor Axis ? ')
     	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)
     $	    'In the elliptical mirror case, it is also necessary to'
     	WRITE(6,*)
     $	    'specify which part of the ellipse is being used. This '
     	WRITE(6,*)
     $       'is achieved by specifing the angle between the major '
     	WRITE(6,*)
     $       'axis and the vector from the ellipse center to the '
     	WRITE(6,*)'mirror pole.'
     	END IF
     	ELL_THE = 
     $RNUMBER ('CCW angle between semi-major axis and pole ? ')
		ELSE IF (FMIRR.EQ.3) THEN
		 WRITE(6,*)
     $'Care !! Enter the torus MAXIMUM radius and the minor radius'
     	R_MAJ	=  RNUMBER ('Tangential [ Major ] Radius ? ')
     	R_MIN	=  RNUMBER ('Sagittal [ Minor ] Radius ? ')
		ELSE IF (FMIRR.EQ.4) THEN
     	IF (IVERB.EQ.1) THEN
     	 WRITE(6,*)'Equation used is      2'
     	 WRITE(6,*)'                    Y    =   2 P X '
     	END IF
     	PARAM	=  RNUMBER ('Parabola Parameter ? ')
		ELSE IF (FMIRR.EQ.7) THEN
     	AXMAJ	= RNUMBER ('Hyperbolical Mirror Semi-Major Axis ? ')
     	AXMIN	= RNUMBER ('Hyperbolical Mirror Semi-Minor Axis ? ')
     	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)
     $       'In the hyperbolical mirror case, it is also necessary '
     	WRITE(6,*)
     $       'to specify which part of the ellipse is being used. '
     	WRITE(6,*)
     $       'This is achieved by specifing the angle between the '
     	WRITE(6,*)
     $       'major axis and the vector from the hyperbola center '
     	WRITE(6,*)'to the mirror pole.'
     	END IF
     	ELL_THE = 
     $	RNUMBER ('CCW angle between semi-major axis and pole ? ')
     		ELSE IF (FMIRR.EQ.8) THEN
     	CONE_A	= RNUMBER ('Cone Half-Opening [deg] ? ')
		END IF
	ELSE
	END IF
**---------------------------------------------------------------------
C#if unix
C	CALL	SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1)  ! Mirror parameters.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
**-----------------------------------------------------------------------
5001	CONTINUE
	IF (IVERB.EQ.1) THEN
	WRITE(6,*)
     $'It may be helpful to save the exact incidence and reflection ',
     $'angles for each ray.  The saved file contains the index of the ',
     $'ray, the incidence angle (in degrees), and the reflection ',
     $'angle for each ray hitting this element.'
	END IF
	F_ANGLE = IYES('Save incidence and reflection angles to disk? ')
     	IF (IVERB.EQ.1) THEN
	WRITE(6,*)
     $' The Optical Element and the the relative mirror are now fully ',
     $'defined. The mirror pole is now located at the "center" of the ',
     $'optical element. It is possible to override this situation and ',
     $'"move" the mirror without affecting the rest of the system.',
     $' It is also possible to move the "source" without affecting the',
     $'rest of the system.',
     $' The movements are expressed in the DEFAULT Mirror Ref. Frame.',
     $' so that if you move BOTH source and mirror the relative',
     $'movement is the vector sum of the individual ones.',
     $'A word of caution: SOURCE movements and MIRROR movements are',
     $'NOT equivalent from the point of view of the whole system.'
     	END IF
     	FSTAT =  IYES ('Do you want to move the Source [ Y/N ] ? ')
		IF (FSTAT.EQ.1) THEN
     	WRITE(6,*)'Source movements in SOURCE REFERENCE FRAME.'
     	WRITE(6,*)'CW rotations are (+) angles.'
     	X_SOUR		=   	RNUMBER	('X-offset ? ')
     	Y_SOUR 		=  	RNUMBER	('Y-offset ? ')
     	Z_SOUR		=   	RNUMBER	('Z-offset ? ')
     	X_SOUR_ROT	=	RNUMBER	('X-rotation ? ')
     	Y_SOUR_ROT	=	RNUMBER	('Y-rotation ? ')
     	Z_SOUR_ROT	=	RNUMBER	('Z-rotation ? ')
     	ALPHA_S = RNUMBER (
     $'Source rotation around Z-axis. CCW is > 0 ')
     	RDSOUR = RNUMBER ('Source Distance from Pole ? ')
     	RTHETA = RNUMBER ('Incidence Angle [ degrees ] ? ')
     	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)'The previous changes are in the SOURCE frame.'
     	WRITE(6,*)'The following OFFSETS are applied in the MIRROR'
     	WRITE(6,*)'reference frame.'
     	END IF
     	OFF_SOUX = RNUMBER ('Source offset in [ x ] ? ')
     	OFF_SOUY = RNUMBER ('                 [ y ] ? ')
     	OFF_SOUZ = RNUMBER ('                 [ z ] ? ')
		ELSE
		END IF
     	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)'   '
	WRITE(6,*)'--- Mirror rotations and position. ---'
     	WRITE(6,*)
     $'We define three angles, as rotations around the three axis.',
     $'These rotation are  defined in the program as corrections to',
     $'the mirror nominal position; that is, they modify the mirror',
     $'position relative to the Default Mirror Reference Frame, where',
     $'all the calculations are performed.',
     $' Remember that rotations',
     $'do NOT commute. I apply them in the same order of entry.',
     $'CW ROTATIONS are (+) angles. ',
     $'A translation can be also applied to the mirror.'
     	END IF
     	F_MOVE = IYES 
     $('Do you want to move the mirror itself [ Y/N ] ? ')
     	IF (F_MOVE.EQ.1) THEN
     	X_ROT	=  RNUMBER ('Rotation around X axis [ degrees ] ? ')
     	Y_ROT	=  RNUMBER ('                Y                  ? ')
     	Z_ROT	=  RNUMBER ('                Z                  ? ')
     	OFFX	=  RNUMBER ('Mirror Offset. In X ? ')
     	OFFY	=  RNUMBER ('                  Y ? ')
     	OFFZ	=  RNUMBER ('                  Z ? ')
     	ELSE
     	END IF
     	F_RIPPLE = IYES ('Distorted surface [ Y/N ] ? ')
     	IF (F_RIPPLE.EQ.1) THEN 		
	  IF (IVERB.EQ.1) THEN
     	WRITE(6,*)'Sinusoidal ripple (0)'
	WRITE(6,*)'Gaussian ripple   (1)'
	WRITE(6,*)'External spline   (2)'
	  END IF
	F_G_S	= IRINT ('Type of distortion ? ')
     	   IF (F_G_S.NE.0) THEN	
     	FILE_RIP	= RSTRING('File to read ? ')
     	   ELSE
     	WRITE(6,*)
     $'Wavelength along the X-axis ?'
     		READ(5,*)X_RIP_WAV
     	WRITE(6,*)
     $'             and the Y-axis ?'
     		READ(5,*)Y_RIP_WAV
     	WRITE(6,*)
     $'Amplitude along the X-axis ?'
     		READ(5,*)X_RIP_AMP
     	WRITE(6,*)
     $'            and the Y-axis ?'
     		READ(5,*)Y_RIP_AMP
     	WRITE(6,*)
     $'Phase for X-axis. 0 means a maximum at the origin. Then ?'
     		READ(5,*)X_PHASE
     	WRITE(6,*)
     $' and  for Y-axis ?'
     		READ(5,*)Y_PHASE
     	   END IF
       	ELSE                                    ! RIP 1
     	END IF
	f_roughness = iyes(
     $'Do you want to include surface roughness [Y/N] ? ' )
	if (f_roughness.eq.1) then
	 file_rough  = rstring( 'File to read ? ')
	 rough_y = rnumber
     $('Roughness RMS in Y direction (along the mirror) [Angstroms] ? ')
	 rough_x = rnumber
     $('Roughness RMS in X direction (transversal) [Angstroms]? ')
	endif
c
**-----------------------------------------------------------------------
C#if unix
C	CALL	SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1)  ! Mirror parameters.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
**--------------------------------------------------------------------
     	F_SCREEN = IYES ('Any screens in this OE [ Y/N ] ? ')
     	IF (F_SCREEN.NE.0) THEN
     	N_SCREEN = IRINT ('How many in this OE [ total ] ? ')
     	DO 11 I=1,N_SCREEN
     	WRITE(6,*)'Screen N. ',I
     	I_SCREEN(I) = IYES ('Is this screen before mirror [ Y/N ] ? ')
     	SL_DIS(I) = RNUMBER('Distance from mirror [ absolute ] ? ')
     	I_SLIT(I) = IYES 
     $('Is Screen Carrying an Aperture Stop [ Y/N ] ? ')
     	 IF (I_SLIT(I).EQ.1) THEN
     	I_STOP(I) = IRINT ('Obstruction [ 1 ] or Aperture [ 0 ] ? ')
     	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)'Kind of slit. Use:'
     	WRITE(6,*)'0		for a rectangular slit'
     	WRITE(6,*)'1		for an elliptical slit'
     	WRITE(6,*)'2		for an "external" slit.'
     	END IF
     	K_SLIT(I) = IRINT ('Stop shape [ 0 r, 1 e, 2 ex ] ? ')
	IF (K_SLIT(I).EQ.2) THEN
#if HP_F77_BUGGY_NAMELIST
# define XXFILSCR FILSCR
#else
# define XXFILSCR FILE_SCR_EXT
#endif
	  XXFILSCR(I) = 
     $		RSTRING('File containing the mask coordinates ? ')
	ELSE
     	  RX_SLIT(I)= RNUMBER ('Dimension along X ? ')
     	  RZ_SLIT(I)= RNUMBER ('                Z ? ')
     	  CX_SLIT(I)= RNUMBER ('Center along X [0.0] ? ')
     	  CZ_SLIT(I)= RNUMBER ('             Z [0.0] ? ')
	ENDIF
     	 ELSE
     	 END IF
     	I_ABS(I)= IYES ('Include absorption [ Y/N ] ? ')
     	   IF (I_ABS(I).EQ.1) THEN
     	WRITE(6,*)
     $'File with optical constants ?'
#ifdef HP_F77_BUGGY_NAMELIST
     	READ (5,111)	FILABS(I)
#else
     	READ (5,111)	FILE_ABS(I)
#endif
     	THICK(I) = RNUMBER ('Thickness of film [ cm ] ? ')
     	   END IF
11     	CONTINUE

     	ELSE
     	END IF
**---------------------------------------------------------------------
C#if unix
C	CALL	SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1)  ! Mirror parameters.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
**---------------------------------------------------------------------
     	FSLIT = IYES ('Slit at continuation plane [ Y/N ] ? ')
		IF (FSLIT.EQ.1) THEN 
     	SLLEN	= RNUMBER ('Slit Length in Sagittal Plane [ x ] ? ')
     	SLWID   = RNUMBER ('Slit Width in Dispersion Plane [ z ] ? ')
     	SLTILT	= RNUMBER ('Slit Tilt, CCW [ degrees ] ? ')
		ELSE
		END IF
     	N_PLATES= IYES ('Extra Image plates [ Y/N ] ? ')
     	IF (N_PLATES.EQ.1) N_PLATES = IRINT ('How many ? ')
     	IF (N_PLATES.GT.0) THEN
     	I	=   1
21     	IF (I.LE.N_PLATES) THEN
     	WRITE(6,*)'Plate # ',I
     	D_PLATE(I) = RNUMBER ('Distance Mirror Center Plate ? ')
     	  I 	=   I + 1
		GOTO 21
     	END IF
     	F_PLATE = IYES ('Plates at orthogonal to Optical Axis ? ')
     	 IF (F_PLATE.EQ.0) THEN
     	IF (IVERB.EQ.1) THEN
     	 WRITE(6,*)
     $'Image plane orientation: the plane is defined by two angles.'
     $,'Take the Y = 0 plane, then rotate it around the X-axis CCW.'
     $,'This is your first angle (elevation). Then rotate it around'
     $,'the Z-axis, still CCW (azimuth) and there you are.'
     	END IF
     	THETA_I = RNUMBER ('Elevation [ degrees ] ? ')
     	ALPHA_I = RNUMBER ('Azimuth               ? ')
     	 ELSE
     	 END IF
     	ELSE
     	END IF
C
C---------------------------------------------------------------------
C
C                SOURCE   FILES
C
C This question applies only to the first OE of an optical system
C
C
     	IF (I_OENUM.EQ.1) THEN
	  FILE_SOURCE = RSTRING ('File containing the source array ? ')
     	END IF
10101	CONTINUE
C
C-----------------------------------------------------------------------
C
C                  SAVE     FILE
C
C
#ifdef vms
    	CALL	FNAME	(FFILE, 'SYS$START:START', I_OENUM, 2)
#else
     	CALL	FNAME	(FFILE, 'start', I_OENUM, 2)
#endif
     	IDUMM = 0
     	CALL	RWNAME	(FFILE, 'W_OE', IDUMM)
     	IF (IDUMM.NE.0) CALL LEAVE 
     $		('INPUT_OE','Error writing NAMELIST',IDUMM)
111	FORMAT (A)
     	WRITE(6,*)'Exit from INPUT'
	END


C	BLOCK DATA 
C     	IMPLICIT	REAL*8		(A-E,G-H,O-Z)
C     	IMPLICIT	INTEGER*4	(F,I-N)
C
C     	COMMON	/CALC	/	NPOINT,NCOL,ISTAR1,IDO_X_S,IDO_Z_S,
C     $				IDO_Y_S,IDO_VZ,IDO_VX,IDO_XL,IDO_XN,
C     $				IDO_ZL,IDO_ZN,N_PLATES,IG_SEED,N_COLOR,
C     $				N_CIRCLE,N_CONE,N_SCREEN,I_SCREEN(10),
C     $				I_SLIT(10),K_SLIT(10),I_STOP(10),
C     $				I_ABS(10),MPURGE(2),NDEG,MOSAIC_SEED
C
C     	DATA	IDO_X_S,IDO_Y_S,IDO_Z_S,IDO_VX,IDO_VZ	/1,1,1,1,1/
C     	DATA	ISTAR1		/ 12345701 /
C
C	END
