	subroutine menutree (menu_name,exit_code)
	implicit integer (a-z)
c++
c	subroutine menutree (menu_name,exit_code)
c
c  Displays menu and sub-menus requested by the user
c  Returns to caller for the following reasons
c
c  0/	Did an uptree function until the menu stack was empty
c  1/   Entered EXIT/STOP/QUIT on one of the data lines
c  2/	Entered control/C
c
c  Assumes main program has done all the appropriate initialization
c
c	menu_name	- input/string
c			  name of menu to execute
c
c	exit_code	- output/integer
c			  reason for return - outlined above
c--
	character*(*) menu_name
c
#if defined(unix) || HAVE_F77_CPP
#	include "parms.inc"
#	include "menu.inc"
#	include "context.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'menu.inc'
	include 'context.inc'
#endif
c
c  initialize menu stack
c
	top_menu_stack=0
	goto_oe=0
	goto_scr=0
c
c  get the index of the next menu to be processed
c
 100	call translate_menuname (menu_name,imenu)
c
c  check for missing menu
c
	if (imenu .lt. 0) then
	  write (message,1000) menu_name
 1000	  format ('Menu requested ("',a,'") has not been implemented')
	  call user_message
	  exit_code=0
	  goto 9900
	endif
c
c  room in menu stack
c
 125	if (top_menu_stack .ge. max_menu_depth) then
	  write (message,1010) top_menu_stack
 1010	  format ('MENUTREE: Menu stack overflow - ',
     *		'Can''t handle more than ',i2,' deep menus')
	  call fatal 
	endif
c
c  put new menu on stack of menus that are active
c
	top_menu_stack=top_menu_stack+1
c
c  enter here when menu stack is popped
c
	menu_stack (top_menu_stack) = imenu
	cur_menu=imenu
	cur_detail_stack (top_menu_stack) = 0
 200	cur_detail_start=m_detail_start(imenu)
	cur_detail_stop=m_detail_stop(imenu)
c
c  check that oe and scr are defined
c
	if (m_type(imenu) .eq. 'OE' .and. cur_oe .eq. 0) then
	  write (message,1030) cur_oe
          call user_message
	  exit_code=0
	  goto 9900
	endif
	if (m_type(imenu) .eq. 'SCR' .and. 
     *		(cur_oe .eq. 0 .or. cur_scr .eq. 0) ) then
	  write (message,1035) cur_oe,cur_scr
	  exit_code=0
	  goto 9900
	endif
 1030	format ('Optical element ',i4,' does not exist')
 1035	format ('Optical element ',i4,' screen ',i4,' does not exist')
c
c  process 1 menu
c    
 	call do1menu (imenu,cur_detail_stack(top_menu_stack),
     *		new_menu,new_detail,exit_code)
	cur_detail_stack (top_menu_stack) = new_detail
c
c  copy goto requests (zero value means ignore)
c
	if (goto_oe .ne. 0) then
	  cur_oe=goto_oe
	  cur_scr=1
	endif
	if (goto_scr .ne. 0) cur_scr=goto_scr
c
c  check for normal uptree operation
c    up to top of tree - then return
c    else pop one menu from menu stack
c
	if (exit_code .eq. 0) then
	  top_menu_stack=top_menu_stack-1
	  if (top_menu_stack .eq. 0) then
	    goto 9900
	  else
	    imenu=menu_stack(top_menu_stack)
	    goto 200
	  endif
	endif
c
c  check for special case - go down to next menu
c  check for move to very same menu - treat at chain rather than call
c
	if (exit_code .eq. -1) then
	  if (imenu .eq. new_menu) goto 200
	  imenu=new_menu
	  goto 125
	endif
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Dispatch on exit code
c
	if (exit_code .lt. 1 .or. exit_code .gt. 2) then
	  write (message,1015) exit_code
 1015	  format ('MENUTREE: Unexpected exit_code (',
     *			i8,') from DO1MENU')
	  call fatal 
	endif
c
	goto (1100,1200) exit_code
c
c  User entered EXIT/QUIT/STOP
c    Pass exit code back to caller
c
 1100	goto 9900
c
c  User entered control/C
c
 1200	goto 9900
c
c  clean off stack
c
 9900	top_menu_stack=0
	call erase_page (1,1)
	call scroll (0)
	call flush_buffer
	return
	end
