C +++
C
C Source: src/utils/optics/torus.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	torus.F
C Revision 1.6  92/01/15  16:28:57  cwelnak
C 6000 changes
C 
C Revision 1.5  91/07/06  19:42:54  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:21:24  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:52:14  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/03/25  15:48:51  khan
C Getting ready for SUN port ...
C 
C Revision 1.1  90/10/10  13:32:54  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C 	PROGRAM		TORUS
C
C	PURPOSE		To compute the major and minor radiuses of
C			a toroidal mirror.
C
C---
     	PROGRAM		TORUS
     	
     	IMPLICIT	REAL*8	(A-H, O-Z)
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

     	CHARACTER*80	RSTRING,FNAME

     	FNAME	=   RSTRING('Name to use for log file ? ')
#ifdef vms
     	OPEN (20, FILE=FNAME, STATUS='NEW')
#else
     	OPEN (20, FILE=FNAME, STATUS='UNKNOWN')
	REWIND (20)
#endif
1     	TOBJ	=   RNUMBER ('Tangential Object: ')
     	TIMA	=   RNUMBER ('            Image: ')
     	SOBJ	=   RNUMBER ('Sagittal   Object: ')
     	SIMA	=   RNUMBER ('            Image: ')
     	THETA	=   RNUMBER ('Incidence   Angle: ')
     	
     	FTAN	=   TOBJ*TIMA/(TOBJ+TIMA)
     	FSAG	=   SOBJ*SIMA/(SOBJ+SIMA)

     	RMAJ	=   FTAN/COS(TORAD*THETA)*2
     	RMIN	=   FSAG*COS(TORAD*THETA)*2

     	WRITE	(6,*)	'Tangential.'
     	WRITE	(6,*)	'Focal length         = ',FTAN
     	WRITE	(6,*)	'Optical Radius       = ',RMAJ
     	
     	WRITE	(6,*)	'Sagittal.'
     	WRITE	(6,*)	'Focal length         = ',FSAG
     	WRITE	(6,*)	'Radius               = ',RMIN

     	WRITE	(20,*)	'Tangential.'
     	WRITE	(20,*)	'Angle                = ',THETA
     	WRITE	(20,*)	'Object		      = ',TOBJ
     	WRITE	(20,*)  'Image		      = ',TIMA
     	WRITE	(20,*)	'Focal length         = ',FTAN
     	WRITE	(20,*)	'Optical Radius       = ',RMAJ
     	
     	WRITE	(20,*)	'Sagittal.'
     	WRITE	(20,*)	'Object		      = ',SOBJ
     	WRITE	(20,*)  'Image		      = ',SIMA
     	WRITE	(20,*)	'Focal length         = ',FSAG
     	WRITE	(20,*)	'Radius               = ',RMIN

     	IF (IYES('Continue ? ').EQ.1) GOTO 1
     	
     	STOP
     	
     	END
