	subroutine menuSimple (menu_name,exit_code)
	implicit integer (a-z)
c++
c	subroutine menuSimple (menu_name,exit_code)
c
c  Displays menu requested by the user.  No submenus are allowed
c    uses line at a time type of input.  Does not deal with GOTO fields
c  Returns to caller for the following reasons
c
c  0/	Normal exit from menu
c  1/   Entered EXIT/STOP/QUIT on one of the data lines
c  2/	Entered control/C
c
c  Assumes main program has done all the appropriate initialization
c
c	menu_name	- input/string
c			  name of menu to execute
c
c	exit_code	- output/integer
c			  reason for return - outlined above
c--
	character*(*) menu_name
c
#if defined(unix) || HAVE_F77_CPP
#	include "parms.inc"
#	include "menu.inc"
#	include "context.inc"
#	include "nldata.inc"
#	include "acc.inc"
#	include "helplib.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'menu.inc'
	include 'context.inc'
	include 'nldata.inc'
	include 'acc.inc'
	include 'helplib.inc'
#endif
c
	character*6 special_word (6)
	integer	    special_exit (6)
	data special_word /'EXIT','QUIT','RETURN','STOP','HELP','?'/
	data special_exit / 1   , 1    , 1      , 1    , 3     , 3 /
c
	character*(l_prompt) prompt
c
	character*(l_val+10) string
c
c  reset scroll region
c
	call scroll (0)
c
c  get the index of the next menu to be processed
c
 	call translate_menuname (menu_name,imenu)
c
c  check for missing menu
c
	if (imenu .lt. 0) then
	  write (message,1000) menu_name
 1000	  format ('Menu requested ("',a,'") has not been implemented')
	  call simpleMessage 
	  exit_code=0
	  goto 9900
	endif
c
	cur_menu=imenu
	cur_detail_start=m_detail_start(imenu)
	cur_detail_stop=m_detail_stop(imenu)
c
c  start at the beginning of the menu
c
	detail=cur_detail_start
c
c  this helps to detect lines that are to be skipped
c
	lastline=d_line(cur_detail_start)
c
c look for kind of field and handle appropriately
c how many lines to skip
c
 100	do i=lastline,d_line(detail)-1
	  call tt_write (' ')
	end do
c
c  save current line number
c
	lastline=d_line(detail)
c
c  is this simple text
c
	if (d_name(detail) .eq. ' ') then
	  call tt_writeTrim (d_prompt(detail))
	  goto 900
	endif
c
c  insert code to check flag here
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  get a value
c  
	key=0
	call nl_find (key,d_rec(detail),d_name(detail),
     *		d_own1(detail),d_own2(detail))
c
c  did it find a match
c
	  if (key .eq. 0) then
	    write (message,1020) d_rec(detail),d_name(detail)
 1020	    format ('DISPLAY1: Record type "',a,'" Variable "',a,
     *		'" is undefined')
	    call fatal 
	  endif
c
c  copy key for quick update
c
	d_key(detail)=nl_key
c
c  solicit input for this line
c
	ldetail=ltrim (d_prompt(detail))
 200	call tt_prompt (d_prompt(detail)(:ldetail)//': ',
     *		string,linput,tt_code)
c
c  check for control/C
c
	if (tt_code .eq. 1) then
	  exit_code=2
	  goto 9900
	endif
c
c  normal termination of read
c    remove leading spaces
c    translate to uppercase
c
 	if (linput .eq. 0) then
	  string=' '
	  goto 500
	else if (linput .lt. len(string) ) then
	  string (linput+1:)=' '
	endif
c
	call leftjustify (string)
#ifdef vms
	call upcase (string)
#else
	if (nl_datatype .ne. 'A') then
	    call upcase (string)
	endif
#endif
c
c  look for special words
c
	do i=1,6
	  if (string .eq. special_word(i)) goto 400
	end do
	goto 500
c
c  Stop word or Help word
c
 400	code=special_exit (i)
	if (code .eq. 1) then
	  exit_code=1
	  goto 9900
	else if (code .eq. 3) then
c
c  special case: HELP
c
	  call help (helplibm,1,d_name(detail) )
	  call controlc (iflag)
	  if (iflag .ne. 0) then
	    exit_code=2
	    goto 9900
	  else
c
c  try again
c
	    goto 200
	  endif
	endif
c
c  convert to internal value
c
 500 	call nl_unpack (d_key(detail))
c
c  don't accept space for numeric input fields
c
	if (nl_datatype .ne. 'A' .and. string .eq. ' ') then
	  call tt_write (
     *		'Blank response allowed for text fields only')
	  goto 200
	endif
	call convert (d_name(detail),nl_datatype,string,code)
	if (code .lt. 0) then
c
c  display message and await response
c
	  message=acc_message
	  call simpleMessage
	  goto 200
	endif
c
c  store new value
c
	nl_int=acc_int
	nl_real=acc_real
	nl_string=acc_string
	call nl_update (d_key(detail),d_rec(detail),d_name(detail),
     *			d_own1(detail),d_own2(detail))
c
c  next detail line
c
 900	detail=detail+1
	if (detail .le. cur_detail_stop) goto 100
	exit_code=0
c
 9900	return
	end
