C +++
C
C Source: src/tools/math/kmod1.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	kmod1.f
C Revision 1.2  90/11/13  14:03:04  khan
C Cleanup and SAVE statements
C 
C Revision 1.1  90/07/17  13:54:56  khan
C Initial revision
C 
C 
C ---

C**************************************************************
	IMPLICIT REAL*8 (A-H,O-Z)
	DIMENSION ARRX(50),ARR(50,3)
	PI=3.141592653589793238D0
	IQ=0
	DO 100 I=1,2
	IQ=IQ+1
	A=0.0001
	B=0.0011
	C=0.0001
	ORD=((I-1)**2+1)/3.0D0
	IC=0
	DO 200 N=1,4
	A=A*10.0
	B=B*10.0
	C=C*10.0
	DO 300 X=A,B,C
	IC=IC+1
	CALL BSKM(X,BK,IQ,ORD)
	ARR(IC,I)=BK
C
C Added the 5/3 case by recursion formula -- Nov 26 1983
C						F.C.
C
     	IF (I.EQ.2) THEN
     	 ARR(IC,3) = ARR(IC,1) + ARR(IC,2)*4/X/3
     	END IF
	ARRX(IC)=X
300	CONTINUE
200	CONTINUE
100	CONTINUE
	OPEN(UNIT=2,FILE='BSKM',STATUS='UNKNOWN')
C	OPEN(UNIT=2,FILE='BSKM',STATUS='NEW',DISPOSE='SAVE')
	WRITE(2,1000)
1000	FORMAT(1X,' MODIFIED BESSEL FUNCTION OF ORDER N ',//)
	WRITE(2,1100)
1100 	FORMAT(1X,' X= ',T20,' N=1/3 ',T40,' N=2/3 ',T60,' N=5/3 ',//)
	WRITE(2,1200) (ARRX(I),(ARR(I,KL),KL=1,3),I=1,IC)
1200	FORMAT(1X,G14.7,T20,G14.7,T40,G14.7,T60,G14.7)
	CLOSE(UNIT=2,DISPOSE='SAVE')
	STOP
	END
C***************************************************************
	SUBROUTINE FACT(K,FAC)
	IMPLICIT REAL*8 (A-H,O-Z)
	FAC=1.0D0
	IF (K.EQ.0) RETURN
	DO 100 I=1,K
100	FAC=FAC*I
	RETURN
	END
C****************************************************************
	SUBROUTINE BSKM(X,BK,IQ,ORD)
	IMPLICIT REAL*8 (A-H,O-Z)
	PI=3.141592653589793238D0
	K=0
	BK=0.0
100	CONTINUE
	CALL GAMMA(K,IQ,GP,GM)
	CALL FACT(K,FAC)
	XX2=(X/2)**K
	PSUM1=-(X/2)**(ORD)/FAC/GP*XX2
	PSUM1=PSUM1*XX2
	PSUM2=(X/2)**(-ORD)/FAC/GM*XX2
	PSUM2=PSUM2*XX2
	PSUM=PSUM1+PSUM2
	PSUM=PSUM*PI/2/SIN(ORD*PI)
	BK=BK+PSUM
	IF (ABS(PSUM).LT.1.0E-15)RETURN
	K=K+1
	IF (K.GT.100) GOTO200
	GO TO 100
200	STOP
	END
C********************* GAMMA FRACTIONAL ************************
	SUBROUTINE GAMMA(K,IQ,GP,GM)
	IMPLICIT REAL*8 (A-H,O-Z)
	G13=2.678938534707748D0
	G23=1.354117939426400D0
	GG=1.0D0
	GOTO (10,20,30), IQ
C************************ GAMMA FOR ORD=1/3 **************************
10	IF (K.EQ.0)THEN
	  GM=G23
	  GP=G13/3
	ELSE
	KK=K+1
	  DO100I1=1,KK
100	  GG=(3*I1-2)/3.0D0*GG
	  GP=GG*G13
	GG=1.0D0
	  DO200I1=1,K
200	  GG=(3*I1-1)/3.0D0*GG
	  GM=GG*G23
	END IF
	RETURN
C**************************GAMMA FOR ORD=2/3**********************
20	IF (K.EQ.0)THEN
	  GM=G13
	  GP=2/3.0D0*G23
	ELSE
	KK=K+1
	  DO 300 I1=1,KK
300	  GG=(3*I1-1)/3.0D0*GG
	  GP=GG*G23
	GG=1.0D0
	  DO 400 I1=1,K
400	  GG=(3*I1-2)/3.0D0*GG
	  GM=GG*G13
	END IF
	RETURN
C********************GAMMA FOR ORD=5/3********************************
30	CONTINUE
C****** NOT READY *********
	RETURN
	END
	
	
