//
// excon.cc: main driver for EXCON engine.
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

/****************************************************************************
 *
 *  excon.c: EXCON main driver program.
 *
 ****************************************************************************/

#include <iostream.h>

#if HAVE_UNISTD_H
# include <unistd.h>
#endif
#include <stdlib.h>
#include <string.h>

#include "daemon.h"
#include "excon_init.h"
#include "exp.h"
#include "global.h"
#include "logger.h"
#include "misc.h"
#include "tool.h"

/****************************************************************************
 *
 *  MAIN 
 *
 ****************************************************************************/

int main(int argc, char** argv) {

    cout << "EXCON/SHADOW Batch Version 1.1." << endl;

    string toolsfile, expfile, output;
    bool background = false;
    excon_init(argc, argv, toolsfile, expfile, output, background);

    // LOAD TOOLS FILE
    if (Globals::toolsmgr->load (toolsfile.c_str())) {
	EXCON_LOG_ALWAYS
	    << "EXCON: Errors found int TOOLS file(s). Fix and re-run"
	    << endl;
	exit(1);
    }

    // LOAD EXPERIMENT FILE
    if (Globals::expmgr->load (expfile.c_str())) {
	EXCON_LOG_ALWAYS
	    << "EXCON: Errors found in EXPERIMENT file(s). Fix and re-run"
	    << endl;
	exit(1);
    }

    //
    // Set the output file (report) Must not set before loading the exp.
    //
    Globals::expmgr->setoutput (output.c_str());

    Globals::expmgr->unlinkreports (); 

    if (background)
	UnixDaemon::start(Globals::curdir.c_str());

    Globals::expmgr->run ();

    EXCON_LOG_ALWAYS << endl << "Experiment completed successfully." << endl;

    // ...STATISTICS
    Globals::stats->report();

    // ...RESULTS
    Globals::expmgr->reportresults ();

    exit(0);
}
