C +++
C
C Source: src/source/bm/power.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	power.F
C Revision 1.2  90/07/18  19:11:49  khan
C Removed most of the subroutines to BM library (libbm.a) since these are
C called by most of the other programs.
C Also added #if vms ... #elif unix ... to OPEN statements.
C 
C Revision 1.1  90/07/11  10:44:58  khan
C Initial revision
C 
C 
C ---

C+++
C	program		power
C
C	purpose		to test the calculations of power density
C---
     	IMPLICIT	REAL*8	(A-H, O-Z)
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
     	CHARACTER*80	RSTRING,OUTFIL
     	THETAMIN	=   RNUMBER ('Theta minimum [ mrad ] ? ')
     	THETAMAX	=   RNUMBER ('      max              ? ')
     	NT	=   IRINT ('Number of points? ')
     	EMIN		=   RNUMBER ('Minimum Energy [ eV ] ? ')
     	EMAX		=   RNUMBER ('Maximum               ? ')
     	NE	=   IRINT ('Number of points? ')
     	THES	=   (THETAMAX-THETAMIN)/(NT-1)
     	EST	=   (EMAX-EMIN)/(NE-1)
     	BENER	=   RNUMBER ('Beam energy [ GeV ] ? ')
     	CURR	=   RNUMBER ('     current [ A ]  ? ')
     	RADIUS	=   RNUMBER ('     radius  [ m ]  ? ')
     	DIST	=   RNUMBER ('Target distance [ m ] ? ')
     	OUTFIL	=   RSTRING ('File name ? ')
     	GAMMA	=   1957.0*BENER
     	R_LAM	=   4.0*PI*RADIUS/3.0/GAMMA**3		!Critical wavel
     	R_LAM	=   R_LAM*1.0D10			!Angstroms
     	C_ENER	=   TOANGS/R_LAM
     	WRITE(6,*)'Critical energy = ',C_ENER
C
C Scaling Factor. Flux is in Phot/mrad^2/eV;
C DIST(m) * 1 mrad = size in mm /10 -> size in cm
C
     	E_CHAR	=   1.602E-19
C
C The routine returns #/eV/mA/mrad^2. Use FACT to go to Watts/mrad^2
C
     	FACT	=   E_CHAR*CURR*1000	!
C
C Geometrical factors. DIST * 1mrad = mm /10 = cm
C
     	COEFF	=   1.0d0/(DIST**2/100)
     	WRITE(6,*)'The calculations will refer to 1 mrad orbit.'
     	IERR	= -1
	IPOL	= 3
#ifdef vms
     	OPEN	(31, FILE=OUTFIL, STATUS='NEW')
#else
     	OPEN	(31, FILE=OUTFIL, STATUS='UNKNOWN')
	REWIND  (31)
#endif
     	CALL	BEND_PHOT (RN, 0.0D0, 0.0D0, GAMMA, C_ENER, IPOL, IERR)
     	IF (IERR.NE.0) STOP 'Open error'
     	WRITE(6,*)'Data ready. Proceed with computation.'
     	PTOT	=  0.0D0
     	DO 10 I=1,NT
     	  THETA = THETAMIN + THES*(I-1)
     	  THECA = THETA*1.0E-3
	  THEA	= ABS(THECA)
     	  PWR	= 0.0D0
     	 DO 20 J=1,NE
     	   ENER	= EMIN +(J-1)*EST
     	   IERR = 1
     	   CALL BEND_PHOT (RN, THEA, ENER, GAMMA, C_ENER, IPOL, IERR)
     	  IF (IERR.EQ.0) THEN
     	    PWR = PWR + ENER*RN*EST*FACT*COEFF
     	    PTOT = PTOT + ENER*RN*EST*FACT*THES
     	  ELSE
     	    WRITE(6,*)'Error detected. IERR= ',IERR,I,J
     	    WRITE(6,*)'Ener = ',ENER,' Theta= ', THECA
C     	    NE = J-1
C    	    IF (NE.EQ.0) GO TO 100
     	    GOTO 200
     	  END IF
 20    	 CONTINUE
200    	  CONTINUE
     	  WRITE (31,*) THETA*DIST, PWR
 10    	CONTINUE
     	WRITE(6,*)'Total power is ',PTOT
     	CLOSE (31)
     	STOP
     	STOP
100	CONTINUE
     	WRITE(6,*)'No sense continuing.'
     	WRITE(6,*)'Total power is ',PTOT
     	CLOSE (31)
     	STOP
     	STOP
     	END
