C +++
C
C Source: src/lib/myran.F
C
C Author: Mumit Khan<khan@xraylith.wisc.edu>
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: myran.F
c Revision 1.2  1995/08/28  23:03:36  khan
c SHADOW/f2c (linux) first cut. Working release, but not well tested
c
c Revision 1.1.1.1  1995/08/24  23:14:57  khan
c SHADOW v2.1 20-jan-1995 dist release
c
C Revision 1.7  1992/01/23  19:42:36  cwelnak
C 6000 changes
C
C Revision 1.6  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.6  91/04/22  15:17:10  khan
C Goof with adding #ifdefs
C 
C Revision 1.5  91/04/22  00:39:40  khan
C EXIT() doesn't seem to work on Ultrix. Replace with STOP. YUK!
C 
C Revision 1.4  1991/04/05  13:54:30  cwelnak
C changed quotes on #include
C
C Revision 1.3  91/03/25  14:45:06  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/03/15  15:38:11  khan
C Getting ready for Sun port...
C 
C Revision 1.1  91/02/21  14:33:38  khan
C Initial revision
C 
C Revision 1.2  91/01/29  13:56:00  cwelnak
C added REAL*4 RAN statement
C 
C Revision 1.1  91/01/24  10:41:30  khan
C Initial revision
C 
C 
C ---


#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif


#if !HAVE_DRAND48 && !defined(F2C) && !defined(USE_DRAND48)

C +++
C	REAL FUNCTION	WRAN (ISEED)
C
C This function is simply a wrapper around the "real" (intrinsic) random
C number generator, RAN, supplied by all FTN compilers. It servers two
C purposes: filter out "bad" random numbers (== 0 in SHADOW) and allow
C SHADOW to read its random numbers out of a text file, so we can get 
C the results across platforms.
C
C 1/23/92 added the option to use the RAND function (IBM RS600
C specfically) in the absence of a RAN function.  Also, when the 6000
C compiler becomes able to handle the CALL EXIT, the STOP should be
C removed. (*update*).
C
C 		ISEED: the seed to give RAN.
C
C #if USE_INTRINSIC_RAN
C ---


	DOUBLE PRECISION FUNCTION WRAN (ISEED)
     	IMPLICIT	REAL*8		(A-H,O-Z)
	INTEGER	ISEED
	INTEGER ITERATION
C
C Adding variables needed for option to read random number series from
C a file, currently called ranfile.  At this point the appropriate line
C should be commented to change LFILE from .TRUE. to .FALSE., and the
C program recompiled.
C
	INTEGER		ICOUNT
	LOGICAL		LFILE, LINIT
	DIMENSION	CXRLRAN(50000)
	DATA		LINIT /.TRUE./
C	DATA		LFILE /.TRUE./
	DATA		LFILE /.FALSE./
	SAVE		LFILE,LINIT,CXRLRAN,ICOUNT

#ifndef vms
	REAL	RAN
#endif
C
#ifdef rs6000
	REAL	RAND
	LOGICAL	LFIRST
	DATA	LFIRST /.TRUE./
	SAVE	LFIRST
C
	IF (LFIRST) THEN
	  CALL SRAND (ISEED)
	  LFIRST = .FALSE.
	ENDIF
C
#endif
C
	IF (LFILE) THEN			! read random no.s from file
	   IF (LINIT) THEN		! initialize array 
	     OPEN(20,FILE='ranfile',FORM='FORMATTED',STATUS='OLD')
	     DO 99 I = 1,50000
99	     READ(20,*) CXRLRAN(I)
	     CLOSE(20)
	     ICOUNT = 1
	     LINIT = .FALSE.
	   ENDIF
	   IF (ICOUNT.GT.50000) THEN
	     WRITE (*,*) 'ERROR:  Read past end of RANFILE. Aborting'
#ifdef rs6000
	     STOP 1
#else
	     CALL EXIT(1)
#endif
C	   ELSE
C	     WRITE (6,*) 'ICOUNT = ',ICOUNT
	   ENDIF
	   TESTRAN = CXRLRAN(ICOUNT)
	   ICOUNT = ICOUNT + 1
	ELSE				! normal case
	ITERATION = 1
 10	CONTINUE
#ifdef rs6000
	TESTRAN = RAND ()
#else
	TESTRAN = RAN (ISEED)
#endif
	IF (TESTRAN .LT. 1.0E-20) THEN
	    ITERATION = ITERATION + 1
	    IF (ITERATION .GE. 10) THEN
		WRITE (*,*) 
     $		'ERROR: RAN returned 0.0D0 10 times. Aborting'
#ifdef rs6000
		STOP	1
#else
		CALL	EXIT (1)
#endif
	    ELSE
		GOTO 10
	    ENDIF
	ENDIF
C
	ENDIF			! file and normal cases rejoin
	WRAN = TESTRAN
	RETURN
	END
C

#else
c
c some machine, eg., rs6k xlf, has serious trouble with empty object file
c so we have to define something here. drag.
c
	subroutine myran_place_holder
	return
	end
#endif
