C +++
C
C Source: src/lib/mdnris.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: mdnris.f
C Revision 1.3  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.2  90/10/24  17:32:02  khan
C Added REAL() cast around SIGN() to make it work on VMS.
C 
C Revision 1.1  90/07/10  14:56:28  khan
C Initial revision
C 
C 
C ---

C   IMSL ROUTINE NAME   - MDNRIS                                        MDRS0010
C                                                                       MDRS0020
C-----------------------------------------------------------------------MDRS0030
C                                                                       MDRS0040
C   COMPUTER            - VAX/SINGLE                                    MDRS0050
C                                                                       MDRS0060
C   LATEST REVISION     - JUNE 1, 1981                                  MDRS0070
C                                                                       MDRS0080
C   PURPOSE             - INVERSE STANDARD NORMAL (GAUSSIAN)            MDRS0090
C                           PROBABILITY DISTRIBUTION FUNCTION           MDRS0100
C                                                                       MDRS0110
C   USAGE               - CALL MDNRIS (P,Y,IER)                         MDRS0120
C                                                                       MDRS0130
C   ARGUMENTS    P      - INPUT VALUE IN THE EXCLUSIVE RANGE (0.0,1.0)  MDRS0140
C                Y      - OUTPUT VALUE OF THE INVERSE NORMAL (0,1)      MDRS0150
C                           PROBABILITY DISTRIBUTION FUNCTION           MDRS0160
C                IER    - ERROR PARAMETER (OUTPUT)                      MDRS0170
C                         TERMINAL ERROR                                MDRS0180
C                           IER = 129 INDICATES P LIES OUTSIDE THE LEGALMDRS0190
C                             RANGE. PLUS OR MINUS MACHINE INFINITY IS  MDRS0200
C                             GIVEN AS THE RESULT (SIGN IS THE SIGN OF  MDRS0210
C                             THE FUNCTION VALUE OF THE NEAREST LEGAL   MDRS0220
C                             ARGUMENT).                                MDRS0230
C                                                                       MDRS0240
C   PRECISION/HARDWARE  - SINGLE/ALL                                    MDRS0250
C                                                                       MDRS0260
C   REQD. IMSL ROUTINES - MERFI,UERTST,UGETIO                           MDRS0270
C                                                                       MDRS0280
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           MDRS0290
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      MDRS0300
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  MDRS0310
C                                                                       MDRS0320
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       MDRS0330
C                                                                       MDRS0340
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN MDRS0350
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    MDRS0360
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        MDRS0370
C                                                                       MDRS0380
C-----------------------------------------------------------------------MDRS0390
C                                                                       MDRS0400
      SUBROUTINE MDNRIS (P,Y,IER)                                       MDRS0410
C                                  SPECIFICATIONS FOR ARGUMENTS         MDRS0420
C     REAL               P,Y                                            MDRS0430
      IMPLICIT DOUBLE PRECISION   (A-H,O-Z)
C     DOUBLE PRECISION   P,Y                                            MDRS0430
      INTEGER            IER                                            MDRS0440
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   MDRS0450
C     REAL               EPS,G0,G1,G2,G3,H0,H1,H2,A,W,WI,SN,SD          MDRS0460
C     REAL               SIGMA,SQRT2,X,XINF                             MDRS0470
C
      DATA               XINF/1.7014E+38/                               MDRS0480
      DATA               SQRT2/1.414214/                                MDRS0490
      DATA               EPS/1.1921E-07/                                MDRS0500
      DATA               G0/.1851159E-3/,G1/-.2028152E-2/               MDRS0510
      DATA               G2/-.1498384/,G3/.1078639E-1/                  MDRS0520
      DATA               H0/.9952975E-1/,H1/.5211733/                   MDRS0530
      DATA               H2/-.6888301E-1/                               MDRS0540
C                                  FIRST EXECUTABLE STATEMENT           MDRS0550
      IER = 0                                                           MDRS0560
      IF (P .GT. 0.0 .AND. P .LT. 1.0) GO TO 5                          MDRS0570
      IER = 129                                                         MDRS0580
C
C Need the followin REAL() cast to make the intrinsic function work on VMS
C
      SIGMA = REAL (SIGN(1.0, REAL(P)))                                 MDRS0590
      Y = SIGMA * XINF                                                  MDRS0600
      GO TO 9000                                                        MDRS0610
    5 IF(P.LE.EPS) GO TO 10                                             MDRS0620
      X = 1.0 -(P + P)                                                  MDRS0630
      CALL MERFI (X,Y,IER)                                              MDRS0640
      Y = -SQRT2 * Y                                                    MDRS0650
      GO TO 9005                                                        MDRS0660
C                                  P TOO SMALL, COMPUTE Y DIRECTLY      MDRS0670
   10 A = P+P                                                           MDRS0680
      W = SQRT(-ALOG(real(A+(A-A*A))))                                  MDRS0690
C                                  USE A RATIONAL FUNCTION IN 1./W      MDRS0700
      WI = 1./W                                                         MDRS0710
      SN = ((G3*WI+G2)*WI+G1)*WI                                        MDRS0720
      SD = ((WI+H2)*WI+H1)*WI+H0                                        MDRS0730
      Y = W + W*(G0+SN/SD)                                              MDRS0740
      Y = -Y*SQRT2                                                      MDRS0750
      GO TO 9005                                                        MDRS0760
 9000 CONTINUE                                                          MDRS0770
      CALL UERTST(IER,6HMDNRIS)                                         MDRS0780
 9005 RETURN                                                            MDRS0790
      END                                                               MDRS0800
