C +++
C
C Source: src/utils/pre/prerefl.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	prerefl.F
C Revision 1.6  92/01/16  15:34:10  cwelnak
C 6000 changes
C 
C Revision 1.5  91/07/06  19:20:42  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:57:22  cwelnak
C changed quotes on #includes
C 
C Revision 1.3  91/03/25  16:26:14  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:50:34  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/10  13:12:57  khan
C Added Pre-processor directives for Unix/VMS compilations
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

***********************************************************************
*	program 	PREREFL					      *
*								      *
*	F.Cerrina,	SRC - June 1983				      *
*			Modified July 1986
*								      *
* This program is based on the compilation of atomic scattering factors
* of B.Henke, Low Energy X-Ray Diagnostics - 1981 and formulaes therein
* The photon energy range is 30-100000 eV, for all elements.	      *
*
* This program will generate a file of the right structure for Shadow *
* The output will be an array in energy				      *
*								      *
C	Link with READLIB.OBJ
***********************************************************************
     	PROGRAM		PREREFL
     	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
	REAL*4		RF1(420),RF2(420),ENERGY(420),OUTFIL(420,2)
	REAL*4		DENSITY
	CHARACTER*80	OUT_FILE,RSTRING
	DIMENSION	AF1(N_DIM),AF2(N_DIM)
	EQUIVALENCE	(OUTFIL(1,1),RF1(1))	
	EQUIVALENCE	(OUTFIL(1,2),RF2(1))	
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

     	RADIUS	=   2.817939 D-13
	I_TYPE	= IRINT ('Element [0] or compound [1] ? ')
     	DENSITY	= RNUMBER('Density [ g/cm3 ] ?')
	IF (I_TYPE.EQ.0) THEN
	  CALL	OPT_ELE	(RF1,RF2,ENERGY,DENSITY)
	ELSE IF (I_TYPE.EQ.1) THEN
	  CALL	OPT_COM	(RF1,RF2,ENERGY,DENSITY)
	ELSE 
	  STOP	'Error !  Invalid response.'
	END IF
     	 WRITE(6,*) 'Enter starting photon energy,end and step'
     	READ(*,*) ESTART,EFINAL,ESTEP
     	OUT_FILE	= RSTRING('Output file : ')

     	QMIN	=   (ESTART)/TOCM*TWOPI
     	QMAX	=   (EFINAL)/TOCM*TWOPI
     	QSTEP	=   (ESTEP)/TOCM*TWOPI
     	NPOINT	=  (EFINAL-ESTART)/ESTEP + 1
	DEPTH0	=   DENSITY/2.0E0
	IF (NPOINT.GT.N_DIM) STOP	'Too many points (*N_DIM* max.)'
** Computes the ALPHA and gamma coefficients.
*** Finds and interpolate for the photon energy.
#ifdef vms
     	OPEN (20,FILE=OUT_FILE,STATUS='NEW',FORM='UNFORMATTED')
#else
     	OPEN (20,FILE=OUT_FILE,STATUS='UNKNOWN',FORM='UNFORMATTED')
	REWIND (20)
#endif
     	WRITE (20)	QMIN,QMAX,QSTEP,DEPTH0
     	WRITE (20)	NPOINT
	ELFACTOR	= LOG10(1.0E4/30.0)/300.0
     	DO 11 I=1,NPOINT
     	PHOTON	=   ESTART + (I-1)*ESTEP
	NENER	=   LOG10(PHOTON/30.0E0)/ELFACTOR + 1
     	F1	=   OUTFIL(NENER,1) + 
     $	(OUTFIL(NENER+1,1) - OUTFIL(NENER,1))*(PHOTON - ENERGY(NENER))/
     $	(ENERGY(NENER+1) - ENERGY(NENER))
     	F2	=   OUTFIL(NENER,2) + 
     $	(OUTFIL(NENER+1,2) - OUTFIL(NENER,2))*(PHOTON - ENERGY(NENER))/
     $	(ENERGY(NENER+1) - ENERGY(NENER))
*** Computes now ALPHA and gamma
     	WAVE	=   TOCM/PHOTON
     	ALPHA	=   RADIUS/PI*(WAVE**2)*F1
     	GAMMA	=   RADIUS/PI*(WAVE**2)*F2
     	AF1(I)	=   (ALPHA)
     	AF2(I)  =   (GAMMA)
11     	CONTINUE
     	WRITE (20)	(AF1(I),I=1,NPOINT)
     	WRITE (20)	(AF2(I),I=1,NPOINT)
     	CLOSE (20)
     	CALL	EXIT (0)
     	END

C+++
C	SUBROUTINE	OPT_ELE
C
C	Purpose		Returns alpha and gamma for an element
C			
C---
     	SUBROUTINE	OPT_ELE (RF1,RF2,ENERGY,DENSITY)
	REAL*4		ATWT,RMU,EMF,DENSITY
     	REAL*4		ENERGY(420),RF1(420),RF2(420)
     	INTEGER *4 	NUMBER
	CHARACTER*2	ELEMENT
	CHARACTER*80	RSTRING
     	DATA	AVOG	/  6.022098     E+23 		     /
     	ELEMENT	= RSTRING('Enter atomic symbol (capitalized) : ')
** Get the data
	CALL 	READLIB(ELEMENT,NUMBER,ATWT,RMU,EMF,ENERGY,RF1,RF2)
** Computes atomic concentration
     	ATOMS	=   DENSITY/ATWT*AVOG
C 
C Return the scattering factor weighed by atomic concentration.
C
	DO 12 I = 1, 420
	  RF1(I)	= ATOMS*RF1(I)
12 	CONTINUE
	DO 13 I = 1, 420
	  RF2(I)	= ATOMS*RF2(I)
13 	CONTINUE
     	RETURN
     	END
C+++
C	SUBROUTINE	OPT_COM
C
C---
     	SUBROUTINE	OPT_COM (RF1,RF2,ENERGY,DENSITY)
	REAL*4		ATWT,RMU,EMF,DENSITY
     	REAL*4		RF1(420),RF2(420),ENERGY(420)
	DIMENSION	IREL(5)
     	INTEGER *4 	NUMBER,NATOM(5)
	CHARACTER*2	ELEMENT(5),ELE
	CHARACTER*80	RSTRING
     	REAL*4		OUTFIL11(420),OUTFIL12(420)
     	REAL*4		OUTFIL21(420),OUTFIL22(420)
     	REAL*4		OUTFIL31(420),OUTFIL32(420)
     	REAL*4		OUTFIL41(420),OUTFIL42(420)
     	REAL*4		OUTFIL51(420),OUTFIL52(420)
     	REAL*4		AT(5),RREL(5)
     	AVOG	=   6.022098 E+23
     	DO 14 I = 1,5
     	  IREL(I) = 0
     	  RREL(I) = 0.0
14      CONTINUE
     	 WRITE(6,*) 'The program is setup to compute optical constants of'
     	 WRITE(6,*) 'compounds with up to 5 elements.'
     	NATOMS	= IRINT('How many atomic species : ')
     	NTOT = 0
     	 WRITE(6,*) 'H2O would be: H, 2 and O, 1.'
     	DO 16 I = 1,NATOMS
     	   WRITE(6,*) 'Enter atomic symbol (capitalized) and ',
     $'formula index for : ',I
	  ELEMENT(I)	= RSTRING(' ')
     	  IREL(I)	= IRINT(' ')
     	  NTOT 		= NTOT + IREL(I)
16      CONTINUE
     	DO 17 I=1,NATOMS
     	  RREL(I) = FLOAT(IREL(I))/NTOT
17     	CONTINUE
** Get the data. F1 and F2 are then 'averaged' together
     	RMOL	= 0.0
     	GO TO (55,44,33,22,11)	NATOMS
11	ELE	= ELEMENT(5)
	CALL	READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL51,OUTFIL52)
	NATOM(5)	= NUMBER
     	RMOL	=          ATWT*IREL(5)
22	ELE	= ELEMENT(4)
	CALL	READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL41,OUTFIL42)
	NATOM(4)	= NUMBER
     	RMOL	= RMOL+          ATWT*IREL(4)
33	ELE	= ELEMENT(3)
	CALL	READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL31,OUTFIL32)
	NATOM(3)	= NUMBER
     	RMOL	= RMOL+         ATWT*IREL(3)
44	ELE	= ELEMENT(2)
	CALL	READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL21,OUTFIL22)
	NATOM(2)	= NUMBER
     	RMOL	= RMOL+         ATWT*IREL(2)
55	ELE	= ELEMENT(1)
	CALL	READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL11,OUTFIL12)
	NATOM(1)	= NUMBER
     	RMOL	= RMOL+         ATWT*IREL(1)
** Computes atomic concentrations and molecular weigth
     	RMOLEC	=   DENSITY/RMOL*AVOG	! This is the number of molecules
     	WRITE (6,*)
     $'Molecular weight is : ',RMOL,' Number of molecules/cm3: ',RMOLEC
     	AT1	=   RMOLEC*irel(1)
     	AT(1)	=   AT1
     	AT2	=   RMOLEC*irel(2)
     	AT(2)	=   AT2
     	AT3	=   RMOLEC*irel(3)
     	AT(3)	=   AT3
     	AT4	=   RMOLEC*irel(4)
     	AT(4)	=   AT4
     	AT5	=   RMOLEC*irel(5)
     	AT(5)	=   AT5
** Computes now the effective F1 and F2
     	DO 18 I = 1,420
     	F1	=   0.0
     	F2	=   0.0
     	GO TO (155,144,133,122,111)	NATOMS
111	F1	=        OUTFIL51(I)*AT5
     	F2	=        OUTFIL52(I)*AT5
122	F1	=   F1 + OUTFIL41(I)*AT4
     	F2	=   F2 + OUTFIL42(I)*AT4
133	F1	=   F1 + OUTFIL31(I)*AT3
     	F2	=   F2 + OUTFIL32(I)*AT3
144	F1	=   F1 + OUTFIL21(I)*AT2
     	F2	=   F2 + OUTFIL22(I)*AT2
155	F1	=   F1 + OUTFIL11(I)*AT1
     	F2	=   F2 + OUTFIL12(I)*AT1
     	RF1(I)	=   F1
     	RF2(I)	=   F2
18      CONTINUE
	RETURN
     	END
