C +++
C
C Source: src/utils/post/translate.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: translate.F
C Revision 1.7  1992/01/16  11:30:20  cwelnak
C 6000 changes
C
C Revision 1.6  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.5  91/04/05  15:51:04  cwelnak
C changed quotes in #includes
C 
C Revision 1.4  91/03/25  16:11:51  khan
C PROGRAM TRANSLATE statement MUST be present before any INCLUDE statements.
C 
C Revision 1.3  91/03/25  15:56:47  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:48:09  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:52  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		TRANSLATE
C
C	PURPOSE		To translate a binary ray file to a readable format.
C---
	PROGRAM		TRANSLATE
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
     	CHARACTER * 80 		FILEIN,FILEOUT,RSTRING
     	REAL	*8		RAY(18,N_DIM)
	INTEGER			IUNIT,OUTFLAG
C	INTEGER			INEWLINE
	INTEGER			ICSV

	FILEIN = RSTRING('File for input ? ')
#ifdef vms
	WRITE(6,*) 'Enter filename or tt: for screen output.'
#else
	WRITE(6,*) 'Enter filename or - for standard output.'
#endif
	FILEOUT = RSTRING('Output filename or device ? ')

     	CALL	RBEAM18	(FILEIN,RAY,NCOL,NPOINT,IFLAG,IERR)

     	WRITE(6,*)'Read         ',NPOINT,' rays.'
	WRITE(6,*)'Each ray has ',NCOL,' entries.'
	NRAY = IRINT('How many rays to translate ? ')
	ICSV = IYES('Create comma separated values (CSV) output [y/N] ? ')
#ifdef vms
     	OPEN (22,FILE=FILEOUT,STATUS='NEW',CARRIAGECONTROL='LIST')
	IUNIT = 22
	OUTFLAG = 0
#else
	IF (FILEOUT(1:1).EQ.'-') THEN
	   IUNIT = 6
	   OUTFLAG = 1
	ELSE
	   IUNIT = 22
     	   OPEN (IUNIT,FILE=FILEOUT,STATUS='UNKNOWN')
	   REWIND (IUNIT)
	   OUTFLAG = 0
	ENDIF
#endif
C
C If ICSV is 0, then add newlines after every 3 numbers to nicely
C fit on a line. If 1, all numbers for the ray goes on a single line,
C separated by commas.  Harder to look at, but easy to load using "foreign" 
C programs.
C
	DO  111 I=1,NRAY
	  IF (ICSV.EQ.0) THEN

	    WRITE (IUNIT,*)		(RAY(J,I),J=1,3)
	    WRITE (IUNIT,*)		(RAY(J,I),J=4,6)
	    WRITE (IUNIT,*)		(RAY(J,I),J=7,9)
	    WRITE (IUNIT,*)		(RAY(J,I),J=10,12)
	    IF (NCOL.EQ.13) THEN
	      WRITE	(IUNIT,*)		RAY(13,I)
	    ELSE IF (NCOL.EQ.18) THEN
	      WRITE (IUNIT,*)		(RAY(J,I),J=13,15)
	      WRITE (IUNIT,*)		(RAY(J,I),J=16,18)
	    END IF
	    WRITE (IUNIT,*)
	  ELSE
	    DO 112 J=1,NCOL
	      WRITE (IUNIT, '(g15.8,$)')	RAY(J,I)
	      IF (J.LT.NCOL) THEN
		WRITE (IUNIT, '(a1,$)')		','
	      ENDIF
112	    CONTINUE
	    WRITE (IUNIT,*)
	  ENDIF
111	CONTINUE

	IF (OUTFLAG.EQ.0) THEN
	   CLOSE (IUNIT)
     	   WRITE(6,*)'All done.'
	ENDIF

     	END
