C +++
C
C Source: src/utils/post/surplot.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: surplot.F
C Revision 1.7  1995/03/09  17:20:03  cwelnak
C added Unix plot option
C
C Revision 1.6  92/01/16  11:04:32  cwelnak
C 6000 changes
C 
C Revision 1.5  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:50:58  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:39  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:48:02  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:50  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C	PROGRAM		SURFPLOT
C	
C	This program will plot a 3-d view of a mirror surface. Does not
C	use MESH but instead joins directly the points. So NO hidden
C	lines but also no unpredictable results.
C--
	PROGRAM		SURPLOT
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
     	REAL*8		RAY(12,N_DIM),PHASE(3,N_DIM),AP(3,N_DIM)
     	CHARACTER*80	INFILE
C Statements to define the use of RSTRING
     	CHARACTER*80	RSTRING
     	EXTERNAL	RSTRING
10     	INFILE = RSTRING ('SURPLOT> File ? ')
     	WRITE(6,*)'Mesh size must be Nx by Ny.'
     	NX = IRINT ('>> Nx ? ')
     	NZ = IRINT ('>> Ny ? ')
     	CALL	RBEAM (INFILE,RAY,PHASE,AP,NCOL,NN,IFLAG,IERR)
	IF (IERR.NE.0)	STOP	'Error in reading ray file.'
     	WRITE(6,*)'READ ',NN,' POINTS.'
#ifdef vms
     	OPEN (20,FILE='SURPLOT',STATUS='NEW')
     	K0 = -NZ
     	DO 20 I=1,NX
     	K0 = K0 + NZ
     	DO 15 J=1,NZ
     	IND	=  K0 + J
     	WRITE (20,*) RAY(1,IND),RAY(2,IND),RAY(3,IND)
15     	CONTINUE
     	WRITE (20,*) 'JOIN 1 X'
20     	CONTINUE
     	K0 = -NX
     	DO 30 I=1,NZ
     	K0 = K0 + NX
     	DO 25 J=1,NX
     	IND = (J-1)*NZ + I
     	WRITE (20,*) RAY(1,IND),RAY(2,IND),RAY(3,IND)
25     	CONTINUE
     	WRITE (20,*) 'JOIN 1 Y'
30     	CONTINUE
#else
     	OPEN (20,FILE='surplot.dat',STATUS='UNKNOWN')
	REWIND (20)
     	OPEN (30,FILE='surplot.prm',STATUS='UNKNOWN')
	REWIND (30)
	WRITE(20,*) '1'
	DELTAX = ABS(RAY(1,NX+1) - RAY(1,1))
	DELTAY = ABS(RAY(2,2) - RAY(2,1))
	WRITE(20,*) DELTAX
	WRITE(20,*) DELTAY
	WRITE(20,*) NX
	WRITE(20,*) NZ
	WRITE(20,*) '5'
	DO 25 I = 1,NN
     	WRITE (20,*) RAY(3,I)
25     	CONTINUE
#if HAVE_XWINDOWS
	WRITE(30,*) 'initpage(xwin)'
#else
	WRITE(*,*)  'Surplot: No XWINDOWS support. Creating Postscript'
	WRITE(21,*) 'setcolor(0)'
	WRITE(21,*) 'initpage(ps,"surplot.ps")'
#endif
	WRITE(30,*) 'regionp(0.1,0.1,0.9,0.9)'
	WRITE(30,*) 'autoscale'
C	WRITE(30,*) 'scalech(0.5)'
	WRITE(30,*) 'plot3d("surplot.dat",0,3)'
	WRITE(30,*) 'label3d("X","Y","Z")'
	WRITE(30,*) 'box3d("bcnst",0,"bcnst",0,"bcnstv",0)'
	WRITE(30,*) 'closepage'
	WRITE(30,*) 'exit'
     	CLOSE (30)
#endif
     	CLOSE (20)
     	END
