C +++
C
C Source: src/utils/post/recolor.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	recolor.F
C Revision 1.8  92/01/16  10:43:33  cwelnak
C *** empty log message ***
C 
C Revision 1.7  92/01/10  16:14:45  cwelnak
C RAN to WRAN (oops.)
C 
C Revision 1.6  1991/07/06  19:43:52  khan
C Grenoble Changes ...
C
C Revision 1.5  91/04/05  15:50:53  cwelnak
C changed quotes in #includes
C 
C Revision 1.4  91/03/25  15:56:28  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.3  91/03/15  16:04:56  khan
C Getting  ready for sun port...
C 
C Revision 1.2  91/01/25  16:47:52  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:48  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C	PROGRAM		RECOLOR
C
C	This program will take a RAY file and modify the photon energies
C	of each ray. The new file will then be used as a BEGIN file.
C
C---
     	PROGRAM		RECOLOR
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
     	DIMENSION	RAY(12,N_DIM),AP(3,N_DIM),PHASE(3,N_DIM),WAVE (10)
     	CHARACTER	*60	INFILE,OUTFILE
10     	WRITE(6,*)'File for input ?'
     	READ (5,1000)	INFILE
     	WRITE(6,*)'and for output ?'
     	READ (5,1000)	OUTFILE
	CALL	RBEAM	(INFILE,RAY,PHASE,AP,NCOL,NPOINT,IFLAG,IERR)
     	WRITE(6,*)'Data ready. Read ',NPOINT,' points.'
     	WRITE(6,*)'Are you going to specify energies in eV [ 0 ] or',
     $' wavelengths in angstroms [ 1 ] ?'
     	READ(5,*)IWHAT
     	WRITE(6,*)'Available options :'
     	WRITE(6,*)'1	single line'
     	WRITE(6,*)'2	multi lines'
     	WRITE(6,*)'3	box distribution'
     	WRITE(6,*)'Then ?'
     	READ(5,*)LINE
     	IF (LINE.EQ.1) THEN
     	 WRITE(6,*)' Value ?'
     	 READ(5,*)WAVE(1)
     	 IF (IWHAT.EQ.0) WAVE(1) = TOANGS/WAVE(1)
     	ELSE IF (LINE.EQ.2) THEN
     	 WRITE(6,*)'How many lines ?'
     	 READ(5,*)NLINES
     	  DO 20 I=1,NLINES
     	   WRITE(6,*)'Line n. ',I,'. Then ?'
     	   READ(5,*)WAVE(I)
     	   IF (IWHAT.EQ.0) WAVE(I) = TOANGS/WAVE(I)
20     	  CONTINUE
     	ELSE IF (LINE.EQ.3) THEN
     	 WRITE(6,*)'Minimum value ?'
     	 READ(5,*)WAVE(1)
     	 WRITE(6,*)'Maximum value ?'
     	 READ(5,*)WAVE(2)
     	 IF (IWHAT.EQ.0) THEN
     	  WAVE(1) = TOANGS/WAVE(1)
     	  WAVE(2) = TOANGS/WAVE(2)
     	 END IF
     	 CMIN = TWOPI/WAVE(1)*1.0D8
     	 CMAX = TWOPI/WAVE(2)*1.0D8
     	 CDELTA = CMAX - CMIN
     	END IF
	IF (LINE.NE.1) THEN
     	  WRITE(6,*)'Enter seed for random number generator :'
     	  READ(5,*)ISEED
	END IF
     	DO 30 I=1,NPOINT
     	 IF (LINE.EQ.1) THEN
     	  RAY (11,I) = TWOPI/WAVE(1)*1.0D8
     	 ELSE IF (LINE.EQ.2) THEN
     	  NN	=   1 + NLINES*WRAN(ISEED)
     	  RAY(11,I)  =  TWOPI/WAVE(NN)*1.0D8
     	 ELSE IF (LINE.EQ.3) THEN
     	  CVAL	=   CMIN + WRAN(ISEED)*CDELTA
     	  RAY(11,I) = CVAL
     	 END IF
30     	CONTINUE
C       IFORM = 0 FOR BINARY OUTPUT AND 1 FOR FORMATTED OUTPUT
        IFORM = 0
	CALL	WRITE_OFF(OUTFILE,RAY,PHASE,AP,NCOL,NPOINT,IFLAG,
     $	IFORM,IERR)
	IF (IERR.NE.0)	STOP	'Error in writting output file.'
     	WRITE(6,*)'All done.'
     	STOP
1000	FORMAT (A)
     	END
