C +++
C
C Source: src/utils/post/old-graphics/preplot.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	preplot.F
C Revision 1.2  91/01/25  16:47:36  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:46  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		PREPLOT
C
C	PURPOSE		To generate a plottable file from any two or 
C			three rows of unformatted data.
C
C	Link using GRA:GRALIB.LNK or GRA:TDSHARE.LNK
C---
     	PROGRAM 	PREPLOT
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
C
     	REAL*8			RAY(18,N_DIM)
	DIMENSION		X(N_DIM),Y(N_DIM),Z(N_DIM),TEST(3)
     	CHARACTER * 32 		FILEIN,FILEOUT
     	INTEGER		CHECK
     	LOGICAL		LTEST
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	CHARACTER*80	RSTRING
     	EXTERNAL	RSTRING

#ifndef vms
	CHARACTER * 512		PRIMVS
	CHARACTER * 512		PRIMVSPATH
#endif
#ifdef __CYGWIN32__
	CHARACTER * 512		CMDARG
	DATA CMDARG		/'-run-primvs'/
#endif
C
     	FILEIN	=   RSTRING ('PREPLOT> Input file ? ')
     	CALL	RBEAM18	(FILEIN,RAY,NCOL,NPOINT,IFLAG,IERR)
	IF (IERR.NE.0)	THEN
	  STOP 'Error in reading input ray file.'
	ELSE
	  WRITE(6,*)'Read         ',NPOINT,' rays.'
	  WRITE(6,*)'Each ray has ',NCOL,' entries.'
	END IF
     	ICOL	=   IRINT ('PREPLOT> How many columns to write out ? ')
	WRITE	(6,101)		NCOL
101	FORMAT(1X,'Row [1-',I2,']  : the individual column')
	WRITE(6,*)'Row   [20]  : R = SQRT(X**2 + Y**2 + Z**2)'
	WRITE(6,*)'Row   [21]  : angle from the Y-axis'
	WRITE(6,*)'Row   [22]  : the magnitude of A vector'
	WRITE(6,*)'Row   [23]  : A**2'
     	KOL1 =  IRINT	('PREPLOT> Row # 1 : ')
     	KOL2 =  IRINT	('PREPLOT>       2 : ')
     	IF (ICOL.EQ.3)  KOL3 = IRINT ('PREPLOT>      3 : ')
     	IF (ICOL.GT.3) THEN
     	WRITE(6,*)'Where do you want to plot ? In hyperspace ?'
     	STOP
     	END IF
     	LTEST = .FALSE.
     	LTEST = KOL1.EQ.11 .OR. KOL2.EQ.11 .OR. KOL3.EQ.11
     	IF (LTEST) THEN
     	  WRITE(6,*)'Option:    Angstroms        [ 0 ] '
     	  WRITE(6,*)'           Electronvolts    [ 1 ] '
     	  WRITE(6,*)'           Cm-1             [ 2 ] '
     	  IENER = IRINT ('PREPLOT> Then ? ')
     	END IF
	WRITE(6,*)'Options --- Enter'
     	WRITE(6,*)'0 for excluding the losses'
     	WRITE(6,*)'1 for including losses at a particular O.E.'
     	WRITE(6,*)'2 for plotting all the rays .'
     	WRITE(6,*)'3 for plotting ONLY the losses (all of them)'
     	WRITE(6,*)'4 for plotting ONLY the losses at a given O.E.'
	KLOSS	=   IRINT ('PREPLOT> Then ? ')
     	IF (KLOSS.EQ.1.OR.KLOSS.EQ.4) THEN
     	CHECK = 
     $IRINT ('Flag value ( -11000 first O.E., -22000 sec O.E., etc.) ?')
     	ELSE
     	END IF
C
	KOUNT	=   0
     	DO 11 I=1,NPOINT
     	IF (RAY(10,I).LT.0.0) KOUNT = KOUNT + 1
     	IF (LTEST) THEN
     	 IF (IENER.EQ.0) THEN		! Angstroms
     	  IF (RAY(11,I).GT.1.0E-10) RAY(11,I) = TWOPI*1.0E+8/RAY(11,I)
     	 ELSE IF (IENER.EQ.1) THEN	! eV
     	   RAY(11,I) = TOCM*RAY(11,I)/TWOPI
     	 END IF
     	END IF
11     	CONTINUE
100     CONTINUE
     	WRITE(6,*)'***********'
	WRITE(6,*)'Found ',(NPOINT-KOUNT),' good points out of',NPOINT
C
#ifdef vms
	WRITE(6,*)'Output options :'
	WRITE(6,*)'  [ 0 ] store rays in a file'
	WRITE(6,*)'  [ 1 ] plot directly on screen'
	WRITE(6,*)'  [ 2 ] both'
	IOUT	= IRINT ('Then ? ')
	IF (IOUT.EQ.0.OR.IOUT.EQ.2) THEN
     	  FILEOUT	=   RSTRING ('PREPLOT> Output file ? ')
	END IF
	IF (IOUT.EQ.1.OR.IOUT.EQ.2) THEN
	  CALL	SET_SCREEN	('PREPLOT>',0,ITERM)
	END IF
#else /*!vms*/
	  WRITE(6,*) 'Display type:'
#if HAVE_XWINDOWS
	  WRITE(6,*) '  [ 0 ] Xwindow'
#endif
	  WRITE(6,*) '  [ 1 ] Tektronix'
	  WRITE(6,*) '  [ 2 ] Postscript file'
	  WRITE(6,*) '  [ 3 ] ASCII file'
	  ITERM = IRINT ('Terminal type:  ')
#if !HAVE_XWINDOWS
	  IF (ITERM.EQ.0) THEN
	      WRITE (*,*) 'No X Windows support. Using PS file'
	      ITERM=2
	  ENDIF
#endif
	  IF (ITERM.LT.0 .OR. ITERM.GT.3) THEN
	      WRITE (*,*) 'Invalid device Id. Using PS file'
	      ITERM=2
	  ENDIF
C
	  IOUT = 0

#endif /*unix*/

C
	NOUT	= 0
     	DO 300 I=1,NPOINT
	 IF (KOL1.EQ.23) THEN
	   XTEMP	= RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
	   IF (NCOL.EQ.18)
     $	     XTEMP = XTEMP + RAY(16,I)**2 + RAY(17,I)**2 + RAY(18,I)**2
	 ELSE IF (KOL1.EQ.22) THEN
	   XTEMP	= RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
	   IF (NCOL.EQ.18)
     $	     XTEMP = XTEMP + RAY(16,I)**2 + RAY(17,I)**2 + RAY(18,I)**2
	   XTEMP	= SQRT(XTEMP) 
	 ELSE IF (KOL1.EQ.20) THEN
	   XTEMP	= SQRT(RAY(1,I)**2 + RAY(2,I)**2 + RAY(3,I)**2)
	 ELSE IF (KOL1.EQ.21) THEN
	   XTEMP	= ACOS(RAY(5,I))
	 ELSE IF (KOL1.LE.18) THEN
	   XTEMP	= RAY(KOL1,I)
	 END IF
	 IF (KOL2.EQ.23) THEN
	   YTEMP	= RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
	   IF (NCOL.EQ.18)
     $	     YTEMP = YTEMP + RAY(16,I)**2 + RAY(17,I)**2 + RAY(18,I)**2
	 ELSE IF (KOL2.EQ.22) THEN
	   YTEMP	= RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
	   IF (NCOL.EQ.18)
     $	     YTEMP = YTEMP + RAY(16,I)**2 + RAY(17,I)**2 + RAY(18,I)**2
	   YTEMP	= SQRT(YTEMP) 
	 ELSE IF (KOL2.EQ.20) THEN
	   YTEMP	= SQRT(RAY(1,I)**2 + RAY(2,I)**2 + RAY(3,I)**2)
	 ELSE IF (KOL2.EQ.21) THEN
	   YTEMP	= ACOS(RAY(5,I))
	 ELSE IF (KOL2.LE.18) THEN
	   YTEMP	= RAY(KOL2,I)
	 END IF
	IF (ICOL.EQ.3) THEN
	 IF (KOL3.EQ.23) THEN
	   ZTEMP	= RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
	   IF (NCOL.EQ.18)
     $	     ZTEMP = ZTEMP + RAY(16,I)**2 + RAY(17,I)**2 + RAY(18,I)**2
	 ELSE IF (KOL3.EQ.22) THEN
	   ZTEMP	= RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
	   IF (NCOL.EQ.18)
     $	     ZTEMP = ZTEMP + RAY(16,I)**2 + RAY(17,I)**2 + RAY(18,I)**2
	   ZTEMP	= SQRT(ZTEMP) 
	 ELSE IF (KOL3.EQ.20) THEN
	   ZTEMP	= SQRT(RAY(1,I)**2 + RAY(2,I)**2 + RAY(3,I)**2)
	 ELSE IF (KOL3.EQ.21) THEN
	   ZTEMP	= ACOS(RAY(5,I))
	 ELSE IF (KOL3.LE.18) THEN
	   ZTEMP	= RAY(KOL3,I)
	 END IF
	END IF

	 IF (KLOSS.EQ.0) THEN
	  IF (RAY(10,I).LT.0.0D0)   GO TO 300
	 ELSE IF (KLOSS.EQ.1) THEN
     	  IF (RAY(10,I).LT.0.0D0.AND.NINT(RAY(10,I)).NE.CHECK) 
     $		GO TO 300
     	 ELSE IF (KLOSS.EQ.3) THEN
	  IF (RAY(10,I).GE.0.0D0) GO TO 300
     	 ELSE IF (KLOSS.EQ.4) THEN
     	  IF (RAY(10,I).LT.0.0D0.AND.NINT(RAY(10,I)).EQ.CHECK) THEN
	  ELSE 
	    GO TO 300
     	  END IF
     	 ELSE
     	 END IF
	    NOUT	= NOUT + 1
	    X(NOUT)	= XTEMP
	    Y(NOUT)	= YTEMP
	    Z(NOUT)	= ZTEMP
300     CONTINUE
C
C Ready for output.
C
	IF (IOUT.EQ.0.OR.IOUT.EQ.2) THEN
#ifdef vms
     	  OPEN (22,FILE=FILEOUT,STATUS='NEW')
#else
     	  OPEN (22,FILE='preplot.dat',STATUS='UNKNOWN')
	  REWIND(22)
#endif
	  IF (ICOL.EQ.3) THEN
     	    DO 12 I=1,NOUT
     	      WRITE (22,*)	X(I),Y(I),Z(I)
12     	    CONTINUE
	  ELSE
     	    DO 13 I=1,NOUT
     	      WRITE (22,*)	X(I),Y(I)
13     	    CONTINUE
	  END IF
     	  CLOSE (22)
	END IF
#ifdef vms
	IF (IOUT.EQ.1.OR.IOUT.EQ.2) THEN
	  CALL TDNEWP
	  CALL TDPLOT (NOUT,X,Y)
	  CALL SET_SCREEN	(' ',1,ITERM)
	END IF
#else
C	IF (IOUT.EQ.3) THEN
C skip this part if writing to ascii file -- already written
	IF (ITERM.NE.3) THEN
	   XMIN = 1.0E20
	   XMAX = -1.0E20
	   YMIN = 1.0E20
	   YMAX = -1.0E20
	   ZMIN = 1.0E20
	   ZMAX = -1.0E20

	   DO 1019 I = 1,NOUT
	      TEST(1) = X(I)
	      TEST(2) = Y(I)
	      TEST(3) = Z(I)
	      XMIN = MIN(XMIN,TEST(1))
	      XMAX = MAX(XMAX,TEST(1))
	      YMIN = MIN(YMIN,TEST(2))
	      YMAX = MAX(YMAX,TEST(2))
	      ZMIN = MIN(ZMIN,TEST(3))
	      ZMAX = MAX(ZMAX,TEST(3))
1019	   CONTINUE
	   DELX = XMAX - XMIN
	   DELY = YMAX - YMIN
	   DELZ = ZMAX - ZMIN
	   XCEN = (XMAX + XMIN)/2.0
	   YCEN = (YMAX + YMIN)/2.0
	   ZCEN = (ZMAX + ZMIN)/2.0
	   XLOW = XCEN - 0.6125*DELX
	   XUPP = XCEN + 0.6125*DELX
	   YLOW = YCEN - 0.6125*DELY
	   YUPP = YCEN + 0.6125*DELY
	   ZLOW = ZCEN - 0.6125*DELZ
	   ZUPP = ZCEN + 0.6125*DELZ
C now write out primvs command file
	 OPEN (23,FILE='preplot.prm',STATUS='UNKNOWN',
     $		FORM='FORMATTED')
         WRITE (23,*) '# Primvs command file to plot PREPLOT output'
	   IF      (ITERM.EQ.0) THEN
	     WRITE (23,*) '# Initialize Xwindow display'
	     WRITE (23,*) ' '
	     WRITE (23,*) 'initpage(xwin)'
	   ELSE IF (ITERM.EQ.1) THEN
	     WRITE (23,*) '# Initialize Tektronix display'
	     WRITE (23,*) ' '
	     WRITE (23,*) 'initpage(tekt)'
	   ELSE IF (ITERM.EQ.2) THEN
	     WRITE (23,*) '# Initialize Postscript file'
	     WRITE (23,*) ' '
	     WRITE (23,*) 'setcolor(0)'
	     WRITE (23,*) 'initpage(ps,"preplot.ps")'
	   END IF
	   WRITE (23,*) '# Set limits on viewing window, plot, and '
	   WRITE (23,*) '# character size.'
	   WRITE (23,*) 'regionr(0.1,0.1,0.9,0.9,1.0)'
	   WRITE (23,3030) XLOW,XUPP,YLOW,YUPP
	   WRITE (23,*) 'color(green)'
	   WRITE (23,*) 'symbol(1)'
	   WRITE (23,*) 'scalechr(0.8)'
	   WRITE (23,*) ' '
	   WRITE (23,*) '# Plot data points from preplot.dat '
	   WRITE (23,*) 'plotp("preplot.dat")'
	   WRITE (23,*) '# Draw axes and tickmarks'
	   WRITE (23,*) 'box("bcnst",0,0,"bcnstv",0,0)'
	   WRITE (23,*) 'closepage'
	   WRITE (23,*) 'exit'
	   CLOSE (23)
C	ENDIF

	IFLAG = 0
	CALL PROGPATH ('primvs', PRIMVS, IFLAG)
	PRIMVSPATH = PRIMVS(1:IBLANK(PRIMVS)) // ' -i preplot.prm'
#if !defined(__CYGWIN32__)
	WRITE(*,*) 'Executing program: ' // 
     $		PRIMVSPATH(1:IBLANK(PRIMVSPATH))
	CALL SYSTEM (PRIMVSPATH)
#else
	IF (IARGC() .EQ. 1) THEN
	    CALL GETARG(1, CMDARG)
	ENDIF
	IF (CMDARG(1:11).EQ.'-run-primvs') THEN
	    WRITE(*,*) 'Executing program: ' // 
     $		PRIMVSPATH(1:IBLANK(PRIMVSPATH))
	    IFLAG = 0
	    CALL RUNPRIMVS ('preplot.prm', iflag)
	ENDIF
#endif

3030	FORMAT ('xyrange(',E15.8,',',E15.8,',',E15.8,',',E15.8,')')
	ENDIF
#endif
     	END
