C +++
C
C Source: src/utils/post/histo2.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: histo2.F
C Revision 1.6  1992/01/15  16:49:01  cwelnak
C 6000 changes
C
C Revision 1.5  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:50:43  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:05  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:21  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:42  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C	PROGRAM		HISTO2
C
C	PURPOSE		Generates a two-dimensional histogram from an
C			output file of SHADOW.
C
C	OUTPUT		A set of three file suitable for the NCAR 
C			plotting routine.
C---
	IMPLICIT REAL*4 (A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

	CHARACTER *80 	INFIL1,INFIL2,XFIL,YFIL,ZFIL,RSTRING,OUTFIL

     	REAL *8		RAY(18,N_DIM),RAY2(18,N_DIM)
     	DIMENSION	PIXEL (52,52),XSID(52),YSID(52)


	INFIL1	= RSTRING ('File for analysis ? ')
	CALL	RBEAM18	(INFIL1,RAY,NCOL,NPOINT,IFLAG,IERR)
	IF (IERR.NE.0) STOP 'Error reading ray file.'
	WRITE(6,*)'Data ready. Read ',NPOINT,' points.'
     	WRITE(6,*)'Columns for x-axis and y-axis?'
     	READ(5,*)IX,IY
     	IF (IX.EQ.11) THEN
     	 WRITE(6,*)'Options:   eV .... 0'
     	 WRITE(6,*)'          Angs.... 1'
     	 WRITE(6,*)'          cm-1.... 2'
     	 ICONV = IRINT ('Then ? ')
     	END IF
     	IF (IY.EQ.11) THEN
     	 WRITE(6,*)'Options:   eV .... 0'
     	 WRITE(6,*)'          Angs.... 1'
     	 WRITE(6,*)'          cm-1.... 2'
     	 ICONV = IRINT ('Then ? ')
     	END IF
     	WRITE(6,*)'X min, X max and number of bins :'
     	READ(5,*)XMIN,XMAX,NX
     	WRITE(6,*)'Y min, Y max and number of bins :'
     	READ(5,*)YMIN,YMAX,NY
     	WRITE(6,*)'Do you want reflectivity too (Y=1,N=0) ?'
     	READ(5,*)KREFL
     	IF (KREFL.EQ.1) THEN
     	  WRITE(6,*)'Options :'
     	  WRITE(6,*)'Power transmitted/reflected ........ 0'
     	  WRITE(6,*)'Power absorbed ..................... 1'
     	  WRITE(6,*)'Local reflectivity/transmission .... 2'
     	  WRITE(6,*)'Then ?'
     	  READ(5,*)KACT
	  IF (KACT.EQ.1.OR.KACT.EQ.0) THEN
     	    WRITE(6,*)'Need a scaling factor ?'
     	    READ(5,*)IANSW
	  END IF
	  FACT	= 1
     	  IF (IANSW.EQ.1) THEN
     	     WRITE(6,*)'Then ?'
     	     READ(5,*)FACT
     	  END IF
     	  NORMAL	=  0
     	 IF (KACT.EQ.1.OR.KACT.EQ.2) THEN
     	  INFIL2 = RSTRING ('File to use for Io ? ')
	  CALL	RBEAM18	(INFIL2,RAY2,NCOL2,NPOINT2,IFLAG,IERR)
	  IF (IERR.NE.0) STOP 'Error reading ray file.'
	  IF (NPOINT2.NE.NPOINT)	STOP
     $'Io file does not have the same number of rays as the input file.'
     	 END IF
     	ELSE
	  WRITE(6,*)'Data normalization. Enter:'
     	  WRITE(6,*)'0	for no normalization'
     	  WRITE(6,*)'1	to normalize to 1'
     	  WRITE(6,*)'2	to normalize to total counts'
	  READ(5,*)NORMAL
     	END IF

     	XWID	=   (XMAX - XMIN)
     	YWID	=   (YMAX - YMIN)
     	XSTEP	=   XWID/(NX-1)
     	YSTEP  =   YWID/(NY-1)
     	AREA	=   XSTEP*YSTEP
** Prepare the 'sides' of the histogram. 
     	DO 11 I=1,NX
     		XSID(I)	=   XMIN + XSTEP*(I-1)
11     	CONTINUE
     	DO 12 J=1,NY+1
     		YSID(J)	=   YMIN + YSTEP*(J-1)
12     	CONTINUE
     	IBAD	=   0
     	DO 100 K=1,NPOINT
          IF (RAY(10,K).LT.0.0) THEN
     		IBAD   =   IBAD + 1
     		GO TO 100
     	  ELSE
     	  END IF
C
     	IF (IX.NE.11) THEN
	  ARGX	=   (RAY(IX,K) - XMIN)/XSTEP
     	ELSE
     	      IF (ICONV.EQ.0) THEN
	   ARGX	=   (RAY(IX,K)/TWOPI*TOCM - XMIN)/XSTEP
     	 ELSE IF (ICONV.EQ.1) THEN
	   ARGX	=   (TWOPI/RAY(IX,K)*1.0D8 - XMIN)/XSTEP
     	 ELSE
	   ARGX	=   (RAY(IX,K) - XMIN)/XSTEP
     	 END IF
     	END IF
C
     	IF (IY.NE.11) THEN
     	  ARGY	=   (RAY(IY,K) - YMIN)/YSTEP
     	ELSE
     	      IF (ICONV.EQ.0) THEN
	   ARGY	=   (RAY(IY,K)/TWOPI*TOCM - YMIN)/YSTEP
     	 ELSE IF (ICONV.EQ.1) THEN
	   ARGY	=   (TWOPI/RAY(IY,K)*1.0D8 - YMIN)/YSTEP
     	 ELSE
	   ARGY	=   (RAY(IY,K) - YMIN)/YSTEP
     	 END IF
     	END IF
     	IBIN	=   IFIX(ARGX) + 1
     	IF (IBIN.GT.52.OR.IBIN.LT.1) GO TO 100
     	JBIN	=   IFIX(ARGY) + 1
     	IF (JBIN.GT.52.OR.JBIN.LT.1) GO TO 100
     	IF (KREFL.EQ.1) THEN
     	 IF (KACT.EQ.0) THEN
     	  ARG	=   (RAY(7,K)**2 + RAY(8,K)**2 + RAY(9,K)**2)
	  IF (NCOL.EQ.18)
     $	    ARG	= ARG + RAY(16,K)**2 + RAY(17,K)**2 + RAY(18,K)**2
     	  ARG 	=   ARG*FACT*TOCM/TWOPI*1.602E-19*RAY(11,K)/AREA
     	 ELSE
     	  ARG1	=   (RAY(7,K)**2 + RAY(8,K)**2 + RAY(9,K)**2)
	  IF (NCOL.EQ.18)
     $	    ARG1 = ARG1 + RAY(16,K)**2 + RAY(17,K)**2 + RAY(18,K)**2
     	  ARG2  =   (RAY2(7,K)**2 + RAY2(8,K)**2 + RAY2(9,K)**2)
	  IF (NCOL2.EQ.18)
     $	    ARG2 = ARG2 + RAY2(16,K)**2 + RAY2(17,K)**2 + RAY2(18,K)**2
     	  IF (KACT.EQ.1) THEN
     	    ARG	=   ARG2 - ARG1
     	    ARG =   ARG*FACT*TOCM/TWOPI*1.602E-19*RAY(11,K)/AREA
     	  ELSE IF (KACT.EQ.2) THEN
     	    ARG =   ARG1/ARG2
     	  END IF
     	 END IF
     	ELSE
     	  ARG	=   1.0
     	END IF
     	  PIXEL (IBIN,JBIN) =   PIXEL(IBIN,JBIN) + ARG
100	CONTINUE

     	WRITE(6,*)'There were ',IBAD,'lost out of ',NPOINT,' rays.'
	XNORM = -1.0E20
	IF (NORMAL.EQ.1) THEN
	  DO 300 I=1,NY
	  DO 300 J=1,NX
300	    XNORM = MAX (XNORM,PIXEL(I,J))
	  DO 400 I=1,NY
	  DO 400 J=1,NX
400	     PIXEL(I,J) = PIXEL(I,J)/XNORM
	ELSE IF (NORMAL.EQ.2) THEN
     	     COUNTS	=   0.0
     	   DO 310 I=1,NY
     	   DO 310 J=1,NX
310          COUNTS = COUNTS + PIXEL(I,J)
     	   DO 410 I=1,NY
     	   DO 410 J=1,NX
410	     PIXEL(I,J) =  PIXEL(I,J)/COUNTS
	END IF

     	WRITE(6,*)'Computations done.'

#ifdef vms
C     	WRITE(6,*)'File for TOP DRAWER [ 0 ] or NCAR [ 1 ] or Generic [ 2 ] ?'
C     	READ(5,*)IANSW
     	IANSW = IRINT
     $  ('File for TOP DRAWER [ 0 ] or NCAR [ 1 ] or Generic [ 2 ] ?')
#else
	WRITE (6,*) 'Output file will be X,Y,Z(X,Y)'
	IANSW = 2
#endif

     	 IF (IANSW.EQ.1) THEN
     	WRITE(6,*)'Enter filenames for X,Y, Z(X,Y) arrays'
     	WRITE(6,*)'X ?'
     	READ (5,1000) XFIL
     	WRITE(6,*)'Y ?'
     	READ (5,1000) YFIL
     	WRITE(6,*)'Z (X,Y) ?'
     	READ (5,1000) ZFIL
1000	FORMAT	(A)

#ifdef vms
     	OPEN (21,FILE=XFIL,STATUS='NEW')
#else
     	OPEN (21,FILE=XFIL,STATUS='UNKNOWN')
	REWIND (21)
#endif
     	DO 13 I=1,NX
     	WRITE (21,*) XSID(I)
13     	CONTINUE
     	CLOSE (21)

#ifdef vms
     	OPEN (22,FILE=YFIL,STATUS='NEW')
#else
     	OPEN (22,FILE=YFIL,STATUS='UNKNOWN')
	REWIND (22)
#endif
     	DO 14 I=1,NY
     	WRITE (22,*) YSID(I)
14     	CONTINUE
     	CLOSE (22)

#ifdef vms
     	OPEN (23,FILE=ZFIL,STATUS='NEW')
#else
     	OPEN (23,FILE=ZFIL,STATUS='UNKNOWN')
	REWIND (23)
#endif
     	DO 16 I=1,NX
     	 WRITE (23,*) (PIXEL (I,J),J=1,NY)
16     	CONTINUE
     	CLOSE (23)

     	ELSE IF (IANSW.EQ.0) THEN
C
#ifdef vms
     	OPEN (37,FILE='MESH.PLT',STATUS='NEW')
#else
     	OPEN (37,FILE='MESH.PLT',STATUS='UNKNOWN')
	REWIND (37)
#endif
	WRITE (37,180)
	WRITE (37,201) (XSID(I),I=1,NX)
C
C
	DO 101 K=1,NY
	WRITE (37,203) YSID(K)
	WRITE (37,230) (PIXEL(I,K),I=1,NX)
101	CONTINUE
C
C
     	CLOSE (37)
	ELSE IF (IANSW.EQ.2) THEN
	  OUTFIL = RSTRING('Enter filename for output: ')
	  OPEN(35,FILE=OUTFIL,STATUS='UNKNOWN')
	  DO 995 I = 1,NX
	    DO 995 K = 1,NY
	      WRITE(35,*) XSID(I),YSID(K),PIXEL(I,K)
995	  CONTINUE
	  CLOSE(35)
     	END IF
	STOP 'All done.'
C
180	FORMAT('READ MESH')
201	FORMAT('X = ',8(1PE14.6)/(4X,8E14.6))
203	FORMAT('Y = ',1PE14.6)
230	FORMAT('Z = ',8(1PE14.6)/(4X,8E14.6))
C
     	END
