	subroutine read_menu 
	implicit integer (a-z)
c++
c	subroutine read_menu
c
c  Reads the MENU data file into memory 
c  The data file defines all the menus and their detail lines
c  The routine makes certain common sense checks while adding
c    the menu definitions
c
c--
#if defined(unix) || HAVE_F77_CPP
#	include "parms.inc"
#	include "menu.inc"
#	include "helplib.inc"
#	include "io.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'menu.inc'
	include 'helplib.inc'
	include 'io.inc'
#endif
c
c  temporary variables for decoding fields in records
c
	character*100			data
	character*(4)			statement_type
c
	character*(l_rec)		rec
	character*(l_rec)		menu_type
	character*(l_menu_title)	menu_title
	character*(l_menuname)		menu_name
	character*(l_menuname)		submenu
	character*(l_name)		name
	character*(l_prompt)		prompt
	character*1			force
	character*1			readonly
c
c  for flags
c
	character*2			result
	character*(1)			flag
	character*(l_rec)		rec1,rec2
	character*(l_name)		name1,name2
	character*(3)			rel
c
c  valid relation names
c
	character*3 okRel (4)
	data okRel /'EQ','NE','AND','OR'/
c
c  work variables
c
	character*(l_menuname)		this_menuname
	character*(l_symbol)		full_symbol
c
c  table of valid record types ('$$$$' merely signals end-of-list)
c    
	character*4 valid_type (9)
	data valid_type /' ','MENU','SKIP','TEXT',
     *				'DATA','SET','HLPC','HLPM','$$$$'/

c
c  reset help library
c  counters of number of elements in array
c  counter of number of records read (for error messages)
c  counter of errors encountered
c
	helplibm='sys$help:helplib'
	helplibc='sys$help:helplib'
	end_of_file=0
	record=0
	n_detail=0
	n_menu=0
	n_flag=0
	errors=0
	this_menuname=' '
c
c  search for menu definition
c
 100	call read_next_menu (valid_type,record_code,data)
	record=record+1
c
c  check for end-of-file
c
	if (record_code .eq. -1) goto 9200
c
c  check for comment
c
	if (data(1:1) .eq. ' ' .or. data(1:1) .eq. '*') goto 100
c
c  get statement type from first 4 bytes of record
c
	statement_type=data(1:4)
c
c  Unrecognized record type (code=0)
c
	if (record_code .eq. 0) then
	  write (message,9010) record,statement_type
 9010	  format ('READ_MENU Record ',i4,': ',
     *		'unrecognized record type "',a,'"')
	  call warning 
	  errors=errors+1
	  goto 100
	endif

c
c  At this point allow only MENU or HELP
c
	if (statement_type .eq. 'HLPC') then
	  helplibc=data(5:)
	  goto 100
	endif
c
	if (statement_type .eq. 'HLPM') then
	  helplibm=data(5:)
	  goto 100
	endif
c
	if (statement_type .ne. 'MENU') then
	  write (message,9015) record,statement_type
 9015	  format ('READ_MENU: Record ',i4,' out ',
     *		  'of order.  Expected TYPE="MENU" but found "',a,'"')
	  call warning 
	  errors=errors+1
	  goto 100
	endif
c
c  New menu - decode and add to the menu collection
c
 150	read (data,9020) menu_type,menu_name,menu_title
 9020	format (5x,a3,8x,a16,8x,a40)
	call upcase (menu_type)
	call upcase (menu_name)
c
c  Check for duplicate menu name
c
	do i=1,n_menu
	  if (menu_name .eq. m_name(i)) then
	    write (message,9021) menu_name,record
 9021	    format ('READ_MENU: Menu "',a,'" is multiply defined ',
     *		    'starting at record ',i4)
	    call fatal 
	  endif
	end do
c
c  check for valid menu type (OE SCR or blank)
c
	if (menu_type .ne. 'OE' .and.
     *	    menu_type .ne. 'SCR' .and.
     *	    menu_type .ne. ' ') then
 	      write (message,9022) record,menu_type
 9022	      format ('READ_MENU Record ',i4,': Menu has illegal ',
     *	        'type (',a,') - use "OE", "SCR", or blank')
	      call warning
	      errors=errors+1
	      menu_type=' '
	endif
c
c  check for space in menu tables
c
	if (n_menu .ge. max_menu) then
	  write (message,9025) n_menu
 9025	  format ('READ_MENU: Can''t handle more than ',i2,' menus')
	  call fatal 
	endif
c
	n_menu=n_menu+1
	m_name(n_menu)=menu_name
	m_type(n_menu)=menu_type
	m_title(n_menu)=menu_title
	m_detail_start(n_menu)=0
	m_detail_stop(n_menu)=0
	m_flag_start(n_menu)=0
	m_flag_stop(n_menu)=0
	this_menuname=menu_name
	line_of_display=2

c
c  get next detail line of menu definition
c
 200	call read_next_menu (valid_type,record_code,data)
	record=record+1
c
c  check for end-of-file
c
	if (record_code .eq. -1) goto 9200
c
c  if blank statement_type then go no further - it's a comment
c
	if (data(1:) .eq. ' ' .or. data(1:1) .eq. '*') goto 200
c
c  get record type from first 4 bytes of record
c
	statement_type=data(1:4)
c
c  Unrecognized record type (code=0)
c
	if (record_code .eq. 0) then
	  write (message,9010) record,statement_type
	  call warning 
	  errors=errors+1
	  goto 200
	endif
c
c  MENU - Finish previous menu then start new one
c
 210	if (statement_type .eq. 'MENU') then
	  if (m_detail_start(n_menu) .ne. 0) then
	    m_detail_stop(n_menu)=n_detail
	  endif
	  if (m_flag_start(n_menu) .ne. 0) then
	    m_flag_stop(n_menu)=n_flag
	  endif
	  goto 150
	endif
c
c  SKIP - Skip this line of the display
c
	if (statement_type .eq. 'SKIP') then
	   line_of_display=line_of_display+1
	   goto 200
	endif

c
c  TEXT - Display string without any associated data
c	  Special case of DATA field
c
	if (statement_type .eq. 'TEXT') then
	  read (data,9030) prompt
 9030	  format (40x,a33)
	  name=' '
	  rec=' '
	  submenu=' '
	  readonly='Y'
	  flag=' '
	  force=' '
	  own1=0
	  own2=0
	  goto 2300
	endif
c
c  HELP - Specify help library
c
	if (statement_type .eq. 'HLPM') then
	  helplibm=data(5:)
	  goto 150
	endif
	if (statement_type .eq. 'HLPC') then
	  helplibc=data(5:)
	  goto 150
	endif

c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  SET
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	if (statement_type .ne. 'SET') goto 2000
	read (data,501) result,rec1,name1,rel,rec2,name2
 501	format (8x,a2,6x,a3,5x,a16,a3,5x,a3,5x,a16)
	call upcase (result)
	call upcase (rel)
	call upcase (rec1)
	call upcase (rec2)
	call upcase (name1)
	call upcase (name2)
	do  i=1,4
	  if (rel .eq. okRel(i)) goto 5010
	end do
	write (message,5009) record,rel
 5009	format ('READ_MENU Record ',i4,': Relation "',a,'" is not ',
     *		'among "EQ","NE","AND", or "OR"')
 5010	continue
	if (result(1:1) .ne. '%') then
	  write (message,502) record,result
 502	  format ('READ_MENU Record ',i4,
     *		  ': All flags in SET statements ',
     *		  'should start with "%" - "',a,'" does not')
	  call warning 
	  errors=errors+1
	  goto 200
	endif
	call checkFlagName (result(2:),iCode)
	if (icode .lt. 0) then
	  write (message,9052) record,flag
	  call warning 
	  errors=errors+1
	  goto 200
	endif
	if (rec1(1:1) .eq. '%') then
	  call checkFlagName (rec1(2:),iCode)
	  if (icode .lt. 0) then
	    write (message,9052) record,rec2
	    call warning 
	    errors=errors+1
	    goto 200
	  endif
	else
	  if (rec1 .eq. ' ' .or. name1 .eq. ' ') then
	    write (message,510) record
 510	    format ('READ_MENU record ',i4,': SET statement left ',
     *		' hand side requires either flag var or both record ',
     *		' and var name')
	    errors=errors+1
	    call warning
	    goto 200
	  endif
	endif
	if (rec2(1:1) .eq. '%') then
	  call checkFlagName (rec2(2:),iCode)
	  if (icode .lt. 0) then
	    write (message,9052) record,rec2
	    call warning 
	    errors=errors+1
	    goto 200
	  endif
	else
	  if (rec2 .eq. ' ' .and. name2 .eq. ' ') then
	    write (message,511) record
 511 	    format ('READ_MENU record ',i4,': SET statement right ',
     *		'hand side requires either flag var or var name or ',
     *		'symbolic value')
	    errors=errors+1
	    call warning
	    goto 200
	  endif
	endif
c
c  room for flag statements
c
	if (n_flag .ge. max_flag) then
	  write (message,504) n_flag,record
 504	  format ('READ_MENU: Can''t handle more than ',i4,
     *		' flag statements - overflow at record ',i4)
	  call fatal 
	endif
	n_flag=n_flag+1
	if (m_flag_start(n_menu) .eq. 0) then
	   m_flag_start(n_menu)=n_flag
	endif
	f_result(n_flag)=result(2:)
	f_rec1(n_flag)=rec1
	f_rec2(n_flag)=rec2
	f_name1(n_flag)=name1
	f_name2(n_flag)=name2
	f_rel(n_flag)=rel
	goto 200
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  DATA - this is the hard part
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
 2000	if (statement_type .ne. 'DATA') then
	  message='READ_MENU: Can''t get here from there'
	  call fatal
	endif
c
	read (data,9040,err=3000) rec,flag,force,readonly,own1,own2,
     *			name,prompt,submenu
 9040	format (5x,a3,1x,a1,a1,a1,i2,i2,a16,8x,a33,a16)
c
c  convert some things to uppercase
c
	call upcase (rec)
	call upcase (flag)
	call upcase (force)
	call upcase (name)
	call upcase (submenu)
	call upcase (readonly)
c
c  Check that Readonly is either blank (implies N), Y, or N
c
 2020	if (readonly .eq. ' ') readonly='N'
	if (readonly .ne. 'N' .and. readonly .ne. 'Y') then
	  write (message,9050) record,readonly
 9050	  format ('READ_MENU: Record ',i4,' has an illegal value ',
     *		  'for Readonly ("',a,'") - Use blank, ',
     *		  '"Y", or "N"')
	  call warning 
	  errors=errors+1
	  goto 200
	endif
	if (force .eq. ' ') force='N'
	if (force .ne. 'N' .and. force .ne. 'Y') then
	  write (message,9051) record,force
 9051	  format ('READ_MENU: Record ',i4,' has an illegal value ',
     *		  'for Force ("',a,'") - Use blank, ',
     *		  '"Y", or "N"')
	  call warning
	  errors=errors+1
	  goto 200
	endif
	if (flag .ne. ' ') then
	  call checkFlagName (flag,icode)
	  if (icode .lt. 0) then
	    write (message,9052) record,flag
 9052	    format ('READ_MENU: Record ',i4,' has an illegal value ',
     *		  'for Flag ("',a,'") - Use letters "A" through "Z"')
	    call warning
	    errors=errors+1
	    goto 200
	  endif
	endif

c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Got the record
c  Room in the array
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
 2300	if (n_detail .ge. max_detail) then
	  write (message,9105) n_detail,record
 9105	  format ('READ_MENU: Can''t handle more than ',i4,
     *		' detail lines - overflow at record ',i4)
	  call fatal 
	endif
c
c  enough room on display
c
	if (line_of_display .ge. max_crt_line) then
	  write (message,9110) this_menuname,line_of_display
 9110	  format ('READ_MENU: Menu "',a,'" occupies more than ',i2,
     *	  	  ' lines of the CRT')
	  call warning 
	  errors=errors+1
	  goto 200
	else
	  line_of_display=line_of_display+1
	endif
c
c  add to the array
c
	n_detail=n_detail+1
	d_rec(n_detail)=rec
	d_name(n_detail)=name
	d_prompt(n_detail)=prompt
	d_submenu(n_detail)=submenu
	d_readonly(n_detail)=readonly
	d_own1(n_detail)=own1
	d_own2(n_detail)=own2
	d_line(n_detail)=line_of_display
	d_flag(n_detail)=flag
	d_force(n_detail)=force
c
c  mark where this menu begins if this is the first entry
c
	if (m_detail_start(n_menu) .eq. 0) then
		m_detail_start(n_menu)=n_detail
	endif
c
c  keep on truckin'
c
	goto 200

c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Conversion errors
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
 3000	write (message,9115) record,name
 9115	format ('READ_MENU Record ',i4,
     *		': Variable "',a,'" has illegal numbers for ',
     *		'subscript 1, subscript 2, or both')
	call warning 
	errors=errors+1
	goto 200
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Return
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
 9200	if (errors .ne. 0) then
	  write (message,9120)
 9120	  format ('READ_MENU: One or more errors in processing menu ',
     *		  'file')
	  call fatal 
	endif
c
	if (n_menu .gt. 0 .and. m_detail_start(n_menu) .ne. 0) then
	  m_detail_stop (n_menu) = n_detail
	endif
c
	if (n_menu .gt. 0 .and. m_flag_start(n_menu) .ne. 0) then
	  m_flag_stop(n_menu) = n_flag
	endif
c
	return
	end
