//
// logger.h: logging facility. 
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#ifndef excon_batch_logger_h
#define excon_batch_logger_h

#include <stdio.h>
#include "xrtypes.h"

/***************************************************************************/

class Hashtable;
class Stq;

/***************************************************************************/


/***************************************************************************
 *
 *  Logging classes
 *
 ***************************************************************************/

class Logger {
public:
    static const unsigned nolog;
    static const unsigned debug;
    static const unsigned exec;
    static const unsigned resolve;
    static const unsigned run;
    static const unsigned report;
    static const unsigned reporter;

public:
    Logger(const char* logfile, int logcode, bool logstderr);
    ~Logger();
    char* getlogfile()			{ return logfile_; }
    void setlogcode(int logcode);
    int setlogfile(const char* logfile);
    void setlogstderr(bool);
    void log(int logcode, const char* logmsg);
private:
    char* logfile_;
    FILE* fp_;
    int logcodes_;
    bool logstderr_;
};

#endif/*excon_batch_logger_h*/
