//
// logger.cc: logging facility. 
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#include <stdio.h>
#include <stdlib.h>

#include "global.h"
#include "logger.h"
#include "utils.h"

/************************************************************************/

const unsigned Logger::nolog = 0x0;
const unsigned Logger::debug = 0x1;
const unsigned Logger::exec = 0x2;
const unsigned Logger::resolve = 0x4;
const unsigned Logger::run = 0x8;
const unsigned Logger::report = 0x10;
const unsigned Logger::reporter = 0x20;

Logger::Logger(const char* logfile, int logcode, bool logstderr) {
    logcodes_ = logcode;
    logfile_ = nil;
    logstderr_ = logstderr;
    fp_ = nil;
    if (logfile)
	setlogfile(logfile);
}

Logger::~Logger() {
    if (fp_)
	fclose(fp_);
    fp_ = nil;
    delete[] logfile_; logfile_ = nil;
}

void Logger::setlogstderr(bool logstderr) {
    logstderr_ = logstderr;
}

int Logger::setlogfile(const char* logfile) {
    int retcode = 0;
    if (fp_)
	fclose(fp_);
    delete[] logfile_;
    logfile_ = strcpy_with_alloc(logfile);
    if ((fp_ = fopen(logfile, "w")) == nil) {
	fprintf(stderr, 
	    "EXCON::setlogfile: can't open log file '%s'\n", logfile
	);
	perror("EXCON::Logger");
	retcode = -1;
    }
    return retcode;
}

void Logger::setlogcode(int logcode) {
    logcodes_ |= logcode;
}

void Logger::log(int logcode, const char* logmsg) {
    assume(fp_ != nil);
    if (logcodes_ && logcode) {
	fputs(logmsg, fp_);
	fflush(fp_);
	if (logstderr_) {
	    fputs(logmsg, stderr);
	    fflush(stderr);
	}
    }
}

/************************************************************************/
