//
// link.cc: dependency linker for input/output variables.
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#include <string.h>

#include "link.h"
#include "utils.h"

Link::Link (
    const char* text, const char* tool, const char* var, 
    const char* actioncode, const char* actionval
) {
    text_ = strcpy_with_alloc(text);
    tool_ = strcpy_with_alloc(tool);
    var_ = strcpy_with_alloc(var);
    actioncode_  = strcpy_with_alloc(actioncode);
    actionval_ = strcpy_with_alloc(actionval);
}

Link* Link::clone () const {
    Link* buddy = new Link(text_, tool_, var_, actioncode_, actionval_);
    return buddy;
}

Link::~Link() {
    delete[] text_; text_ = nil;
    delete[] tool_; tool_ = nil;
    delete[] var_; var_ = nil;
    delete[] actioncode_; actioncode_ = nil;
    delete[] actionval_; actionval_ = nil;
}

ResolvedLink::ResolvedLink (const Link* link, const char* toolinstance) 
    : link_(link) 
{
    instance_ = strcpy_with_alloc(toolinstance);
}

ResolvedLink::~ResolvedLink() {
    delete[] instance_; instance_ = nil;
}

ResolvedLink* ResolvedLink::clone() const {
    return new ResolvedLink(link_, instance_);
}
