C +++
C
C Source: src/source/source.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: source.F
C Revision 1.14  1992/02/12  13:43:59  cwelnak
C loop unrolling for undulator (sun)
C
C Revision 1.13  92/01/21  14:22:07  cwelnak
C 6000 changes
C 
C Revision 1.12  91/10/25  20:24:51  cwelnak
C elliptical wiggler code fix -- difonzo
C 
C Revision 1.11  1991/08/26  11:40:59  khan
C cosmetic changes.
C
C Revision 1.10  91/07/06  19:59:53  khan
C Elliptical Undulator by Sylvia Difonzo
C 
C
C Revision 1.10 91/06/28  di fonzo - singh
C Added option for elliptical wiggler
C
C Revision 1.9  91/04/05  14:03:31  cwelnak
C changed quotes on #include
C 
C Revision 1.8  91/03/20  16:46:39  cwelnak
C SUN version -- changes INCLUDE to #include
C 
C Revision 1.7  91/03/15  15:36:39  khan
C Getting ready for Sun port...
C 
C Revision 1.6  91/02/21  14:40:34  khan
C Replaced RAN with WRAN (wrapper for RAN that checks for 0.0D0 return)
C 
C Revision 1.5  90/11/09  14:13:25  khan
C Added SAVE statements...
C 
C Revision 1.4  90/07/19  20:53:06  khan
C Put Preprocessor/conditionals to make it work on both VMS and Ultrix.
C 
C Revision 1.3  90/07/14  22:39:17  khan
C All global include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.2  90/07/11  00:00:26  khan
C Added an ASCII option to BEGIN file. SOURCE now takes two parameters.
C 
C Revision 1.1  90/07/10  14:57:03  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	SOURCE
C
C	PURPOSE		To generate a (12,ndim) array describing the system
C			source.
C
C	INPUTS		From modules SETSOUR, MSETUP, through COMMON.BLK
C			The following two input parameters are meant to
C			be passed to the WRITE_OFF subroutine to control
C			the output format.
C	    FNAME	Name of the output file. This enables us to use
C			use ASCII or BINARY output files (BEGIN.DAT's).
C	    IOFORM = 0, Binary output file.
C		   = 1, ASCII output file. (only unix version)
C
C	OUTPUTS		File BEGIN.DAT
C
C	MODIFICATIONS	Included wiggler and undulator source (2/26/88)
C
C---
	SUBROUTINE 	SOURCE1 (FNAME, IOFORM)
C
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
C
	INTEGER		IOFORM
	CHARACTER*(*)	FNAME
C
	CHARACTER*80	ERRMSG
	DIMENSION	BEGIN(12,N_DIM), PHASE(3,N_DIM), AP(3,N_DIM)
	DIMENSION 	DIREC(3),AP_VEC(3),E_TEMP(3),SB_POS(3),
     $			VTEMP(3),GRID(6,N_DIM),A_VEC(3),A_TEMP(3),
     $			E_BEAM(3)
	DIMENSION	SIGXL(10),SIGZL(10)
	REAL*8		SEED_Y(5,N_DIM),Y_X(5,N_DIM),Y_XPRI(5,N_DIM),
     $                  Y_Z(5,N_DIM),Y_ZPRI(5,N_DIM),
     $			Y_CURV(5,N_DIM),Y_PATH(5,N_DIM)
	REAL*8		Y_TEMP(N_DIM),C_TEMP(N_DIM),X_TEMP(N_DIM),
     $			Z_TEMP(N_DIM),ANG_TEMP(N_DIM),P_TEMP(N_DIM),
     $                  ANG2_TEMP(N_DIM)

	DIMENSION	CDFX(31,31,51),CDFZ(31,51),CDFW(51)
	DIMENSION	D_POL(31,31,51)
	DIMENSION	UPHI(31,31,51),UTHETA(31,51),UENER(51)
	DIMENSION	JI(2),DZ(2),THE_INT(2)
	DIMENSION	II(4),DX(4),PHI_INT(4)

C
C Save the *big* arrays so it will:
C  -- zero out the elements.
C  -- put in the global heap.
C
	SAVE		BEGIN, PHASE, AP, 
     $ 			DIREC,AP_VEC,E_TEMP,SB_POS,
     $			GRID,A_VEC,A_TEMP,E_BEAM,
     $			SIGXL,SIGZL,
     $			SEED_Y,Y_X,Y_XPRI,Y_Z,Y_ZPRI,
     $			Y_CURV,Y_PATH,
     $			Y_TEMP,C_TEMP,X_TEMP,Z_TEMP,
     $			ANG_TEMP,P_TEMP,ANG2_TEMP

      	DATA	SQRT_2	/ 1.41421 35623 73095 04880 16887 D0/

     	KREJ = 0
     	NREJ = 0
C
C Sets up some variables needed for the rest of the routine
C
C First figure out the number of columns written out for each ray.
C
	IF (F_POLAR.EQ.1) THEN
	  NCOL	= 18
	ELSE IF (F_OPD.EQ.1) THEN
	  NCOL	= 13
	ELSE
	  NCOL	= 12
	END IF

	IF (F_WIGGLER.EQ.1) THEN
C
C Normal wigger case:
C read in the wiggler trajectory, tangent and radius, and other parameters
C
#ifdef vms
	  OPEN	(29, FILE=FILE_TRAJ, STATUS='OLD', 
     $			FORM='UNFORMATTED', READONLY)
#else
	  OPEN	(29, FILE=FILE_TRAJ, STATUS='OLD', 
     $			FORM='UNFORMATTED')
#endif
	  READ	(29)	NP_TRAJ,PATH_STEP,BENER,RAD_MIN,RAD_MAX,PH1,PH2
	  DO 13 I = 1, NP_TRAJ
	    READ (29)	
     $		XIN,YIN,SEEDIN,ANGIN,CIN
C+++
C The program will build the splines for generating the stocastic source.
C the splines are defined by:
C
C      Y(X) = G(2,I)+X(I)*(G(3,I)+X(I)*(G(4,I)+X(I)*G(5,I)))
C
C which is valid between the interval X(I) and X(I+1)
C
C We define the 5 arrays:
C    Y_X(5,N)    ---> X(Y)
C    Y_XPRI(5,N) ---> X'(Y)
C    Y_CURV(5,N) ---> CURV(Y)
C    Y_PATH(5,N) ---> PATH(Y)
C    F(1,N) contains the array of Y values where the nodes are located.
C+++
	    Y_TEMP(I)	= YIN*CONV_FACT			! Convert to user units
	    X_TEMP(I)	= XIN*CONV_FACT			! Convert to user units
	    SEED_Y(1,I)	= SEEDIN
	    ANG_TEMP(I)	= ANGIN
	    C_TEMP(I)	= CIN
	    P_TEMP(I)	= (I-1)*PATH_STEP*CONV_FACT	! Convert to user units
C
C Array initialization:
C
	    Y_X(1,I)	= Y_TEMP(I)
	    Y_XPRI(1,I)	= Y_TEMP(I)
	    Y_CURV(1,I)	= Y_TEMP(I)
	    Y_PATH(1,I)	= Y_TEMP(I)
13	  CONTINUE
	  CLOSE	(29)
C
C Generate the (5) splines. Notice that the nodes are always in the first
C element already.
C      Y_X     : on input, first row contains nodes.
C      X_TEMP  : input array to which to fit the splines
C      NP_TRAJ : # of spline points
C      IER     : status flag
C On output:
C      Y_X(1,*)    : spline nodes
C      Y_X(2:5,*)  : spline coefficients (relative to X_TEMP)
C
	  NP_SY	= NP_TRAJ
	  IER	= 1
C*************************************
	  CALL	PIECESPL(SEED_Y, Y_TEMP,   NP_SY,   IER)
	  IER	= 0
	  CALL	CUBSPL	(Y_X,    X_TEMP,   NP_TRAJ, IER)
	  IER	= 0
	  CALL	CUBSPL	(Y_XPRI, ANG_TEMP, NP_TRAJ, IER)
	  IER	= 0
	  CALL	CUBSPL	(Y_CURV, C_TEMP,   NP_TRAJ, IER)
	  IER	= 0
	  CALL	CUBSPL	(Y_PATH, P_TEMP,   NP_TRAJ, IER)
C+++
C Compute the path length to the middle (origin) of the wiggler.
C We need to know the "center" of the wiggler coordinate.
C input:     Y_PATH  ---> spline array
C            NP_TRAJ ---> # of points
C            Y_TRAJ  ---> calculation point (ind. variable)
C output:    PATH0   ---> value of Y_PATH at X = Y_TRAJ. If
C                         Y_TRAJ = 0, then PATH0 = 1/2 length 
C                         of trajectory.
C+++
	  Y_TRAJ	= 0.0D0
	  CALL	SPL_INT	(Y_PATH, NP_TRAJ, Y_TRAJ, PATH0, IER)
C
C These flags are set because of the original program structure.
C
 	F_PHOT		= 0
  	F_COLOR		= 3
C	FGRID		= 0
  	FSOUR		= 3
  	FDISTR		= 4
	ELSE IF (F_WIGGLER.EQ.3) THEN
C
C Elliptical wiggler case:
C
#ifdef vms
	  OPEN	(29, FILE=FILE_TRAJ, STATUS='OLD', 
     $			FORM='UNFORMATTED', READONLY)
#else
	  OPEN	(29, FILE=FILE_TRAJ, STATUS='OLD', 
     $			FORM='UNFORMATTED')
#endif
	  READ	(29)	NP_TRAJ,PATH_STEP,BENER,RAD_MIN,RAD_MAX,PH1,PH2
	  DO 14 I = 1, NP_TRAJ
	    READ (29) XIN,YIN,ZIN,SEEDIN,ANGIN1,ANGIN2,CIN	
C+++
C The program will build the splines for generating the stocastic source.
C the splines are defined by:
C
C      Y(X) = G(2,I)+X(I)*(G(3,I)+X(I)*(G(4,I)+X(I)*G(5,I)))
C
C which is valid between the interval X(I) and X(I+1)
C
C We define the 7 arrays:
C    Y_X(5,N)    ---> X(Y)
C    Y_XPRI(5,N) ---> X'(Y)
C    Y_Z(5,N)    ---> Z(Y)
C    Y_ZPRI(5,N) ---> Z'(Y)
C    Y_CURV(5,N) ---> CURV(Y)
C    Y_PATH(5,N) ---> PATH(Y)
C    F(1,N) contains the array of Y values where the nodes are located.
C+++
	    Y_TEMP(I)	= YIN*CONV_FACT			! Convert to user units
	    X_TEMP(I)	= XIN*CONV_FACT			! Convert to user units
	    Z_TEMP(I)	= ZIN*CONV_FACT			! Convert to user units
	    SEED_Y(1,I)	= SEEDIN
	    ANG_TEMP(I)= ANGIN1
	    ANG2_TEMP(I)= ANGIN2
	    C_TEMP(I)	= CIN
	    P_TEMP(I)	= (I-1)*PATH_STEP*CONV_FACT	! Convert to user units
C
C Array initialization:
C
	    Y_X(1,I)	= Y_TEMP(I)
	    Y_XPRI(1,I)	= Y_TEMP(I)
	    Y_Z(1,I)	= Y_TEMP(I)
	    Y_ZPRI(1,I)	= Y_TEMP(I)
	    Y_CURV(1,I)	= Y_TEMP(I)
	    Y_PATH(1,I)	= Y_TEMP(I)
14	  CONTINUE
	  CLOSE	(29)
C
C Generate the (7) splines. Notice that the nodes are always in the first
C element already.
C      Y_X (or Y_Z)       : on input, first row contains nodes.
C      X_TEMP (or Z_TEMP) : input array to which fit the splines
C      NP_TRAJ : # of spline points
C      IER     : status flag
C On output:
C      Y_X(1,*) or (Y_Z(1,*))     : spline nodes
C      Y_X(2:5,*) (or Y_Z(2:5,*)) : spline coefficients (relative to
C                                   X_TEMP (or Z_TEMP))
C
	  NP_SY	= NP_TRAJ
	  IER	= 1
C*************************************
	  CALL	PIECESPL(SEED_Y, Y_TEMP,   NP_SY,   IER)
	  IER	= 0
	  CALL	CUBSPL	(Y_X,    X_TEMP,   NP_TRAJ, IER)
	  IER	= 0
	  CALL	CUBSPL	(Y_Z,    Z_TEMP,   NP_TRAJ, IER)
	  IER	= 0
	  CALL	CUBSPL	(Y_XPRI, ANG_TEMP, NP_TRAJ, IER)
	  IER	= 0
	  CALL	CUBSPL	(Y_ZPRI, ANG2_TEMP, NP_TRAJ, IER)
	  IER	= 0
	  CALL	CUBSPL	(Y_CURV, C_TEMP,   NP_TRAJ, IER)
	  IER	= 0
	  CALL	CUBSPL	(Y_PATH, P_TEMP,   NP_TRAJ, IER)
C+++
C Compute the path length to the middle (origin) of the wiggler.
C We need to know the "center" of the wiggler coordinate.
C input:     Y_PATH  ---> spline array
C            NP_TRAJ ---> # of points
C            Y_TRAJ  ---> calculation point (ind. variable)
C output:    PATH0   ---> value of Y_PATH at X = Y_TRAJ. If
C                         Y_TRAJ = 0, then PATH0 = 1/2 length 
C                         of trajectory.
C+++
	  Y_TRAJ	= 0.0D0
	  CALL	SPL_INT	(Y_PATH, NP_TRAJ, Y_TRAJ, PATH0, IER)
C
C These flags are set because of the original program structure.
C
 	F_PHOT		= 0
  	F_COLOR		= 3
C	FGRID		= 0
  	FSOUR		= 3
  	FDISTR		= 4
	ELSE IF (F_WIGGLER.EQ.2) THEN
C
C Uudulator case : first read in the CDF's and degree of polarization.
C
#ifdef vms
	  OPEN	(30, FILE=FILE_TRAJ, STATUS='OLD',
     $	  	FORM='UNFORMATTED', READONLY)
#else
	  OPEN	(30, FILE=FILE_TRAJ, STATUS='OLD',
     $	  	FORM='UNFORMATTED')
#endif
	  READ	(30)	NE,NT,NP,IANGLE

	  DO 17 K = 1,NE
17	     READ  	(30)	UENER(K)
	  DO 27 K = 1,NE
	     DO 27 J = 1,NT
27	        READ   	(30)   	UTHETA(J,K)
	  DO 37 K = 1,NE
	     DO 37 J = 1,NT
		DO 37 I = 1,NP
37	           READ	(30)	UPHI(I,J,K)

	  DO 47 K = 1,NE
47	     READ   	(30) 	CDFW(K)
	  DO 57 K = 1,NE
	     DO 57 J = 1,NT
57	        READ	(30)	CDFZ(J,K)
	  DO 67 K = 1,NE
	     DO 67 J = 1,NT
		DO 67 I = 1,NP
67	           READ	(30)	CDFX(I,J,K)

	  DO 87 K = 1,NE
	     DO 87 J = 1,NT
		DO 87 I = 1,NP
87	  	   READ	(30)	D_POL(I,J,K)

D	  READ	(30)	(UENER(K), K = 1,NE)
D	  READ	(30)	((UTHETA(J,K), J = 1,NT), K = 1,NE)
D	  READ	(30)	(((UPHI(I,J,K), I = 1,NP), J = 1,NT), K = 1,NE)
D
D	  READ	(30)	(CDFW(K), K = 1,NE)
D	  READ	(30)	((CDFZ(J,K), J = 1,NT), K = 1,NE)
D	  READ	(30)	(((CDFX(I,J,K), I = 1,NP), J = 1,NT), K = 1,NE)
D
D	  READ	(30)	(((D_POL(I,J,K), I = 1,NP), J = 1,NT), K = 1,NE)

	  CLOSE	(30)
C
C These flags are set because of the original program structure.
C
	  F_PHOT	= 0
	  F_COLOR	= 3
C	  FGRID		= 0
	  FSOUR		= 3
	  F_COHER	= 1
	ELSE
	  RAD_MIN	= ABS(R_MAGNET)
	  RAD_MAX	= ABS(R_MAGNET)
	END IF
C
C Prepares some SR variables; the vertical divergence replaces the emittance
C
     	IF (FDISTR.EQ.4.OR.FDISTR.EQ.6) THEN
	  F_COHER = 0
	  IF (R_ALADDIN.LT.0.0D0) THEN
	    POL_ANGLE = -90.0D0
	  ELSE
	    POL_ANGLE = 90.0D0
	  END IF
	END IF
	POL_ANGLE     =   TORAD*POL_ANGLE
C
C Saved values of emittance that user inputs.  Write these out to 
C namelist instead of EPSI/SIGMA.  6/25/93 clw.
C
     	IF (FSOUR.EQ.3) THEN
	  EPSI_XOLD = EPSI_X
	  EPSI_ZOLD = EPSI_Z
	  IF (SIGMAX.NE.0.0D0) THEN
	    EPSI_X	=   EPSI_X/SIGMAX
	  ELSE
	    EPSI_X	=   0.0D0
	  END IF
	  IF (SIGMAZ.NE.0.0D0) THEN
	    EPSI_Z	=   EPSI_Z/SIGMAZ
	  ELSE
	    EPSI_Z	=   0.0D0
	  END IF
     	END IF

     	PHOTON(1) = PH1
     	PHOTON(2) = PH2
     	PHOTON(3) = PH3
     	PHOTON(4) = PH4
     	PHOTON(5) = PH5
     	PHOTON(6) = PH6
     	PHOTON(7) = PH7
     	PHOTON(8) = PH8
     	PHOTON(9) = PH9
     	PHOTON(10) = PH10
C
C sets up the acceptance/rejection method for optimizing source
C notice that this is acceptable ONLY for random sources
C
     	IF ( F_BOUND_SOUR.EQ.1 .AND. FGRID.EQ.0 ) THEN
     	  CALL 	SOURCE_BOUND (XDUM,YDUM,-1)
     	END IF
C
C tests for grids
C
	IF (FGRID.EQ.4.OR.FGRID.EQ.5) THEN
	  SIGXL(1) = SIGXL1
	  SIGXL(2) = SIGXL2
	  SIGXL(3) = SIGXL3
	  SIGXL(4) = SIGXL4
	  SIGXL(5) = SIGXL5
	  SIGXL(6) = SIGXL6
	  SIGXL(7) = SIGXL7
	  SIGXL(8) = SIGXL8
	  SIGXL(9) = SIGXL9
	  SIGXL(10) = SIGXL10
C
	  SIGZL(1) = SIGZL1
	  SIGZL(2) = SIGZL2
	  SIGZL(3) = SIGZL3
	  SIGZL(4) = SIGZL4
	  SIGZL(5) = SIGZL5
	  SIGZL(6) = SIGZL6
	  SIGZL(7) = SIGZL7
	  SIGZL(8) = SIGZL8
	  SIGZL(9) = SIGZL9
	  SIGZL(10) = SIGZL10
C
C The next two assignments are just for convenience of the original program 
C structure.
C
	  FSOUR	= 4
	  FDISTR = 7
	END IF
	IF (F_PHOT.EQ.1) THEN
	  IF (F_COLOR.EQ.1) THEN
	    PHOTON(1)	=   TOANGS/PHOTON(1)
	  ELSE IF (F_COLOR.EQ.2) THEN
	    DO  21 I=1,N_COLOR
	      PHOTON(I)	=   TOANGS/PHOTON(I)
21	    CONTINUE
	  ELSE IF (F_COLOR.EQ.3) THEN
	    DO 31 I=1,2
	      PHOTON(I)	=   TOANGS/PHOTON(I)
31	    CONTINUE
     	  END IF
     	END IF
C
C If the S.R. case has been chosen, set up the subroutine for the
C  vertical distribution.
C
	IF (FDISTR.EQ.6) CALL ALADDIN1 (DUMMY,DUMMY,-1,IER)
     	IF (FDISTR.EQ.4) 
     $	CALL WHITE (RAD_MIN,RAD_MAX,DUMMY,DUMMY,DUMMY,DUMMY,DUMMY,0)
C
C Calculate the total number of rays.
C
102	CONTINUE

	IF (FDISTR.NE.5) THEN
	  NMOM	= IDO_VX * IDO_VZ
	ELSE
	  NMOM	= (N_CONE * N_CIRCLE) 
	  IDO_VX = N_CIRCLE
	  IDO_VZ = N_CONE
	END IF
	NSPACE	= IDO_X_S * IDO_Y_S * IDO_Z_S

	IF (FGRID.EQ.0) THEN
	  NTOTAL	= NPOINT
	ELSE IF (FGRID.EQ.1) THEN
	  NTOTAL	= NSPACE * NMOM
	ELSE IF (FGRID.EQ.2) THEN
	  NTOTAL	= NSPACE * NPOINT
	ELSE IF (FGRID.EQ.3) THEN
	  NTOTAL	= NPOINT * NMOM
	ELSE IF (FGRID.EQ.4) THEN
	  NTOTAL	= IDO_XL * NPOINT * IDO_ZL * NPOINT
	ELSE IF (FGRID.EQ.5) THEN
	  NTOTAL	= IDO_XL * IDO_XN * IDO_ZL * IDO_ZN
	END IF

     	IF (NTOTAL.LE.0)	CALL LEAVE ('SOURCE','NPOINT = 0',0)
     	IF (NTOTAL.GT.N_DIM)	CALL LEAVE ('SOURCE','Too many rays.',0)
C
C Compute the steps and iteration count limits for the grid generation.
C
	IF (IDO_X_S.GT.1)	STEP_X	= 1.0D0/(IDO_X_S - 1)
	IF (IDO_Y_S.GT.1)	STEP_Y	= 1.0D0/(IDO_Y_S - 1)
	IF (IDO_Z_S.GT.1)	STEP_Z	= 1.0D0/(IDO_Z_S - 1)
	IF (IDO_VX.GT.1)	STEP_VX	= 1.0D0/(IDO_VX - 1)
	IF (IDO_VZ.GT.1)	STEP_VZ	= 1.0D0/(IDO_VZ - 1)
	IF (IDO_XN.GT.1)	STEP_XN = 1.0D0/(IDO_XN - 1)
	IF (IDO_ZN.GT.1)	STEP_ZN = 1.0D0/(IDO_ZN - 1)
	CL_X	= (IDO_X_S - 1) / 2.0D0
	CL_Y	= (IDO_Y_S - 1) / 2.0D0
	CL_Z	= (IDO_Z_S - 1) / 2.0D0
	CL_VX	= (IDO_VX - 1) / 2.0D0
	CL_VZ	= (IDO_VZ - 1) / 2.0D0
	CL_XN	= (IDO_XN - 1) / 2.0D0
	CL_ZN	= (IDO_ZN - 1) / 2.0D0
C
C First fill out a "typical" part of the GRID direction.
C
	INDEXMOM	= 0	
	IF (FGRID.EQ.0.OR.FGRID.EQ.2) THEN
	  DO 41 I = 1, NPOINT
	    GRID (4,I)	= WRAN (ISTAR1)
	    GRID (6,I)	= WRAN (ISTAR1)
41	  CONTINUE
	  INDEXMOM	= NPOINT
	ELSE IF (FGRID.EQ.1.OR.FGRID.EQ.3) THEN
	  DO 51 C_VX = -CL_VX, CL_VX
	    DO 61 C_VZ = -CL_VZ, CL_VZ
	      INDEXMOM	= INDEXMOM + 1
	      GRID (4,INDEXMOM)	= C_VX * STEP_VX + 0.5D0
	      GRID (6,INDEXMOM)	= C_VZ * STEP_VZ + 0.5D0
61	    CONTINUE
51	  CONTINUE
C	  IF (FDISTR.EQ.5) THEN
C	    INDEXMOM = INDEXMOM + 1
C	    GRID (4,INDEXMOM)	= 0.0D0
C	    GRID (6,INDEXMOM)	= -1.0D0
C	  END IF
	ELSE IF (FGRID.EQ.4.OR.FGRID.EQ.5) THEN
	  DO 71 I = 1, IDO_XL
	    IF (FGRID.EQ.4) THEN
	      DO 81 J = 1, NPOINT
	        INDEXMOM		= INDEXMOM + 1
	        GRID(1,INDEXMOM)	= SIGXL(I)
	        GRID(2,INDEXMOM)	= WRAN (ISTAR1)
	        GRID(4,INDEXMOM)	= WRAN (ISTAR1)
81	      CONTINUE
	    ELSE
	      DO 91 C_XN = -CL_XN, CL_XN
	        INDEXMOM		= INDEXMOM + 1
	        GRID(1,INDEXMOM)	= SIGXL(I)
	        GRID(2,INDEXMOM)	= WRAN (ISTAR1)
	        GRID(4,INDEXMOM)	= C_XN * STEP_XN + 0.5D0
91 	      CONTINUE
	    END IF
71 	  CONTINUE
	END IF
C
C Now fill out the entire GRID.
C
	INDEXSPA = 0
	IF (FGRID.EQ.0) THEN
	  DO 103 I = 1, NPOINT
	    GRID (1,I)	= WRAN (ISTAR1)
	    GRID (2,I)	= WRAN (ISTAR1)
	    GRID (3,I)	= WRAN (ISTAR1)
103	  CONTINUE
	  INDEXSPA = NPOINT
	ELSE IF (FGRID.EQ.3) THEN
	  DO 113 I = 1, NPOINT
	    TEMPX = WRAN (ISTAR1)
	    TEMPY = WRAN (ISTAR1)
	    TEMPZ = WRAN (ISTAR1)
	    DO 121 J = 1, INDEXMOM
	      INDEXSPA	= INDEXSPA + 1
	      GRID(1,INDEXSPA)	= TEMPX
	      GRID(2,INDEXSPA)	= TEMPY
	      GRID(3,INDEXSPA)	= TEMPZ
	      GRID(4,INDEXSPA)	= GRID (4,J)
	      GRID(6,INDEXSPA)	= GRID (6,J)
121	    CONTINUE
113	  CONTINUE
	ELSE IF (FGRID.EQ.1.OR.FGRID.EQ.2) THEN
	  DO 131 C_X = -CL_X, CL_X
	    DO 141 C_Y = -CL_Y, CL_Y
	      DO 151 C_Z = -CL_Z, CL_Z
		DO 161 J = 1, INDEXMOM
	      	  INDEXSPA	= INDEXSPA + 1
	      	  GRID (1,INDEXSPA)	= C_X * STEP_X + 0.5D0
	      	  GRID (2,INDEXSPA)	= C_Y * STEP_Y + 0.5D0
		  GRID (3,INDEXSPA)	= C_Z * STEP_Z + 0.5D0
		  GRID (4,INDEXSPA)	= GRID (4,J)
		  GRID (6,INDEXSPA)	= GRID (6,J)
161		CONTINUE
151	      CONTINUE
141	    CONTINUE
131	  CONTINUE
	ELSE IF (FGRID.EQ.4.OR.FGRID.EQ.5) THEN
	  DO 171 I = 1, IDO_ZL
	    IF (FGRID.EQ.4) THEN
	      DO 181 J = 1, NPOINT
	        TEMP = WRAN (ISTAR1)
	        DO 191 K = 1, IDO_XL*NPOINT
	          INDEXSPA		= INDEXSPA + 1
	          GRID(1,INDEXSPA)	= GRID(1,K)
		      GRID(2,INDEXSPA)	= GRID(2,K)
	          GRID(4,INDEXSPA)	= GRID(4,K)
	          GRID(3,INDEXSPA)	= SIGZL(I)
	          GRID(6,INDEXSPA)	= TEMP
191	        CONTINUE
181	      CONTINUE
	    ELSE
	      DO 201 C_ZN = -CL_ZN, CL_ZN
	        TEMP	= C_ZN * STEP_ZN + 0.5D0
	        DO 211 K = 1, IDO_XL*IDO_XN
	          INDEXSPA		= INDEXSPA + 1
	          GRID(1,INDEXSPA)	= GRID(1,K)
		  	  GRID(2,INDEXSPA)	= GRID(2,K)
	          GRID(4,INDEXSPA)	= GRID(4,K)
	          GRID(3,INDEXSPA)	= SIGZL(I)
	          GRID(6,INDEXSPA)	= TEMP
211	        CONTINUE
201	      CONTINUE
	    END IF
171	  CONTINUE
	END IF	
C
C---------------------------------------------------------------------
C           POSITIONS
C
C
     	KK	=   0
     	MM	=   0
	DO 10000 ITIK=1,NTOTAL
     	KK	=  KK + 1
     	IF (KK.EQ.250) THEN
     	  ITOTRAY = KK + MM*250
     	 IF (MM.EQ.0) THEN
     	  WRITE(6,*)'Generated ',ITOTRAY,' rays out of ',NTOTAL
     	 ELSE
     	  WRITE(6,*)'          ',ITOTRAY
     	 END IF
     	  KK = 0
     	  MM = MM + 1
     	END IF
C
C The following entry point is for the "optimized" source
C
C
10001	CONTINUE
C
C
C The following interpolation is done for wiggler: GRID -> Y, Y -> X, Y -> Z, 
C Y -> X', Y -> RAD, Y -> path length from middle of wiggler.
C 
C Either wiggler case
C
    	IF ((F_WIGGLER.EQ.1).OR.(F_WIGGLER.EQ.3)) THEN
C
C Normal wiggler case
C
	  IF (F_WIGGLER.EQ.1) THEN
	    ARG_Y = GRID(2,ITIK)
	    CALL SPL_INT (SEED_Y, NP_SY,   ARG_Y,  Y_TRAJ,    IER)
	    CALL SPL_INT (Y_X,    NP_TRAJ, Y_TRAJ, X_TRAJ,    IER)
	    CALL SPL_INT (Y_XPRI, NP_TRAJ, Y_TRAJ, ANGLE,     IER)
	    CALL SPL_INT (Y_CURV, NP_TRAJ, Y_TRAJ, CURV,      IER)
	    CALL SPL_INT (Y_PATH, NP_TRAJ, Y_TRAJ, EPSI_PATH, IER)
          END IF
C
C Elliptical wiggler case
C
          IF (F_WIGGLER.EQ.3) THEN
	    ARG_Y = GRID(2,ITIK)
	    CALL SPL_INT (SEED_Y, NP_SY,   ARG_Y,  Y_TRAJ,    IER)
	    CALL SPL_INT (Y_X,    NP_TRAJ, Y_TRAJ, X_TRAJ,    IER)
	    CALL SPL_INT (Y_Z,    NP_TRAJ, Y_TRAJ, Z_TRAJ,    IER)
	    CALL SPL_INT (Y_XPRI, NP_TRAJ, Y_TRAJ, ANGLE1,    IER)
	    CALL SPL_INT (Y_ZPRI, NP_TRAJ, Y_TRAJ, ANGLE2,    IER)
	    CALL SPL_INT (Y_CURV, NP_TRAJ, Y_TRAJ, CURV,      IER)
	    CALL SPL_INT (Y_PATH, NP_TRAJ, Y_TRAJ, EPSI_PATH, IER)
          END IF
C
	  EPSI_PATH	= EPSI_PATH - PATH0	! now refer to wiggler's origin
	  IF (CURV.LT.0) THEN
	    POL_ANGLE	= 90.0D0		! instant orbit is CW
	  ELSE
	    POL_ANGLE	= -90.0D0		!		   CCW
	  END IF
	  IF (CURV.EQ.0) THEN
	    R_MAGNET	= 1.0D+20
	  ELSE
	    R_MAGNET	= ABS(1.0D0/CURV)
	  END IF
	  POL_ANGLE 	= TORAD*POL_ANGLE
C above statement added 24 march 1992 to change POL_ANGLE to radians. clw.
C
    	ELSE IF (FSOURCE_DEPTH.EQ.4) THEN		! Synchrontron depth
     	  ANGLE		=   GRID(2,ITIK) * (HDIV1 + HDIV2) - HDIV2
	  EPSI_PATH	=   ABS(R_ALADDIN)*ANGLE
C
C Undulator case : first interpolate for the photon energy.
C
    	ELSE IF (F_WIGGLER.EQ.2) THEN
	  ESEED		= GRID(2,ITIK)* CDFW(NE)
	  DO 221 K = 1, NE-1
	    IF (ESEED.LE.CDFW(K+1)) GO TO 510
221	  CONTINUE
510    	  DK		= (ESEED - CDFW(K))/(CDFW(K+1) - CDFW(K))
	  KI		= K
	  PENERGY	= UENER(K) + DK*(UENER(K+1) - UENER(K))
	  Q_WAVE	= TWOPI*PENERGY/TOCM
C
C then interpolate for theta (Z').
C
	  ZSEED		= GRID(6,ITIK) 

	  INDEX	= 1
	  DO 231 K = KI, KI+1
	      CZMAX	= ZSEED*CDFZ(NT,K)
	      DO 241 J = 1, NT-1
	        IF (CZMAX.LE.CDFZ(J+1,K)) THEN
		  JI(INDEX) = J
    	  	  DZ(INDEX) = (CZMAX - CDFZ(J,K))/(CDFZ(J+1,K) - CDFZ(J,K))
		  THE_INT(INDEX) = UTHETA(J,K) + DZ(INDEX)*
     $				(UTHETA(J+1,K) - UTHETA(J,K))
		  GO TO 520
	        END IF	
241	      CONTINUE
520	      INDEX = INDEX + 1
231	  CONTINUE

	  THETA	= THE_INT(1) + DK*(THE_INT(2)-THE_INT(1))

C
C Finally interpolate for phi (X').
C
	  XSEED		= GRID(4,ITIK) 

	  INDEX	= 1
	  DO 251 K = KI, KI+1
	    JNOW = JI(K-KI+1)
	    DO 261 J = JNOW, JNOW + 1
	        CXMAX	= XSEED * CDFX(NP,J,K)
	        DO 271 I = 1, NP-1
	          IF (CXMAX.LE.CDFX(I+1,J,K)) THEN
		    II(INDEX) = I
    	  	    DX(INDEX) = (CXMAX - CDFX(I,J,K))
     $				/(CDFX(I+1,J,K) - CDFX(I,J,K))
	  	    PHI_INT(INDEX) = UPHI(I,J,K) + DX(INDEX)*
     $					(UPHI(I+1,J,K) - UPHI(I,J,K))
		    GO TO 530
	          END IF	
271	        CONTINUE
530	      INDEX = INDEX + 1
261	    CONTINUE
251	  CONTINUE

	  PHI1 = PHI_INT(1) + DZ(1)*(PHI_INT(2) - PHI_INT(1))
	  PHI2 = PHI_INT(3) + DZ(2)*(PHI_INT(4) - PHI_INT(3))
	  PHI  = PHI1 + DK*(PHI2 - PHI1)

C
C Also the degree of polarization.
C

C ++++
C
C BEGIN BUG BUG BUG BUG (Tue Apr  8 21:25:51 CDT 1997)
C
C DELTAI, DELTAJ and DELTAK are used uninitialized here, and I have no 
C idea what these are supposed represent. I'm setting it to zero for 
C now, which is what most compilers do (not F77 standard however, and
C on some systems, you understandably get garbage). Also, fixed THETA3
C calculation (was THETA4 -- typo). -- MK
C
	  DELTAI = 0.0
	  DELTAJ = 0.0
	  DELTAK = 0.0
C
C END BUG  BUG
C
C ---
	  THETA1	= D_POL(I,J,K) + 
     $		(D_POL(I,J,K+1)     - D_POL(I,J,K))*		DELTAK
	  THETA2	= D_POL(I,J+1,K) + 
     $		(D_POL(I,J+1,K+1)   - D_POL(I,J+1,K))*		DELTAK
	  THETA3	= D_POL(I+1,J,K) + 
     $		(D_POL(I+1,J,K+1)   - D_POL(I+1,J,K))*		DELTAK
	  THETA4	= D_POL(I+1,J+1,K) + 
     $		(D_POL(I+1,J+1,K+1) - D_POL(I+1,J+1,K))* 	DELTAK
	  PHI1		= THETA1 + (THETA2-THETA1)*DELTAJ	
	  PHI2		= THETA3 + (THETA4-THETA3)*DELTAJ	
	  POL_DEG	= PHI1 + (PHI2-PHI1)*DELTAI
C
	  POL_ANGLE	= 90.0D0
	  EPSI_PATH	= 0.0D0
	  I_CHANGE	= 1
	  POL_ANGLE 	= TORAD*POL_ANGLE
C above statement added 24 march 1992 to change POL_ANGLE to radians. clw.
C
C If the cdf's are in polar coordinates switch them to cartesian angles.
C
	  IF (IANGLE.EQ.1) THEN
	    A_Z = ASIN(SIN(THETA)*SIN(PHI))
	    A_X = ACOS(COS(THETA)/COS(A_Z))
	    THETA	= A_Z
	    PHI		= A_X
	  END IF
C
C Decide in which quadrant THETA and PHI are.
C
	  IF (FGRID.EQ.0.OR.FGRID.EQ.2) THEN
	    IF (WRAN(ISTAR1).LT.0.5)	PHI = -PHI
	    IF (WRAN(ISTAR1).LT.0.5)	THETA = -THETA
	  END IF
       END IF                          !Undulator ends.

	GO TO (1,2,3,4,5,7), FSOUR + 1

1	CONTINUE
C
C Point source **
C
	GO TO 111

2	CONTINUE
C
C Rectangular source 
C
	XXX 		= (-1.0D0 + 2.0D0*GRID(1,ITIK))*WXSOU/2
	ZZZ 		= (-1.0D0 + 2.0D0*GRID(3,ITIK))*WZSOU/2
	GO TO 111

3	CONTINUE
C
C Elliptical source **
C Uses a transformation algorithm to generate a uniform variate distribution
C
	IF (FGRID.EQ.1.OR.FGRID.EQ.2) THEN
	  PHI		= TWOPI*GRID(1,ITIK)*(IDO_X_S-1)/IDO_X_S
	ELSE
	  PHI 		= TWOPI*GRID(1,ITIK)
	END IF
	RADIUS 		= SQRT(GRID(3,ITIK))
	XXX 		= WXSOU*RADIUS*COS(PHI)
	ZZZ 		= WZSOU*RADIUS*SIN(PHI)
	GO TO 111

4	CONTINUE
C
C Gaussian -- In order to accomodate the generation nof finite emittance
C beams, we had to remove the 'grid' case.
C 
	ARG_X 		= GRID(1,ITIK)
	ARG_Z 		= GRID(3,ITIK)
C
C Compute the actual distance (EPSI_W*) from the orbital focus
C
	EPSI_WX		= EPSI_DX + EPSI_PATH
	EPSI_WZ		= EPSI_DZ + EPSI_PATH
     	CALL	
     $	GAUSS	(SIGMAX, EPSI_X, EPSI_WX, XXX, E_BEAM(1), istar1)
     	CALL	
     $	GAUSS	(SIGMAZ, EPSI_Z, EPSI_WZ, ZZZ, E_BEAM(3), istar1)
C
C For normal wiggler, XXX is perpendicular to the electron trajectory at 
C the point defined by (X_TRAJ,Y_TRAJ,0).
C
	IF (F_WIGGLER.EQ.1) THEN
	  YYY	= Y_TRAJ - XXX*SIN(ANGLE)
	  XXX	= X_TRAJ + XXX*COS(ANGLE)
	  GO TO 550
	ELSE IF (F_WIGGLER.EQ.2) THEN
	  ANGLEX	= E_BEAM(1) + PHI
	  ANGLEV	= E_BEAM(3) + THETA
	  DIREC(1)	= TAN(ANGLEX)
	  DIREC(2)	= 1.0D0
	  DIREC(3)	= TAN(ANGLEV)/COS(ANGLEX)
	  CALL	NORM	(DIREC,DIREC)
	  GO TO 1111	  
        ELSE IF (F_WIGGLER.EQ.3) THEN
          VTEMP(1) = XXX
          VTEMP(2) = 0.0D0
          VTEMP(3) = ZZZ
          ANGLE1= -ANGLE1
          ANGLE3= 0.0D0
          CALL ROTATE(VTEMP,ANGLE3,ANGLE2,ANGLE1,VTEMP)
          XXX=X_TRAJ + VTEMP(1)
          YYY=Y_TRAJ + VTEMP(2)
          ZZZ=Z_TRAJ + VTEMP(3)
	END IF
	GO TO 111

5 	CONTINUE
C
C Ellipses in phase space (spatial components).
C
	IF (FGRID.EQ.4) THEN
	  PHI_X		= TWOPI * GRID(4,ITIK)
	  PHI_Z		= TWOPI * GRID(6,ITIK)
	ELSE
	  PHI_X		= TWOPI * GRID(4,ITIK) * (IDO_XN-1) / IDO_XN
	  PHI_Z		= TWOPI * GRID(6,ITIK) * (IDO_ZN-1) / IDO_ZN
	END IF
	XXX		= GRID(1,ITIK)*SIGMAX*COS(PHI_X)
	ZZZ		= GRID(3,ITIK)*SIGMAZ*COS(PHI_Z)
	GO TO 111

7	CONTINUE
C
C Plasma source (Dense Plasma)
C	PLASMA_ANGLE is the full angle source cone opening.
C	WYSOU becomes the total length of the source
C	The angle remains that of a uniform source (or conical)
C
	PLASMA_APERTURE = TAN(PLASMA_ANGLE/2.0)
	YYY	=	(1 - 2*GRID(2,ITIK))*WYSOU/2.0
	IF (YYY.GT.0.0) THEN
		RMAX	=  PLASMA_ANGLE*(WYSOU/2-YYY)
	ELSE
		RMAX	=  ABS(PLASMA_ANGLE*(YYY+WYSOU/2))
	END IF
	IF (FGRID.EQ.1.OR.FGRID.EQ.2) THEN
	  PHI		= TWOPI*GRID(1,ITIK)*(IDO_X_S-1)/IDO_X_S
	ELSE
	  PHI 		= TWOPI*GRID(1,ITIK)
	END IF
	RADIUS 		= SQRT(GRID(3,ITIK))
	XXX 		= RMAX*RADIUS*COS(PHI)
	ZZZ 		= RMAX*RADIUS*SIN(PHI)
	GOTO 111

 111	CONTINUE
C
C---------------------------------------------------------------------
C                      DEPTH
C
C
	 GO TO (110,220,330,440)  FSOURCE_DEPTH
C
C No depth case.
C
110	 GO TO 550
C
C Uniform depth distribution
C
 220	YYY 		= (-1.0D0 + 2.0D0*GRID(2,ITIK))*WYSOU/2
	 GO TO 550
C
C Gaussian depth distribution 
C
330	ARG_Y 		= GRID(2,ITIK)

	CALL MDNRIS (ARG_Y,YYY,IER)
	  IF (IER.NE.0) WRITE(6,*)'Warning ! Error in YYY,MNDRIS (SOURCE)'

	YYY 		= YYY*SIGMAY

	 GO TO 550
C
C Synchrotron depth distribution
C
440	CONTINUE
CC	R_ALADDIN NEGATIVE FOR COUNTER-CLOCKWISE SOURCE	
	IF (R_ALADDIN.LT.0) THEN
	  YYY		=   (ABS(R_ALADDIN) + XXX) * SIN(ANGLE)
	ELSE
	  YYY 		=   ( R_ALADDIN - XXX) * SIN(ANGLE)
	END IF
	XXX 		=   COS(ANGLE) * XXX +
     $				R_ALADDIN * (1.0D0 - COS(ANGLE))

550	CONTINUE
C
C---------------------------------------------------------------------
C             DIRECTIONS
C
C   Generates now the direction of the rays.
C
C
101	CONTINUE
	I_CHANGE	= 1
	GO TO (11,11,33,44,55,44,77), FDISTR

11	CONTINUE
C
C   Uniform distribution ( Isotrope emitter ) and cosine  source
C
C   Distinction not ready yet. Not important for small apertures 
C
     	XMAX1 		=   TAN(HDIV1)
     	XMAX2		= - TAN(HDIV2)
     	ZMAX1		=   TAN(VDIV1)
	ZMAX2		= - TAN(VDIV2)
	XRAND 		= (GRID(4,ITIK)*(XMAX1 - XMAX2) + XMAX2)
     	ZRAND 		= (GRID(6,ITIK)*(ZMAX1 - ZMAX2) + ZMAX2)
	THETAR 		= ATAN(SQRT(XRAND**2+ZRAND**2))
    	CALL 	ATAN_2 (ZRAND,XRAND,PHIR)
	DIREC(1) 	= COS(PHIR)*SIN(THETAR)
     	DIREC(2) 	= COS(THETAR)
	DIREC(3) 	= SIN(PHIR)*SIN(THETAR)
C     	ARG	=   GRID(6,ITIK)*(SIN(VDIV1) + SIN(VDIV2)) - SIN(VDIV2)
C     	PHIR	=   GRID(4,ITIK)*(HDIV1 + HDIV2) - HDIV1
C     	THETAR  =   ASIN(ARG)
C     	DIREC(1)	=   SIN(PHIR)*COS(THETAR)
C     	DIREC(2)	=   COS(PHIR)*COS(THETAR)
C     	DIREC(3)	=   SIN(THETAR)
	GO TO 1111

33 	CONTINUE
C
C Gaussian emitter 
C Note : an emitter cannot have an angular gaussian distribution, as a
C gaussian is defined from -infin. to + infin. It might be an useful
C approximation in several cases. This program uses a gaussian 
C distribution onto an ideal image plane, independent in x and z. This 
C approximation will not break down for large sigma.
C
	ARG_VX 		= GRID(4,ITIK)
	ARG_VZ 		= GRID(6,ITIK)

	CALL MDNRIS (ARG_VX,DIR_X,IER)
	  IF (IER.NE.0) WRITE(6,*)'Warning !Error in DIR_X:MNDRIS(SOURCE)'

	DIREC(1) 	= DIR_X*SIGDIX

	CALL MDNRIS (ARG_VZ,DIR_Z,IER)
	  IF (IER.NE.0) WRITE(6,*)'Warning !Error in DIR_Z:MNDRIS(SOURCE)'

	DIREC(3) 	= DIR_Z*SIGDIZ
	DIREC(2) 	= 1.0D0

	CALL NORM (DIREC,DIREC)

	GO TO 1111

44	CONTINUE
C
C Synchrotron source 
C Note. The angle of emission IN PLANE is the same as the one used
C before. This will give rise to a source curved along the orbit.
C The elevation angle is instead characteristic of the SR distribution.
C The electron beam emittance is included at this stage. Note that if
C EPSI = 0, we'll have E_BEAM = 0.0, with no changes.
C
    	IF (F_WIGGLER.EQ.3) ANGLE=0        ! Elliptical Wiggler.
     	ANGLEX		=   ANGLE + E_BEAM(1)
	DIREC(1) 	=   TAN(ANGLEX)
     	IF (R_ALADDIN.LT.0.0D0) DIREC(1) = - DIREC(1)
	DIREC(2) 	=   1.0D0
	ARG_ANG 	=   GRID(6,ITIK)
C
C In the case of SR, we take into account the fact that the electron
C trajectory is not orthogonal to the field. This will give a correction
C to the photon energy.  We can write it as a correction to the 
C magnetic field strength; this will linearly shift the critical energy
C and, with it, the energy of the emitted photon.
C
     	 E_TEMP(3)	=   TAN(E_BEAM(3))/COS(E_BEAM(1))
     	 E_TEMP(2)	=   1.0D0
     	 E_TEMP(1)	=   TAN(E_BEAM(1))
     	 CALL	NORM	(E_TEMP,E_TEMP)
     	 CORREC	=   SQRT(1.0D0-E_TEMP(3)**2)
4400    IF (FDISTR.EQ.6) THEN
	  CALL ALADDIN1 (ARG_ANG,ANGLEV,F_POL,IER)
     	  Q_WAVE	=   TWOPI*PHOTON(1)/TOCM*CORREC
     	  POL_DEG	=   ARG_ANG
     	ELSE IF (FDISTR.EQ.4) THEN
     	  ARG_ENER	=   WRAN (ISTAR1)
	  RAD_MIN	=   ABS(R_MAGNET)
     	  CALL WHITE 
     $		(RAD_MIN,CORREC,ARG_ENER,ARG_ANG,Q_WAVE,ANGLEV,POL_DEG,1)
     	END IF
      	IF (ANGLEV.LT.0.0) I_CHANGE = -1
     	ANGLEV		=   ANGLEV + E_BEAM(3)
C
C Test if the ray is within the specified limits
C
     	IF (FGRID.EQ.0.OR.FGRID.EQ.2) THEN
     	 IF (ANGLEV.GT.VDIV1.OR.ANGLEV.LT.-VDIV2) THEN
     	  ARG_ANG = WRAN(ISTAR1)
C
C If it is outside the range, then generate another ray.
C
     	  GO TO 4400
     	 END IF
     	END IF
	DIREC(3) 	=   TAN(ANGLEV)/COS(ANGLEX)
    	IF (F_WIGGLER.EQ.3) THEN
           CALL ROTATE (DIREC, ANGLE3,ANGLE2,ANGLE1,DIREC)
        END IF
     	CALL	NORM	(DIREC,DIREC)
     	GO TO 1111
55	CONTINUE
C   Now generates a set of rays along a cone centered about the normal,
C   plus a ray along the normal itself.
C     	
	IF (FGRID.EQ.1.OR.FGRID.EQ.3) THEN
	  ANGLE	=   TWOPI*GRID(4,ITIK)*(IDO_VX-1)/IDO_VX
	ELSE
	  ANGLE	=   TWOPI*GRID(4,ITIK)
	END IF
C temp fix -- 16 Jan 1987
C     	  ANG_CONE	=   CONE_MIN + 
C     $			(CONE_MAX - CONE_MIN)*GRID(6,ITIK)
     	ANG_CONE	=   COS(CONE_MIN) 
     $	- GRID(6,ITIK)*(COS(CONE_MIN)-COS(CONE_MAX))
     	ANG_CONE	=  ACOS(ANG_CONE)
     	DIREC(1)	=   SIN(ANG_CONE)*COS(ANGLE)
     	DIREC(2)	=   COS(ANG_CONE)
     	DIREC(3)	=   SIN(ANG_CONE)*SIN(ANGLE)
C
	GO TO 1111

77	CONTINUE
C
C Ellipses in phase space (momentum components).
C
	ANGLEX		= GRID(1,ITIK)*SIGDIX*SIN(PHI_X)
	ANGLEV		= GRID(3,ITIK)*SIGDIZ*SIN(PHI_Z)
	DIREC(1)	= SIN(ANGLEX)
	DIREC(3)	= SIN(ANGLEV)
	DIREC(2)	= SQRT(1.0D0 - DIREC(1)**2 - DIREC(3)**2)
	GO TO 1111

1111 	CONTINUE
C
C  ---------------------------------------------------------------------
C                 POLARIZATION
C
C   Generates the polarization of the ray. This is defined on the
C   source plane, so that A_VEC is along the X-axis and AP_VEC is along Z-axis.
C   Then care must be taken so that A will be perpendicular to the ray 
C   direction.
C
C   In the case of SR, the value of POL_DEG is set by the call to
C   the module ALADDIN, so that it is possible to take into account the
C   angular dependence of the source polarization.
C
     	 A_VEC(1)		=   1.0D0
     	 A_VEC(2)		=   0.0D0
     	 A_VEC(3)		=   0.0D0
C
C   Rotate A_VEC so that it will be perpendicular to DIREC and with the
C   right components on the plane.
C 
    	CALL	CROSS	(A_VEC,DIREC,A_TEMP)
     	CALL	CROSS	(DIREC,A_TEMP,A_VEC)
     	CALL	NORM	(A_VEC,A_VEC)
	CALL	CROSS	(A_VEC,DIREC,AP_VEC)
	CALL	NORM	(AP_VEC,AP_VEC)

	IF (F_POLAR.EQ.1) THEN
C
C   WaNT A**2 = AX**2 + AZ**2 = 1 , instead of A_VEC**2 = 1 .
C
	 DENOM	= SQRT(1.0D0 - 2.0D0*POL_DEG + 2.0D0*POL_DEG**2)
	 AX	= POL_DEG/DENOM
	 CALL	SCALAR	(A_VEC,AX,A_VEC)
C
C   Same procedure for AP_VEC
C
	 AZ	= (1-POL_DEG)/DENOM
	 CALL	SCALAR 	(AP_VEC,AZ,AP_VEC)
	ELSE
C
C If don't want the full polarization, then POL_DEG is only defined in the 
C case of synchrotron radiation.
C
	 IF (FDISTR.EQ.4.OR.FDISTR.EQ.6.OR.F_WIGGLER.NE.0) THEN
	   IF (WRAN(ISTAR1).GT.POL_DEG) THEN
C
C A_VEC is along x or z -axis according to POL_DEG.
C
	     A_VEC(1)	= AP_VEC(1)
	     A_VEC(2)	= AP_VEC(2)
	     A_VEC(3)	= AP_VEC(3)
	   END IF
	 END IF
	END IF
C
C Now the phases of A_VEC and AP_VEC.
C
	 IF (F_COHER.EQ.1) THEN
	   PHASEX	= 0.0D0
	 ELSE
	   PHASEX	= WRAN(ISTAR1) * TWOPI
	 END IF
	 PHASEZ		= PHASEX + POL_ANGLE*I_CHANGE
C
C---------------------------------------------------------------------
C            PHOTON   ENERGY
C
C Generates the wavevector of the ray. Depending on the choice, a
C single or a set of Q is created.NOTE: units are cm -1
C
C
C
C In the case of SR, Q_WAVE is already known
C
	IF (FDISTR.EQ.4.OR.FDISTR.EQ.6.OR.F_WIGGLER.NE.0) GO TO 2050
     	GO TO (2020,2030,2040)	F_COLOR

2010	CONTINUE
C
C Not interested in the photon energy. Set at 0.0
C
     	GO TO 2050

2020	CONTINUE
C
CSingle line. 
C
     	Q_WAVE	=   TWOPI*PHOTON(1)/TOCM
     	GO TO 2050

2030	CONTINUE
C
C Several photon energies (up to 10) with same relative intensities.
C
     	N_TEST	=   WRAN (ISTAR1)*N_COLOR + 1
     	Q_WAVE	=   TWOPI*PHOTON(N_TEST)/TOCM
     	GO TO 2050

2040	CONTINUE
C
C Box photon distribution
C
     	PHOT_CH	=   PHOTON(1) + 
     $				(PHOTON(2) - PHOTON(1))*WRAN(ISTAR1)
     	Q_WAVE	=   TWOPI*PHOT_CH/TOCM
     	GO TO 2050
C
C Create the final array 
C
2050	BEGIN (1,ITIK) 	=   XXX
	BEGIN (2,ITIK) 	=   YYY
	BEGIN (3,ITIK) 	=   ZZZ
	BEGIN (4,ITIK) 	=    DIREC(1)
	BEGIN (5,ITIK) 	=    DIREC(2)
	BEGIN (6,ITIK) 	=    DIREC(3)
     	BEGIN (7,ITIK)	=   A_VEC(1)
     	BEGIN (8,ITIK)	=   A_VEC(2)
     	BEGIN (9,ITIK)	=   A_VEC(3)
     	BEGIN (10,ITIK)	=   1.0D0
     	BEGIN (11,ITIK)	=   Q_WAVE
     	BEGIN (12,ITIK)	=   FLOAT (ITIK)
	IF (F_POLAR.EQ.1) THEN
 	  PHASE (1,ITIK)	=   0.0D0
	  PHASE (2,ITIK)  	=   PHASEX
	  PHASE (3,ITIK)  	=   PHASEZ
	  AP    (1,ITIK)	=   AP_VEC(1)
	  AP    (2,ITIK)	=   AP_VEC(2)
	  AP    (3,ITIK)	=   AP_VEC(3)
	END IF
C
C All rays are generated. Test for acceptance if optimized source is
C specified.
C
     	IF (F_BOUND_SOUR.EQ.1 .AND. FGRID.EQ.0 ) THEN
     	  SB_POS(1) = XXX
     	  SB_POS(2) = YYY 
     	  SB_POS(3) = ZZZ
     	  ITEST = 1
     	  CALL SOURCE_BOUND (SB_POS, DIREC, ITEST)
     	 IF (ITEST.LT.0) THEN
     	   K_REJ = K_REJ + 1
     	   N_REJ = N_REJ + 1
C     	   WRITE(6,*) 'itest ===',ITEST
     	  IF (K_REJ.EQ.500) THEN
     	    WRITE(6,*)N_REJ,'   rays have been rejected so far.'
     	    WRITE(6,*)ITIK, '                  accepted.'
     	    K_REJ = 0
     	  END IF 
	  DO 301 J=1,6
     	    GRID(J,ITIK) = WRAN(ISTAR1)
301    	  CONTINUE
     	  GOTO 10001
     	 END IF
     	END IF
10000	CONTINUE

	IFLAG	= 0
      	CALL WRITE_OFF(FNAME,BEGIN,PHASE,AP,NCOL,NTOTAL,
     $      IFLAG,IOFORM,IERR)
     	IF (IERR.NE.0) THEN
	    ERRMSG = 'Error Writing File '// FNAME
	    CALL LEAVE ('SOURCE', ERRMSG, IERR)
	ENDIF
     	NPOINT = NTOTAL
	IF (FSOUR.EQ.3) THEN
C
C Reset EPSI_X and EPSI_Z to the values input by the user.
C
	   EPSI_X = EPSI_XOLD
	   EPSI_Z = EPSI_ZOLD
	ENDIF
     	WRITE(6,*)'Exit from SOURCE'
     	RETURN
     	END
