C +++
C
C Source: src/source/input_source.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: input_source.F
C Revision 1.14  1992/01/21  13:53:36  cwelnak
C more 6000 changes ...
C
C Revision 1.13  92/01/21  13:21:35  cwelnak
C 6000 changes
C 
C Revision 1.12  91/12/06  20:36:21  cwelnak
C added ifndef ELLWIGG around elliptical wiggler prompt
C 
C Revision 1.11  1991/07/06  19:59:53  khan
C Elliptical Undulator by Sylvia Difonzo
C
C Revision 1.10  91/04/05  14:03:29  cwelnak
C changed quotes on #include
C 
C Revision 1.9  91/03/20  16:45:53  cwelnak
C SUN version -- changes INCLUDE to #include
C 
C Revision 1.8  91/02/21  14:40:15  khan
C Replaced RAN with MYRAN (wrapper for RAN that checks for 0.0D0 return)
C 
C Revision 1.7  90/11/09  14:13:24  khan
C Added SAVE statements...
C 
C Revision 1.6  90/07/23  21:15:26  khan
C Added pre-processor directives.
C 
C Revision 1.5  90/07/19  20:53:03  khan
C Put Preprocessor/conditionals to make it work on both VMS and Ultrix.
C 
C Revision 1.4  90/07/17  00:24:07  khan
C Got rid of the "SYS$START" prefix to START file name in rwname call.
C 
C Revision 1.3  90/07/15  16:34:16  khan
C SHADOW Version file is moved to ./../include/ dir.
C 
C Revision 1.2  90/07/14  22:39:15  khan
C All global include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.1  90/07/10  14:56:17  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	INPUT_SOURCE
C
C	PURPOSE		Reads in the parameters of the optical system
C
C---
	SUBROUTINE INPUT_SOURCE

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
C	INCLUDE		'SHADOW$INC:DATA.BLK/LIST'
#endif
C
     	CHARACTER*80	MSSG,MSSG2,RSTRING
	CHARACTER*132 	VERSION
C     	DATA	IDO_X_S,IDO_Y_S,IDO_Z_S,IDO_VX,IDO_VZ	/1,1,1,1,1/
C     	DATA	ISTAR1		/ 12345701 /
C
C
     	WRITE(6,*)'Call to INPUT'
C
C#if unix
C   	CALL	SYSTEM ('clear')
C#elif vms
C     	CALL	LIB$ERASE_PAGE(1,1)
C     	CALL	LIB$SET_SCROLL (5,24)
C#endif
	CALL CLSCREEN
C		       123456789 123456789 123456789 123456789 1
     	MSSG (1:40) = '---------------------------------- S H A '
        MSSG (41:80)= ' D O W  -------------------------------'
     	WRITE (6,'(1X,A)')  MSSG
C
C Get the data file path using either SHADOW$DATA or Unix SHADOW_DATA_DIR
C environment variable. Also, check for existence in the routine itself.
C
	IFLAG = 1
	CALL DATAPATH ('VERSION', VERSION, IFLAG)
	IF (IFLAG .NE. 0) THEN
	    CALL LEAVE ('INPUT_SOURCE', 'VERSION file not found', 1)
	ENDIF
#if defined(vms)
     	OPEN (11, FILE=VERSION, STATUS='OLD',READONLY)
#else
     	OPEN (11, FILE=VERSION, STATUS='OLD')
#endif 
     	READ (11,*) I1,I1,I1
     	READ (11,'(1X,A)') MSSG2
     	CLOSE(11)
     	WRITE (6,'(1X,A)') MSSG2
     	WRITE (6,2222) 
2222	FORMAT (1X,/,1X,'Defining source : ')
     	WRITE(6,*)'When prompted for a yes/no answer, you may enter:'
     	WRITE(6,*)'for   YES  answer      Y, 1'
     	WRITE(6,*)'for   NO   answer      anything else'
     	WRITE (6,'(1X,///)')
     	IVERB = 
     $IYES ('Do you want a verbose [ 1 ] or terse [ 0 ] output ?')
**---------------------------------------------------------------------
C#if unix
C	CALL SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1) ! Analysis type.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)

**---------------------------------------------------------------------
     	WRITE(6,*)'------------- SOURCE SPECS ------------------'
       	IF (IVERB.EQ.1) THEN
     	WRITE(6,*)'Options available:'
     	WRITE(6,*)'Random in  BOTH REAL and MOMENTUM space	      0'
     	WRITE(6,*)'Grid       BOTH				      1'
     	WRITE(6,*)'Grid       REAL, random  MOMENTUM	              2'
     	WRITE(6,*)'Random     REAL,  grid   MOMENTUM		      3'
	WRITE(6,*)'Ellipses in PHASE space, random around each ellipse 4'
	WRITE(6,*)'Ellipses in PHASE space,   grid around each ellipse 5'
     	END IF
	FGRID = IRINT ('Source modelling type [ 0-5 ] ? ')
		IF (FGRID.EQ.0) THEN		!3
     	NPOINT= IRINT ('How many rays [ 1 - 5 000 ] ? ')
     	ISTAR1= IRINT ('Seed [ odd, 1000 - 1 000 000 ] ? ')
     		ELSE IF (FGRID.EQ.2.OR.FGRID.EQ.3.OR.FGRID.EQ.4) THEN
     	NPOINT= IRINT ('How many rays for RANDOM part ? ')
     	ISTAR1= IRINT ('Seed [ odd, 1000 - 1 000 000 ] ? ')
		END IF				!3
* Go now on to define the source.
     	F_BOUND_SOUR 	=  IYES('Do you want to optimize the source ? ')
     	IF ( F_BOUND_SOUR.EQ.1 ) FILE_BOUND = 
     $	RSTRING ('Please input name of file with acceptance: ')
     	  
**---------------------------------------------------------------------
C#if unix
C	CALL SYSTEM ('clear')
C#elif vms
C     	CALL LIB$ERASE_PAGE (5,1)
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
**---------------------------------------------------------------------
	WRITE(6,*)'Source type : [ 0 ] regular source'
	WRITE(6,*)'              [ 1 ] normal wiggler'
	WRITE(6,*)'              [ 2 ] undulator'
	WRITE(6,*)'              [ 3 ] elliptical wiggler'
	F_WIGGLER	= IRINT ('Then ? ')
	IF (F_WIGGLER.NE.0) THEN
	  IF ((F_WIGGLER.EQ.1) .OR. (F_WIGGLER.EQ.3)) THEN
	    FILE_TRAJ	= RSTRING 
     $		('File containing the electron trajectory ? ')
	    CONV_FACT	= RNUMBER 
     $		('Conversion factor from meters to user units ? ')
     	    HDIV1 = RNUMBER 
     $		('Horizontal half-divergence [ (+)x, rads ] ? ')
     	    HDIV2 = RNUMBER 
     $		('                           [ (-)x, rads ] ? ')
     	    VDIV1 = RNUMBER 
     $		('Vertical                   [ (+)z, rads ] ? ')
     	    VDIV2 = RNUMBER 
     $		('                           [ (-)z, rads ] ? ')
	  ELSE IF (F_WIGGLER.EQ.2) THEN
	    FILE_TRAJ	= RSTRING
     $		('File containing the CDF''s ? ')	
	  END IF
	  IF (FGRID.NE.0) THEN
     	    NPOINT= IRINT ('How many rays [ 1 - 5 000 ] ? ')
     	    ISTAR1= IRINT ('Seed [ odd, 1000 - 1 000 000 ] ? ')
	  END IF
     	  SIGMAX	= RNUMBER ('Sigma along X ? ')
     	  SIGMAZ	= RNUMBER ('            Z ? ')
C23456789112345678921234567893123456789412345678951234567896123456789712
	  WRITE(6,*)'Electron beam emittance.  Units are: rads*[ units', 
     $'of length used so far ]'
     	  EPSI_X = rnumber ('Beam emittances in X [ at waist ] ? ')
     	  EPSI_DX= rnumber ('Distance of insertion device''s center' //
     $' from X waist [ signed ] ? ')
     	  EPSI_Z = rnumber ('Beam emittances in Z [ at waist ] ? ')
     	  EPSI_DZ= rnumber ('Distance of insertion device''s center' //
     $' from Z waist [ signed ] ? ')
     	  IF (iverb.eq.1) then
     			WRITE (6,540)
540	FORMAT (/,1X,'Polarization component of interest. Enter ',/,
     $1x,'parallel polarization    1',/,
     $1x,'perpendicular            2',/,
     $1x,'total                    3',/,
     $1x,'                   then ? ',$)
     	end if
     	  F_POL = irint ('Polarization Selected [ 1-3 ] ? ')
	  GO TO 10100
	END IF
**---------------------------------------------------------------------
C#if unix
C	CALL SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1) ! Source geometry.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
**---------------------------------------------------------------------
	IF (FGRID.EQ.4.OR.FGRID.EQ.5) THEN
	  IF (IVERB.EQ.1) THEN
	    WRITE(6,*)
     $	    'Ellipses in PHASE space are accomplished by assumming '
	    WRITE(6,*)
     $	    'a double Gaussian distribution in phase space and then'
	    WRITE(6,*)
     $	    'generating data points at various concentric sigma '
	    WRITE(6,*)'levels (1-sigma, 3-sigma etc.)'
	  END IF
	  SIGMAX = RNUMBER ('Sigma for X ? ')
	  SIGDIX = RNUMBER 
     $		('Sigma for X'' (hori. divergence) [ rads ] ? ')
	  IDO_XL = IRINT ('How many sigma levels ? ')
	  DO 11 I = 1, IDO_XL
	    WRITE(6,*)'Sigma level of ellipse ',I
	    IF (I.EQ.1) SIGXL1 = RNUMBER (' ? ')
	    IF (I.EQ.2) SIGXL2 = RNUMBER (' ? ')
	    IF (I.EQ.3) SIGXL3 = RNUMBER (' ? ')
	    IF (I.EQ.4) SIGXL4 = RNUMBER (' ? ')
	    IF (I.EQ.5) SIGXL5 = RNUMBER (' ? ')
	    IF (I.EQ.6) SIGXL6 = RNUMBER (' ? ')
	    IF (I.EQ.7) SIGXL7 = RNUMBER (' ? ')
	    IF (I.EQ.8) SIGXL8 = RNUMBER (' ? ')
	    IF (I.EQ.9) SIGXL9 = RNUMBER (' ? ')
	    IF (I.EQ.10) SIGXL10 = RNUMBER (' ? ')
11	  CONTINUE
	  IF (FGRID.EQ.5) IDO_XN = IRINT 
     $			  ('No. of rays within each level ?')
	  SIGMAZ = RNUMBER ('Sigma for Z ? ')
     	  SIGDIZ = RNUMBER 
     $		('Sigma for Z'' (vert. divergence) [ rads ] ? ')
	  IDO_ZL = IRINT ('How many sigma levels ? ')
	  DO 21 I = 1, IDO_ZL
	    WRITE(6,*)'Sigma level of ellipse ',I
	    IF (I.EQ.1) SIGZL1 = RNUMBER (' ? ')
	    IF (I.EQ.2) SIGZL2 = RNUMBER (' ? ')
	    IF (I.EQ.3) SIGZL3 = RNUMBER (' ? ')
	    IF (I.EQ.4) SIGZL4 = RNUMBER (' ? ')
	    IF (I.EQ.5) SIGZL5 = RNUMBER (' ? ')
	    IF (I.EQ.6) SIGZL6 = RNUMBER (' ? ')
	    IF (I.EQ.7) SIGZL7 = RNUMBER (' ? ')
	    IF (I.EQ.8) SIGZL8 = RNUMBER (' ? ')
	    IF (I.EQ.9) SIGZL9 = RNUMBER (' ? ')
	    IF (I.EQ.10) SIGZL10 = RNUMBER (' ? ')
21	  CONTINUE
	  IF (FGRID.EQ.5) IDO_ZN = IRINT  
     $	  ('No. of rays within each level ?')
	  GO TO 470
	END IF
     	IF (IVERB.EQ.1) THEN
	WRITE (6,440)
C23456789112345678921234567893123456789412345678951234567896123456789712
440	FORMAT (1X,' The source is specified in the laboratory ',/,1X,
     $'reference frame. The program will then rotate the set of ',/,1X,
     $  'rays in the mirror frame.',//,1X,
     $	'Type of source,now.',//,10X,
     $  'use  ( 0 ) for point source  ',/,10X,
     $  '     ( 1 ) for rectangular  s.',/,10X,
     $  '     ( 2 ) for elliptical   s.',/,10X,
     $  '     ( 3 ) for gaussian     s.',/,10X,
     $  '     ( 6 ) for dense plasma s. (EXPERIMENTAL)',/,10X)
     	END IF
	FSOUR = IRINT ('X-Z plane source type [ 0-3, 6 ] ? ')
	IF (FSOUR.EQ.1) THEN 
     	WXSOU	= RNUMBER ('Source Width  [ x ] ? ' )
     	WZSOU	= RNUMBER ('       Height [ z ] ? ')
     		IF (FGRID.EQ.1.OR.FGRID.EQ.2) THEN
     	IDO_X_S = IRINT ('How many points along the source X ? ')
     	IDO_Z_S = IRINT ('                                 Z ? ')
     		END IF
	ELSE IF (FSOUR.EQ.2) THEN          
     	WXSOU	= RNUMBER ('Source Width  [ x ] ? ' )
     	WZSOU	= RNUMBER ('       Height [ z ] ? ')
     		IF (FGRID.EQ.1.OR.FGRID.EQ.2) THEN
     	IDO_X_S = IRINT 
     $		('How many concentric ellipses within the source ? ')
     	IDO_Z_S = IRINT ('How many points on each ellipse ? ')
     		END IF

	ELSE IF (FSOUR.EQ.3) THEN          
     	SIGMAX	= RNUMBER ('Sigma along X ? ')
     	SIGMAZ	= RNUMBER ('            Z ? ')
     		IF (FGRID.EQ.1.OR.FGRID.EQ.2) THEN
     	IDO_X_S = IRINT ('How many points along the source X ? ')
     	IDO_Z_S = IRINT ('                                 Z ? ')
     		END IF

	ELSE IF (FSOUR.EQ.6) THEN
	PLASMA_ANGLE = RNUMBER ('Source cone full opening (radians)')
     		IF (FGRID.EQ.1.OR.FGRID.EQ.2) THEN
     	IDO_X_S = IRINT ('How many points along the source X ? ')
     	IDO_Z_S = IRINT ('                                 Z ? ')
     		END IF
	END IF				   
470	CONTINUE
* Inquires now about the source depth.
**---------------------------------------------------------------------
C#if unix
C	CALL SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1) ! Source depth, if any.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
C23456789112345678921234567893123456789412345678951234567896123456789712
**---------------------------------------------------------------------
c
c       dense plasma assumes flat depth distrib here for now. See later.
c
	IF (FSOUR.EQ.6) THEN
	  FSOURCE_DEPTH = 2
	ELSE
     	  IF (IVERB.EQ.1) THEN
	    WRITE (6,490)
490 	    FORMAT (1X,
     $  'Source depth. The actual source will be centered on',
     $  'the no-depth position. Use ',/,10x,
     $  '	(1) for no depth,',/,10x,
     $  '	(2) for flat depth distribution,',/,10x,
     $  '	(3) for gaussian depth distribution,',/,10x,
     $  '       (4) for a synchrotron source depth distr.',//,20x,
     $  '	Then ? ',$)
     	  END IF
	  FSOURCE_DEPTH = IRINT ('Source Depth [ 1-4 ] ? ')
	END IF
* The S.R. case will be dealt with aftewards, when asking the details of
* the source.
     	IF (FSOURCE_DEPTH.EQ.2) THEN
	 WYSOU = RNUMBER ('Source Depth ? ')
     	ELSE IF (FSOURCE_DEPTH.EQ.3) THEN
	 SIGMAY	=  RNUMBER ('Sigma along depth ? ')
	ELSE IF (FSOURCE_DEPTH.EQ.4.AND.(FGRID.EQ.4.OR.FGRID.EQ.5)) THEN
     	  WRITE(6,*)
     $'Notice: the ORBIT radius MUST be in the same units as the rest',
     $' of the optical system.'
     	  WRITE(6,*)
     $'Use negative ORBIT radius argument for CCW storage ring.'
	  R_ALADDIN = rnumber ('Orbit Radius [ same as other units ] ?')
     	  HDIV1 = RNUMBER('Horizontal half-divergence [ (+)x, rads ] ? ')
     	  HDIV2 = RNUMBER('                           [ (-)x, rads ] ? ')
     	END IF
1111	CONTINUE
     	IF ((FGRID.EQ.1.OR.FGRID.EQ.2).AND.FSOURCE_DEPTH.NE.1) THEN  !6
     	  IDO_Y_S = IRINT ('How many points along the depth ? ')
     	END IF					!6
	IF (FGRID.EQ.4.OR.FGRID.EQ.5) GO TO 770

**---------------------------------------------------------------------
C#if unix
C	CALL SYSTEM ('clear')
C#elif vms
C	CALL LIB$ERASE_PAGE (5,1) ! Source emission parameters.
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
**---------------------------------------------------------------------
c
c       dense plasma assumes conical source distribution for now.
c
	IF (FSOUR.EQ.6) THEN
     	  FDISTR = 5
	ELSE
     	  IF (IVERB.EQ.1) THEN
	    WRITE (6,530)	
530 	    FORMAT (/,1X,'O.K., got it so far.',/,10X,
     $  'Source distribution now. We may use ',/,10X,
     $  '    ( 1 ) for a flat source',/,10X,
     $  '    ( 2 )       uniform   s.',/,10X,
     $  '    ( 3 )       gaussian  s.',/,10X,
     $  '    ( 4 )       synchrotron ',/,10X,
     $	'    ( 5 )       conical ',/,10X,
     $	'    ( 6 )       exact synchrotron ',/)
	  END IF
     	  FDISTR = IRINT ('Source Angle Distribution [ 1-6 ] ? ')
	ENDIF
     	IF ((FGRID.EQ.1.OR.FGRID.EQ.3).AND.FDISTR.NE.5) THEN
     	  IDO_VZ = IRINT ('How many points in the vertical ? ')
     	  IDO_VX = IRINT ('          and in the horizontal ? ')
     	ELSE IF ((FGRID.EQ.1.OR.FGRID.EQ.3).AND.FDISTR.EQ.5) THEN
     	  N_CONE = irint ('How many points along cone radius ? ')
     	  N_CIRCLE = irint ('                and along circles ? ')
     	END IF
		IF (FDISTR.NE.5) THEN      	!1
     	HDIV1 = RNUMBER ('Horizontal half-divergence [ (+)x, rads ] ? ')
     	HDIV2 = RNUMBER ('                           [ (-)x, rads ] ? ')
     	VDIV1 = RNUMBER ('Vertical                   [ (+)z, rads ] ? ')
     	VDIV2 = RNUMBER ('                           [ (-)z, rads ] ? ')
		ELSE            		!1
     	cone_max = rnumber ('Max half-divergence ? ')
     	cone_min = rnumber ('Min half-divergence ? ')
		END IF				!1
		IF (FDISTR.EQ.3) THEN		!2
     	sigdiz = rnumber ('Vertical sigma [ rads ] ? ')
     	sigdix = rnumber ('Horizontal              ? ')
		ELSE IF (FDISTR.EQ.4.OR.FDISTR.EQ.6) THEN	!2.1
     	r_magnet  = rnumber ('Magnetic Radius [ m ] ? ')
     	WRITE(6,*)
     $'Notice: the ORBIT radius MUST be in the same units as the rest',
     $' of the optical system.'
     	WRITE(6,*)
     $'Use negative ORBIT radius argument for CCW storage ring.'
	r_aladdin = rnumber ('Orbit Radius [ same as other units ] ?')
     			IF (FSOUR.EQ.3) THEN
     	iansw = iyes 
     $('Do you want to include electron beam emittances [ Y/N ] ? ')
     				IF (IANSW.EQ.1) THEN
     	  WRITE(6,*)
     $'Units are : rads*[ units of length used so far ]'
     	EPSI_X = rnumber ('Beam emittances in X [ at waist ] ? ')
     	EPSI_DX= rnumber ('Distance from waist [ signed ] ? ')
     	EPSI_Z = rnumber ('Beam emittances in Z [ at waist ] ? ')
     	EPSI_DZ= rnumber ('Distance from waist [ signed ] ? ')
     			     	END IF
     		     	END IF
     	BENER = RNUMBER ('Electron Beam Energy [ GeV ] ? ')
     	if (iverb.eq.1) then
     			WRITE (6,640)
640	FORMAT (/,1X,'Polarization component of interest. Enter ',/,
     $1x,'parallel polarization    1',/,
     $1x,'perpendicular            2',/,
     $1x,'total                    3',/,
     $1x,'                   then ? ',$)
     	end if
     	f_pol = irint ('Polarization Selected [ 1-3 ] ? ')
	  IF (FDISTR.EQ.4) THEN
	    IF (IVERB.EQ.1) THEN
		WRITE (6,*) 'The source can be generated according to',
     $' either [0] photons or [1] power distribution.'
	    END IF
	    F_SR_TYPE	= IRINT ('Distribution type [0,1] ? ')
	  END IF
		END IF				!2
C
770	CONTINUE
     	IF (FDISTR.NE.4.AND.FDISTR.NE.6) THEN
     	  I_ANSW = IYES ('Do you want a Photon energy [ Y/N ] ? ')
     	ELSE
     	  I_ANSW = 1
     	END IF
     	IF (I_ANSW.NE.1) GO TO 10100
     	IF (FDISTR.NE.6) THEN
     	 IF (IVERB.EQ.1) THEN
     	   WRITE(6,*)'We have these choices :'
     	   WRITE(6,*)'Single line ......................... 1'
     	   WRITE(6,*)'Several lines ....................... 2'
     	   WRITE(6,*)'Uniform source....................... 3'
     	 END IF
     	  F_COLOR = IRINT ('Energy distribution [ 1-3 ] ? ')
     	ELSE IF (FDISTR.EQ.6) THEN
     	  F_COLOR = 1
     	END IF
     	F_PHOT = IRINT ('Photon Energy [ 0 ] or Angstroms [ 1 ] ? ' )
     	IF (F_COLOR.EQ.1) THEN
     	 IF (F_PHOT.EQ.0) PH1 = RNUMBER ('Energy [ eV ] ? ')
     	 IF (F_PHOT.EQ.1) PH1 = RNUMBER ('Wavelength [ A ] ? ')
     	ELSE IF (F_COLOR.EQ.2) THEN
     	 n_color = irint('How many lines ? ')
     		  DO 31 I_COL=1,N_COLOR
        WRITE(6,*)'Photon energy or wavelength for line ',I_COL
     		IF (I_COL.EQ.1)  PH1 = RNUMBER (' ? ')
     		IF (I_COL.EQ.2)  PH2 = RNUMBER (' ? ')
     		IF (I_COL.EQ.3)  PH3 = RNUMBER (' ? ')
     		IF (I_COL.EQ.4)  PH4 = RNUMBER (' ? ')
     		IF (I_COL.EQ.5)  PH5 = RNUMBER (' ? ')
     		IF (I_COL.EQ.6)  PH6 = RNUMBER (' ? ')
     		IF (I_COL.EQ.7)  PH7 = RNUMBER (' ? ')
     		IF (I_COL.EQ.8)  PH8 = RNUMBER (' ? ')
     		IF (I_COL.EQ.9)  PH9 = RNUMBER (' ? ')
     		IF (I_COL.EQ.10)  PH10 = RNUMBER (' ? ')
31     		  CONTINUE
     	ELSE IF (F_COLOR.EQ.3) THEN
     	 WRITE(6,*)'From photon energy or wavelength ... '
     	 PH1 = rnumber (' ? ')
     	 WRITE(6,*)'... to photon energy or wavelength :'
     	 PH2 = rnumber (' ? ')
     	END IF
10100	CONTINUE
**---------------------------------------------------------------------
C#if unix
C	CALL SYSTEM ('clear')
C#elif vms
C     	CALL	LIB$ERASE_PAGE(5,1)	! Polarization
C#endif
	CALL CLSCREEN
	WRITE(6,'(1X,A)') MSSG
	WRITE(6,'(1X,A)') MSSG2
	WRITE(6,*)
**---------------------------------------------------------------------
	  F_OPD		= IYES 
     $	('Do you want to store the optical paths (OPD) [Y/N] ? ')
** Inquire about the source polarization.
	  F_POLAR	= IYES
     $  ('Do you want to generate the A vectors (electric field) ' //
     $  '[Y/N] ?')
	IF (F_POLAR.EQ.0)	GO TO 10101
C
C For SR, all the polarization varibles will be defined by SOURCE internally.
C
	IF (FDISTR.EQ.4.OR.FDISTR.EQ.6.OR.F_WIGGLER.NE.0) GO TO 10101
  	IF (IVERB.EQ.1) THEN
     	  WRITE(6,*)'Source polarization is specified by degree of ',
     $'polarization (= AX/(AX+AZ)) and phase angle of AZ from ',
     $'AX, for instance ,'
     	  WRITE(6,*)'Circular polarized :'
     	  WRITE(6,*)'    phase diff.    = +90 (CW) or -90 (CCW) degree'
     	  WRITE(6,*)'    deg. of polar. = 0.5'
     	  WRITE(6,*)'Linear polarized   :'
	  WRITE(6,*)'    phase diff.    = 0'
	  WRITE(6,*)'    deg. of polar. = cos(phi)/(cos(phi)+sin(phi))'
	  WRITE(6,*)'    where      phi = angle of polarization plane ',
     $'from X-axis.'
     	END IF
	POL_ANGLE	= RNUMBER ('Phase difference ?')
	POL_DEG		= RNUMBER ('Degree of polarization ?')
	IF (IVERB.EQ.1) THEN
	  WRITE(6,*)
     $	  'If the absolute phase of AX does not change from one ray', 
     $' to another, the source is coherent.  If it is randomly ',
     $'distributed, the source is incoherent.'
	END IF
	F_COHER		= IRINT ('Incoherent [0] or coherent [1] ?')
**---------------------------------------------------------------------
*				Store the input data
**---------------------------------------------------------------------
** The format is the same as that used by SILENT.	
10101	CONTINUE
#ifdef vms
    	CALL	FNAME	(FFILE, 'SYS$START:START', 0, 2)
#else
    	CALL	FNAME	(FFILE, 'start', 0, 2)
#endif
     	IDUMM = 0
     	CALL	RWNAME	(FFILE, 'W_SOUR', IDUMM)
     	IF (IDUMM.NE.0) CALL LEAVE 
     $		('INPUT_SOURCE','Error writing NAMELIST',IDUMM)
111	FORMAT (A)
     	WRITE(6,*)'Exit from INPUT_SOURCE'
	END

