C +++
C
C Source: src/source/id/uphoton.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: uphoton.F
C Revision 1.6  1992/01/22  22:04:01  cwelnak
C 6000 changes
C
C Revision 1.5  1991/12/19  19:45:54  cwelnak
C Barry's 1990 undulator changes.
C
C Revision 1.4  1991/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C
C Revision 1.3  90/10/30  00:01:50  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:04:57  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C Substitue pre_rad.blk for PRE_RAD.BLK
C 
C Revision 1.1  90/07/17  15:36:40  khan
C Initial revision
C 
C 
C ---

C+++
C
C	SUBROUTINE		UPHOTON
C
C	PURPOSE:		To compute the photon distribution of an 
C				undulator for a certain (ener,theta,phi).
C
C	INPUT:			ENER, photon energy (eV)
C				THETA, angle (rad)
C				PHI, angle (rad)
C				The calling program should define the common 
C				block PARA2
C
C	OUTPUT:			PHOT, # of photons
C				POL_DEG, degree of polarization
C---
	SUBROUTINE		UPHOTON	(ENER,THETA,PHI,PHOT,POL_DEG)
	
	IMPLICIT		REAL*8	(A-H,O-Z)

#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif
C
	DIMENSION		AXR(1001),AXI(1001)
	DIMENSION		AYR(1001),AYI(1001)
	DIMENSION		AZR(1001),AZI(1001)
	DIMENSION		N(3),P_PI(3),EP(3)

	DATA	PI	/  3.1415 92653 58979 32384 62643 D0 /
	DATA	PIHALF	/  1.5707 96326 79489 66192 31322 D0 /
	DATA	TWOPI	/  6.2831 85307 17958 64769 25287 D0 /
	DATA	TODEG	/ 57.2957 79513 08232 08767 98155 D0 /
	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852    D-4		     /
	DATA	TOANGS	/  1.239 852    D+4		     /
C
	c     = 2.998D8		!M/SEC
	e     = 1.602D-19	!COULOMB
	h     = 6.626D-34	!PLANCK'S CONSTANT  JOULE*SEC
	hh    = H/E		!  "         "	    eV*sec
	hbar  = H/TWOPI		!  "         "      joule*sec
	hhbar = HH/TWOPI	!  "	     "	    eV*sec
     	epsi    = 8.854D-12	!FARAD/METER
     	epsi_fac = 16.0D0*PI**3*EPSI*C
     	epsi_fac = 1/EPSI_FAC	! {4 pi epsi_0 * 4 pi^2}
C
C  observation vector		n = ( rnx, rny, rnz )
C  electron trajectory 		rr = ( xofz, yofz, z )
C
	  IF (IANGLE.EQ.2) THEN
	      RNX = COS(THETA)*SIN(PHI)			!cartesian
	      RNY = SIN(THETA)
	      RNZ = COS(THETA)*COS(PHI)
	  ELSE IF (IANGLE.EQ.1) THEN
	      RNX = SIN(THETA)*COS(PHI)			!polar
	      RNY = SIN(THETA)*SIN(PHI)
	      RNZ = COS(THETA)
	  END IF
C
C Begin Integration loop.
C First integrate over the (N-1) periods of ideal sinusodal trajectory.
C
C  omega is frequency of radiation, unit:  (SEC-1)
C
	OMEGA  = ENER/HHBAR
	COMEGA = OMEGA/C	!CONSTANT FOR EXTERNAL
C
C  compute integral: A = beta exp(ipsi) 1/(c*betaz) dz
C
C Begins integration loop.
C
     		  DO 19 L=1,NPoint			!Begin loop 4
C
		   PSI   = - COMEGA*( TOFZ(L)*C
     $			   - RNX*XOFZ(L) 
     $			   - 0.0d0	!	RNY*YOFZ(L)
     $			   - RNZ*Z(L) )
C
     		   CPSI= COS(PSI)
     		   SPSI= SIN(PSI)
C
C The following elements should be divided by "C", but due to overflow
C errors we do this later.
C X component
C
		   AXR(L) = CPSI*BETAX(L)/BETAZ(L)
		   AXI(L) = SPSI*BETAX(L)/BETAZ(L)
C
C Y component
C
C		   AYR(L) = 0.0d0 ! 	CPSI*BETAY(L)/BETAZ(L)
C		   AYI(L) = 0.0d0 !	SPSI*BETAY(L)/BETAZ(L)
C
C Z component
C
     		   AZR(L) = CPSI
     		   AZI(L) = SPSI
19       	  CONTINUE			!End loop 4
C
C Perform integration.
C
		  CALL SIMPSON (ZSTEP,AXR,AXR_I,NPoint)
		   CALL SIMPSON (ZSTEP,AXI,AXI_I,NPoint)
     		  CALL SIMPSON (ZSTEP,AZR,AZR_I,NPoint)
     		   CALL SIMPSON (ZSTEP,AZI,AZI_I,NPoint)
C		  CALL SIMPSON (ZSTEP,AYR,AYR_I,NPoint)
C		   CALL SIMPSON (ZSTEP,AYI,AYI_I,NPoint)
		AYR_I	= 0.0D0
		AYI_I	= 0.0D0
C
C  A = N X (N X BETA) = N (N dot BETA)-BETA (N dot N)
C
     		  DOT_R   = RNX*AXR_I + RNY*AYR_I + RNZ*AZR_I
     		  DOT_I   = RNX*AXI_I + RNY*AYI_I + RNZ*AZI_I
C Divide by "C"
     		  DOT_R   = DOT_R/C
     		  DOT_I	  = DOT_I/C
		  ATXR = RNX*DOT_R - AXR_I/C
		   ATXI = RNX*DOT_I - AXI_I/C
		  ATYR = RNY*DOT_R - AYR_I/C
		   ATYI = RNY*DOT_I - AYI_I/C
		  ATZR = RNZ*DOT_R - AZR_I/C
		   ATZI = RNZ*DOT_I - AZI_I/C
C
C  Now include G(omega), grating term.
C
	GN 	= SIN((NCOMP-1)*OMEGA/2.0d0*( TAU - RLAU*RNZ/C))
	G0 	= SIN(          OMEGA/2.0d0*( TAU - RLAU*RNZ/C))
	IF (ABS(G0).GT.1.0E-15) THEN
	   GG = GN/G0
 	ELSE
     	   GG	= NCOMP - 1
     	END IF
C
C FS is the extra e^(i*(N-1)*psi/2) factor in front of the (sinNx/sinx) term.
C	
	FS	= -0.5*(NCOMP-2)*OMEGA*(TAU - RLAU*RNZ/C)
		  ATEMPXR = GG * (COS(FS)*ATXR - SIN(FS)*ATXI)
		   ATEMPXI = GG * (COS(FS)*ATXI + SIN(FS)*ATXR)
		  ATEMPYR = GG * (COS(FS)*ATYR - SIN(FS)*ATYI)
		   ATEMPYI = GG * (COS(FS)*ATYI + SIN(FS)*ATYR)
		  ATEMPZR = GG * (COS(FS)*ATZR - SIN(FS)*ATZI)
		   ATEMPZI = GG * (COS(FS)*ATZI + SIN(FS)*ATZR)
C
C Integration for the (N-1) periods is completed.
C

C
C Now the part for the two ends of the undulator :
C
C The entrance to the undulator:
C
		NC	= 0.5*(NPOINT+1)
     		  DO 29 L=1,NC				
C
		   PSI   = - COMEGA*( TOFZ1(L)*C
     $			   - RNX*XOFZ1(L) 
     $			   - 0.0d0	!	RNY*YOFZ(L)
     $			   - RNZ*Z1(L))
C
     		   CPSI= COS(PSI)
     		   SPSI= SIN(PSI)
C
C The following elements should be divided by "C", but due to overflow
C errors we do this later.
C X component
C
		   AXR(L) = CPSI*BETAX1(L)/BETAZ1(L)
		   AXI(L) = SPSI*BETAX1(L)/BETAZ1(L)
C
C Y component
C
C		   AYR(L) = 0.0d0 ! 	CPSI*BETAY(L)/BETAZ(L)
C		   AYI(L) = 0.0d0 !	SPSI*BETAY(L)/BETAZ(L)
C
C Z component
C
     		   AZR(L) = CPSI
     		   AZI(L) = SPSI
29      	 CONTINUE 				!End loop 4
C
C Perform integration.
C
		  CALL SIMPSON (EZSTEP,AXR,AXR_I1,NC)
		   CALL SIMPSON (EZSTEP,AXI,AXI_I1,NC)
     		  CALL SIMPSON (EZSTEP,AZR,AZR_I1,NC)
     		   CALL SIMPSON (EZSTEP,AZI,AZI_I1,NC)
C		  CALL SIMPSON (EZSTEP,AYR,AYR_I1,NC)
C		   CALL SIMPSON (EZSTEP,AYI,AYI_I1,NC)
		AYR_I1	= 0.0D0
		AYI_I1	= 0.0D0
C
C The exit of the undulator:
C
     		  DO 39 L=1,NC				
C
		   PSI   = - COMEGA*( TOFZ2(L)*C
     $			   - RNX*XOFZ2(L) 
     $			   - 0.0d0	!	RNY*YOFZ(L)
     $			   - RNZ*Z2(L))
C
     		   CPSI= COS(PSI)
     		   SPSI= SIN(PSI)
C
C The following elements should be divided by "C", but due to overflow
C errors we do this later.
C X component
C
		   AXR(L) = CPSI*BETAX2(L)/BETAZ2(L)
		   AXI(L) = SPSI*BETAX2(L)/BETAZ2(L)
C
C Y component
C
C		   AYR(L) = 0.0d0 ! 	CPSI*BETAY(L)/BETAZ(L)
C		   AYI(L) = 0.0d0 !	SPSI*BETAY(L)/BETAZ(L)
C
C Z component
C
     		   AZR(L) = CPSI
     		   AZI(L) = SPSI
39      	 CONTINUE 				!End loop 4
C
C Perform integration.
C
		  CALL SIMPSON (EZSTEP,AXR,AXR_I2,NC)
		   CALL SIMPSON (EZSTEP,AXI,AXI_I2,NC)
     		  CALL SIMPSON (EZSTEP,AZR,AZR_I2,NC)
     		   CALL SIMPSON (EZSTEP,AZI,AZI_I2,NC)
C		  CALL SIMPSON (EZSTEP,AYR,AYR_I2,NC)
C		   CALL SIMPSON (EZSTEP,AYI,AYI_I2,NC)
		AYR_I2	= 0.0D0
		AYI_I2	= 0.0D0
C
C Add contributions from the two ends:
C
		AXR_I	= AXR_I1 + AXR_I2
		 AYR_I	= AYR_I1 + AYR_I2
		  AZR_I	= AZR_I1 + AZR_I2
		AXI_I	= AXI_I1 + AXI_I2
		 AYI_I	= AYI_I1 + AYI_I2
		  AZI_I	= AZI_I1 + AZI_I2
C
C  A = N X (N X BETA) = N (N dot BETA)-BETA (N dot N)
C
     		  DOT_R   = RNX*AXR_I + RNY*AYR_I + RNZ*AZR_I
     		  DOT_I   = RNX*AXI_I + RNY*AYI_I + RNZ*AZI_I
C Divide by "C"
     		  DOT_R   = DOT_R/C
     		  DOT_I	  = DOT_I/C
		  EATEMPXR = RNX*DOT_R - AXR_I/C
		   EATEMPXI = RNX*DOT_I - AXI_I/C
		  EATEMPYR = RNY*DOT_R - AYR_I/C
		   EATEMPYI = RNY*DOT_I - AYI_I/C
		  EATEMPZR = RNZ*DOT_R - AZR_I/C
		   EATEMPZI = RNZ*DOT_I - AZI_I/C
C
C  Integration over the entire undulator is completed.  
C
C  Now sum up the two contributions:
C
		  ATEMPXR = ATEMPXR + EATEMPXR
		   ATEMPXI = ATEMPXI + EATEMPXI
		  ATEMPYR = ATEMPYR + EATEMPYR
		   ATEMPYI = ATEMPYI + EATEMPYI
		  ATEMPZR = ATEMPZR + EATEMPZR
		   ATEMPZI = ATEMPZI + EATEMPZI

C
C  compute modulus sqared:  A(omega)*Astar(omega)
C
		  AAX     = ATEMPXR**2 + ATEMPXI**2
		   AAY    = ATEMPYR**2 + ATEMPYI**2
		    AAZ   = ATEMPZR**2 + ATEMPZI**2
C
C  Include polarization.  The coord system is defined so that z is parallel
C  to the normal vector at the observation point.  Polarization written in 
C  terms of this coord system.  sigma:: horizontal, pi:: vertical
C
C  the polarization is defined as:   |E(parallel)|^2/|E(total)|^2
C
		 ATOT   = AAX + AAY + AAZ
		 IF (ATOT.EQ.AAX) THEN
		   POL_DEG = 1.0D0
		 ELSE
		   POL_DEG = AAX/ATOT
		 END IF
C
C  Compute energy radiated by a single electron from values of integral; 
C  This energy is in units of J/cm-1/solid angle
C
	EFAC	= (OMEGA*E)**2*EPSI_FAC
     	POWERX = AAX*EFAC
     	POWERY = AAY*EFAC
     	POWERZ = AAZ*EFAC
C
C Change to Joules/eV/solid angles (energy radiated by 1 electron along
C the trajectory)
C
	POWERX = POWERX/HHBAR
	POWERY = POWERY/HHBAR
	POWERZ = POWERZ/HHBAR
C
C Include current (N electrons/sec) and converts at the same time to 
C		/mrad**2
C Units are now Watts/eV/mrad**2
C
     	POWERX = POWERX*RCURR/e*1.0D-6
     	POWERY = POWERY*RCURR/e*1.0D-6
     	POWERZ = POWERZ*RCURR/e*1.0D-6
C
C Compute number of photons/sec/eV/mrad**2
C
     	R_NPH_X = POWERX/(ENER*E)
     	R_NPH_Y = POWERY/(ENER*E)
     	R_NPH_Z = POWERZ/(ENER*E)
C
C Compute number of photons/sec/eV/rad**2
C
	R_NPH_X = R_NPH_X*1.0D6
	R_NPH_Y = R_NPH_Y*1.0D6
	R_NPH_Z = R_NPH_Z*1.0D6
C
C Bandpass or constant dE case
C
	IF (ICOMP.EQ.0) THEN
     	   POWERX = POWERX*BPASS*ENER
     	   POWERY = POWERY*BPASS*ENER
     	   POWERZ = POWERZ*BPASS*ENER
     	   POWERT = POWERX + POWERY + POWERZ
     	   R_NPH_X = R_NPH_X*BPASS*ENER
     	   R_NPH_Y = R_NPH_Y*BPASS*ENER
     	   R_NPH_Z = R_NPH_Z*BPASS*ENER
     	   R_NPH_T = R_NPH_X + R_NPH_Y + R_NPH_Z
	ELSE
     	   POWERX = POWERX
     	   POWERY = POWERY
     	   POWERZ = POWERZ
     	   POWERT = POWERX + POWERY + POWERZ
     	   R_NPH_X = R_NPH_X
     	   R_NPH_Y = R_NPH_Y
     	   R_NPH_Z = R_NPH_Z
     	   R_NPH_T = R_NPH_X + R_NPH_Y + R_NPH_Z
     	END IF
C
C PHOT is either in photon/sec/rad^2/eV or photon/sec/rad^2/bandpass.
C
	PHOT = R_NPH_T
C	WRITE (26,*) PHOT,ENER
C
	RETURN
	END
