C +++
C
C Source: src/source/bm/srfull.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	srfull.F
C Revision 1.3  90/11/13  14:00:48  khan
C Cleanup and SAVE statements
C 
C Revision 1.2  90/07/18  19:34:48  khan
C Added SHADOW_SR_DIR environment string to find the location of the GOUNF
C data file. Also removed common routines to the BM library(libbm.a).
C 
C Revision 1.1  90/07/11  10:45:09  khan
C Initial revision
C 
C 
C ---

C+++
C	PROGRAM		SYNC_FUN
C
C	PURPOSE		Generate a table of values of functions frequently
C			used in Synchrotron Radiation calculations.
C			
C			Bessel Functions of order 1/2, 3/2, 5/2
C
C			Green's G0 function.
C
C	RANGE		from 20*lam_c to 10**-5 lam_c
C
C---
	PROGRAM		SRFULL
	IMPLICIT 	REAL*8 		(A-H,O-Z)
     			REAL*4		X_WRI,Y_WRI,Z_WRI
	DIMENSION 	ARRX(10000),ARR(10000,3),G0(10000)
     	DIMENSION	F_PAR(10000),F_TOT(10000),F_PER(10000)
C
	PI=3.141592653589793238D0
C
     	ORD23	=  2.0D0/3.0D0
     	ORD13	=  1.0D0/3.0D0
C
     	NP	=  1001
     	EX_LOW	=  -5.0D0
     	EX_UPP  =   1.30103
     	EX_STEP =  (EX_UPP - EX_LOW)*1.0D-3
     	DO 99 I=1,NP
     	  X_EX 	=  EX_UPP - EX_STEP*(I-1)
     	  X 	=  10.0D0**X_EX
     	 CALL	BSKM(X,BK,1,ORD13)
	  ARR(I,1)=BK
	 CALL	BSKM(X,BK,2,ORD23)
	  ARR(I,2)=BK
C
C Added the 5/3 case by recursion formula -- Nov 26 1983
C						F.C.
C
     	  ARR(I,3) = ARR(I,1) + ARR(I,2)*4/X/3
	  ARRX(I)=X
 99    	CONTINUE
C
#ifdef vms
	OPEN	(2, FILE='BSKM', STATUS='NEW')
#else
	OPEN	(2, FILE='BSKM', STATUS='UNKNOWN')
	REWIND	(2)
#endif
	WRITE	(2,1000)
1000	FORMAT	(1X,' MODIFIED BESSEL FUNCTION OF ORDER N ',//)
	WRITE	(2,1100)
1100 	FORMAT	(1X,' X= ',T20,' N=1/3 ',T40,' N=2/3 ',T60,' N=5/3 ',//)
	WRITE	(2,1200) (ARRX(I),(ARR(I,KL),KL=1,3),I=1,NP)
1200	FORMAT	(1X,G14.7,T20,G14.7,T40,G14.7,T60,G14.7)
	CLOSE	(2)
C
C Function G0 -- April 1984, F.C.
C Use a trapezoidal integration.
C
#ifdef vms
     	OPEN 	(22, FILE='G0FUNC', STATUS='NEW')
#else
     	OPEN 	(22, FILE='G0FUNC', STATUS='UNKNOWN')
	REWIND	(22)
#endif
     	G0(1)	=  ARR(1,3)
     	X_J	=  10.0D0**EX_UPP
     	WRITE (22,*)	X_J,G0(1)
     	ARRX(1)	=	X_J
     	DO 199 J=2,NP
     	  X_J1 	=  EX_UPP - EX_STEP*(J-1)
     	  X_J 	=  EX_UPP - EX_STEP*(J-2)
     	  X_J1 	=  10.0D0**X_J1
     	  X_J	=  10.0D0**X_J
     	  XSTEP =  ABS(X_J1 - X_J)
     	  G0(J) =  G0(J-1) + ( ARR(J-1,3) + ARR(J,3) )*0.5D0*XSTEP
     	  WRITE (22,*)	X_J1,G0(J)
     	  ARRX(J)	=   X_J1
 199   	CONTINUE
     	CLOSE 	(22)
C
C This is the unformatted file that will eventually contain the
C whole synchrotron radiation spectrum.
C
#ifdef vms
     	OPEN 	(23, FILE='GOUNF', STATUS='NEW', FORM='UNFORMATTED')
#else
     	OPEN 	(23, FILE='GOUNF', STATUS='UNKNOWN', 
     $		FORM='UNFORMATTED')
	REWIND	(23)
#endif
     	  WRITE (23)	NP
     	 DO 299 J=1,NP
     	  X_WRI	=   ARRX(J)
     	  Y_WRI =   G0(J)
     	  WRITE (23)	X_WRI,Y_WRI
 299   	 CONTINUE
     	CLOSE	(23)
C
C Computes now the vertical distribution at the same values of Y.
C Due to the symmetry around the orbit plane, only half of the
C distribution is computed, for a total of 41 = 2*21 - 1 points.
C The range is desumed from the approximated formula for sigma_z'
C as published by S.Krinsky in its paper in SR (North Holland)
C
#ifdef vms
     	OPEN	(23, FILE='SRSPEC', STATUS='NEW', FORM='UNFORMATTED',
     $			INITIALSIZE = 500)
#else
     	OPEN	(23, FILE='SRSPEC', STATUS='UNKNOWN', 
     $			FORM='UNFORMATTED')
	REWIND	(23)
#endif
     	COEFF	=  4*0.57D0/1957.0D0
     	DO 399 J=1,NP,5
C
C ARRX(J) is lambdac/lambda, or energy/energyc.
C
     	  VAL	=  1/ARRX(J)
     	  PSIMAX =  COEFF*VAL**0.43	!Radians
     	  STEP	=  PSIMAX/20
     	 DO 499 I=1,21
C
C Range from -psimax to zero
C
     	   PSI	=  -PSIMAX + (I-1)*STEP
     	   PSI	=   PSI*1957.0D0
     	   ARG  =  (1 + PSI**2)
     	   XCALL=   0.5D0*ARG**1.5D0*ARRX(J)
     	  CALL	BSKM (XCALL,Y23,2,ORD23)
     	  CALL	BSKM (XCALL,Y13,1,ORD13)
     	   F_PAR(I)=  ARG**2*Y23**2
     	   F_PER(I)=  PSI**2*ARG**2*Y13**2
     	   F_TOT(I)=  F_PAR(I) + F_PER(I)
 499 	 CONTINUE
C
C Normalize the distributions to 1
C
     	 DO 599 I=1,21
     	   F_PAR(I)=  F_PAR(I)/F_PAR(21)
     	   F_PER(I)=  F_PER(I)/F_PAR(21)
     	   F_TOT(I)=  F_TOT(I)/F_PAR(21)
 599 	 CONTINUE
C
C Write out; file is real*4
C
     	  X_WRI	=   ARRX(J)
     	  Y_WRI =   G0(J)
     	  Z_WRI =   PSIMAX
     	 WRITE (23)	X_WRI,Y_WRI,Z_WRI
     	 DO 699 I=1,21
     	   X_WRI =   F_PAR(I)
     	   Y_WRI =   F_PER(I)
     	   Z_WRI =   F_TOT(I)
     	  WRITE (23)	X_WRI,Y_WRI,Z_WRI
 699 	 CONTINUE
 399 	CONTINUE
	END
C----------------------------------------------------------------------
