C +++
C
C Source: src/source/bm/srcdf.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	srcdf.F
C Revision 1.4  90/11/13  14:00:46  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/18  19:14:54  khan
C Using SHADOW_SR_DIR environment string to find the files SRS* and G0UNF,
C as opposed to VMS's use of the LOGICALS for the file names.
C 
C Revision 1.2  90/07/12  16:22:06  khan
C Buf fix with binary read/write format for SR* files. Note that the
C format of files are now incompatible with VMS version since the
C IMPLIED DO LOOPS have been unrolled.
C 
C Revision 1.1  90/07/11  10:45:06  khan
C Initial revision
C 
C 
C ---

C+++
C	PROGRAM		SRCDF
C
C	PURPOSE		Generate a table of CDF for both the
C			G0 and the angular part.
C
C	RANGE		from 10*lam_c to 10**-5 lam_c
C
C---
	IMPLICIT 	REAL*8 		(A-H,O-Z)
			REAL*8		X_WRI,Y_WRI,Z_WRI
     			REAL*8		X1_WRI,X2_WRI,X3_WRI,X4_WRI,X5_WRI
			INTEGER		NP
	DIMENSION 	ARRX(10000),ARR(10000,3),G0(10000)
     	DIMENSION	F_PAR(41),F_TOT(41),F_PER(41),DEG_POL(41)
     	DIMENSION	CDF(4,41),CDF_G0(3,10000),PDF(4,41)
	CHARACTER*132	SRSPEC, SRANG, SRDISTR
	DATA		SRSPEC	/ 'SRSPEC' /
	DATA		SRANG	/ 'SRANG'  /
	DATA		SRDISTR	/ 'SRDISTR' /
C
	PI=3.141592653589793238D0
C
     	ORD23	=  2.0D0/3.0D0
     	ORD13	=  1.0D0/3.0D0
C
     	NP	=  1001
     	EX_LOW	=  -5.0D0
C     	EX_UPP  =   1.30103
C Change maximum energy to 10*(critical energy) instead of 20*, because 
C the CDF in that range is too small to handle by the white SR (REAL*4)
 	EX_UPP	=   1.0D0
    	EX_STEP =  (EX_UPP - EX_LOW)*1.0D-3
     	DO  10 I=1,NP
     	  X_EX 	=  EX_UPP - EX_STEP*(I-1)
     	  X 	=  10.0D0**X_EX
     	 CALL	BSKM(X,BK,1,ORD13)
	  ARR(I,1)=BK
	 CALL	BSKM(X,BK,2,ORD23)
	  ARR(I,2)=BK
C
C Added the 5/3 case by recursion formula -- Nov 26 1983
C						F.C.
C
     	  ARR(I,3) = ARR(I,1) + ARR(I,2)*4/X/3
	  ARRX(I)=X
10     	CONTINUE
     	WRITE(6,*)'Bessel Functions completed'
C
C Function G0 -- April 1984, F.C.
C Use a trapezoidal integration.
C
     	G0(1)	=  ARR(1,3)
     	X_J	=  10.0D0**EX_UPP
     	ARRX(1)	=	X_J
     	DO  20 J=2,NP
     	  X_J1 	=  EX_UPP - EX_STEP*(J-1)
     	  X_J 	=  EX_UPP - EX_STEP*(J-2)
     	  X_J1 	=  10.0D0**X_J1
     	  X_J	=  10.0D0**X_J
     	  XSTEP =  ABS(X_J1 - X_J)
     	  G0(J) =  G0(J-1) + ( ARR(J-1,3) + ARR(J,3) )*0.5D0*XSTEP
     	  ARRX(J)	=   X_J1
20     	CONTINUE
     	WRITE(6,*)'G0 completed'
C
C This is the unformatted file that will eventually contain the
C whole synchrotron radiation spectrum.
C
#ifdef vms
     	OPEN 	(23, FILE=SRDISTR, STATUS='NEW', 
     $			FORM='UNFORMATTED')
#else
     	OPEN 	(23, FILE=SRDISTR(1:IBLANK(SRDISTR)),STATUS='UNKNOWN', 
     $			FORM='UNFORMATTED')
	REWIND 	(23)
#endif
     	 WRITE (23)	2,NP
     	 CDF_G0 (1,1) = ARRX (1)
     	 CDF_G0 (2,1) = 0.0
     	 CDF_G0 (3,1) = 0.0
     	 DO  25 J=2,NP
     	   CDF_G0 (1,J) =   ARRX(J)
     	   CDF_G0 (2,J) =   (G0(J-1)+G0(J))*0.5D0*(ARRX(J-1)-ARRX(J)) +
     $			     CDF_G0 (2,J-1)
     	   CDF_G0 (3,J) =   (G0(J-1)*ARRX(J-1)+G0(J)*ARRX(J))*0.5D0*
     $			    (ARRX(J-1)-ARRX(J)) +
     $			     CDF_G0 (3,J-1)
25     	 CONTINUE
     	  CDF_MAX  =  CDF_G0 (2,NP)
     	  PWR_MAX  =  CDF_G0 (3,NP)
     	 DO  30 J=1,NP
     	   CDF_G0 (2,J) =   CDF_G0 (2,J)/CDF_MAX
     	   CDF_G0 (3,J) =   CDF_G0 (3,J)/PWR_MAX
C
C Write out E/Ec, CDF of the # of photons, CDF of the power.
C 
     	  WRITE (23)	CDF_G0(1,J),CDF_G0(2,J),CDF_G0(3,J)
CD	  WRITE (25,*)	X_WRI,Y_WRI
30     	 CONTINUE
     	CLOSE	(23)
     	WRITE(6,*)'G0 CDF completed and written'
	WRITE(6,*)'Total area of G0  = ',CDF_MAX
C	I_CONT	= IRINT	('Continue with angular part [1/0] ? ')
C	IF (I_CONT.EQ.0) GO TO 111
C
C Computes now the vertical distribution at the same values of Y.
C The range is desumed from the approximated formula for sigma_z'
C as published by S.Krinsky in its paper in SR (North Holland).
C This fromula works well for high photon energies, but is too large
C for low h_nu.
C

#ifdef vms
     	OPEN	(23, FILE=SRSPEC, STATUS='NEW',
     $	    FORM='UNFORMATTED')
     	OPEN	(24, FILE=SRANG, STATUS='NEW',
     $	    FORM='UNFORMATTED')
#else
     	OPEN	(23, FILE=SRSPEC(1:IBLANK(SRSPEC)),STATUS='UNKNOWN',
     $	    FORM='UNFORMATTED')
	REWIND	(23)
     	OPEN	(24, FILE=SRANG(1:IBLANK(SRANG)),STATUS='UNKNOWN',
     $	    FORM='UNFORMATTED')
	REWIND	(24)
#endif 
C
     	WRITE(6,*)'Step (E.G., 4) ? '
     	READ(5,*)IST
     	NST	=  (NP-1)/IST + 1
C     	WRITE	(23,*)	NST,5,IST
     	WRITE	(23)	NST,5,IST
C     	WRITE	(24,*)	NST,4,IST
     	WRITE	(24)	NST,4,IST
C	WRITE	(24,*)	EX_UPP,EX_LOW,EX_STEP
	WRITE	(24)	EX_UPP,EX_LOW,EX_STEP
     	COEFF	=  4*0.57D0/1957.0D0
     	DO  40 J=1,NP,IST
C
C ARRX(J) is lambdac/lambda, or energy/energyc.
C
     	  VAL	=  1/ARRX(J)
     	  PSIMAX =  2*COEFF*VAL**0.43/3	!Radians
     	  IF (ARRX(J).LT.1.0E-4) PSIMAX = PSIMAX*0.75
     	  STEP	=  PSIMAX/20
     	WRITE(6,*)'Start J= ',J,' for e/ec= ',ARRX(J)
     	 DO  50 I=1,41
C
C Range from -psimax to +psimax
C
     	   PSI	=  -PSIMAX + (I-1)*STEP
     	   PSI	=   PSI*1957.0D0
     	   CDF (1,I) = PSI
      	   ARG  =  (1 + PSI**2)
     	   XCALL=   0.5D0*ARG**1.5D0*ARRX(J)
     	  CALL	BSKM (XCALL,Y23,2,ORD23)
     	  CALL	BSKM (XCALL,Y13,1,ORD13)
     	   F_PAR(I)=  ARG**2*Y23**2
     	   F_PER(I)=  PSI**2*ARG*Y13**2
     	   F_TOT(I)=  F_PAR(I) + F_PER(I)
C
C Fix May 9, 1990.    SHADOW defined the degree of polarization as Ax/(Ax+Az),
C instead of Ax^2/(Ax^2+Az^2).  So here we need to take the square root of the
C powers (F_PAR, F_PER).
C
C Old:     DEG_POL(I)   = F_PAR(I)/F_TOT(I)
	   DEG_POL(I)   = sqrt(F_PAR(I))/
     $                  (sqrt(F_PAR(I)) + sqrt(F_PER(I)))

50     	 CONTINUE
C
C Computes the three CDF's
C
     	CDF(2,1) =  F_PAR(1)*STEP
     	CDF(3,1) =  F_PER(1)*STEP
     	CDF(4,1) =  F_TOT(1)*STEP
     	DO  60 I=2,41
     	  CDF(2,I) = CDF(2,I-1) + (F_PAR(I)+F_PAR(I-1))*.5*STEP
     	  CDF(3,I) = CDF(3,I-1) + (F_PER(I)+F_PER(I-1))*.5*STEP
     	  CDF(4,I) = CDF(4,I-1) + (F_TOT(I)+F_TOT(I-1))*.5*STEP
60     	CONTINUE
     	C2_MAX	=   CDF(2,41) - CDF(2,1)
     	C3_MAX  =   CDF(3,41) - CDF(3,1)
     	C4_MAX  =   CDF(4,41) - CDF(4,1)
     	C2_MIN	=   CDF(2,1)
     	C3_MIN	=   CDF(3,1)
     	C4_MIN	=   CDF(4,1)
C
C The integral of PDF over the angle(in radian) equal to G0, for an 1 Gev 
C machine.
C
     	DO  70 I=1,41
	  PDF(1,I) = CDF(1,I)
	  PDF(2,I) = F_PAR(I)/C4_MAX*G0(J)
	  PDF(3,I) = F_PER(I)/C4_MAX*G0(J)
	  PDF(4,I) = F_TOT(I)/C4_MAX*G0(J)
     	  CDF(2,I) = (CDF(2,I)-C2_MIN)/C2_MAX
     	  CDF(3,I) = (CDF(3,I)-C3_MIN)/C3_MAX
     	  CDF(4,I) = (CDF(4,I)-C4_MIN)/C4_MAX
70     	CONTINUE
C
C Write out; file is real*4
C
     	  X_WRI =   ARRX(J)
     	  Z_WRI =   PSIMAX
C     	 WRITE (23,*)	X_WRI,Z_WRI
     	 WRITE (23)	X_WRI,Z_WRI
C	 WRITE (24,*)	X_WRI,Z_WRI,G0(J)
	 WRITE (24)	X_WRI,Z_WRI,G0(J)
     	 DO  80 I=1,21
     	   X1_WRI =   CDF(1,I)
     	   X2_WRI =   CDF(2,I)
     	   X3_WRI =   CDF(3,I)
     	   X4_WRI =   CDF(4,I)
	   X5_WRI =   DEG_POL(I)
C     	  WRITE (23,*)	X1_WRI,X2_WRI,X3_WRI,X4_WRI,X5_WRI
     	  WRITE (23)	X1_WRI,X2_WRI,X3_WRI,X4_WRI,X5_WRI
C	  WRITE (24,*)	PDF(1,I),PDF(2,I),PDF(3,I),PDF(4,I)
	  WRITE (24)	PDF(1,I),PDF(2,I),PDF(3,I),PDF(4,I)
80     	 CONTINUE
40     	CONTINUE
111	END
