C +++
C
C Source: src/source/bm/setup.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	setup.f
C Revision 1.2  90/07/18  19:11:53  khan
C Removed most of the subroutines to BM library (libbm.a) since these are
C called by most of the other programs.
C Also added #if vms ... #elif unix ... to OPEN statements.
C 
C Revision 1.1  90/07/11  10:44:59  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	SETUP
C
C	PURPOSE		Initialize a set of variable to compute a SR
C			spectrum.
C
C---
	SUBROUTINE SETUP
C
	IMPLICIT 	REAL*8 		(A-H,O-Z)

#if defined(unix) || HAVE_F77_CPP
#       include		"bm.blk"
#elif defined(vms)
	INCLUDE		'bm.blk'
#endif
C
	NP 	= 1001
	THETA 	= 1.0D0
C ***** uses a 1 mrad angle (horizontal) ******
C ***** band-pass is 1 eV		 ******
	CONST 	= 3.951D+28*PHOT*THETA/1000.0*RAD**2.0D0
	GAMM 	= 1957.0D0*BENER
	CONST 	= CONST/GAMM**4
C ***** THIS USES A CURRENT OF 1 mA ******
	CONST 	= CONST*0.001D0
	RLCR 	= 5.59D0*RAD/BENER**3
	RL 	= 12398.0D0/PHOT
	STEP 	= 2.0D0*PSIMAX/(NP-1)
	FCT 	= RLCR/2/RL

	RETURN
	END
C 
