C +++
C
C Source: src/source/bm/bskm.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	bskm.f
C Revision 1.1  90/07/18  18:47:32  khan
C Initial revision
C 
C 
C ---

C+++
C	SUBROUTINE	BSKM
C
C	PURPOSE		Computes the modified Bessel functions of
C			order 1/2, 3/2 and 5/2
C
C---
	  SUBROUTINE BSKM(X,BK,IQ,ORD)

	  IMPLICIT 	REAL*8 		(A-H,O-Z)

	  G13 = 2.678938534707748D0
	  G23 = 1.354117939426400D0
	  PI = 3.141592653589793238D0
	  K = 0
	  BK = 0.0D0

	IF (X.LT.10.1) THEN
	IF (IQ.EQ.1)THEN
	  PP = (X/2)**(-ORD)/G23-(X/2)**ORD/G13*3
	GO TO 250
230	DO 240 J = 1,K
	  PPP = PPP*(X/2)**2/J/FLOAT(3*J-2)*3.0D0
240	  PPM = PPM*(X/2)**2/J/FLOAT(3*J-1)*3.0D0
	  PPP = PPP/G13*(X/2)**ORD*3.0D0/(3*J-2)
	  PPM = PPM/G23*(X/2)**(-ORD)
	  PP = PPM-PPP
250	  PP = PP*PI/2/SIN(ORD*PI)
	  BK = BK+PP
	  	IF(ABS(PP).LT.1.0D-20) RETURN
	  K = K+1
	  PPP = 1.0D0
	  PPM = 1.0D0
	GOTO230

	ELSE

	  PP = (X/2)**(-ORD)/G13-(X/2)**ORD/G23*3.0D0/2
	GO TO 350
330	DO 340 J = 1,K
	  PPP = PPP*(X/2)**2/J/FLOAT(3*J-1)*3.0D0
340	  PPM = PPM*(X/2)**2/J/FLOAT(3*J-2)*3.0D0
	  PPP = PPP/G23*(X/2)**ORD*3.0D0/(3*J-1)
	  PPM = PPM/G13*(X/2)**(-ORD)
	  PP = PPM-PPP
350	  PP = PP*PI/2/SIN(ORD*PI)
	  BK = BK+PP
	IF(ABS(PP).LT.1.0D-20) RETURN
	  K = K+1
	  PPP = 1.0D0
	  PPM = 1.0D0
	GO TO 330

	END IF

	ELSE
	  ZZ = 8*X
	  BK = 1.0D0
	  RMU = 4*ORD**2
	  BK = (PI/2/X)**0.5*EXP(-X)
	  BK = BK*(1+(RMU-1)/ZZ+(RMU-1)*(RMU-9)/2/ZZ**2+(RMU-1)*(RMU-9)*
     1         (RMU-25)/6/(ZZ)**3)
	END IF
	RETURN
	END
 
