C +++
C
C Source: src/source/bm/aladdin.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	aladdin.F
C Revision 1.9  91/04/05  14:22:17  cwelnak
C changed quotes on #include
C 
C Revision 1.8  91/03/20  17:02:17  cwelnak
C SUN version -- changes INCLUDE to #inlcude
C 
C Revision 1.7  90/11/13  14:00:42  khan
C Cleanup and SAVE statements
C 
C Revision 1.6  90/07/23  21:52:57  khan
C Renamed RCDF to be unique for each
C 
C Revision 1.5  90/07/18  19:10:58  khan
C Removed most of the subroutines to BM library (libbm.a) since these are
C called by most of the other programs.
C Also added #if vms ... #elif unix ... to OPEN statements.
C 
C Revision 1.4  90/07/14  22:38:47  khan
C All global include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.3  90/07/12  16:08:22  khan
C Bug fix with misspelling ALADDIN common block. Fixed.
C 
C Revision 1.2  90/07/11  15:50:39  khan
C fixed up parameter misalignments in the common blocks with PAD integers.
C Moved all common blocks needing PAD's to ALADDIN.BLK file.
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	ALADDIN1
C
C	PURPOSE		a) To compute the SR vertical distribution at a
C			   given photon energy and machine.
C			b) to generate a random variate with the above
C			   distribution.
C
C	ALGORITHM	Formulae published by K.Green in the BNL internal
C			report. The Bessel function are computed directly
C
C	FLAGS		i_flag: if .lt. 0, initializtion call. The SR
C			        distribuiton is computed using the data
C                               in the common blocks /source/, /aladdin/.
C
C				if .gt. 0, the random variate is generated
C				according to the former computation.
C
C	INPUT		r_var:  uniform random variate
C
C	OUTPUT		ang_out:elevation angle.
C
C           to disk:    4 files:
C			 SPARxxxx.DAT  \
C			 SPERxxxx.DAT  |--> SR vertical distribution.
C			 STOTxxxx.DAT  /
C			 FLUX.DAT      ---> Integrated Flux.
C
C----

	SUBROUTINE ALADDIN1 (R_VAR,ANG_OUT,I_FLAG,IERROR)

	IMPLICIT 	REAL*8 		(A-H,O-Z)
			CHARACTER *6 	FILSAV,Q
C
#if defined(unix) || HAVE_F77_CPP
#	include		"bm.blk"
#elif defined(vms)
	INCLUDE		'BM.BLK'
#endif
	COMMON	/FOURT/	FILSAV,Q
C
     	IERROR	=  0
	IF (I_FLAG.LT.0) THEN

     		PHOT	=    PHOTON_(1)
     		PSIMAX	=    MAX(VDIV1,VDIV2)
     		RAD	=    ABS(R_MAGNET)
     		BENER	=    B_ENER

		CALL SETUP
		CALL COMPUTE
		CALL FILESAVE
	ELSE
** The values of I_FLAG are :
**	1. Parallel,
**      2. Perpendicular,
**	3. Total polarization.
		CALL SOLVE (R_VAR,ANG_OUT,I_FLAG)
     		IF (IER.NE.0) THEN
     		  IERROR = IER
     		  RETURN
     		END IF
** If the total polarization is selected, R_VAR will contain on
** return the degree of polarization at an angle ANG_OUT above the
** machine plane. The definition is slightly different from usual, as
** we define = 1 for pure parallel pol., = 0 for pure perpendicular,
** so that 0.5 will be pure circular. The module SOURCE will then 
** generate a randomly choosen polarization between the two.
     		IF (I_FLAG.EQ.3) THEN
     		 DO 100	I=1,1001
     		  TEST   =   ABS(ANG_OUT - PTOT(I,1)/1000)
     		  IF (TEST.LE.STEP)  GO TO 200
100		 CONTINUE
200		 CONTINUE
     		   IF (PTOT(I,2).NE.0.0D0) THEN
C
C Fix May 9, 1990.   SOURCE defined the degree of polarization as Ax/(Ax+Az),
C instead of Ax^2/(Ax^2+Az^2).  So to calculate the degree of polarization, 
C we need to take the square root of the powers (PPAR, PPER).
C
C OLD: 		     DEGREE	=   PPAR(I,2)/PTOT(I,2) 
     		     DEGREE	=   sqrt(PPAR(I,2))
     $				/(sqrt(PPAR(I,2))+sqrt(PPER(I,2))) 
     		   ELSE
     		     DEGREE	=   1.0D0
     		   END IF
     		 R_VAR	=   DEGREE
     		ELSE IF (I_FLAG.EQ.2) THEN
     		  R_VAR	=   0.0D0   
     		ELSE
     		  R_VAR	=   1.0D0
     		END IF
	END IF
	RETURN
	END
