#if !defined(__CYGWIN32__) && !USE_C_IO

C +++
C
C Source: src/lib/writeoff.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: writeoff.F
C Revision 1.9  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.8  91/04/05  13:54:41  cwelnak
C changed quotes on #include
C 
C Revision 1.7  91/03/25  10:59:11  cwelnak
C SUN version - INC to #inc
C 
C Revision 1.6  90/11/13  14:05:09  khan
C Cleanup and SAVE statements
C 
C Revision 1.5  90/07/20  22:05:27  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.4  90/07/15  15:31:12  khan
C All public include files (common.blk, etc) are now in ./../../include dir.
C 
C Revision 1.3  90/07/11  15:53:38  khan
C Fixed bug in writing the 12 column ray file (in implicit DO LOOP).
C 
C Revision 1.2  90/07/11  00:00:58  khan
C Added an ASCII option to BEGIN file. SOURCE now takes two parameters.
C 
C Revision 1.1  90/07/10  14:57:43  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif


C+++
C	SUBROUTINE	WRITE_OFF (FNAME,RAY,PHASE,AP,NCOL,NPOINT,IFLAG,IERR)
C
C	Input	:	FNAME	(character*(*))	Output file name
C			RAY	Array which contains the basic 12 columns that
C				defined each ray
C			PHASE	Array which contains the OPD and the 2 phase 
C				angles of the A vector
C			AP	Array which contains the Ap vector for each ray
C			NCOL	Number of columns for each ray 
C				(valid NCOL = 12, 13, or 18)
C			NPOINT	Number of rays
C			IFLAG	A flag which is written to the output file.
C			IFORM = 0, Binary output
C			      = 1, Formatted output
C	
C	Output	:	IERR = 0, normal return
C			     = 1, error opening file
C			     = 2, error writing file
C
C---
	SUBROUTINE	WRITE_OFF (FNAME,RAY,PHASE,AP,NCOL,NPOINT,
     $			IFLAG,IFORM,IERR)
	INTEGER		NCOL, NPOINT, IFLAG, IFORM, IERR
     	REAL*8		RAY (12,NPOINT), PHASE(3,NPOINT), AP(3,NPOINT)
     	CHARACTER *(*)	FNAME
C
C Declarations for the local vars.
C
	INTEGER		ISIZE, IOUNIT
	PARAMETER	(IOUNIT = 20)
	CHARACTER*80	FFORMAT
C
C Check for valid argument of NCOL.
C
	IF (NCOL.NE.12.AND.NCOL.NE.13.AND.NCOL.NE.18)
     $	CALL	LEAVE ('WRITE_OFF','Invalid argument of NCOL.',NCOL)
C
C Computes the file initialsize, for maximum transfer efficiency
C
     	ISIZE	=   (8*NCOL*NPOINT/512.0) + 2
C
C Decide if output is formatted or unformatted.
C

	IF (IFORM .EQ. 0) THEN
	  FFORMAT = 'UNFORMATTED'
	ELSEIF (IFORM .EQ. 1) THEN
	  FFORMAT = 'FORMATTED'
	ELSE
	  CALL 	LEAVE ('WRITE_OFF', 'Invalid argument of IO Format', 
     $    IFORM)
	ENDIF
C
C Now do the dirty deed. ALso, Remove the INITIALSIZE hint used for the VMS
C version.
C
#if defined(vms)
     	OPEN (IOUNIT,FILE=FNAME,STATUS='NEW',FORM=FFORMAT,ERR=10)
#else
     	OPEN (IOUNIT,FILE=FNAME,STATUS='unknown',FORM=FFORMAT,ERR=10)
	REWIND (IOUNIT)
#endif
C
	IF (IFORM .EQ. 0) THEN
	  WRITE (IOUNIT,ERR=20) NCOL, NPOINT, IFLAG
	ELSE
	  WRITE (IOUNIT,*, ERR=20) NCOL, NPOINT, IFLAG
	ENDIF
C
	IF (NCOL.EQ.12) THEN
	  IF (IFORM .EQ. 0) THEN
	      DO 199 I = 1, NPOINT
		  WRITE (IOUNIT,ERR=20) (RAY(J,I), J=1,12)
 199	      CONTINUE
	  ELSE
	      DO 299 I = 1, NPOINT
		  WRITE (IOUNIT,*,ERR=20) (RAY(J,I), J=1,12)
 299	      CONTINUE
	  ENDIF
	ELSE IF (NCOL.EQ.13) THEN
	  IF (IFORM.EQ.0) THEN
	      DO 399 I = 1, NPOINT
		  WRITE (IOUNIT,ERR=20) 
     $                (RAY(J,I), J=1,12), PHASE(1,I)
 399	      CONTINUE
	  ELSE
	      DO 499 I = 1, NPOINT
		  WRITE (IOUNIT,*,ERR=20) 
     $                (RAY(J,I), J=1,12), PHASE(1,I)
 499	      CONTINUE
	  ENDIF
	ELSE IF (NCOL.EQ.18) THEN
	  IF (IFORM .EQ. 0) THEN
	      DO 599 I = 1, NPOINT
		  WRITE (20,ERR=20)
     $	              (RAY(J,I), J = 1,12), (PHASE(K,I), K = 1,3),
     $	              (AP(L,I), L = 1,3)
 599	      CONTINUE
	  ELSE
	      DO 699 I = 1, NPOINT
		  WRITE (20,*,ERR=20)
     $	              (RAY(J,I), J = 1,12), (PHASE(K,I), K = 1,3),
     $	              (AP(L,I), L = 1,3)
 699	      CONTINUE
	  ENDIF
	ENDIF
C
C Close file.
C
    	CLOSE	(IOUNIT)
C
     	IERR	=  0
     	RETURN
10	IERR	=  1
     	RETURN
20	IERR	=  2
     	RETURN
     	END

#else /* __CYGWIN32__ || USE_C_IO */

	subroutine write_off_fortran_dummy
	return
	end

#endif
