#if defined(__CYGWIN32__)

#ifdef _MSC_VER
# define F77_NAME(name) __stdcall name
#else
# if !NO_FORT_UNDERSCORE
#  define F77_NAME(name) name ## _
# else
#  define F77_NAME(name) name
# endif
#endif

#ifdef _MSC_VER
# define RUNPRIMVS F77_NAME(RUNPRIMVS)
#else
# define RUNPRIMVS F77_NAME(runprimvs)
#endif

/*
 * this is due to a bug in libc:system() in cygwin32 B16.
 */

#warning "CYGWIN32 bug-fix call-primvs routine. FIX"

void RUNPRIMVS (char *ftn_script, int* iflag, unsigned long len) {
    char* argv[4];
    char script[256];
    int i;
    int pid;

    /* fix fortran string */
    for(i = len; ftn_script[i-1] == ' '; --i)
	;
    strncpy(script, ftn_script, i+1);
    script[i] = '\0';

    argv[0] = "primvs";
    argv[1] = "-i";
    argv[2] = script;
    argv[3] = 0;
    *iflag = 0;
    if ((pid = vfork ()) == 0) {
	execvp(argv[0], argv);
        exit (100);
    }
    else if (pid == -1) {
	*iflag = -1;
	return;
    }
    else {
	int status;
	int rc = _wait (&status);
	if (rc == -1) {
	    *iflag = -1;
	    return;
	}
	status = (status >> 8) & 0xff;
	*iflag = status;
	return;
    }
}

#else
static int run_primvs_dummy;
#endif
