C +++
C
C Source: src/lib/messages.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: messages.F
C Revision 1.6  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.5  91/04/05  13:54:29  cwelnak
C changed quotes on #include
C 
C Revision 1.4  91/03/25  10:30:44  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.3  90/11/13  14:04:58  khan
C Cleanup and SAVE statements
C 
C Revision 1.2  90/07/20  22:05:15  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.1  90/07/10  14:56:31  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	TMSSG	(TEXT1,TEXT2,IFLAG)
C
C	PURPOSE		Outputs a simple message to the screen and
C			to a file. Typically used for error messages.
C
C	ARGUEMNTS	TEXT1 : Tipically, the calling routine name
C			TEXT2 : A file name, or a message
C			IFLAG : A flag or an IOSTAT value. Written only
C				if negative. A Fortran error decoder will
C				be included later.
C
C	COMMON		IO_UNITS	I_tt	TT: unit number (6)
C					I_log   Log file unit number
C						(the log file will be
C						opened and closed 
C						elsewhere)
C---
     	SUBROUTINE	TMSSG (T1, T2, IFLAG)
C
     	COMMON	/IO_UNITS	/I_tt,I_log
C
     	CHARACTER *(*)	t1, t2
C
C Write to terminal first
C
     	WRITE (I_tt, 100) t1, t2
     	IF (iflag.NE.0) WRITE (I_tt, 110) t1, iflag
C
C ... then to log file.
C 
     	WRITE (I_log, 100) t1, t2
     	IF (iflag.NE.0) WRITE (I_log, 110) t1, iflag
C
     	RETURN
C
100	FORMAT (1X,A,'> ',A)
110	FORMAT (1X,A,'> ',I5)
     	END
C
C+++
C	SUBROUTINE	LINEOUT		(Text)
C
C	PURPOSE		To output a formatted line to the terminal and
C			to a file.
C
C---
     	SUBROUTINE	LINEOUT		(Text) 
C
     	CHARACTER *(*)	Text
C
     	COMMON	/IO_UNITS	/I_tt,I_log
C     	
     	WRITE	(I_tt,  *) Text
     	WRITE	(I_log, *) Text
C
     	RETURN	
     	END
