C +++
C
C datapath.F: get pathname of a SHADOW data file
C
C Source: src/lib/datapath.F
C
C Author: Mumit Khan <khan@xraylith.wisc.edu>
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C
C Copyright(c) 1996 Mumit Khan
C 
C ---

#ifndef SHADOW_DATA_DIR
# define SHADOW_DATA_DIR '/usr/local/shadow/data'
#endif

#ifndef PATH_SEP
# ifdef unix
#  define PATH_SEP '/'
# elif _WIN32
#  ifdef __CYGWIN32__
#   define PATH_SEP '/'
#  else
#   define PATH_SEP '\\'
#  endif
# else
#  define PATH_SEP '/'
# endif
#endif

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

	subroutine datapath (file, path, iflag)
c++
c
c datapath -- gets a full pathname for a SHADOW data file
c
c input:
c    file:   the file name to find
c    iflag:  0 don't check for existence
c	     1 do check for existence
c 
c returns: 
c    path:   the returned full path
c    iflag:  0 if ok
c            1 does not exist
c
c--
     	implicit	real*8		(a-e,g-h,o-z)
     	implicit	integer*4	(f,i-n)
	character*(*) file, path
#if defined(unix) || defined(_WIN32)
	character*256 datadir, shadow_root
	logical linited
	logical lexist
	data linited /.false./
	save linited, datadir
#endif
c
c
#ifdef vms
c
c vms is simple. Simply return with SHADOW$DATA prefix and let DCL do
c it's magic.
c
	iflag = 0
	path = 'SHADOW$DATA:' // file
c
#elif defined(unix) || defined(_WIN32)
c
c unix and such OSs with environment variable is trickier, since we want
c better control.
c
c first check SHADOW_DATA_DIR. If not found, check SHADOW_ROOT. Then
c concatenate the filename with the data directory name.
c
	if (.not.linited) then
	  call getenv ('SHADOW_DATA_DIR', datadir)
	  if (datadir(1:1).eq.' ') then
	    call getenv('SHADOW_ROOT', shadow_root)
	    if (shadow_root(1:1).eq.' ') then
	      datadir = SHADOW_DATA_DIR 
	    else
	      datadir = shadow_root(1:iblank(shadow_root)) //
     $	        PATH_SEP // 'data'
            endif
	  endif
	  linited = .true.
	endif
	path = datadir(1:iblank(datadir)) // PATH_SEP // file
c
c check for existence if the caller wants. Note that this does not check
c for protection violation, only existence.
c
	if (iflag .eq. 1) then
	    inquire (file = path, exist = lexist)
	    if (.not. lexist) then
	        iflag = 1
	    else 
	        iflag = 0
	    endif
	else
	    iflag = 0
	endif
#else /* not a known system */
c # warning UNKNOWN SYSTEM. REPORT TO SHADOW MAINTAINER. 
c
c on systems we know nothing about, simply return the filename as path.
c
	iflag = 0
	path = file
#endif
c
	return
	end
