'\"
'\" $Id: tixOptionMenu.n,v 1.1.1.1 2002/04/02 03:50:26 khan Exp $
'\"
'\"
'\" Copyright (c) 1993-1999 Ioi Kim Lam.
'\" Copyright (c) 2000-2001 Tix Project Group.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The file man.macros and some of the macros used by this file are
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
.so man.macros
'\"----------------------------------------------------------------------
.TH tixOptionMenu n 4.0 Tix "Tix Built-In Commands"
.BS
'\"
'\"
'\"----------------------------------------------------------------------
.SH NAME
tixOptionMenu \- Create and manipulate tixOptionMenu widgets
'\"
'\"
'\"
'\"----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixOptionMenu \fIpathName \fR?\fIoptions\fR?
'\"
'\"
'\"----------------------------------------------------------------------
.SH SUPER-CLASS
The \fBTixOptionMenu\fR class is derived from the \fBTixLabelWidget\fR
class and inherits all the commands, options and
subwidgets of its super-class.
'\"
'\"----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'\"
The OptionMenu widget supports all the standard Tix widget
options. See the \fBTix-Options(n)\fR manual entry for details on the
standard Tix widget options.
'\"
'\"----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'\"
'\"----------BEGIN
.OP \-command command Command
Specifies the command to be called when the \fB\-value\fR option of
the OptionMenu is changed. The command will be called with one
arguments -- the new value of the OptionMenu widget.
'\"----------END
'\"
'\"----------BEGIN
.OP \-disablecallback disableCallback DisableCallback
A boolean value indicating whether callbacks should be disabled. When
set to true, the TCL command specified by the \fB\-command\fR option
is not executed when the \fB\-value\fR of the OptionMenu widget
changes.
'\"----------END
'\"
'\"----------BEGIN
.OP \-dynamicgeometry dynamicGeometry DynamicGeometry
A boolean value indicating whether the size of the \fBmenubutton\fR
subwidget should change dynamically to match the width of the
currently selected menu entry. If set to false (the default), the the
size of the menubutton subwidget will be wide enough to display every
menu entry fully and does not change when the user selects different
entries.
'\"----------END
'\"
'\"----------BEGIN
.OP \-label label Label
Specifies the string to display as the label of this OptionMenu widget.
'\"----------END
'\"
'\"----------BEGIN
.OP \-labelside labelSide LabelSide
Specifies where the label should be displayed relative to the entry
subwidget. Valid options are: \fBtop\fR, \fBleft\fR, \fBright\fR,
\fBbottom\fR, \fBnone\fR or \fBacrosstop\fR.
'\"----------END
'\"
'\"----------BEGIN
.OP \-state state State
Specifies the whether the OptionMenu widget is normal or disabled. Only
the values "normal" and "disabled" are recognized.
'\"----------END
'\"
'\"----------BEGIN
.OP \-value value Value
Specifies the value of the OptionMenu. The value of the OptionMenu
widget is the name of the item currently displayed by its
\fBmenubutton\fR subwidget.
'\"----------END
'\"
'\"----------BEGIN
.OP \-variable variable Variable
Specifies the global variable in which the value of the OptionMenu
should be stored. The value of the OptionMenu will be automatically
updated when this variable is changed.
'\"----------END
'\"
'\"----------------------------------------------------------------------
.SH SUBWIDGETS
'\"----------BEGIN
.LP
.nf
Name:		\fBmenu\fR
Class:		\fBMenu\fR
.fi
.IP
The menu subwidget, which is popped up when the user press the
\fBmenubutton\fR subwidget.
'\"----------END
'\"
'\"----------BEGIN
.LP
.nf
Name:		\fBmenubutton\fR
Class:		\fBMenubutton\fR
.fi
.IP
The menubutton subwidget.
'\"----------END
.BE
'\"
'\"
'\"----------------------------------------------------------------------
.SH DESCRIPTION
'\"
.PP
'\"
The \fBtixOptionMenu\fR command creates a new window (given by
the \fIpathName\fR argument) and makes it into a OptionMenu
widget. Additional options, described above, may be specified on the
command line or in the option database to configure aspects of the
OptionMenu such as its cursor and relief.
'\"
'\"
'\"----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'\"
The \fBtixOptionMenu\fR command creates a new Tcl command whose
name is the same as the path name of the OptionMenu's
window. This command may be used to invoke various operations on the
widget. It has the following general form:
'\"
.RS
.CS
'\"
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
.RE
'\"
\fIPathName\fR is the name of the command, which is the same as the
OptionMenu widget's path name. \fIOption\fR and the
\fIarg\fRs determine the exact behavior of the command. The following
commands are possible for OptionMenu widgets:
'\"
'\"
.TP
\fIpathName \fBadd\fR \fItype name \fR?\fIoption value ...\fR?
'\"
Adds a new item into the OptionMenu widget. \fItype\fR must be either
\fBcommand\fR or \fBseparator\fR. The \fIoptions\fR may be any of the
valid options for the \fBcommand\fR or \fBseparator\fR menu entry
types for the TK \fBmenu\fR widget class, except \fB\-command\fR.
'\"
.TP
\fIpathName \fBcget\fR \fIoption\fR
'\"
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixOptionMenu\fR command.
'\"
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'\"
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string. \fIOption\fR may have
any of the values accepted by the \fBtixOptionMenu\fR command.
'\"
.TP
\fIpathName \fBdelete\fR \fIname\fR
'\"
Deletes the menu entry identified by \fIname\fR.
'\"
'\"
.TP
\fIpathName \fBdisable\fR \fIname\fR
'\"
Disables the menu entry identified by \fIname\fR.
'\"
.TP
\fIpathName \fBenable\fR \fIname\fR
'\"
Enables the menu entry identified by \fIname\fR.
'\"
'\"
.TP
\fIpathName \fBentrycget\fR \fIname option\fR
'\"
Returns the current value of the configuration option given by
\fIoption\fR in the menu entry identified by \fIname\fR. \fIOption\fR
may have any of the values accepted by the \fBadd\fR widget command.
'\"
.TP
\fIpathName \fBentryconfigure\fI name\fR ?\fIoption\fR? \fI?value option value ...\fR?
'\"
Query or modify the configuration options of the menu entry identified
by \fIname\fR. If no \fIoption\fR is specified, returns a list
describing all of the available options for the menu entry (see
\fBTk_ConfigureInfo\fR for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command
returns a list describing the one named option (this list will be
identical to the corresponding sublist of the value returned if no
\fIoption\fR is specified). If one or more \fIoption\-value\fR pairs
are specified, then the command modifies the given option(s) to
have the given value(s); in this case the command returns an empty
string. \fIOption\fR may have any of the values accepted by the
\fBadd\fR widget command.
'\"
.TP
\fIpathName \fBentries\fR
'\"
Returns the names of all the entries currently in the OptionMenu
widget.
'\"
.TP
\fIpathName \fBsubwidget \fIname ?args?\fR 
'\"
When no options are given, this command returns the pathname of the
subwidget of the specified name.

When options are given, the widget command of the specified subwidget
will be called with these options.
'\"
'\"
'\"
'\"----------------------------------------------------------------------
'\".SH BINDINGS
'\".PP
'\"
'\"
'\"
'\"----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)



