#!/bin/csh -f
#
# MAKE_ID: driver program for the insertion devices code for SHADOW.
#
# Author: Mumit khan <khan@xraylith.wisc.edu>
#
# Source: src/source/id/make_id
#
# ----------------------------------------------
#               SHADOW
#    Center for X-ray Lithography
#  University of Wisconsin-Madison
#  3731 Schneider Dr., Stoughton, WI, 53589
# ------------------------------------------------
#
# Log:	make_id
# Revision 1.2  91/04/02  09:47:31  khan
# change path to match SUN config.
# 
# Revision 1.1  90/07/17  23:33:20  khan
# Initial revision
# 
#

#
# This is the command procedure to activate either the wiggler or undulator.
# This must be called before running SOURCE.
#

# First of all, Where are all the programs? Set it to nothing if all the
# programs are in the PATH variable of the SHELL.

if (! $?SHADOW_ROOT) then
    echo "Must have SHADOW_ROOT defined in the environment"
    echo "source .shadowrc before running shadow."
    exit 1
endif

if (! $?SHADOW_START_DIR) setenv SHADOW_START_DIR './'
if (! $?SHADOW_PROGDIR) then
    setenv SHADOW_PROGDIR $SHADOW_ROOT/bin
endif

# The VMS version of MAKE_ID first runs EPATH, which sets a LOGICAL to say
# what device the user has picked. Since Unix processes can't set the
# environment of parent processes (god knows why), we have to kludge it
# (sort of like tset does) by writing the environment strings to a file
# and source'ing the file. So define the SHADOW_ENV_FILE to pick a file. 

if (! $?SHADOW_ENV_FILE) then
    setenv SHADOW_ENV_FILE  "/tmp/shadow-env-${USER}"
endif

# Run epath to create the parameter and the trajectory files. EPATH also
# sets the environment SHADOW_ID_DEV to specifiy the chosen device.

#if (-e $SHADOW_ENV_FILE) rm -f $SHADOW_ENV_FILE

$SHADOW_PROGDIR/epath

source $SHADOW_ENV_FILE
rm -f $SHADOW_ENV_FILE

# now depending on the return value, run appropriate programs.
switch ($SHADOW_ID_DEV)
    case 'WIGGLER':
	$SHADOW_PROGDIR/nphoton
	breaksw
    
    case 'UNDULATOR':
	$SHADOW_PROGDIR/undul
	breaksw
    
    default:
	echo "Error: EPATH return code $status invalid. No device chosen."
	exit 1
endsw

# Unset the SHADOW_DEV_ID if exists.
if ($?SHADOW_DEV_ID) unsetenv SHADOW_DEV_ID

exit 0

