'\"
'\" $Id: tixPanedWindow.n,v 1.1.1.1 2002/04/02 03:50:26 khan Exp $
'\"
'\"
'\" Copyright (c) 1993-1999 Ioi Kim Lam.
'\" Copyright (c) 2000-2001 Tix Project Group.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1.1.1 2002/04/02 03:50:26 khan Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1.1.1 2002/04/02 03:50:26 khan Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\"----------------------------------------------------------------------
.TH tixPanedWindow n 4.0 Tix "Tix Built-In Commands"
.BS
'\"
'\"
'\"----------------------------------------------------------------------
.SH NAME
tixPanedWindow \- Create and manipulate tixPanedWindow widgets
'\"
'\"----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixPanedWindow \fIpathName \fR?\fIoptions\fR?
'\"
'\"----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'\"
The PanedWindow widget supports all the standard options of a frame
widget. See the \fBoptions(n)\fR manual entry for details on the
standard options.
'\"
'\"----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'\"
'\"----------BEGIN
.LP
.nf
'\"
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
'\"
.fi
.IP
'\"
Specifies the command to invoke when the panes change their sizes.
This command is called with a list of integers that record the new
sizes of the panes. The sizes of the panes are listed in the order of
the panes' creation.
'\"----------END
'\"
'\"----------BEGIN
.OP \-dynamicgeometry dynamicGeometry DynamicGeometry
'\"
If set to true, the size of the PanedWindow will dynamically change
if the size of any of its panes changes. Otherwise, the size of the
PanedWindow will only increase when size of any of its panes changes
and will not decrease. The default value is true.
'\"----------END
'\"
'\"----------BEGIN
.OP \-handleactivebg handleActiveBg HandleActiveBg
'\"
Specifies the active background color of the resize handles. When the
mouse cursor enters a resize handle, the resize handle will adopt
the active background color.
'\"----------END
'\"
'\"
'\"----------BEGIN
.OP \-handlebg handleBg Background
'\"
Specifies the normal background color of the resize handles.
'\"----------END
'\"
'\"----------BEGIN
.OP \-height height Height
Specifies the desired height for the window.
'\"----------END
'\"
'\"----------BEGIN
.OP \-orientation orientation Orientation
Specifies the orientation of the panes. Must be either \fBvertical\fR
or \fBhorizontal\fR.
'\"----------END
'\"
'\"----------BEGIN
.OP "-paneborderwidth or -panebd" paneBorderWidth PaneBorderWidth
Specifies the border width of the panes.
'\"----------END
'\"
'\"----------BEGIN
.OP \-panerelief paneRelief PaneRelief
Specifies the border relief of the panes.
'\"----------END
'\"
'\"----------BEGIN
.OP \-separatoractivebg separatorActiveBg SeparatorActiveBg
Specifies the active background color of the separators. When the user
grabs a resize handle, the separators
will adopt the active background color.
'\"----------END
'\"
'\"----------BEGIN
.OP \-separatorbg separatorBg Background
'\"
Specifies the normal background color of the separators.
'\"----------END
'\"
'\"
'\"----------BEGIN
.OP \-width width Width
Specifies the desired width for the window.
'\"----------END
'\"----------------------------------------------------------------------
.SH SUBWIDGETS
.PP
'\"
All the pane subwidgets created as a result of the \fBadd\fR command
can be accessed by the \fBsubwidget\fR command. They are identified by
the \fBpaneName\fR parameter to the \fBadd\fR command.
'\"
.BE
'\"
'\"----------------------------------------------------------------------
.SH DESCRIPTION

.PP
'\"
The \fBtixPanedWindow\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a PanedWindow widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
PanedWindow widget such as its cursor and relief.
'\"
.PP
'\"
The PanedWindow widget allows the user to interactively manipulate the
sizes of several panes. The panes can be arranged either vertically or
horizontally. Each individual pane may have upper and lower limits of
its size. The user changes the sizes of the panes by dragging the
resize handle between two panes.
'\"
'\"----------------------------------------------------------------------
.SH "WIDGET COMMAND"
'\"
.PP
'\"
The \fBtixPanedWindow\fR command creates a new Tcl command whose name is
the same as the path name of the PanedWindow widget's window.  This
command may be used to invoke various operations on the widget.  It
has the following general form:
'\"
.RS
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
.RE
'\"
\fIPathName\fR is the name of the command, which is the same as the
frame widget's path name. \fIOption\fR and the \fIarg\fRs determine
the exact behavior of the command.  The following commands are
possible for PanedWindow widgets:
'\"
.TP 
\fIpathName \fBadd\fI paneName \fR?\fIoption value ...\fR?
'\"
Adds a new pane subwidget with the name \fIpaneName\fR into the
PanedWindow widget. Additional configuration options can be
given to configure the new button subwidget. Three configuration
options are supported:
.RS
'\"
.TP
\fB\-after\fR \fIpane\fR
'\"
Specifies that the new pane should be placed after \fIpane\fR in the
list of panes in this PanedWindow widget.
'\"
.TP
\fB\-at\fR \fIinteger\fR
'\"
Specifies the position of the new pane in the list of panes in this
PanedWindow widget. \fB0\fR means the first position, \fB1\fR means
the second, and so on. In addition, \fBend\fR means the end of the
list.
'\"
.TP
\fB\-before\fR \fIpane\fR
'\"
Specifies that the new pane should be placed before \fIpane\fR in the
list of panes in this PanedWindow widget.
'\"
.TP
\fB\-expand\fR \fIfactor\fR
'\"
Specifies the \fBexpand/shrink factor\fR of this pane. \fIFactor\fR
must be a non-negative floating point number. The default value is
0.0. The expand/shrink factor is used to calculate how much each pane
should grow or shrink when the size of the PanedWindow main window is
changed. When the main window expands/shrinks by \fIn\fR pixels, then
pane \fIi\fR will grow/shrink by about \fIn * factor(i) /
summation(factors)\fR, where \fIfactor(i)\fR is the expand/shrink
factor of pane i and \fIsummation(factors)\fR is the summation of the
expand/shrink factors of all the panes. If \fIsummation(factors)\fR is
0.0, however, only the last visible pane will be grown or shrunk.
'\"
.TP
\fB\-min\fR \fIinteger\fR
'\"
Specifies the minimum size, in pixels, of the new pane; the default is 0.
'\"
.TP
\fB\-max\fR \fIinteger\fR
Specifies the maximum size, in pixels, of the new pane; the default is 10000.
'\"
.TP
\fB\-size\fR \fIinteger\fR
Specifies the size, in pixels, of the new pane; if the \fB\-size\fR
option is not given, or set to the empty string, the PanedWindow
widget will use the natural size of the pane subwidget.
'\"
.RE
'\"
.TP
\fIpathName \fBcget\fR \fIoption\fR
'\"
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may be \fB\-min\fR, \fB\-max\fR and/or
\fB\-size\fR, or any option accepted by the Tk frame widget.
'\"
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'\"
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string. \fIOption\fR may be any
of the non-static options of the PanedWindow widget.
'\"
.TP
\fIpathName \fBdelete\fR \fIpaneName\fR
'\"
Removes the pane given by \fIpaneName\fR and deletes its contents.
'\"
.TP
\fIpathName \fBforget\fR \fIpaneName\fR
'\"
Removes the pane given by \fIpaneName\fR but does not delete its
contents. This pane can be later added back to the PanedWindow widget
by the \fBmanage\fR method.
'\"
.TP
\fIpathName \fBmanage\fR \fIpaneName \fR?\fIoption value ...\fR?
'\"
Adds the pane given by \fIpaneName\fR back to the PanedWindow widget.
\fIPaneName\fR must be already forgotten by the \fBforget\fR
method. Additional \fIoption-value\fR pairs, same as those accepted by
the \fBadd\fR method, can be given to control the appearance and
position of the pane.
'\"
.TP
\fIpathName \fBpanecget\fR \fIpaneName option\fR
'\"
Returns the current value of the configuration option given by
\fIoption\fR in the pane given by \fIpaneName\fR. \fIOption\fR may
have any of the values accepted by the \fBadd\fR widget command.
'\"
.TP
\fIpathName \fBpaneconfigure\fI paneName \fR?\fIoption\fR? ?\fIvalue ...\fR?
'\"
'\"
When no option is given, prints out the values of all options of this
pane. If \fIoption\fR is specified with no \fIvalue\fR, then the
command returns the current value of that option. If one or more
\fIoption\-value\fR pairs are specified, then the command modifies the
given pane's option(s) to have the given value(s); in this case the
command returns an empty string. \fIOption\fR may be \fB\-min\fR,
\fB\-max\fR and/or \fB\-size\fR, or any option accepted by the Tk
frame widget. The sizes of the panes may be changed as a result of
calling the \fBpaneconfigure\fR command.
'\"
.TP
\fIpathName \fBpanes\fR
'\"
Returns a list of the names of all panes.
'\"
.TP
\fIpathName \fBsetsize\fR \fIpaneName newSize\fR ?\fIdirection\fR?
'\"
Sets the size of the pane specified by \fIpaneName\fR to
\fInewSize\fR. The \fIdirection\fR parameter specifies in which
direction the pane should grow/shrink. Possible values are \fBnext\fR:
the pane will grow or shrink by moving the boundary between itself and
the pane to its right or bottom; \fBprev\fR: the pane will grow or
shrink by moving the boundary between itself and the pane to its left
or top.
'\"
.TP
\fIpathName \fBsubwidget \fIname ?args?\fR 
'\"
When no options are given, returns the pathname of the subwidget of
the specified name.
.LP
When options are given, the widget command of the specified subwidget will
be called with these options.
'\"
'\"----------------------------------------------------------------------
.SH BINDINGS
'\"
The panes' sizes will be changed when the user drags the handles. The
change in the panes' sizes may be subjected to the \fB\-min\fR,
\fB\-max\fR and \fB\-size\fR options of the panes.
'\"
'\"
'\"----------------------------------------------------------------------
.SH KEYWORDS
'\"
TIX, Container Widget




