#
# settings-win.tcl: routines for SHADOW GUI personal settings for Windows
#
# ------------------------------------------------
# Mumit Khan <khan@xraylith.wisc.edu>
# Center for X-ray Lithography
# University of Wisconsin-Madison
# 3731 Schneider Dr., Stoughton, WI, 53589
# ------------------------------------------------
#
# Copyright (c) 1994-1997 Mumit Khan
#
#

#
# These are all private routines called by the settings: module (settings.tcl)
#
# settings:load_win	    -  load settings from file/registry
# settings:save_win	    -  load settings to file/registry
# 

#
# LOAD_SETTINGS: load user-specific settings for Windows
#
proc settings:load_win {a} {
    global gvars
    upvar 1 $a settings

    # key is HKEY_CURRENT_USER\\SOFTWARE\\CXrL\\SHADOW\\Settings
    set key $gvars(settings_file)
    if [catch {registry values $key *} varnames] {return} 
    vputs "Loading settings from $key..."

    foreach var $varnames {
        set value [string trim [registry get $key $var]]
	set var [string trim $var]
	set settings($var) $value
    }
    vputs "Loaded settings from $key."
    return 0
}

#
# SAVE_SETTINGS: save current preference for windows
#
proc settings:save_win {a} {
    global gvars 
    upvar 1 $a settings

    # key is HKEY_CURRENT_USER\\SOFTWARE\\CXrL\\SHADOW\\Settings
    set key $gvars(settings_file)
    vputs "Saving settings to $key..."
    foreach pname [array names settings] {
	registry set $key $pname [set settings($pname)]
    }
    vputs "Saved settings to $key."
    return 0
}
