#! /bin/sh
#
# run-system: wrapper for SHADOW trace program
#
# Author: Mumit Khan <khan@xraylith.wisc.edu>
#
# ----------------------------------------------
#	       SHADOW
#    Center for X-ray Lithography
#  University of Wisconsin-Madison
#  3731 Schneider Dr., Stoughton, WI, 53589
# ------------------------------------------------
#
# Copyright (c) 1996 Mumit Khan
#

# environment variables that this shell script sets/changes:
# export VARIABLES.

# error message function
error () {
    echo "`basename $0`: $@" 1>&2
    exit 1
}

# usage message function
usage () {
    if [ ! -z "$@" ]; then
	echo "`basename $0`: $@" 1>&2
    fi
    echo "Usage: `basename $0` -n NUM_OE -f START_PREFIX [-help] [-debug]" 1>&2
    exit 1
}


# don't bother to continue if SHADOW environmet isn't set up properly.
if [ -z "${SHADOW_ROOT}" ]; then
	error \
"SHADOW environment is not properly setup for this script
to run.  Set the environment variables via the \`\`.shadowrc'' shell script 
provided with SHADOW distribution."
fi

if [ -z "${SHADOW_BIN}" ]; then
    SHADOW_BIN=${SHADOW_ROOT}/bin
fi

# Now all the programs that we need to run.
TRACE=${SHADOW_BIN}/trace

#
# set up the variables, including the ones from EXCON.
#
STARTPREFIX=			# start file prefix (eg., "start")
NUM_OE=0			# number of OE's to run
RETVAL=0			# return codes from programs.

# Parse command line args.
while [ $# -gt 0 ]; do
    case "$1" in
	-f)
	    if [ $# -lt 2 ]; then
		usage "$1 option requires a start file prefix name"
	    fi
	    shift
	    STARTPREFIX="$1"
	    ;;
	-n)
	    if [ $# -lt 2 ]; then
		usage "$1 option requires a number (number of OEs)"
	    fi
	    shift
	    NUM_OE="$1"
	    ;;
	-debug|-d)
	    set -x
	    ;;
	-help|-h)
	    usage ""
	    ;;
	*)
	    usage "Illegal command line option $1"
	    ;;
    esac
    shift
done


#
# check sanity
#

if test -z "$STARTPREFIX"; then
    error "Must provide start file prefix (eg., start)"
fi

if test $NUM_OE -le 0; then
    error "SYSTEM must have more >= 1 OEs to run (currently = $NUM_OE)"
fi

#
# now run the programs. 
#

tmpfile=/tmp/khan.$$.tmp
touch $tmpfile
chmod a+rw $tmpfile
cur_oe=1
while test $cur_oe -le $NUM_OE; do
    startfile="${STARTPREFIX}.0${cur_oe}"
    cat >> $tmpfile << __EOB1
0
${startfile}
__EOB1
    
    cur_oe=`expr $cur_oe + 1`
done
cat >> $tmpfile << __EOB2
0
exit
__EOB2
cat $tmpfile | ${TRACE} -m batch 
RETVAL=$?

rm -f $tmpfile
exit ${RETVAL}
