#
# toolbar.tcl: routines for SHADOW Toolbar.
#
# ------------------------------------------------
# Mumit Khan <khan@xraylith.wisc.edu>
# Center for X-ray Lithography
# University of Wisconsin-Madison
# 3731 Schneider Dr., Stoughton, WI, 53589
# ------------------------------------------------
#
# Copyright (c) 1994-1996 Mumit Khan
#
#

proc toolbar:make {w toolbar {balloon {}} {takefocus {1}}} {
    # We create the frame and the ScrolledHList widget
    # at the top of the dialog box
    #
    frame $w -bd 1 -relief sunken -class XMenuToolBar

    #
    # toolbar is a list of toolbar items.
    #
    # {title {image ""} {callback $args}}
    #

    set i 1
    foreach item $toolbar {
	lappend buttons [toolbar:add $w $i $item $balloon $takefocus]
	incr i
    }
    global gvars
    if {$gvars(screentype) == "s"} {set pad 4} {set pad 10}
    eval pack $buttons -side left -padx $pad -pady $pad -expand 0 -fill both
    return $w
}

proc toolbar:add {w index tool {balloon {}} {takefocus {1}}} {
    global gvars
    set label [lindex $tool 0]
    set image [lindex $tool 1]
    set state [lindex $tool 2]
    set callback [lindex $tool 3]
    set balloon_msgs [lindex $tool 4]

    if {$image == ""} {
	set add_image 0
    } else {
	set add_image 1
    }
    if {$label == ""} {
	if !$add_image {
	    set label "N/A"
	    set add_label 1
	} else {
	    set add_label 0
	}
    } else {
        set add_label 1
    }

    if {$image != ""} {
	if [catch "tix getimage $image" img] {
	    puts stderr "toolbar:add (INTERNAL): Image $image not found"
	    set add_image 0
	}
    }

    set btn_w $w.btn${index}
    if {$gvars(screentype) == "s"} {
        set width 30
        set height 30
    } else {
        set width 40
        set height 40
    }
    button $btn_w -command "$callback" \
        -takefocus $takefocus \
        -padx 4 -pady 1 -width $width -height $width

    # Create the first image: we create a line, then put a string,
    # a space and a image into this line, from left to right.
    # The result: we have a one-line image that consists of three
    # individual items
    #
    set btn_img [image create compound -window $btn_w]
    if $add_image {
	$btn_img add line
	$btn_img add image -image $img
    }
    if $add_label {
	$btn_img add line
	$btn_img add text -text $label
    }
 
    $btn_w config -image $btn_img

    #
    # add the balloon message if applicable.
    #
    set nballoon [llength $balloon_msgs]
    if {$balloon != "" && $nballoon} {
	if {$nballoon == 1} {
	    $balloon bind $btn_w -msg [lindex $balloon_msgs 0]
	} else {
	    $balloon bind $btn_w -balloonmsg [lindex $balloon_msgs 0] \
		-statusmsg [lindex $balloon_msgs 1]
	}
    }

    return $btn_w
}
