'\"
'\" Copyright 2001-2 by Silicon Metrics Corporation.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Silicon Metrics or any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Silicon Metrics disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Silicon Metrics be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" The hierarchical table widget created by George Howlett.
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1.1.1 2002/04/02 03:50:11 khan Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.ft CW
.sp
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
.ft R
.sp
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH treeview n 2.4 BLT "BLT Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
treeview \- Create and manipulate hierarchical table widgets
.BE
.SH SYNOPSIS
\fBtreeview\fR \fIpathName \fR?\fIoptions\fR?
.SH DESCRIPTION
The \fBtreeview\fR widget displays a tree of data.  It replaces both
the \fBhiertable\fR and \fBhierbox\fR widgets.  The \fBtreeview\fR is
100% syntax compatible with the \fBhiertable\fR widget.  The
\fBhiertable\fR command is retained for sake of script-level
compatibility.  This widget obsoletes the \fBhierbox\fR widget.  It
does everything the old \fBhierbox\fR widget did, but also provides
data sharing (via \fItree data objects\fR) and the ability to tag
nodes.
.SH INTRODUCTION
The \fBtreeview\fR widget displays hierarchical data.  Data is
represented as nodes in a general-ordered tree.  Each node may have
sub-nodes and these nodes can in turn has their own children.
.PP
A node is displayed as a row entry in the widget.  Each entry has a
text label and icon.  When a node has children, its entry is drawn
with a small button to the left of the label.  Clicking the mouse over
this button opens or closes the node.  When a node is \fIopen\fR, its
children are exposed.  When it is \fIclosed\fR, the children and their
descedants are hidden.  The button is normally a \f(CW+\fR or
\f(CW\-\fR symbol (ala Windows Explorer), but can be replaced with a
pair of Tk images (open and closed images).
.PP
If the node has data associated with it, they can be displayed in
columns running vertically on either side the tree.  You can control
the color, font, etc of each entry.  Any entry label or data field can
be edited in-place.
.SH "TREE DATA OBJECT"
The tree is not stored inside the widget but in a tree data object
(see the \fBtree\fR command for a further explanation).  Tree data
objects can be shared among different clients, such as a
\fBtreeview\fR widget or the \fBtree\fR command.  You can walk the
tree and manage its data with the \fBtree\fR command tree, while
displaying it with the \fBtreeview\fR widget.  Whenever the tree is
updated, the \fBtreeview\fR widget is automatically redrawn.
.PP
By default, the \fBtreeview\fR widget creates its own tree object.
The tree initially contains just a root node.  But you can also
display trees created by the \fBtree\fR command using the \fB\-tree\fR
configuration option.  \fBTreeview\fR widgets can share the same tree
object, possibly displaying different views of the same data.
.PP
A tree object has both a Tcl and C API.  You can insert or delete
nodes using \fBtreeview\fR widget or \fBtree\fR command operations,
but also from C code.  For example, you can load the tree from your C
code while still managing and displaying the tree from Tcl. The widget
is automatically notified whenever the tree is modified via C or Tcl.
.SH SYNTAX
.DS
\fBtreeview \fIpathName \fR?\fIoption value\fR?...
.DE
The \fBtreeview\fR command creates a new window \fIpathName\fR and
makes it into a \fBtreeview\fR widget.  At the time this command is
invoked, there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.  Additional options may be
specified on the command line or in the option database to configure
aspects of the widget such as its colors and font.  See the
\fBconfigure\fR operation below for the exact details about what
\fIoption\fR and \fIvalue\fR pairs are valid.
.PP
If successful, \fBtreeview\fR returns the path name of the widget.  It
also creates a new Tcl command by the same name.  You can use this
command to invoke various operations that query or modify the widget.
The general form is:
.DS
\fIpathName \fIoperation\fR \fR?\fIarg\fR?...
.DE
Both \fIoperation\fR and its arguments determine the exact behavior of
the command.  The operations available are described in the
.SB "TREEVIEW OPERATIONS"
section.
.SH "IDS AND TAGS"
Nodes can be inserted into a tree using the \fBtreeview\fR widget 
.CS
blt::treeview .t
set node [.t insert end root "one"]
.CE
or \fBtree\fR command. 
.CS
set tree [blt::tree create]
set node [$tree insert root "one"]
.CE
In both cases, a number identifying the node is returned (the value of
\f(CW$node\fR).  This serial number or \fIid\fR uniquely identifies
the node.  Please note that you can't infer a location or position of
a node from its id.  The only exception is that the root node is
always id \f(CW0\fR. Since nodes may have the same labels or be moved
within the tree, ids provide an convenient way to identify nodes.  If
a tree is shared, the ids will be the same regardless if you are using
by the \fBtreeview\fR widget or the \fBtree\fR command.  Ids are
recycled when the node deleted.
.PP
A node may also have any number of \fItags\fR associated with it.  A
tag is just a string of characters, and it may take any form except
that of an integer.  For example, "\f(CWx123\fR" is valid, but
"\f(CW123\fR" isn't.  The same tag may be associated with many
different nodes.  This is typically done to associate a group of
nodes.  Many operations in the \fBtreeview\fR widget take either node
ids or tag names as arguments.  Using a tag says to apply the operation
to all nodes with that tag.
.PP
The tag \fBall\fR is implicitly associated with every node in
the tree.  It may be used to invoke operations on all the nodes in the
tree. 
.PP
Tags may be shared, just like trees, between clients.  For example,
you can use the tags created by the \fBtree\fR command with
\fBtreeview\fR widgets.
.SH SPECIAL NODE IDS
There are also several special non-numeric ids.  Special ids differ
from tags in that they are always translated to their numeric
equivalent.  They also take precedence over tags.  For example, you
can't use a tag name that is a special id.  These ids are specific to
the \fBtreeview\fR widget.
.TP 15
\fBactive\fR
The node where the mouse pointer is currently located.
When a node is active, it is drawn using its active icon 
(see the \fB\-activeicon\fR option).
The \fBactive\fR id is changed automatically by moving the mouse
pointer over another node or by using the \fBentry activate\fR
operation. Note that there can be only one active node at a time.
.TP 15
\fBanchor\fR
The node representing the fixed end of the current selection.  
The anchor is set by the \fBselection anchor\fR operation.
.TP 15
\fBcurrent\fR
The node where the mouse pointer is currently located.
But unlike \fBactive\fR, this id changes while the
selection is dragged.  It is used to determine the
current node during button drags.
.TP 15
\fBdown\fR
The next open node from the current focus. The \fBdown\fR of
the last open node is the same.
.TP 15
\fBend\fR
The last open node (in depth-first order) on the tree.  
.TP 15
\fBfocus\fR
The node that currently has focus.  When a node has focus,
it receives key events.  To indicate focus, the node
is drawn with a dotted line around its label.  You can change the 
focus using the \fBfocus\fR operation.
.TP 15
\fBlast\fR
The last open node from the current focus. But unlike \fBup\fR,
when the focus is at root, \fBlast\fR wraps around to the last
open node in the tree.
.TP 15
\fBmark\fR
The node representing the non-fixed end of the current selection.  
The mark is set by the \fBselection mark\fR operation.
.TP 15
\fBnext\fR
The next open node from the current focus.  But unlike \fBdown\fR,
when the focus is on last open node, \fBnext\fR wraps around to the 
root node.
.TP 15
\fBnextsibling\fR
The next sibling from the node with the current focus.  If the node
is already the last sibling then it is the \fBnextsibling\fB.
.TP 15
\fBparent\fR
The parent of the node with the current focus. The \fBparent\fR
of the root is also the root.
.TP 15
\fBprevsibling\fR
The previous sibling from the node with the current focus.  If the node
is already the first sibling then it is the \fBprevsibling\fB.
.TP 15
\fBroot\fR
The root node. You can also use id \f(CW0\fR to indicate
the root.
.TP 15
\fBup\fR
The last open node (in depth-first order) from the current focus. The
\fBup\fR of the root node (i.e. the root has focus) is also the root.
.TP 15
\fBview.top\fR
First node that's current visible in the widget.
.TP 15
\fBview.bottom\fR
Last node that's current visible in the widget.
.TP 15
\fB@\fIx\fB,\fIy\fR
Indicates the node that covers the point in the treeview window
specified by \fIx\fR and \fIy\fR (in pixel coordinates).  If no
part of the entryd covers that point, then the closest node to that
point is used.
.PP
A node may be specified as an id or tag. If the specifier is an
integer then it is assumed to refer to the single node with that id.
If the specifier is not an integer, it's checked to see if it's a
special id (such as focus).  Otherwise, it's assumed to be tag.  Some
operations only operate on a single node at a time; if a tag refers to
more than one node, then an error is generated.
.SH DATA FIELDS
A node in the tree can have \fIdata fields\fR.  A data field is a
name-value pair, used to represent arbitrary data in the node.  Nodes
can contain different fields (they aren't required to contain the same
fields).  You can optionally display these fields in the
\fBtreeview\fR widget in columns running on either side of the
displayed tree.  A node's value for the field is drawn in the column
along side its node in the hierarchy.  Any node that doesn't have a
specific field is left blank.  Columns can be interactively resized,
hidden, or, moved.
.SH ENTRY BINDINGS
You can bind Tcl commands to be invoked when events occur on nodes
(much like Tk canvas items).  You can bind a node using its id or
its \fIbindtags\fR.  Bindtags are simply names that associate a
binding with one or more nodes.  There is a built-in tag \f(CWall\fR
that all node entries automatically have.
.SH "TREEVIEW OPERATIONS"
The \fBtreeview\fR operations are the invoked by specifying
the widget's pathname, the operation, and any arguments that pertain 
to that operation.  The general form is:
.sp
.CS
\fIpathName operation \fR?\fIarg arg ...\fR?
.CE
.sp
\fIOperation\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following operation are available for \fBtreeview\fR widgets:
.TP
\fIpathName \fBbbox\fR ?\fB-screen\fR? \fItagOrId...\fR
Returns a list of 4 numbers, representing a bounding box of around
the specified entries. The entries is given by one or more \fItagOrId\fR 
arguments.  
If the \fB\-screen\fR flag is given, then the x-y coordinates
of the bounding box are returned as screen coordinates, not 
virtual coordinates. Virtual coordinates start from \f(CW0\fR from the
root node.
The returned list contains the following values.
.RS
.TP 1.25i
\fIx\fR 
X-coordinate of the upper-left corner of the bounding box.
.TP
\fIy\fR
Y-coordinate of the upper-left corner of the bounding box.
.TP
\fIwidth\fR
Width of the bounding box.
.TP
\fIheight\fR
Height of the bounding box.
.RE
.TP
\fIpathName \fBbind\fR \fItagName\fR ?\fIsequence command\fR?
Associates \fIcommand\fR with \fItagName\fR such that whenever the
event sequence given by \fIsequence\fR occurs for a node with this
tag, \fIcommand\fR will be invoked.  The syntax is similar to the 
\fBbind\fR command except that it operates on \fBtreeview\fR entries, 
rather than widgets. See the \fBbind\fR manual entry for
complete details on \fIsequence\fR and the substitutions performed on 
\fIcommand\fR before invoking it.  
.sp
If all arguments are specified then a new binding is created, replacing 
any existing binding for the same \fIsequence\fR and \fItagName\fR.
If the first character of \fIcommand\fR is \f(CW+\fR then \fIcommand\fR 
augments an existing binding rather than replacing it. 
If no \fIcommand\fR argument is provided then the command currently
associated with \fItagName\fR and \fIsequence\fR (it's an error occurs 
if there's no such binding) is returned.  If both \fIcommand\fR and 
\fIsequence\fR are missing then a list of all the event sequences for 
which bindings have been defined for \fItagName\fR. 
.TP
\fIpathName \fBbutton \fIoperation\fR ?\fIargs\fR?
This command is used to control the button selectors within a 
\fBtreeview\fR widget.  
It has several forms, depending on \fIoperation\fR:
.RS
.TP
\fIpathName \fBbutton activate\fR \fItagOrId\fR
Designates the node given by \fItagOrId\fR as active.  
When a node is active it's entry is drawn using its active icon 
(see the \fB\-activeicon\fR option). 
Note that there can be only one active entry at a time.
The special id \fBactive\fR indicates the currently active node.
.TP
\fIpathName \fBbutton bind\fR \fItagName\fR ?\fIsequence command\fR?
Associates \fIcommand\fR with \fItagName\fR such that whenever the
event sequence given by \fIsequence\fR occurs for an button of a
node entry with this tag, \fIcommand\fR will be invoked.  The syntax is
similar to the \fBbind\fR command except that it operates on
\fBtreeview\fR buttons, rather than widgets. See the \fBbind\fR
manual entry for complete details on \fIsequence\fR and the
substitutions performed on \fIcommand\fR before invoking it.
.sp
If all arguments are specified then a new binding is created, replacing 
any existing binding for the same \fIsequence\fR and \fItagName\fR.
If the first character of \fIcommand\fR is \f(CW+\fR then \fIcommand\fR 
augments an existing binding rather than replacing it. 
If no \fIcommand\fR argument is provided then the command currently
associated with \fItagName\fR and \fIsequence\fR (it's an error occurs 
if there's no such binding) is returned.  If both \fIcommand\fR and 
\fIsequence\fR are missing then a list of all the event sequences for 
which bindings have been defined for \fItagName\fR. 
.TP
\fIpathName \fBbutton cget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBbutton configure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described in the section 
.SB "BUTTON OPTIONS" 
below.
.RE
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBclose \fR?\fB\-recurse\fR? \fItagOrId...\fR
Closes the node specified by \fItagOrId\fR.  In addition, if a Tcl
script was specified by the \fB\-closecommand\fR option, it is
invoked.  If the node is already closed, this command has no effect.
If the \fB\-recurse\fR flag is present, each child node is
recursively closed.
.TP
\fIpathName \fBcolumn \fIoperation\fR ?\fIargs\fR?
The following operations are available for treeview columns.
.RS
.TP
\fIpathName \fBcolumn activate\fR \fIcolumn\fR
Sets the active column to \fIcolumn\fR.  \fIColumn\fR is the
name of a column in the widget.
When a column is active, it's drawn using its \fB\-activetitlebackground\fR
and \fB\-activetitleforeground\fR options.  If \fIcolumn\fR is the \f(CW""\fR,
then no column will be active.  If no column argument is provided, then
the name of the currently active column is returned.
.TP
\fIpathName \fBcolumn cget\fR \fIname\fR \fIoption\fR
Returns the current value of the column configuration option given
by \fIoption\fR for \fIname\fR.  \fIName\fR is the name of column
that corresponds to a data field.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBcolumn configure\fR \fIname\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the column designated
by \fIname\fR. \fIName\fR is the name of the column corresponding
to a data field.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described in the section
.SB "COLUMN OPTIONS" 
below.
.TP
\fIpathName \fBcolumn delete\fR \fIfield\fR ?\fIfield\fR...?
Deletes one of more columns designated by \fIfield\fR.  Note
that this does not delete the data fields themselves.
.TP
\fIpathName \fBcolumn insert\fR \fIposition\fR \fIfield\fR ?\fIoptions\fR...?
Inserts one of more columns designated by \fIfield\fR.  A column displays
each node's data field by the same name.  If the node doesn't
have the given field, the cell is left blank.
\fIPosition\fR
indicates where in the list of columns to add the new column.  It may be
either a number or \f(CWend\fR. 
.TP
\fIpathName \fBcolumn invoke\fR \fIfield\fR
Invokes the Tcl command associated with the column \fIfield\fR, 
if there is one (using the column's \fB\-command\fR option).  
The command is ignored if the column's \fB\-state\fR option 
set to \f(CWdisabled\fR.
.TP
\fIpathName \fBcolumn move \fIname\fR \fIdest\fR 
Moves the column \fIname\fR to the destination position.  
\fIDest\fR is the name of another column or a screen position
in the form \f(CW@\fIx\f(CW,\fIy\fR.
.TP
\fIpathName \fBcolumn names\fR
Returns a list of the names of all columns in the widget.
The list is ordered as the columns are drawn from left-to-right.
.TP
\fIpathName \fBcolumn nearest\fR \fIx\fR ?\fIy\fR?
Returns the name of the column closest to the given X-Y screen
coordinate.  If you provide a \fIy\fR argument (it's optional),
a name is returned only when if the point is over a column's title.
.RE
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described in the section
.SB "TREEVIEW OPTIONS"
below.
.TP
\fIpathName \fBcurselection\fR
Returns a list containing the ids of all of the entries that are 
currently selected.
If there are no entries selected, then the empty string is returned.
.TP
\fIpathName \fBdelete \fItagOrId\fR...
Deletes one or more entries given by \fItagOrId\fR and its children.
.TP
\fIpathName \fBentry \fIoperation\fR ?\fIargs\fR?
The following operations are available for treeview entries.
.RS
.TP
\fIpathName \fBentry activate\fR \fItagOrId\fR
Sets the active entry to the one specified by \fItagOrId\fR.  
When an entry is active it is drawn using its active icon 
(see the \fB\-activeicon\fR option). 
Note that there can be only one active node at a time.
The special id of the currently active node is \fBactive\fR.
.TP
\fIpathName \fBentry cget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBentry children\fR \fItagOrId\fR  ?\fIfirst\fR? ?\fIlast\fR?
Returns a list of ids for the given range of children of \fItagOrId\fR.  
\fITagOrId\fR is the id or tag of the node to be examined.
If only a \fIfirst\fR argument is present, then the id 
of the that child at that numeric position is returned.  If both \fIfirst\fR 
and \fIlast\fR arguments are given, then the ids of all the children
in that range are returned.  Otherwise the ids of all children
are returned.  
.TP
\fIpathName \fBentry configure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described below:
.TP
\fIpathName \fBentry delete\fR \fItagOrId\fR ?\fIfirst\fR ?\fIlast\fR?
Deletes the one or more children nodes of the parent \fItagOrId\fR.
If \fIfirst\fR and \fIlast\fR arguments are present, they are
positions designating a range of children nodes to be deleted.
.TP
\fIpathName \fBentry isbefore \fItagOrId1\fR \fItagOrId2\fR
Returns 1 if \fItagOrId1\fR is before \fItagOrId2\fR and 0 otherwise.
.TP
\fIpathName \fBentry ishidden \fItagOrId\fR
Returns 1 if the node is currently hidden and 0 otherwise.  A node is
also hidden if any of its ancestor nodes are closed or hidden.
.TP
\fIpathName \fBentry isopen \fItagOrId\fR
Returns 1 if the node is currently open and 0 otherwise.
.TP
\fIpathName \fBentry size\fR \fB\-recurse\fR \fItagOrId\fR
Returns the number of children for parent node \fItagOrId\fR.  
If the \fB\-recurse\fR flag is set, the number of all 
its descendants is returned.  The node itself is not counted.
.RE
.TP
\fIpathName \fBfind \fR?\fIflags\fR? \fIfirst\fR \fIlast\fR
Finds for all entries matching the criteria given by \fIflags\fR.  A
list of ids for all matching nodes is returned. \fIFirst\fR and
\fIlast\fR are ids designating the range of the search in
depth-first order. If \fIlast\fR is before \fIfirst\fR, then nodes
are searched in reverse order.  The valid flags are:
.RS
.TP 1.25i
\fB\-name\fI pattern\fR
Specifies pattern to match against node names.
.TP 1.25i
\fB\-full\fI pattern\fR
Specifies pattern to match against node pathnames.
.TP 1.25i
\fB\-\fIoption\fI pattern\fR
Specifies pattern to match against the node entry's configuration option.
.TP 1.25i
\fB\-exact\fR
Patterns must match exactly.  The is the default.
.TP 1.25i
\fB\-glob\fR
Use global pattern matching.  Matching is done in a fashion
similar to that used by the C-shell.  For  the  two
strings  to match, their contents must be identical
except that the  following  special  sequences  may
appear in pattern:
.RS 
.TP 5
\f(CW*\fR
Matches  any  sequence  of  characters in
string, including a null string.
.TP 5
\f(CW?\fR
Matches any single character in string.
.TP 5
\f(CW[\fIchars\f(CW]\fR
Matches any character in the set given by \fIchars\fR. If a sequence of the
form \fIx\fR-\fIy\fR appears in \fIchars\fR, then any character between 
\fIx\fR and \fIy\fR,
inclusive, will match.
.TP 5
\f(CW\\\fIx\fR
Matches  the  single  character  \fIx\fR.  This
provides a way of  avoiding  the  special
interpretation of the characters \f(CW*?[]\\\fR in
the pattern.
.RE
.TP 1.25i
\fB\-regexp\fR
Use regular expression pattern matching (i.e. the same as implemented
by the \fBregexp\fR command).  
.TP 1.25i
\fB\-nonmatching\fR
Pick entries that don't match.  
.TP 1.25i
\fB\-exec\fI string\fR
Specifies a Tcl script to be invoked for each matching node.
Percent substitutions are performed on \fIstring\fR before 
it is executed.  The following substitutions are valid:
.RS 
.TP 5
\f(CW%W\fR
The pathname of the widget.
.TP 5
\f(CW%p\fR
The name of the node.
.TP 5
\f(CW%P\fR
The full pathname of the node.
.TP 5
\f(CW%#\fR
The id of the node.
.TP 5
\f(CW%%\fR
Translates to a single percent.
.RE
.TP 1.25i
\fB\-count\fI number\fR
Stop searching after \fInumber\fR matches.
.TP 1.25i
\fB\-\-\fR
Indicates the end of flags.
.RE
.TP
\fIpathName \fBfocus \fR \fItagOrId\fR
Sets the focus to the node given by \fItagOrId\fR.  When a node
has focus, it can receive keyboard events.   
The special id \fBfocus\fR designates the node that currently has focus.
.TP
\fIpathName \fBget \fR?\fB\-full\fR? \fItagOrId\fR \fItagOrId\fR...
Translates one or more ids to their node entry names.  It returns a list of 
names for all the ids specified.  If the \fB\-full\fR
flag is set, then the full pathnames are returned.  
.sp
Note: If the \fB\-separator\fR option is the empty string (the default), 
the result is always a list of lists, even if there is only one node
specified.
.TP 
\fIpathName \fBhide \fR?\fBflags\fR? \fItagOrId\fR...
Hides all nodes matching the criteria given by \fIflags\fR.  The
search is performed recursively for each node given by \fItagOrId\fR.
The valid flags are described below:
.RS
.TP 1.25i
\fB\-name\fI pattern\fR
Specifies pattern to match against node names.
.TP 1.25i
\fB\-full\fI pattern\fR
Specifies pattern to match against node pathnames.
.TP 1.25i
\fB\-\fIoption\fI pattern\fR
Specifies pattern to match against the node entry's configuration option.
.TP 1.25i
\fB\-exact\fR
Match patterns exactly.  The is the default.
.TP 1.25i
\fB\-glob\fR
Use global pattern matching.  Matching is done in a fashion
similar to that used by the C-shell.  For  the  two
strings  to match, their contents must be identical
except that the  following  special  sequences  may
appear in pattern:
.RS 
.TP 5
\f(CW*\fR
Matches  any  sequence  of  characters in
string, including a null string.
.TP 5
\f(CW?\fR
Matches any single character in string.
.TP 5
\f(CW[\fIchars\f(CW]\fR
Matches any character in the set given by \fIchars\fR. If a sequence of the
form \fIx\fR-\fIy\fR appears in \fIchars\fR, then any character between 
\fIx\fR and \fIy\fR,
inclusive, will match.
.TP 5
\f(CW\\\fIx\fR
Matches  the  single  character  \fIx\fR.  This
provides a way of  avoiding  the  special
interpretation of the characters \f(CW*?[]\\\fR in
the pattern.
.RE
.TP 1.25i
\fB\-regexp\fR
Use regular expression pattern matching (i.e. the same as implemented
by the \fBregexp\fR command).  
.TP 1.25i
\fB\-nonmatching\fR
Hide nodes that don't match.  
.TP 1.25i
\fB\-\-\fR
Indicates the end of flags.
.RE
.TP
\fIpathName \fBindex \fR?\fB\-at\fR ?\fB\-path\fR? \fItagOrId\fR? \fIstring\fR 
Returns the id of the node specified by \fIstring\fR.  \fIString\fR
may be a tag or node id.
Some special ids are normally relative to the node that 
has focus.  The \fB\-at\fR flag lets you select another node.
.TP
\fIpathName \fBinsert \fR?\fB\-at \fItagOrId\fR? \fIposition\fR \fIpath\fR ?\fIoptions...\fR? ?\fIpath\fR? ?\fIoptions...\fR? 
Inserts one or more nodes at \fIposition\fR.  \fIPosition\fR is the
location (number or \f(CWend\fR) where the new nodes are added to
the parent node.  \fIPath\fR is the pathname of the new node.
Pathnames can be formated either as a Tcl list (each element is a path
component) or as a string separated by a special character sequence
(using the \fB\-separator\fR option).  Pathnames are normally
absolute, but the \fB\-at\fR switch lets you select a relative
starting point.  Its value is the id of the starting node.  
.sp
All ancestors of the new node must already exist, unless the
\fB\-autocreate\fR option is set.  It is also an error if a node
already exists, unless the \fB\-allowduplicates\fR option is set.
.sp
\fIOption\fR and \fIvalue\fR may have any of the values accepted by the 
\fBentry configure\fR operation described in the
.SB "ENTRY OPERATIONS"
section below.  This command returns a list of the ids of
the new entries.
.TP
\fIpathName \fBmove \fItagOrId\fR \fIhow\fR \fIdestId\fR
Moves the node given by \fItagOrId\fR to the destination node.  The
node can not be an ancestor of the destination.  \fIDestId\fR is
the id of the destination node and can not be the root of the
tree.  In conjunction with \fIhow\fR, it describes how the move is
performed.
.RS
.TP 8
\f(CWbefore\fR
Moves the node before the destination node.
.TP 8
\f(CWafter\fR
Moves the node after the destination node.
.TP 8
\f(CWinto\fR
Moves the node to the end of the destination's list of children.
.RE
.TP
\fIpathName \fBnearest \fIx y\fR ?\fIvarName\fR?
Returns the id of the node entry closest to the given X-Y screen
coordinate.  If the coordinate is not directly over any node, then the
empty string is returned.  If the argument \fIvarName\fR is present,
this is a Tcl variable that is set to either \f(CWbutton\fR,
\f(CWlabel\fR, \f(CWlabel\fR, or \f(CW""\fR depending what part of the
entry the coordinate lies.
.TP
\fIpathName \fBopen \fR?\fB\-recurse\fR? \fItagOrId...\fR
Opens the one or more nodes specified by \fItagOrId\fR.  
If a node is not already open, the Tcl script specified by the 
\fB\-opencommand\fR option is invoked. If the \fB\-recurse\fR flag 
is present, then each descendant is recursively opened.  
.TP
\fIpathName \fBrange\fR ?\fB-open\fR? \fIfirst last\fR
Returns the ids in depth-first order of the nodes
between the \fIfirst\fR and \fIlast\fR ids.  If the \fB\-open\fR
flag is present, it indicates to consider only open nodes.
If \fIlast\fR is before \fIfirst\fR, then the ids are
returned in reverse order.
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command implements scanning.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIx y\fR
Records \fIx\fR and \fIy\fR and the current view in the treeview
window;  used in conjunction with later \fBscan dragto\fR commands.
Typically this command is associated with a mouse button press in
the widget.  It returns an empty string.
.TP
\fIpathName \fBscan dragto \fIx y\fR.
Computes the difference between its \fIx\fR and \fIy\fR
arguments and the \fIx\fR and \fIy\fR arguments to the last
\fBscan mark\fR command for the widget.
It then adjusts the view by 10 times the
difference in coordinates.  This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the list at high speed through the window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBsee\fR ?\fB\-anchor \fIanchor\fR? \fItagOrId\fR
Adjusts the view of entries so that the node given by \fItagOrId\fR is
visible in the widget window.  It is an error if \fBtagOrId\fR is a
tag that refers to more than one node.  By default the node's entry
is displayed in the middle of the window.  This can changed using the
\fB\-anchor\fR flag.  Its value is a Tk anchor position.
.TP
\fIpathName \fBselection \fIoption arg\fR
This command is used to adjust the selection within a \fBtreeview\fR
widget.  It has several forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBselection anchor \fItagOrId\fR
Sets the selection anchor to the node given by \fItagOrId\fR.
If \fItagOrId\fR refers to a non-existent node, then the closest
node is used.
The selection anchor is the end of the selection that is fixed
while dragging out a selection with the mouse.
The special id \fBanchor\fR may be used to refer to the anchor
node.
.TP
\fIpathName \fBselection cancel\fR
Clears the temporary selection of entries back to the
current anchor.  Temporary selections are created by 
the \fBselection mark\fR operation.
.TP
\fIpathName \fBselection clear \fIfirst \fR?\fIlast\fR?
Removes the entries between \fIfirst\fR and \fIlast\fR
(inclusive) from the selection.  Both \fIfirst\fR and 
\fIlast\fR are ids representing a range of entries.
If \fIlast\fR isn't given, then only \fIfirst\fR is deselected.
Entries outside the selection are not affected.
.TP
\fIpathName \fBselection clearall\fR
Clears the entire selection.  
.TP
\fIpathName \fBselection mark \fItagOrId\fR
Sets the selection mark to the node given by \fItagOrId\fR.  This
causes the range of entries between the anchor and the mark to be
temporarily added to the selection.  The selection mark is the end of
the selection that is fixed while dragging out a selection with the
mouse.  The special id \fBmark\fR may be used to refer to the current 
mark node.
If \fItagOrId\fR refers to a non-existent node, then the mark
is ignored.
Resetting the mark will unselect
the previous range.  Setting the anchor finalizes the range.
.TP
\fIpathName \fBselection includes \fItagOrId\fR
Returns 1 if the node given by \fItagOrId\fR is currently
selected, 0 if it isn't.
.TP
\fIpathName \fBselection present\fR
Returns 1 if any nodes are currently selected and 0 otherwise.
.TP
\fIpathName \fBselection set \fIfirst \fR?\fIlast\fR?
Selects all of the nodes in the range between
\fIfirst\fR and \fIlast\fR, inclusive, without affecting
the selection state of nodes outside that range.
.TP
\fIpathName \fBselection toggle \fIfirst \fR?\fIlast\fR?
Selects/deselects nodes in the range between
\fIfirst\fR and \fIlast\fR, inclusive, from the selection.
If a node is currently selected, it becomes deselected, and
visa versa.
.RE
.TP 
\fIpathName \fBshow \fR?\fBflags\fR? \fItagOrId\fR...
Exposes all nodes matching the criteria given by \fIflags\fR.  This
is the inverse of the \fBhide\fR operation.  The search is performed
recursively for each node given by \fItagOrId\fR.  The valid flags are
described below:
.RS
.TP 1.25i
\fB\-name\fI pattern\fR
Specifies pattern to match against node names.
.TP 1.25i
\fB\-full\fI pattern\fR
Specifies pattern to match against node pathnames.
.TP 1.25i
\fB\-\fIoption\fI pattern\fR
Specifies pattern to match against the entry's configuration option.
.TP 1.25i
\fB\-exact\fR
Match patterns exactly.  The is the default.
.TP 1.25i
\fB\-glob\fR
\fB\-glob\fR
Use global pattern matching.  Matching is done in a fashion
similar to that used by the C-shell.  For  the  two
strings  to match, their contents must be identical
except that the  following  special  sequences  may
appear in pattern:
.RS 
.TP 5
\f(CW*\fR
Matches  any  sequence  of  characters in
string, including a null string.
.TP 5
\f(CW?\fR
Matches any single character in string.
.TP 5
\f(CW[\fIchars\f(CW]\fR
Matches any character in the set given by \fIchars\fR. If a sequence of the
form \fIx\fR-\fIy\fR appears in \fIchars\fR, then any character between 
\fIx\fR and \fIy\fR,
inclusive, will match.
.TP 5
\f(CW\\\fIx\fR
Matches  the  single  character  \fIx\fR.  This
provides a way of  avoiding  the  special
interpretation of the characters \f(CW*?[]\\\fR in
the pattern.
.RE
.TP 1.25i
\fB\-regexp\fR
Use regular expression pattern matching (i.e. the same as implemented
by the \fBregexp\fR command).  
.TP 1.25i
\fB\-nonmatching\fR
Expose nodes that don't match.  
.TP 1.25i
\fB\-\-\fR
Indicates the end of flags.
.RE
.TP
\fIpathName \fBsort\fR ?\fIoperation\fR? \fIargs...\fR
.RS
.TP
\fIpathName \fBsort auto\fR ?\fIboolean\fR
Turns on/off automatic sorting of node entries.  If \fIboolean\fR is
true, entries will be automatically sorted as they are opened,
closed, inserted, or deleted.  If no \fIboolean\fR argument is
provided, the current state is returned.
.TP
\fIpathName \fBsort cget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBsort configure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the sorting configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given sorting option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described below:
.RS
.TP
\fB\-column\fI string\fR
Specifies the column to sort. Entries in the widget are rearranged
according to this column.  If \fIcolumn\fR is \f(CW""\fR then
no sort is performed.
.TP
\fB\-command\fI string\fR
Specifies a Tcl procedure to be called when sorting nodes. 
The procedure is called with three arguments: the pathname of the widget
and the fields of two entries.  The procedure returns 1 if the first
node is greater than the second, -1 is the second is greater, and 0
if equal.  
.TP
\fB\-decreasing\fI boolean\fR
Indicates to sort in ascending/descending order.  If \fIboolean\fR 
is true, then the entries as in descending order. The default is 
\f(CWno\fR.
.TP
\fB\-mode\fI string\fR
Specifies how to compare entries when sorting. \fIString\fR
may be one of the following:
.RS 
.TP 1.5i
\f(CWascii\fR
Use string comparison based upon the ASCII collation order.
.TP 1.5i
\f(CWdictionary\fR 
Use dictionary-style comparison.  This is the same as \f(CWascii\fR
except (a) case is ignored except as a tie-breaker and (b) if two
strings contain embedded numbers, the numbers compare as integers, not
characters.  For example, "bigBoy" sorts between
"bigbang" and "bigboy", and "x10y" sorts between "x9y" and "x11y".
.TP 1.5i
\f(CWinteger\fR
Compares fields as integers.
.TP 1.5i
\f(CWreal\fR
Compares fields as floating point numbers.
.TP 1.5i
\f(CWcommand\fR
Use the Tcl proc specified by the \fB\-command\fR option to compare entries 
when sorting.   If no command is specified, the sort reverts to 
\f(CWascii\fR sorting.
.RE
.RE
.TP
\fIpathName \fBsort once\fR ?\fIflags\fR? \fItagOrId...\fR
Sorts the children for each entries specified by \fItagOrId\fR.  
By default, entries are sorted by name, but you can specify a 
Tcl proc to do your own comparisons.
.RS
.TP 1.5i
\fB\-recurse\fR
Recursively sort the entire branch, not just the children.
.RE
.RE
.TP
\fIpathName \fBtag \fIoperation args\fR
Tags are a general means of selecting and marking nodes in the tree.
A tag is just a string of characters, and it may take any form except
that of an integer.  The same tag may be associated with many
different nodes.  
.sp
Both \fIoperation\fR and its arguments determine the exact behavior of
the command.  The operations available for tags are listed below.
.RS
.TP
\fIpathName\fR \fBtag add\fR \fIstring\fR \fIid\fR...
Adds the tag \fIstring\fR to one of more entries.
.TP
\fIpathName\fR \fBtag delete\fR \fIstring\fR \fIid\fR...
Deletes the tag \fIstring\fR from one or more entries.  
.TP
\fIpathName\fR \fBtag forget\fR \fIstring\fR
Removes the tag \fIstring\fR from all entries.  It's not an error if no
entries are tagged as \fIstring\fR.
.TP
\fIpathName\fR \fBtag names\fR ?\fIid\fR?
Returns a list of tags used.  If an \fIid\fR argument
is present, only those tags used by the node designated by \fIid\fR 
are returned.
.TP
\fIpathName\fR \fBtag nodes\fR \fIstring\fR
Returns a list of ids that have the tag \fIstring\fR.  If no node
is tagged as \fIstring\fR, then an empty string is returned.
.RE
.TP
\fIpathName \fBtext \fIoperation\fR ?\fIargs\fR?
This operation is used to provide text editing for cells (data 
fields in a column) or entry labels.
It has several forms, depending on \fIoperation\fR:
.RS
.TP
\fIpathName \fBtext apply\fR
Applies the edited buffer, replacing the entry label
or data field. The edit window is hidden.
.TP
\fIpathName \fBtext cancel\fR
Cancels the editing operation, reverting the entry label 
or data value back to the previous value. The edit window is hidden.
.TP
\fIpathName \fBtext cget\fI value\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBtext configure\fR ?\fIoption value\fR?
Query or modify the configuration options of the edit window.
If no \fIoption\fR is specified, returns a list describing all of
the available options (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described in the section 
.SB "TEXT EDITING OPTIONS" 
below.
.RE
.TP
\fIpathName \fBtext delete\fI first last\fR
Deletes the characters in the edit buffer between the two given
character positions.  
.TP
\fIpathName \fBtext get\fR ?\fI\-root\fR? \fIx y\fR
.TP
\fIpathName \fBtext icursor\fI index\fR
.TP
\fIpathName \fBtext index\fI index\fR
Returns the text index of given \fIindex\fR.
.TP
\fIpathName \fBtext insert\fI index string\fR
Insert the text string \fIstring\fR into the edit buffer at the index 
\fIindex\fR.  For example, the index 0 will prepend the buffer.
.TP
\fIpathName \fBtext selection\fI args\fR
This operation controls the selection of the editing window.  Note
that this differs from the selection of entries.
It has the following forms:
.RS
.TP
\fIpathName \fBtext selection adjust\fI index\fR
Adjusts either the first or last index of the selection.
.TP
\fIpathName \fBtext selection clear\fR
Clears the selection.
.TP
\fIpathName \fBtext selection from\fI index\fR
Sets the anchor of the selection.
.TP
\fIpathName \fBtext selection present\fR
Indicates if a selection is present.
.TP
\fIpathName \fBtext selection range\fI start end\fR
Sets both the anchor and mark of the selection.
.TP
\fIpathName \fBtext selection to\fI index\fR
Sets the unanchored end (mark) of the selection.
.RE
.TP
\fIpathName \fBtoggle \fItagOrId\fR
Opens or closes the node given by \fItagOrId\fR.  If the corresponding 
\fB\-opencommand\fR or \fB\-closecommand\fR option is set, then that
command is also invoked. 
.TP
\fIpathName \fBxview \fIargs\fR
This command is used to query and change the horizontal position of the
information in the widget's window.  It can take any of the following
forms:
.RS
.TP
\fIpathName \fBxview\fR
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the horizontal span that is visible in the window.
For example, if the first element is .2 and the second element is .6,
20% of the \fBtreeview\fR widget's text is off-screen to the left, 
the middle 40% is visible
in the window, and 40% of the text is off-screen to the right.
These are the same values passed to scrollbars via the \fB\-xscrollcommand\fR
option.
.TP
\fIpathName \fBxview\fR \fItagOrId\fR
Adjusts the view in the window so that the character position given by
\fItagOrId\fR is displayed at the left edge of the window.
Character positions are defined by the width of the character \fB0\fR.
.TP
\fIpathName \fBxview moveto\fI fraction\fR
Adjusts the view in the window so that \fIfraction\fR of the
total width of the \fBtreeview\fR widget's text is off-screen to the left.
\fIfraction\fR must be a fraction between 0 and 1.
.TP
\fIpathName \fBxview scroll \fInumber what\fR
This command shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an abbreviation
of one of these.
If \fIwhat\fR is \fBunits\fR, the view adjusts left or right by
\fInumber\fR character units (the width of the \fB0\fR character)
on the display;  if it is \fBpages\fR then the view adjusts by
\fInumber\fR screenfuls.
If \fInumber\fR is negative then characters farther to the left
become visible;  if it is positive then characters farther to the right
become visible.
.RE
.TP
\fIpathName \fByview \fI?args\fR?
This command is used to query and change the vertical position of the
text in the widget's window.
It can take any of the following forms:
.RS
.TP
\fIpathName \fByview\fR
Returns a list containing two elements, both of which are real fractions
between 0 and 1.
The first element gives the position of the node at the
top of the window, relative to the widget as a whole (0.5 means
it is halfway through the treeview window, for example).
The second element gives the position of the node just after
the last one in the window, relative to the widget as a whole.
These are the same values passed to scrollbars via the \fB\-yscrollcommand\fR
option.
.TP
\fIpathName \fByview\fR \fItagOrId\fR
Adjusts the view in the window so that the node given by
\fItagOrId\fR is displayed at the top of the window.
.TP
\fIpathName \fByview moveto\fI fraction\fR
Adjusts the view in the window so that the node given by \fIfraction\fR
appears at the top of the window.
\fIFraction\fR is a fraction between 0 and 1;  0 indicates the first
node, 0.33 indicates the node one-third the
way through the \fBtreeview\fR widget, and so on.
.TP
\fIpathName \fByview scroll \fInumber what\fR
This command adjusts the view in the window up or down according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR.
If \fIwhat\fR is \fBunits\fR, the view adjusts up or down by
\fInumber\fR lines;  if it is \fBpages\fR then
the view adjusts by \fInumber\fR screenfuls.
If \fInumber\fR is negative then earlier nodes
become visible;  if it is positive then later nodes
become visible.
.RE
.SH "TREEVIEW OPTIONS"
In addition to the \fBconfigure\fR operation, widget configuration
options may also be set by the Tk \fBoption\fR command.  The class
resource name is \f(CWTreeView\fR.
.CS
option add *TreeView.Foreground white
option add *TreeView.Background blue
.CE
The following widget options are available:
.TP
\fB\-activebackground \fIcolor\fR
Sets the background color for active entries.  A node
is active when the mouse passes over it's entry or using the 
\fBactivate\fR operation.  
.TP
\fB\-activeforeground \fIcolor\fR
Sets the foreground color of the active node.  A node
is active when the mouse passes over it's entry or using the 
\fBactivate\fR operation.  
.TP
\fB\-activeicons \fIimages\fR
Specifies images to be displayed for an entry's icon
when it is active. \fIImages\fR is a list of two Tk images: 
the first image is displayed when the node is open, the
second when it is closed.
.TP
\fB\-autocreate \fIboolean\fR
If \fIboolean\fR is true, automatically create missing ancestor 
nodes when inserting new nodes. Otherwise flag an error.
The default is \f(CWno\fR.
.TP
\fB\-allowduplicates \fIboolean\fR
If \fIboolean\fR is true, allow nodes with duplicate pathnames
when inserting new nodes.  Otherwise flag an error.
The default is \f(CWno\fR.
.TP
\fB\-background \fIcolor\fR
Sets the background color of the widget.  The default is \f(CWwhite\fR.
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3\-D border around the outside edge of the widget.  The
\fB\-relief\fR option determines if the border is to be drawn.  The
default is \f(CW2\fR.
.TP
\fB\-closecommand \fIstring\fR
Specifies a Tcl script to be invoked when a node is closed.  You can
overrider this for individual entries using the entry's \fB\-closecommand\fR 
option. The default is \f(CW""\fR.
Percent substitutions are performed on \fIstring\fR before 
it is executed.  The following substitutions are valid:
.RS 
.TP 5
\f(CW%W\fR
The pathname of the widget.
.TP 5
\f(CW%p\fR
The name of the node.
.TP 5
\f(CW%P\fR
The full pathname of the node.
.TP 5
\f(CW%#\fR
The id of the node.
.TP 5
\f(CW%%\fR
Translates to a single percent.
.RE
.TP
\fB\-cursor \fIcursor\fR
Specifies the widget's cursor.  The default cursor is \f(CW""\fR.
.TP
\fB\-dashes \fInumber\fR
Sets the dash style of the horizontal and vertical lines drawn connecting 
entries. \fINumber\fR is the length in pixels of the dashes and gaps in
the line. If \fInumber\fR is \f(CW0\fR, solid lines will 
be drawn. The default is \f(CW1\fR (dotted).
.TP
\fB\-exportselection \fIboolean\fR 
Indicates if the selection is exported.  If the widget is exporting its
selection then it will observe the standard X11 protocols for handling
the selection.  Selections are available as type \fBSTRING\fR;
the value of the selection will be the label of the selected nodes,
separated by newlines.  The default is \f(CWno\fR.
.TP
\fB\-flat \fIboolean\fR
Indicates whether to display the tree as a flattened list. 
If \fIboolean\fR is true, then the hierarchy will be a list of full
paths for the nodes.  This option also has affect on sorting. 
See the 
.SB "SORT OPERATIONS"
section for more information.
The default is \f(CWno\fR.
.TP
\fB\-focusdashes \fIdashList\fR 
Sets the dash style of the outline rectangle drawn around the entry
label of the node that current has focus. \fINumber\fR is the length
in pixels of the dashes and gaps in the line.  If
\fInumber\fR is \f(CW0\fR, a solid line will be drawn. The default is
\f(CW1\fR.
.TP
\fB\-focusforeground \fIcolor\fR 
Sets the color of the focus rectangle. 
The default is \f(CWblack\fR.
.TP
\fB\-font \fIfontName\fR 
Specifies the font for entry labels.  You can override this for individual
entries with the entry's \fB\-font\fR configuration option.  The default is
\f(CW*-Helvetica-Bold-R-Normal-*-12-120-*\fR.
.TP
\fB\-foreground \fIcolor\fR 
Sets the text color of entry labels.  You can override this for individual
entries with the entry's \fB\-foreground\fR configuration option.  
The default is
\f(CWblack\fR.
.TP
\fB\-height \fIpixels\fR
Specifies the requested height of widget.  The default is
\f(CW400\fR.
.TP
\fB\-hideroot \fIboolean\fR
If \fIboolean\fR is true, it indicates that no entry for the root node 
should be displayed.  The default is \f(CWno\fR.
.TP 
\fB\-highlightbackground  \fIcolor\fR
Specifies the normal color of the traversal highlight region when
the widget does not have the input focus.  
.TP 
\fB\-highlightcolor \fIcolor\fR
Specifies the color of the traversal highlight rectangle when
the widget has the input focus. 
The default is \f(CWblack\fR.
.TP 
\fB\-highlightthickness \fIpixels\fR
Specifies the width of the highlight rectangle indicating when the
widget has input focus. The value may have any of the forms acceptable
to \fBTk_GetPixels\fR.  If the value is zero, no focus highlight will
be displayed.  The default is \f(CW2\fR.
.TP
\fB\-icons \fIimages\fR
Specifies images for the entry's icon.
\fIImages\fR is a list of two Tk images: 
the first image is displayed when the node is open, the
second when it is closed.
.TP
\fB\-linecolor \fIcolor\fR
Sets the color of the connecting lines drawn between entries.  
The default is \f(CWblack\fR.
.TP
\fB\-linespacing \fIpixels\fR
Sets the number of pixels spacing between entries.  
The default is \f(CW0\fR.
.TP
\fB\-linewidth \fIpixels\fR
Set the width of the lines drawn connecting entries.  If \fIpixels\fR
is \f(CW0\fR, no vertical or horizontal lines are drawn. 
The default is \f(CW1\fR.
.TP
\fB\-newtags \fIboolean\fR 
If \fIboolean\fR is true, when sharing a tree object (see the
\fB\-tree\fR option), don't share its tags too.  
The default is \f(CW0\fR.
.TP
\fB\-opencommand \fIstring\fR
Specifies a Tcl script to be invoked when a node is open.  
You can override this for individual entries with the entry's
\fB\-opencommand\fR configuration option.  The default is \f(CW""\fR.
Percent substitutions are performed on \fIstring\fR before 
it is executed.  The following substitutions are valid:
.RS 
.TP 5
\f(CW%W\fR
The pathname of the widget.
.TP 5
\f(CW%p\fR
The name of the node.
.TP 5
\f(CW%P\fR
The full pathname of the node.
.TP 5
\f(CW%#\fR
The id of the node.
.TP 5
\f(CW%%\fR
Translates to a single percent.
.RE
.TP
\fB\-relief \fIrelief\fR
Specifies the 3-D effect for the widget.  \fIRelief\fR
specifies how the \fBtreeview\fR widget should appear relative to widget 
it is packed into; for example, \f(CWraised\fR means the \fBtreeview\fR widget 
should appear to protrude.  The default is \f(CWsunken\fR.
.TP
\fB\-scrollmode \fImode\fR 
Specifies the style of scrolling to be used.  The following
styles are valid.  This is the default is \f(CWhierbox\fR.
.RS
.TP 1.25i
\f(CWlistbox\fR
Like the \fBlistbox\fR widget, the last entry can always be
scrolled to the top of the widget window.  This allows the scrollbar
thumb to shrink as the last entry is scrolled upward.
.TP 1.25i
\f(CWhierbox\fR
Like the \fBhierbox\fR widget, the last entry can only be
viewed at the bottom of the widget window.  The scrollbar
stays a constant size.  
.TP 1.25i
\f(CWcanvas\fR
Like the \fBcanvas\fR widget, the entries are bound within
the scrolling area. 
.RE
.TP 
\fB\-selectbackground \fIcolor\fR
Sets the background color selected node entries.
The default is \f(CW#ffffea\fR.
.TP 
\fB\-selectborderwidth \fIpixels\fR
Sets the width of the raised 3-D border drawn around the labels 
of selected entries. The default is \f(CW0\fR.
\fB\-selectcommand \fIstring\fR
Specifies a Tcl script to invoked when the set of selected
nodes changes.
The default is \f(CW""\fR.
.TP
\fB\-selectforeground \fIcolor\fB
Sets the color of the labels of selected node entries. 
The default is \f(CWblack\fR.
.TP 
\fB\-selectmode \fImode\fR
Specifies the selection mode. If \fImode\fR is 
\f(CWsingle\fR, only one node can be selected
at a time.  If \f(CWmultiple\fR more than one
node can be selected.
The default is \f(CWsingle\fR.
.TP
\fB\-separator \fIstring\fR
Specifies the character sequence to use when spliting the path components.  
The separator may be several characters wide (such as "::")
Consecutive separators in a pathname are treated as one.
If \fIstring\fR is the empty string, the pathnames are Tcl lists. 
Each element is a path component.   The default is \f(CW""\fR.
.TP
\fB\-showtitles \fIboolean\fR
If \fIboolean\fR is false, column titles are not be displayed.  
The default is \f(CWyes\fR.
.TP 
\fB\-sortselection \fIboolean\fR
If \fIboolean\fR is true, nodes in the selection are ordered as they
are currently displayed (depth-first or sorted), not in the order
they were selected. The default is \f(CWno\fR.
.TP
\fB\-takefocus\fR \fIfocus\fR 
Provides information used when moving the focus from window to window
via keyboard traversal (e.g., Tab and Shift-Tab).  If \fIfocus\fR is
\f(CW0\fR, this means that this window should be skipped entirely during
keyboard traversal.  \f(CW1\fR means that the this window should always
receive the input focus.  An empty value means that the traversal
scripts make the decision whether to focus on the window.
The default is \f(CW"1"\fR.
.TP
\fB\-trim \fIstring\fR
Specifies a string leading characters to trim from entry pathnames 
before parsing.  This only makes sense if the \fB\-separator\fR is also
set.  The default is \f(CW""\fR.
.TP
\fB\-width \fIpixels\fR
Sets the requested width of the widget.  If \fIpixels\fR is 0, then
the with is computed from the contents of the \fBtreeview\fR widget.
The default is \f(CW200\fR.
.TP 
\fB\-xscrollcommand \fIstring\fR
Specifies the prefix for a command used to communicate with horizontal
scrollbars.  Whenever the horizontal view in the widget's window 
changes, the widget will generate a Tcl command by concatenating the 
scroll command and two numbers.  If this option is not specified, then 
no command will be executed.
.TP
\fB\-xscrollincrement\fR \fIpixels\fR
Sets the horizontal scrolling distance. The default is 20 pixels.
.TP
\fB\-yscrollcommand \fIstring\fR
Specifies the prefix for a command used to communicate with vertical
scrollbars.   Whenever the vertical view in the widget's window 
changes, the widget will generate a Tcl command by concatenating the 
scroll command and two numbers.  If this option is not specified, then 
no command will be executed.
.TP
\fB\-yscrollincrement\fR \fIpixels\fR
Sets the vertical scrolling distance. The default is 20 pixels.
.SH "ENTRY OPTIONS"
Many widget configuration options have counterparts in entries.  For
example, there is a \fB\-closecommand\fR configuration option for both
widget itself and for individual entries.  Options set at the widget
level are global for all entries.  If the entry configuration option
is set, then it overrides the widget option.  This is done to avoid
wasting memory by replicated options.  Most entries will have
redundant options.
.PP
There is no resource class or name for entries.
.TP
\fB\-activeicons \fIimages\fR
Specifies images to be displayed as the entry's icon
when it is active. This overrides the global \fB\-activeicons\fR
configuration option for the specific entry.
\fIImages\fR is a list of two Tk images: 
the first image is displayed when the node is open, the
second when it is closed.
.TP
\fB\-bindtags \fItagList\fR
Specifies the binding tags for nodes.  \fITagList\fR is a list
of binding tag names.  The tags and their order will determine how
events are handled for nodes.  Each tag in the list matching the current 
event sequence will have its Tcl command executed.  The default value 
is \f(CWall\fR.
.TP
\fB\-button \fIstring\fR
Indicates whether a button should be displayed on the left side
of the node entry.  \fIString\fR can be \f(CWyes\fR, \f(CWno\fR, 
or \f(CWauto\fR.  If \f(CWauto\fR, then a button is automatically
displayed if the node has children.  This is the default.
.TP
\fB\-closecommand \fIstring\fR
Specifies a Tcl script to be invoked when the node is closed.  This
overrides the global \fB\-closecommand\fR option for this entry.
The default is \f(CW""\fR.
Percent substitutions are performed on \fIstring\fR before 
it is executed.  The following substitutions are valid:
.RS 
.TP 5
\f(CW%W\fR
The pathname of the widget.
.TP 5
\f(CW%p\fR
The name of the node.
.TP 5
\f(CW%P\fR
The full pathname of the node.
.TP 5
\f(CW%#\fR
The id of the node.
.TP 5
\f(CW%%\fR
Translates to a single percent.
.RE
.TP
\fB\-data \fIstring\fR
Sets data fields for the node.  \fIString\fR is a list of 
name-value pairs to be set. The default is \f(CW""\fR.
.TP
\fB\-font \fIfontName\fR 
Sets the font for entry labels.  This overrides the widget's
\fB\-font\fR option for this node.  The default is
\f(CW*-Helvetica-Bold-R-Normal-*-12-120-*\fR.
.TP
\fB\-foreground \fIcolor\fR 
Sets the text color of the entry label.  This overrides the widget's
\fB\-foreground\fR configuration option.  The default is \f(CW""\fR.
.TP
\fB\-icons \fIimages\fR
Specifies images to be displayed for the entry's icon.
This overrides the global \fB\-icons\fR configuration option.
\fIImages\fR is a list of two Tk images: 
the first image is displayed when the node is open, the
second when it is closed.
.TP
\fB\-label \fIstring\fR
Sets the text for the entry's label.  If not set, this 
defaults to the name of the node. The default is \f(CW""\fR.
.TP
\fB\-opencommand \fIstring\fR
Specifies a Tcl script to be invoked when the entry is opened.  
This overrides the widget's \fB\-opencommand\fR option for this node.  
The default is \f(CW""\fR. 
Percent substitutions are performed on \fIstring\fR before 
it is executed.  The following substitutions are valid:
.RS 
.TP 5
\f(CW%W\fR
The pathname of the widget.
.TP 5
\f(CW%p\fR
The name of the node.
.TP 5
\f(CW%P\fR
The full pathname of the node.
.TP 5
\f(CW%#\fR
The id of the node.
.TP 5
\f(CW%%\fR
Translates to a single percent.
.RE
.SH "BUTTON OPTIONS"
Button configuration options may also be set by the \fBoption\fR command.
The resource subclass is \f(CWButton\fR.   The resource name is always
\f(CWbutton\fR.
.CS
option add *TreeView.Button.Foreground white
option add *TreeView.button.Background blue
.CE
The following are the configuration options available for buttons.
.TP
\fB\-activebackground \fIcolor\fR
Sets the background color of active buttons.  A button
is made active when the mouse passes over it or by the 
\fBbutton activate\fR operation.  
.TP
\fB\-activeforeground \fIcolor\fR
Sets the foreground color of active buttons.  A button
is made active when the mouse passes over it or by the 
\fBbutton activate\fR operation.  
.TP
\fB\-background \fIcolor\fR
Sets the background of the button.  The default is \f(CWwhite\fR.
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3\-D border around the button.  
The \fB\-relief\fR option determines if a border is to be drawn.  The
default is \f(CW1\fR.
.TP
\fB\-closerelief \fIrelief\fR
Specifies the 3-D effect for the closed button.  \fIRelief\fR
indicates how the button should appear relative to the widget; 
for example, \f(CWraised\fR means the button should
appear to protrude.  The default is \f(CWsolid\fR.
.TP
\fB\-cursor \fIcursor\fR
Sets the widget's cursor.  The default cursor is \f(CW""\fR.
.TP
\fB\-foreground \fIcolor\fR 
Sets the foreground color of buttons. 
The default is \f(CWblack\fR.
.TP
\fB\-images \fIimages\fR
Specifies images to be displayed for the button.
\fIImages\fR is a list of two Tk images: 
the first image is displayed when the button is open, the
second when it is closed.  If the \fIimages\fR is the empty string,
then a plus/minus gadget is drawn.  The default is \f(CW""\fR.
.TP
\fB\-openrelief \fIrelief\fR
Specifies the 3-D effect of the open button.  \fIRelief\fR
indicates how the button should appear relative to the widget; 
for example, \f(CWraised\fR means the button should
appear to protrude.  The default is \f(CWflat\fR.
.TP
\fB\-size \fIpixels\fR
Sets the requested size of the button.  
The default is \f(CW0\fR.
.RE
.SH "COLUMN OPTIONS"
Column configuration options may also be set by the \fBoption\fR command.
The resource subclass is \f(CWColumn\fR.   The resource name is the 
name of the column.
.CS
option add *TreeView.Column.Foreground white
option add *TreeView.treeView.Background blue
.CE
The following configuration options are available for columns.
.TP
\fB\-background \fIcolor\fR
Sets the background color of the column.  This overrides
the widget's \fB\-background\fR option. The default is \f(CWwhite\fR.
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3\-D border of the column.  
The \fB\-relief\fR option determines if a border is to be drawn.  The
default is \f(CW0\fR.
.TP
\fB\-edit \fIboolean\fR
Indicates if the column's data fields can be edited. If \fIboolean\fR is 
false, the data fields in the column may not be edited.
The default is \f(CWyes\fR.
.TP
\fB\-foreground \fIcolor\fR 
Specifies the foreground color of the column. 
You can override this for individual entries with the entry's 
\fB\-foreground\fR option.
The default is \f(CWblack\fR.
.TP
\fB\-font \fIfontName\fR 
Sets the font for a column.  You can override this for individual entries
with the entry's \fB\-font\fR option.  The default is
\f(CW*-Helvetica-Bold-R-Normal-*-12-120-*\fR.
.TP
\fB\-hide \fIboolean\fR
If \fIboolean\fR is true, the column is not displayed.
The default is \f(CWyes\fR.
.TP
\fB\-justify \fIjustify\fR
Specifies how the column data fields title should be justified within
the column.  This matters only when the column is wider than the 
data field to be display.
\fIJustify\fR must be \f(CWleft\fR, \f(CWright\fR, or \f(CWcenter\fR.  
The default is \f(CWleft\fR.
.TP
\fB\-pad \fIpad\fR
Specifies how much padding for the left and right sides of the column.
\fIPad\fR is a list of one or two screen distances.  If \fIpad\fR
has two elements, the left side of the column is padded by the first
distance and the right side by the second.  If \fIpad\fR has just one
distance, both the left and right sides are padded evenly.  The
default is \f(CW2\fR.
.TP
\fB\-relief \fIrelief\fR
Specifies the 3-D effect of the column.  \fIRelief\fR
specifies how the column should appear relative to the widget; 
for example, \f(CWraised\fR means the column should
appear to protrude.  The default is \f(CWflat\fR.
.TP
\fB\-state \fIstate\fR
Sets the state of the column. If \fIstate\fR is \f(CWdisable\fR then
the column title can not be activated nor invoked.
The default is \f(CWnormal\fR.
.TP
\fB\-text \fIstring\fR
Sets the title for the column.
The default is \f(CW""\fR.
.TP
\fB\-titleforeground \fIcolor\fR 
Sets the foreground color of the column title. 
The default is \f(CWblack\fR.
.TP
\fB\-titleshadow \fIcolor\fR 
Sets the color of the drop shadow of the column title.  
The default is \f(CW""\fR.
.TP
\fB\-width \fIpixels\fR
Sets the requested width of the column.  This overrides
the computed with of the column.  If \fIpixels\fR is 0,
the width is computed as from the contents of the column. The
default is \f(CW0\fR.
.RE
.SH "TEXT EDITING OPTIONS"
Text edit window configuration options may also be set by the 
\fBoption\fR command. The resource class is \f(CWTreeViewEditor\fR.
The resource name is always \f(CWedit\fR.
.CS
option add *TreeViewEditor.Foreground white
option add *edit.Background blue
.CE
The following are the configuration options available for the
text editing window.
.TP
\fB\-background \fIcolor\fR
Sets the background of the text edit window.  The default is \f(CWwhite\fR.
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3\-D border around the edit window.  
The \fB\-relief\fR option determines if a border is to be drawn.  The
default is \f(CW1\fR.
.TP
\fB\-exportselection \fIboolean\fR
Indicates if the text selection is exported.  If the edit window is 
exporting its selection then it will observe the standard X11 protocols 
for handling the selection.  Selections are available as type \fBSTRING\fR.
The default is \f(CWno\fR.
.TP
\fB\-relief \fIrelief\fR
Specifies the 3-D effect of the edit window.  \fIRelief\fR
indicates how the background should appear relative to the edit
window; for example, \f(CWraised\fR means the background should
appear to protrude.  The default is \f(CWsolid\fR.
.TP
\fB\-selectbackground \fIcolor\fR
Sets the background of the selected text in the edit window.  
The default is \f(CWwhite\fR.
.TP
\fB\-selectborderwidth \fIpixels\fR
Sets the width of the 3\-D border around the selected text in the 
edit window.  The \fB\-selectrelief\fR option determines if a border 
is to be drawn.  The default is \f(CW1\fR.
.TP
\fB\-selectforeground \fIcolor\fR
Sets the foreground of the selected text in the edit window.  
The default is \f(CWwhite\fR.
.TP
\fB\-selectrelief \fIrelief\fR
Specifies the 3-D effect of the selected text in the edit window.  
\fIRelief\fR indicates how the text should appear relative to the edit
window; for example, \f(CWraised\fR means the text should
appear to protrude.  The default is \f(CWflat\fR.
.RE
.SH "DEFAULT BINDINGS"
Tk automatically creates class bindings for treeviews that give them
Motif-like behavior.  Much of the behavior of a \fBtreeview\fR widget is determined
by its \fB\-selectmode\fR option, which selects one of two ways
of dealing with the selection.
.PP
If the selection mode is \fBsingle\fR, only one node can be 
selected at a time.
Clicking button 1 on an node selects
it and deselects any other selected item.
.PP
If the selection mode is \fBmultiple\fR,
any number of entries may be selected at once, including discontiguous
ranges.  Clicking Control-Button-1 on a node entry
toggles its selection state without affecting any other entries.
Pressing Shift-Button-1 on a node entry selects
it, extends the selection.
.IP [1]
In \fBextended\fR mode, the selected range can be adjusted by pressing
button 1 with the Shift key down:  this modifies the selection to
consist of the entries between the anchor and the entry under
the mouse, inclusive.
The un-anchored end of this new selection can also be dragged with
the button down.
.IP [2]
In \fBextended\fR mode, pressing button 1 with the Control key down
starts a toggle operation: the anchor is set to the entry under
the mouse, and its selection state is reversed.  The selection state
of other entries isn't changed.
If the mouse is dragged with button 1 down, then the selection state
of all entries between the anchor and the entry under the mouse
is set to match that of the anchor entry;  the selection state of
all other entries remains what it was before the toggle operation
began.
.IP [3]
If the mouse leaves the treeview window with button 1 down, the window
scrolls away from the mouse, making information visible that used
to be off-screen on the side of the mouse.
The scrolling continues until the mouse re-enters the window, the
button is released, or the end of the hierarchy is reached.
.IP [4]
Mouse button 2 may be used for scanning.
If it is pressed and dragged over the \fBtreeview\fR widget, the contents of
the hierarchy drag at high speed in the direction the mouse moves.
.IP [5]
If the Up or Down key is pressed, the location cursor (active
entry) moves up or down one entry.
If the selection mode is \fBbrowse\fR or \fBextended\fR then the
new active entry is also selected and all other entries are
deselected.
In \fBextended\fR mode the new active entry becomes the
selection anchor.
.IP [6]
In \fBextended\fR mode, Shift-Up and Shift-Down move the location
cursor (active entry) up or down one entry and also extend
the selection to that entry in a fashion similar to dragging
with mouse button 1.
.IP [7]
The Left and Right keys scroll the \fBtreeview\fR widget view left and right
by the width of the character \fB0\fR.
Control-Left and Control-Right scroll the \fBtreeview\fR widget view left and
right by the width of the window.
Control-Prior and Control-Next also scroll left and right by
the width of the window.
.IP [8]
The Prior and Next keys scroll the \fBtreeview\fR widget view up and down
by one page (the height of the window).
.IP [9]
The Home and End keys scroll the \fBtreeview\fR widget horizontally to
the left and right edges, respectively.
.IP [10]
Control-Home sets the location cursor to the the first entry, 
selects that entry, and deselects everything else
in the widget.
.IP [11]
Control-End sets the location cursor to the the last entry, 
selects that entry, and deselects everything else
in the widget.
.IP [12]
In \fBextended\fR mode, Control-Shift-Home extends the selection
to the first entry and Control-Shift-End extends
the selection to the last entry.
.IP [13]
In \fBmultiple\fR mode, Control-Shift-Home moves the location cursor
to the first entry and Control-Shift-End moves
the location cursor to the last entry.
.IP [14]
The space and Select keys make a selection at the location cursor
(active entry) just as if mouse button 1 had been pressed over
this entry.
.IP [15]
In \fBextended\fR mode, Control-Shift-space and Shift-Select
extend the selection to the active entry just as if button 1
had been pressed with the Shift key down.
.IP [16]
In \fBextended\fR mode, the Escape key cancels the most recent
selection and restores all the entries in the selected range
to their previous selection state.
.IP [17]
Control-slash selects everything in the widget, except in
\fBsingle\fR and \fBbrowse\fR modes, in which case it selects
the active entry and deselects everything else.
.IP [18]
Control-backslash deselects everything in the widget, except in
\fBbrowse\fR mode where it has no effect.
.IP [19]
The F16 key (labelled Copy on many Sun workstations) or Meta-w
copies the selection in the widget to the clipboard, if there is
a selection.
.PP
The behavior of \fBtreeview\fR widgets can be changed by defining new bindings 
for individual widgets or by redefining the class bindings.
.SS WIDGET BINDINGS
In addition to the above behavior, the following additional behavior
is defined by the default widget class (TreeView) bindings.
.IP \f(CW<ButtonPress-2>\fR 
Starts scanning. 
.IP \f(CW<B2-Motion>\fR 
Adjusts the scan.
.IP \f(CW<ButtonRelease-2>\fR
Stops scanning.
.IP \f(CW<B1-Leave>\fR 
Starts auto-scrolling.
.IP \f(CW<B1-Enter>\fR
Starts auto-scrolling 
.IP \f(CW<KeyPress-Up>\fR 
Moves the focus to the previous entry.
.IP \f(CW<KeyPress-Down>\fR 
Moves the focus to the next entry.
.IP \f(CW<Shift-KeyPress-Up>\fR
Moves the focus to the previous sibling.
.IP \f(CW<Shift-KeyPress-Down>\fR
Moves the focus to the next sibling.
.IP \f(CW<KeyPress-Prior>\fR 
Moves the focus to first entry.  Closed or hidden entries
are ignored.
.IP \f(CW<KeyPress-Next>\fR 
Move the focus to the last entry. Closed or hidden entries
are ignored.
.IP \f(CW<KeyPress-Left>\fR 
Closes the entry.  It is not an error if the entry has no children.
.IP \f(CW<KeyPress-Right>\fR 
Opens the entry, displaying its children.  It is not an
error if the entry has no children.
.IP \f(CW<KeyPress-space>\fR 
In "single" select mode this selects the entry.  In "multiple" mode,
it toggles the entry (if it was previous selected, it is not
deselected).
.IP \f(CW<KeyRelease-space>\fR 
Turns off select mode.
.IP \f(CW<KeyPress-Return>\fR 
Sets the focus to the current entry.
.IP \f(CW<KeyRelease-Return>\fR 
Turns off select mode.
.IP \f(CW<KeyPress>\fR 
Moves to the next entry whose label starts with the letter typed.
.IP \f(CW<KeyPress-Home>\fR 
Moves the focus to first entry.  Closed or hidden entries
are ignored.
.IP \f(CW<KeyPress-End>\fR 
Move the focus to the last entry. Closed or hidden entries
are ignored.
.IP \f(CW<KeyPress-F1>\fR 
Opens all entries.
.IP \f(CW<KeyPress-F2>\fR
Closes all entries (except root).
.SS BUTTON BINDINGS
Buttons have bindings.  There are associated with the "all" bindtag
(see the entry's -bindtag option).  You can use the \fBbind\fR
operation to change them.
.IP \f(CW<Enter>\fR 
Highlights the button of the current entry.
.IP \f(CW<Leave>\fR 
Returns the button back to its normal state.
.IP \f(CW<ButtonRelease-1>\fR
Adjust the view so that the current entry is visible.
.SS ENTRY BINDINGS
Entries have default bindings.  There are associated with the "all"
bindtag (see the entry's -bindtag option).  You can use the \fBbind\fR
operation to modify them.
.IP \f(CW<Enter>\fR 
Highlights the current entry.
.IP \f(CW<Leave>\fR 
Returns the entry back to its normal state.
.IP \f(CW<ButtonPress-1>\fR 
Sets the selection anchor the current entry.
.IP \f(CW<Double-ButtonPress-1>\fR
Toggles the selection of the current entry.
.IP \f(CW<B1-Motion>\fR
For "multiple" mode only.  Saves the current location of the
pointer for auto-scrolling.  Resets the selection mark.  
.IP \f(CW<ButtonRelease-1>\fR
For "multiple" mode only.  Sets the selection anchor to the 
current entry.
.IP \f(CW<Shift-ButtonPress-1>\fR
For "multiple" mode only. Extends the selection.
.IP \f(CW<Shift-Double-ButtonPress-1>\fR 
Place holder. Does nothing.
.IP \f(CW<Shift-B1-Motion>\fR 
Place holder. Does nothing.
.IP \f(CW<Shift-ButtonRelease-1>\fR 
Stop auto-scrolling.
.IP \f(CW<Control-ButtonPress-1>\fR 
For "multiple" mode only.  Toggles and extends the selection.
.IP \f(CW<Control-Double-ButtonPress-1>\fR
Place holder. Does nothing.
.IP \f(CW<Control-B1-Motion>\fR 
Place holder. Does nothing.
.IP \f(CW<Control-ButtonRelease-1>\fR 
Stops auto-scrolling.
.IP \f(CW<Control-Shift-ButtonPress-1>\fR 
???
.IP \f(CW<Control-Shift-Double-ButtonPress-1>\fR
Place holder. Does nothing.
.IP \f(CW<Control-Shift-B1-Motion>\fR 
Place holder. Does nothing.
.SS COLUMN BINDINGS
Columns have bindings too.  They are associated with the column's
"all" bindtag (see the column -bindtag option).  You can use the
\fBcolumn bind\fR operation to change them.
.IP \f(CW<Enter>\fR 
Highlights the current column title.
.IP \f(CW<Leave>\fR 
Returns the column back to its normal state.
.IP \f(CW<ButtonRelease-1>\fR
Invokes the command (see the column's -command option) if one
if specified.  
.SS COLUMN RULE BINDINGS
.IP \f(CW<Enter>\fR 
Highlights the current and activates the ruler.
.IP \f(CW<Leave>\fR 
Returns the column back to its normal state. Deactivates the
ruler.
.IP \f(CW<ButtonPress-1>\fR 
Sets the resize anchor for the column.
.IP \f(CW<B1-Motion>\fR 
Sets the resize mark for the column.
.IP \f(CW<ButtonRelease-1>\fR 
Adjust the size of the column, based upon the resize anchor and mark
positions.
.SH EXAMPLE
The \fBtreeview\fR command creates a new widget.  
.CS
treeview .h \-bg white
.CE
A new Tcl command \f(CW.h\fR is also created.  This command can be used
to query and modify the \fBtreeview\fR widget.  For example, to change the 
background
color of the table to "green", you use the new command and the widget's
\fBconfigure\fR operation.
.CS
# Change the background color.
\&.h configure \-background "green"
.CE
By default, the \fBtreeview\fR widget will automatically create a new tree object
to contain the data.  The name of the new tree is the pathname of the
widget.  Above, the new tree object name is ".h".  But you can use the
\fB\-tree\fR option to specify the name of another tree.
.CS
# View the tree "myTree".
\&.h configure \-tree "myTree"
.CE
When a new tree is created, it contains only a root node.  The node
is automatically opened.  The id of the root node is always
\f(CW0\fR (you can use also use the special id \f(CWroot\fR). The
\fBinsert\fR operation lets you insert one or more new entries into
the tree.  The last argument is the node's \fIpathname\fR.  
.CS
# Create a new entry named "myEntry"
set id [\&.h insert end "myEntry"]
.CE
This appends a new node named "myEntry".  It will positioned as the
last child of the root of the tree (using the position "end").  You
can supply another position to order the node within its siblings.
.CS
# Prepend "fred".
set id [\&.h insert 0 "fred"]
.CE
Entry names do not need to be unique.  By default, the node's label
is its name.  To supply a different text label, add the \fB\-label\fR
option.
.CS
# Create a new node named "fred"
set id [\&.h insert end "fred" -label "Fred Flintstone"]
.CE
The \fBinsert\fR operation returns the id of the new node.  You can
also use the \fBindex\fR operation to get this information.
.CS
# Get the id of "fred"
\&.h index "fred"
.CE
To insert a node somewhere other than root, use the \fB\-at\fR switch.
It takes the id of the node where the new child will be added.
.CS
# Create a new node "barney" in "fred".
\&.h insert -at $id end "barney" 
.CE
A pathname describes the path to an entry in the hierarchy.  It's a
list of entry names that compose the path in the tree.  Therefore, you
can also add "barney" to "fred" as follows.
.CS
# Create a new sub-entry of "fred"
\&.h insert end "fred barney" 
.CE
Every name in the list is ancestor of the next.  All ancestors must
already exist.  That means that an entry "fred" is an ancestor of
"barney" and must already exist.  But you can use the
\fB\-autocreate\fR configuration option to force the creation of
ancestor nodes.
.CS
# Force the creation of ancestors.
\&.h configure -autocreate yes 
\&.h insert end "fred barney wilma betty" 
.CE
Sometimes the pathname is already separated by a character sequence
rather than formed as a list.  A file name is a good example of this.
You can use the \fB\-separator\fR option to specify a separator string
to split the path into its components.  Each pathname inserted is
automatically split using the separator string as a separator.
Multiple separators are treated as one.
.CS
\&.h configure -separator /
\&.h insert end "/usr/local/tcl/bin" 
.CE
If the path is prefixed by extraneous characters, you can
automatically trim it off using the \fB\-trim\fR option.  It removed
the string from the path before it is parsed.
.CS
\&.h configure -trim C:/windows -separator /
\&.h insert end "C:/window/system" 
.CE
You can insert more than one entry at a time with the \fBinsert\fR
operation.  This can be much faster than looping over a list of names.
.CS
# The slow way
foreach f [glob $dir/*] {
    \&.h insert end $f
}
# The fast way
eval .h insert end [glob $dir/*]
.CE
In this case, the \fBinsert\fR operation will return a list of ids
of the new entries.
.PP
You can delete entries with the \fBdelete\fR operation.  It takes one or
more tags of ids as its argument. It deletes the entry and all its
children.
.CS
\&.h delete $id
.CE
Entries have several configuration options.  They control the appearance
of the entry's icon and label.  We have already seen the \fB\-label\fR
option that sets the entry's text label.   The \fBentry configure\fR
operation lets you set or modify an entry's configuration options.
.CS
\&.h entry configure $id -color red -font fixed
.CE
You can hide an entry and its children using the \fB\-hide\fR option.
.CS
\&.h entry configure $id -hide yes
.CE
More that one entry can be configured at once.  All entries specified
are configured with the same options.
.CS
\&.h entry configure $i1 $i2 $i3 $i4 -color brown 
.CE
An icon is displayed for each entry.  It's a Tk image drawn to the
left of the label.  You can set the icon with the entry's
\fB\-icons\fR option.  It takes a list of two image names: one to
represent the open entry, another when it is closed.
.CS
set im1 [image create photo -file openfolder.gif]
set im2 [image create photo -file closefolder.gif]
\&.h entry configure $id -icons "$im1 $im2"
.CE
If \fB\-icons\fR is set to the empty string, no icons are display.
.PP
If an entry has children, a button is displayed to the left of the
icon. Clicking the mouse on this button opens or closes the
sub-hierarchy.  The button is normally a \f(CW+\fR or \f(CW\-\fR
symbol, but can be configured in a variety of ways using the \fBbutton
configure\fR operation.  For example, the \f(CW+\fR and \f(CW\-\fR
symbols can be replaced with Tk images.
.CS
set im1 [image create photo -file closefolder.gif]
set im2 [image create photo -file downarrow.gif]
\&.h button configure $id -images "$im1 $im2" \\
    -openrelief raised -closerelief raised
.CE
Entries can contain an arbitrary number of \fIdata fields\fR.  Data
fields are name-value pairs.  Both the value and name are strings.
The entry's \fB\-data\fR option lets you set data fields.
.CS
\&.h entry configure $id -data {mode 0666 group users}
.CE
The \fB\-data\fR takes a list of name-value pairs.  
.PP
You can display these data fields as \fIcolumns\fR in the
\fBtreeview\fR widget.  You can create and configure columns with
the \fBcolumn\fR operation.  For example, to add a new column to the
widget, use the \fBcolumn insert\fR operation.  The last argument is
the name of the data field that you want to display.
.CS
\&.h column insert end "mode"
.CE
The column title is displayed at the top of the column.  By default,
it's is the field name.  You can override this using the column's
\fB\-text\fR option.
.CS
\&.h column insert end "mode" -text "File Permissions"
.CE
Columns have several configuration options.  The \fBcolumn
configure\fR operation lets you query or modify column options.
.CS
\&.h column configure "mode" -justify left
.CE
The \fB\-justify\fR option says how the data is justified within in
the column.  The \fB\-hide\fR option indicates whether the column is
displayed.
.CS
\&.h column configure "mode" -hide yes
.CE
Entries can be selected by clicking on the mouse.  Selected entries
are drawn using the colors specified by the \fB\-selectforeground\fR 
and \fB\-selectbackground\fR configuration options.
The selection itself is managed by the \fBselection\fR operation.
.CS
# Clear all selections
\&.h selection clear 0 end
# Select the root node
\&.h selection set 0 
.CE
The \fBcurselection\fR operation returns a list of ids of
all the selected entries.
.CS
set ids [\&.h curselection]
.CE
You can use the \fBget\fR operation to convert the ids to 
their pathnames.
.CS
set names [eval .h get -full $ids]
.CE
If a treeview is exporting its selection (using the
\fB\-exportselection\fR option), then it will observe the standard X11
protocols for handling the selection.  Treeview selections are
available as type \fBSTRING\fR; the value of the selection will be the
pathnames of the selected entries, separated by newlines.
.PP
The \fBtreeview\fR supports two modes of selection: \f(CWsingle\fR
and \f(CWmultiple\fR.  In single select mode, only one entry can be
selected at a time, while multiple select mode allows several entries
to be selected.  The mode is set by the widget's \fB\-selectmode\fR
option.
.CS
\&.h configure -selectmode "multiple"
.CE
You can be notified when the list of selected entries changes.  The widget's
\fB\-selectcommand\fR specifies a Tcl procedure that is called whenever
the selection changes.
.CS
proc SelectNotify { widget } {
   set ids [\&$widget curselection]
}
\&.h configure -selectcommand "SelectNotify .h"
.CE
The widget supports the standard Tk scrolling and scanning operations.
The \fBtreeview\fR can be both horizontally and vertically. You can
attach scrollbars to the \fBtreeview\fR the same way as the listbox
or canvas widgets.
.CS
scrollbar .xbar -orient horizontal -command ".h xview"
scrollbar .ybar -orient vertical -command ".h yview"
\&.h configure -xscrollcommand ".xbar set" \\
    -yscrollcommand ".ybar set"
.CE
There are three different modes of scrolling: \f(CWlistbox\fR,
\f(CWcanvas\fR, and \f(CWhierbox\fR.  In \f(CWlistbox\fR mode, the last
entry can always be scrolled to the top of the widget.  In \f(CWhierbox\fR
mode, the last entry is always drawn at the bottom of the widget.
The scroll mode is set by the widget's \fB\-selectmode\fR
option.
.CS
\&.h configure -scrollmode "listbox"
.CE
Entries can be programmatically opened or closed using the \fBopen\fR
and \fBclose\fR operations respectively.  
.CS
\&.h open $id
\&.h close $id
.CE
When an entry is opened, a Tcl procedure can be automatically invoked.
The \fB\-opencommand\fR option specifies this procedure.  This
procedure can lazily insert entries as needed.
.CS
proc AddEntries { dir } {
   eval .h insert end [glob -nocomplain $dir/*] 
}
\&.h configure -opencommand "AddEntries %P"
.CE
Now when an entry is opened, the procedure \f(CWAddEntries\fR is
called and adds children to the entry.  Before the command is invoked,
special "%" substitutions (like \fBbind\fR) are performed. Above,
\f(CW%P\fR is translated to the pathname of the entry.
.PP
The same feature exists when an entry is closed.  The
\fB\-closecommand\fR option specifies the procedure.
.CS
proc DeleteEntries { id } {
   .h entry delete $id 0 end
}
\&.h configure -closecommand "DeleteEntries %#"
.CE
When an entry is closed, the procedure \f(CWDeleteEntries\fR is called
and deletes the entry's children using the \fBentry delete\fR operation
(\f(CW%#\fR is the id of entry).
.SH KEYWORDS
treeview, widget
