/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.internal.ImageUtils;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.views.ImageView;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class Slice2DAction
extends Action
implements IViewActionDelegate {
    ImageView iv = null;

    public Slice2DAction() {
    }

    public Slice2DAction(String string) {
        super(string, 1);
        this.setEnabled(true);
    }

    public void init(IViewPart view) {
        this.iv = view instanceof ImageView ? (ImageView)view : null;
    }

    public void run(IAction action) {
        this.slice2D();
    }

    public void run() {
        this.slice2D();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void slice2D() {
        try {
            Vector selectedFiles = SampleNavigatorView.view.getSelectedFilesIndex();
            if (selectedFiles.size() <= 1) {
                this.iv.updateStatusLabel("select at least 2 files to make a slice");
            } else {
                if (this.iv == null) {
                    this.iv = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", "0").getView(true);
                }
                if (this.iv != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", Integer.toString(200), 1);
                    ImageView imageSlice2DView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", Integer.toString(200)).getView(true);
                    imageSlice2DView.stopListening();
                    Rectangle selectionArea = this.iv.getImage().getSelectedArea();
                    Rectangle imageArea = this.iv.getImage().screenRectangleToImageRectangle(selectionArea, true);
                    if (this.iv.getZoomSelection() == ZoomSelection.AREA) {
                        ImageUtils.Slice2DArea(imageArea.x, imageArea.y, imageArea.x + imageArea.width, imageArea.y + imageArea.height);
                    } else {
                        this.iv.updateStatusLabel("zoom on a 2D area to make a slice");
                    }
                    imageSlice2DView.transferSelectedSettings(this.iv);
                    imageSlice2DView.setName("2D Slice " + this.iv.getFileName());
                }
            }
        }
        catch (PartInitException ex) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error opening view", (Throwable)ex);
        }
    }
}

