/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint;

import fable.framework.imageprint.PrintSettings;
import fable.framework.toolbox.SWTUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImagePrintUtils {
    private static final boolean debug = false;

    public static boolean printControl(Control control) {
        return ImagePrintUtils.printControl(control, null);
    }

    public static boolean printControl(Control control, PrintSettings settings) {
        if (control == null) {
            return false;
        }
        if (settings == null) {
            settings = new PrintSettings();
        }
        Point size = control.getSize();
        Image image = new Image((Device)control.getDisplay(), size.x, size.y);
        if (image == null) {
            return false;
        }
        GC gc1 = new GC((Drawable)control);
        gc1.copyArea(image, 0, 0);
        gc1.dispose();
        boolean res = ImagePrintUtils.dialogPrintImage(control.getShell(), image, control.getDisplay().getDPI(), settings);
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
        return res;
    }

    public static boolean dialogPrintImage(Shell shell, Image image, Point imageDPI, PrintSettings settings) {
        Printer printer;
        PrinterData newPrinterData;
        if (image == null || image.isDisposed()) {
            return false;
        }
        if (settings == null) {
            settings = new PrintSettings();
        }
        Image image1 = new Image(image.getDevice(), image, 0);
        PrintDialog dialog = new PrintDialog(shell, 0);
        PrinterData printerData = settings.getPrinterData();
        if (printerData != null) {
            dialog.setPrinterData(printerData);
        }
        if ((newPrinterData = dialog.open()) == null) {
            if (image1 != null && !image1.isDisposed()) {
                image1.dispose();
            }
            return false;
        }
        if (newPrinterData.printToFile) {
            FileDialog fileDialog = new FileDialog(shell, 4096);
            String file = fileDialog.open();
            if (file != null) {
                newPrinterData.fileName = file;
            } else {
                if (image1 != null && !image1.isDisposed()) {
                    image1.dispose();
                }
                return false;
            }
        }
        if ((printer = new Printer(newPrinterData)) == null) {
            return false;
        }
        settings.setPrinterData(newPrinterData);
        ImagePrintUtils.printImage(image1, shell.getDisplay().getDPI(), settings);
        if (!printer.isDisposed()) {
            printer.dispose();
        }
        return true;
    }

    public static void printImage(Image image, final Point imageDPI, PrintSettings settings) {
        if (image == null || image.isDisposed()) {
            return;
        }
        final PrintSettings settings1 = settings == null ? new PrintSettings() : settings;
        final Printer printer = new Printer(settings1.getPrinterData());
        if (printer == null) {
            return;
        }
        final Image image1 = new Image(image.getDevice(), image, 0);
        Thread printThread = new Thread(){

            @Override
            public void run() {
                if (!printer.startJob("JavaImagePrinting")) {
                    SWTUtils.errMsgAsync("Failed to start print job!");
                    if (!printer.isDisposed()) {
                        printer.dispose();
                    }
                    return;
                }
                ImagePrintUtils.drawImage((Drawable)printer, printer.getDPI(), printer.getBounds(), image1, imageDPI, settings1);
                if (image1 != null && !image1.isDisposed()) {
                    image1.dispose();
                }
                printer.endPage();
                printer.endJob();
                if (!printer.isDisposed()) {
                    printer.dispose();
                }
            }
        };
        printThread.start();
    }

    public static void drawImage(Drawable drawable, Point drawableDPI, Rectangle bounds, Image image, Point imageDPI, PrintSettings settings) {
        if (drawable == null || image == null || image.isDisposed()) {
            return;
        }
        if (settings == null) {
            settings = new PrintSettings();
        }
        if (drawableDPI == null) {
            drawableDPI = new Point(72, 72);
        }
        if (imageDPI == null) {
            imageDPI = new Point(72, 72);
        }
        int imageWidth = image.getBounds().width;
        int imageHeight = image.getBounds().height;
        double dpiScaleFactorX = (double)drawableDPI.x * 1.0 / (double)imageDPI.x;
        double dpiScaleFactorY = (double)drawableDPI.y * 1.0 / (double)imageDPI.y;
        double left = settings.getLeft() * (double)drawableDPI.x;
        double right = settings.getRight() * (double)drawableDPI.x;
        double top = settings.getTop() * (double)drawableDPI.y;
        double bottom = settings.getBottom() * (double)drawableDPI.y;
        int drawableWidth = bounds.width;
        int drawableHeight = bounds.height;
        Rectangle trim = drawable instanceof Printer ? ((Printer)drawable).computeTrim(0, 0, 0, 0) : new Rectangle(0, 0, 0, 0);
        int leftMargin = (int)left + trim.x;
        int rightMargin = drawableWidth - (int)right + trim.x;
        int topMargin = (int)top + trim.y;
        int bottomMargin = drawableHeight - (int)bottom + trim.y;
        int availableWidth = rightMargin - leftMargin;
        int availableHeight = bottomMargin - topMargin;
        if (availableWidth <= 0) {
            SWTUtils.errMsgAsync("Horizontal margins are too large!");
            return;
        }
        if (availableHeight <= 0) {
            SWTUtils.errMsgAsync("Vertical margins are too large!");
            return;
        }
        double imageSizeFactor = Math.min(1.0, (double)(rightMargin - leftMargin) * 1.0 / (dpiScaleFactorX * (double)imageWidth));
        imageSizeFactor = Math.min(imageSizeFactor, (double)(bottomMargin - topMargin) * 1.0 / (dpiScaleFactorY * (double)imageHeight));
        int drawnWidth = (int)(dpiScaleFactorX * imageSizeFactor * (double)imageWidth);
        int drawnHeight = (int)(dpiScaleFactorX * imageSizeFactor * (double)imageHeight);
        if (settings.getHorizontalAlign() == 4) {
            drawnWidth = availableWidth;
        }
        if (settings.getVerticalAlign() == 4) {
            drawnHeight = availableHeight;
        }
        if (drawnWidth < availableWidth) {
            switch (settings.getHorizontalAlign()) {
                case 16384: {
                    break;
                }
                case 0x1000000: {
                    leftMargin += (availableWidth - drawnWidth) / 2;
                    break;
                }
                case 131072: {
                    leftMargin += availableWidth - drawnWidth;
                }
            }
        }
        if (drawnHeight < availableHeight) {
            switch (settings.getVerticalAlign()) {
                case 128: {
                    break;
                }
                case 0x1000000: {
                    topMargin += (availableHeight - drawnHeight) / 2;
                    break;
                }
                case 1024: {
                    topMargin += availableHeight - drawnHeight;
                }
            }
        }
        GC gc = new GC(drawable);
        gc.drawImage(image, 0, 0, imageWidth, imageHeight, bounds.x + leftMargin, bounds.y + topMargin, drawnWidth, drawnHeight);
        gc.dispose();
    }

    public static void paintPreview(GC gc, Canvas canvas, Rectangle canvasBounds, Image image, PrintSettings settings) {
        double printerAspect;
        double canvasAspect;
        if (canvas == null || canvas.isDisposed() || image == null || image.isDisposed() || settings == null || canvasBounds == null) {
            return;
        }
        if (settings == null) {
            settings = new PrintSettings();
        }
        Printer printer = new Printer(settings.getPrinterData());
        Display display = canvas.getDisplay();
        Point displayDPI = display.getDPI();
        Point printerDPI = printer.getDPI();
        Rectangle printerBounds = printer.getBounds();
        if (settings.getOrientation() == PrintSettings.Orientation.LANDSCAPE) {
            printerBounds = new Rectangle(printerBounds.y, printerBounds.x, printerBounds.height, printerBounds.width);
            printerDPI.x = printer.getDPI().y;
            printerDPI.y = printer.getDPI().x;
        }
        if ((canvasAspect = (double)canvasBounds.height / (double)canvasBounds.width) > (printerAspect = (double)printerBounds.height / (double)printerBounds.width)) {
            int newHeight = (int)((double)canvasBounds.height * printerAspect / canvasAspect + 0.5);
            canvasBounds.y += (canvasBounds.height - newHeight) / 2;
            canvasBounds.height = newHeight;
        } else {
            int newWidth = (int)((double)canvasBounds.width * canvasAspect / printerAspect + 0.5);
            canvasBounds.x += (canvasBounds.width - newWidth) / 2;
            canvasBounds.width = newWidth;
        }
        double scaleFactor = (double)canvasBounds.width / (double)printerBounds.width * (double)printerDPI.x / (double)displayDPI.x;
        PrintSettings scaledSettings = settings.clone();
        scaledSettings.setLeft(scaleFactor * scaledSettings.getLeft());
        scaledSettings.setRight(scaleFactor * scaledSettings.getRight());
        scaledSettings.setTop(scaleFactor * scaledSettings.getTop());
        scaledSettings.setBottom(scaleFactor * scaledSettings.getBottom());
        gc.setBackground(display.getSystemColor(1));
        gc.fillRectangle(canvasBounds);
        ImagePrintUtils.drawImage((Drawable)canvas, displayDPI, canvasBounds, image, display.getDPI(), scaledSettings);
        if (!printer.isDisposed()) {
            printer.dispose();
        }
    }
}

