import xfab
from xfab import sglib
import numpy as n
from re import sub
from string import lower

class sg:
	def __init__(self,sgno = None, sgname = None):
		if sgno != None:
			klass_name = "".join('sg%i' %sgno)
		elif sgname != None:
			klass_name = sgdic[lower(sub("\s+","",sgname))]
		if hasattr(xfab, 'sglib'):
			module = getattr(xfab, 'sglib')
			if hasattr(module, klass_name):
				klass  = getattr(module, klass_name)
			else:
				raise Exception("No " + klass_name + " class in sglib")
		else:
			raise Exception("sglib module cannot be reached")
	
		obj = klass()

		self.name = obj.name
		self.no = obj.no
		self.nsymop = obj.nsymop
		self.nuniq = obj.nuniq
		self.syscond = n.array(obj.syscond)
		self.rot = n.array(obj.rot)
		self.trans = n.array(obj.trans)


sgdic = {
         "p1" : "sg1",
         "p-1" : "sg2",
         "p2" : "sg3",
         "p21" : "sg4",
         "c2" : "sg5",
         "pm" : "sg6",
         "pc" : "sg7",
         "cm" : "sg8",
         "cc" : "sg9",
         "p2/m" : "sg10",
         "p21/m" : "sg11",
         "c2/m" : "sg12",
         "p2/c" : "sg13",
         "p21/c" : "sg14",
         "c2/c" : "sg15",
         "p222" : "sg16",
         "p2221" : "sg17",
         "p21212" : "sg18",
         "p212121" : "sg19",
         "c2221" : "sg20",
         "c222" : "sg21",
         "f222" : "sg22",
         "i222" : "sg23",
         "i212121" : "sg24",
         "pmm2" : "sg25",
         "pmc21" : "sg26",
         "pcc2" : "sg27",
         "pma2" : "sg28",
         "pca21" : "sg29",
         "pnc2" : "sg30",
         "pmn21" : "sg31",
         "pba2" : "sg32",
         "pna21" : "sg33",
         "pnn2" : "sg34",
         "cmm2" : "sg35",
         "cmc21" : "sg36",
         "ccc2" : "sg37",
         "amm2" : "sg38",
         "abm2" : "sg39",
         "ama2" : "sg40",
         "aba2" : "sg41",
         "fmm2" : "sg42",
         "fdd2" : "sg43",
         "imm2" : "sg44",
         "iba2" : "sg45",
         "ima2" : "sg46",
         "pmmm" : "sg47",
         "pnnn" : "sg48",
         "pccm" : "sg49",
         "pban" : "sg50",
         "pmma" : "sg51",
         "pnna" : "sg52",
         "pmna" : "sg53",
         "pcca" : "sg54",
         "pbam" : "sg55",
         "pccn" : "sg56",
         "pbcm" : "sg57",
         "pnnm" : "sg58",
         "pmmn" : "sg59",
         "pbcn" : "sg60",
         "pbca" : "sg61",
         "pnma" : "sg62",
         "cmcm" : "sg63",
         "cmca" : "sg64",
         "cmmm" : "sg65",
         "cccm" : "sg66",
         "cmma" : "sg67",
         "ccca" : "sg68",
         "fmmm" : "sg69",
         "fddd" : "sg70",
         "immm" : "sg71",
         "ibam" : "sg72",
         "ibca" : "sg73",
         "imma" : "sg74",
         "p4" : "sg75",
         "p41" : "sg76",
         "p42" : "sg77",
         "p43" : "sg78",
         "i4" : "sg79",
         "i41" : "sg80",
         "p-4" : "sg81",
         "i-4" : "sg82",
         "p4/m" : "sg83",
         "p42/m" : "sg84",
         "p4/n" : "sg85",
         "p42/n" : "sg86",
         "i4/m" : "sg87",
         "i41/a" : "sg88",
         "p422" : "sg89",
         "p4212" : "sg90",
         "p4122" : "sg91",
         "p41212" : "sg92",
         "p4222" : "sg93",
         "p42212" : "sg94",
         "p4322" : "sg95",
         "p43212" : "sg96",
         "i422" : "sg97",
         "i4122" : "sg98",
         "p4mm" : "sg99",
         "p4bm" : "sg100",
         "p42cm" : "sg101",
         "p42nm" : "sg102",
         "p4cc" : "sg103",
         "p4nc" : "sg104",
         "p42mc" : "sg105",
         "p42bc" : "sg106",
         "i4mm" : "sg107",
         "i4cm" : "sg108",
         "i41md" : "sg109",
         "i41cd" : "sg110",
         "p-42m" : "sg111",
         "p-42c" : "sg112",
         "p-421m" : "sg113",
         "p-421c" : "sg114",
         "p-4m2" : "sg115",
         "p-4c2" : "sg116",
         "p-4b2" : "sg117",
         "p-4n2" : "sg118",
         "i-4m2" : "sg119",
         "i-4c2" : "sg120",
         "i-42m" : "sg121",
         "i-42d" : "sg122",
         "p4/mmm" : "sg123",
         "p4/mcc" : "sg124",
         "p4/nbm" : "sg125",
         "p4/nnc" : "sg126",
         "p4/mbm" : "sg127",
         "p4/mnc" : "sg128",
         "p4/nmm" : "sg129",
         "p4/ncc" : "sg130",
         "p42/mmc" : "sg131",
         "p42/mcm" : "sg132",
         "p42/nbc" : "sg133",
         "p42/nnm" : "sg134",
         "p42/mbc" : "sg135",
         "p42/mnm" : "sg136",
         "p42/nmc" : "sg137",
         "p42/ncm" : "sg138",
         "i4/mmm" : "sg139",
         "i4/mcm" : "sg140",
         "i41/amd" : "sg141",
         "i41/acd" : "sg142",
         "p3" : "sg143",
         "p31" : "sg144",
         "p32" : "sg145",
         "r3" : "sg146",
         "p-3" : "sg147",
         "r-3" : "sg148",
         "p312" : "sg149",
         "p321" : "sg150",
         "p3112" : "sg151",
         "p3121" : "sg152",
         "p3212" : "sg153",
         "p3221" : "sg154",
         "r32" : "sg155",
         "p3m1" : "sg156",
         "p31m" : "sg157",
         "p3c1" : "sg158",
         "p31c" : "sg159",
         "r3m" : "sg160",
         "r3c" : "sg161",
         "p-31m" : "sg162",
         "p-31c" : "sg163",
         "p-3m1" : "sg164",
         "p-3c1" : "sg165",
         "r-3m" : "sg166",
         "r-3c" : "sg167",
         "p6" : "sg168",
         "p61" : "sg169",
         "p65" : "sg170",
         "p62" : "sg171",
         "p64" : "sg172",
         "p63" : "sg173",
         "p-6" : "sg174",
         "p6/m" : "sg175",
         "p63/m" : "sg176",
         "p622" : "sg177",
         "p6122" : "sg178",
         "p6522" : "sg179",
         "p6222" : "sg180",
         "p6422" : "sg181",
         "p6322" : "sg182",
         "p6mm" : "sg183",
         "p6cc" : "sg184",
         "p63cm" : "sg185",
         "p63mc" : "sg186",
         "p-6m2" : "sg187",
         "p-6c2" : "sg188",
         "p-62m" : "sg189",
         "p-62c" : "sg190",
         "p6/mmm" : "sg191",
         "p6/mcc" : "sg192",
         "p63/mcm" : "sg193",
         "p63/mmc" : "sg194",
         "p23" : "sg195",
         "f23" : "sg196",
         "i23" : "sg197",
         "p213" : "sg198",
         "i213" : "sg199",
         "pm-3" : "sg200",
         "pn-3" : "sg201",
         "fm-3" : "sg202",
         "fd-3" : "sg203",
         "im-3" : "sg204",
         "pa-3" : "sg205",
         "ia-3" : "sg206",
         "p432" : "sg207",
         "p4232" : "sg208",
         "f432" : "sg209",
         "f4132" : "sg210",
         "i432" : "sg211",
         "p4332" : "sg212",
         "p4132" : "sg213",
         "i4132" : "sg214",
         "p-43m" : "sg215",
         "f-43m" : "sg216",
         "i-43m" : "sg217",
         "p-43n" : "sg218",
         "f-43c" : "sg219",
         "i-43d" : "sg220",
         "pm-3m" : "sg221",
         "pn-3n" : "sg222",
         "pm-3n" : "sg223",
         "pn-3m" : "sg224",
         "fm-3m" : "sg225",
         "fm-3c" : "sg226",
         "fd-3m" : "sg227",
         "fd-3c" : "sg228",
         "im-3m" : "sg229",
         "ia-3d" : "sg230",
        }
