/**
 * 
 */
package fable.framework.navigator.controller;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

import fable.framework.navigator.toolBox.IVarKeys;
import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.Sample;
import fable.framework.toolbox.SampleException;

/**
 * @author suchet
 * 
 */
public class SampleController implements IPropertyChangeListener {

	/**
	 * class to register listeners for a specific sample name
	 * 
	 * @author andy
	 * 
	 */
	/*
	 * class SampleChangeListener { String sampleName; IPropertyChangeListener
	 * listener;
	 * 
	 * SampleChangeListener(String _name, IPropertyChangeListener _listener) {
	 * sampleName = _name; listener = _listener; } }
	 */
	private Vector<Sample> vSample = new Vector<Sample>();
	private static SampleController controller;
	// private ISampleAdapter sampleListener;
	private Sample sample; // active view ; current sample
	private ArrayList<IPropertyChangeListener> myListeners;
	private FabioFile currentFile;
	private int currentIndex;

	private SampleController() {

		vSample = new Vector<Sample>();
		myListeners = new ArrayList<IPropertyChangeListener>();

	}

	public String[] getKeys() throws SampleException {
		String[] res = null;
		if (sample != null) {
			res = sample.getKeys();
		}
		return res;
	}

	public static SampleController getController() {
		if (controller == null) {
			controller = new SampleController();

		}
		return controller;

	}

	public void addSample(Sample s) {
		vSample.add(s);
		s.addPropertyChangeListener(this);

		fireAddSample();
		// 06/08/2008 for peakssptBy default, set this sample to current sample
		// !
		sample = s;
	}

	public void setCurrentSample(Sample s) {
		sample = s;
		// System.out.println("setCurrentSample(): set current sample to "+sample.get_name());
		fireCurrentSample(vSample.indexOf(sample));
	}

	public Sample getCurrentsample() {
		return sample;
	}

	public int getCurrentsampleIndex() {
		int i = 0;
		if (vSample != null && sample != null) {
			i = vSample.indexOf(sample);
		}
		return i;
	}

	public int getNumberOfSample() {
		return vSample.size();
	}

	public Sample getLastSample() {
		return vSample.lastElement();
	}

	public void removeSample(int index) {
		vSample.removeElementAt(index);
	}

	public void removeSample(Sample s) {
		fireSampleRemoved(s);
		vSample.remove(s);

	}

	public int getCurrentFileIndex() {
		return currentIndex;
	}

	/**
	 * 
	 * 23 oct. 07
	 * 
	 * @author G. Suchet
	 * @param index
	 *            edf index in sample
	 * @description set current file (selected in table for example)from current
	 *              sample
	 */
	public void setCurrentFileIndex(int index) {
		if (sample != null) {
			if (index >= 0 && index < sample.getFilteredfiles().size()) {
				currentIndex = index;
				currentFile = sample.getFilteredfiles().elementAt(index);
				sample.setCurrentFile(currentFile);
				fireCurrentFileHasChanged();
			}

		}
	}

	/**
	 * 
	 * 23 oct. 07
	 * 
	 * @author G. Suchet
	 * @return currentFile if exists, else if one sample at least exists, return
	 *         the first element of the last sample loaded
	 */
	public FabioFile getCurrentFile() {
		if (currentFile != null) {
			return currentFile;
		} else if (vSample != null && vSample.size() > 0) {
			Sample directory = vSample.lastElement();
			if (directory.getFabioFiles() != null
					&& directory.getFabioFiles().size() > 0) {
				return directory.getFabioFiles().firstElement();
			}
		}
		return null;
	}

	// --------- LISTENER -----------------------------------------------------
	public void addPropertyChangeListener(IPropertyChangeListener listener) {
		myListeners.add(listener);
	}

	public void removePropertyChangeListener(IPropertyChangeListener listener) {
		myListeners.remove(listener);
	}

	public synchronized void fireCurrentFileHasChanged() {
		for (Iterator<IPropertyChangeListener> iter = myListeners.iterator(); iter
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) iter
					.next();
			element.propertyChange(new PropertyChangeEvent(this,
					IVarKeys.SET_CURRENTFILE_EVENT, null, currentFile));
		}
	}

	/**
	 * Send an event to all listener to do something on the next image in a list
	 * if i > 0 or with the previous image if i < 0. See an example in
	 * <code>fable.peaksearch</code>.
	 */
	private void fireGetNext(int i) {
		for (Iterator<IPropertyChangeListener> iter = myListeners.iterator(); iter
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) iter
					.next();
			element.propertyChange(new PropertyChangeEvent(this,
					fable.framework.internal.IVarKeys.NEXTIMAGE, null, i));
		}

	}

	/**
	 * Send an event to all listener to do something on the first image in a
	 * list. See an example in <code>fable.peaksearch</code>.
	 */
	private void fireGetFirst() {
		for (Iterator<IPropertyChangeListener> iter = myListeners.iterator(); iter
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) iter
					.next();
			element.propertyChange(new PropertyChangeEvent(this,
					fable.framework.internal.IVarKeys.FIRSTIMAGE, null, null));
		}

	}

	/**
	 * Send an event to all listener to do something on the last image in a
	 * list. See an example in <code>fable.peaksearch</code>.
	 */
	private void fireGetLast() {
		for (Iterator<IPropertyChangeListener> iter = myListeners.iterator(); iter
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) iter
					.next();
			element.propertyChange(new PropertyChangeEvent(this,
					fable.framework.internal.IVarKeys.LASTIMAGE, null, null));
		}

	}

	public void fireSampleRemoved(Sample s) {
		for (Iterator<IPropertyChangeListener> iter = myListeners.iterator(); iter
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) iter
					.next();
			element.propertyChange(new PropertyChangeEvent(this,
					IVarKeys.REMOVE_SAMPLE_EVENT, null, s));

		}
	}

	public void fireCurrentSample(int index) {
		for (Iterator<IPropertyChangeListener> iter = myListeners.iterator(); iter
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) iter
					.next();
			element.propertyChange(new PropertyChangeEvent(this,
					IVarKeys.CURRENT_SAMPLE_EVENT, null, index));

		}

	}//

	public void fireAddSample() {
		for (Iterator<IPropertyChangeListener> iter = myListeners.iterator(); iter
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) iter
					.next();
			element.propertyChange(new PropertyChangeEvent(this,
					IVarKeys.NEW_SAMPLE_EVENT, null, vSample.lastElement()));

		}
	}

	public void fireUpdatePlot() {
		for (Iterator<IPropertyChangeListener> iter = myListeners.iterator(); iter
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) iter
					.next();
			element.propertyChange(new PropertyChangeEvent(this,
					IVarKeys.UPDATE_PLOT_EVENT, null, null));

		}
	}

	/**
	 * This event is sent if a sample has new files.
	 */
	public void fireUpdateFiles() {
		for (Iterator<IPropertyChangeListener> iter = myListeners.iterator(); iter
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) iter
					.next();
			element.propertyChange(new PropertyChangeEvent(this,
					IVarKeys.UPDATE_SAMPLEFILES_EVENT, null, vSample
							.lastElement()));

		}
	}

	public void propertyChange(PropertyChangeEvent event) {
		if (event.getProperty().equals("updateHeaderValues")) {
			fireUpdatePlot();
		} else if (event.getProperty().equals(
				fable.framework.internal.IVarKeys.UPDATEFILES_EVENT)) {
			fireUpdateFiles();
		}

	}

	/**
	 * return a regular expression to filter on all the file types supported by
	 * fabio (this should be done with preferences in the future) Gaelle : this
	 * list is now available in fable.framework.internal.IVarKeys
	 * 
	 * @return
	 */
	private static final String getSupportedFilesRegex() {
		/*
		 * file types support by fabio :
		 * 
		 * 'edf' : ['edf'], 'cor' : ['edf'], 'pnm' : ['pnm'], 'pgm' : ['pnm'],
		 * 'pbm' : ['pnm'], 'tif' : ['tif'], 'tiff' : ['tif'], 'img' :
		 * ['adsc','OXD'], 'mccd' : ['marccd'], 'mar2300': ['mar345'], 'sfrm' :
		 * ['bruker100'], 'msk' : ['fit2dmask'],
		 */
		final String edfFormat = ".*\\.edf", edfFormatGZip = ".*\\.edf\\.gz", edfFormatBz2 = ".*\\.edf\\.bz2";
		final String corFormat = ".*\\.cor", corFormatGZip = ".*\\.cor\\.gz", corFormatBz2 = ".*\\.cor\\.bz2";
		final String tifFormat = ".*\\.tif", tifFormatGZip = ".*\\.tif\\.gz", tifFormatBz2 = ".*\\.tif\\.bz2";
		final String tiffFormat = ".*\\.tiff", tiffFormatGZip = ".*\\.tiff\\.gz", tiffFormatBz2 = ".*\\.tiff\\.bz2";
		final String adscFormat = ".*\\.img", adscFormatGZip = ".*\\.img\\.gz", adscFormatBz2 = ".*\\.img\\.bz2";
		final String mccdFormat = ".*\\.mccd", mccdFormatGZip = ".*\\.mccd\\.gz", mccdFormatBz2 = ".*\\.mccd\\.bz2";
		final String mar2300Format = ".*\\.mccd", mar2300FormatGZip = ".*\\.mccd\\.gz", mar2300FormatBz2 = ".*\\.mccd\\.bz2";
		final String pnmFormat = ".*\\.pnm", pgmFormat = ".*\\.pgm", pbmFormat = ".*\\.pbm";
		final String brukerFormat = ".*\\.(\\d+)?", brukerFormatBz2 = ".*\\.(\\d+)?\\.bz2";
		String ProcessedFileRegex = edfFormat + "|" + edfFormatGZip + "|"
				+ edfFormatBz2;
		ProcessedFileRegex = ProcessedFileRegex + "|" + corFormat + "|"
				+ corFormatGZip + "|" + corFormatBz2;
		ProcessedFileRegex = ProcessedFileRegex + "|" + tifFormat + "|"
				+ tifFormatGZip + "|" + tifFormatBz2;
		ProcessedFileRegex = ProcessedFileRegex + "|" + tiffFormat + "|"
				+ tiffFormatGZip + "|" + tiffFormatBz2;
		ProcessedFileRegex = ProcessedFileRegex + "|" + adscFormat + "|"
				+ adscFormatGZip + "|" + adscFormatBz2;
		ProcessedFileRegex = ProcessedFileRegex + "|" + mccdFormat + "|"
				+ mccdFormatGZip + "|" + mccdFormatBz2;
		ProcessedFileRegex = ProcessedFileRegex + "|" + mar2300Format + "|"
				+ mar2300FormatGZip + "|" + mar2300FormatBz2;
		ProcessedFileRegex = ProcessedFileRegex + "|" + pnmFormat + "|"
				+ pgmFormat + "|" + pbmFormat;
		ProcessedFileRegex = ProcessedFileRegex + "|" + brukerFormat + "|"
				+ brukerFormatBz2;
		return ProcessedFileRegex;
	}

	public Vector<Sample> getSamples() {
		return vSample;
	}

	/**
	 * 
	 * @param i
	 *            1 to get next image or -1 to get previous image
	 */
	public void getNext(int i) {
		fireGetNext(i);

	}

	/**
	 * Send an event to all <code>SampleController</code> listener to do
	 * something with the first image. See example in <code>PeaksSptView</code>.
	 */
	public void getFirstImage() {
		fireGetFirst();
	}

	/**
	 * Send an event to all <code>SampleController</code> listener to do
	 * something with the last image. See example in <code>PeaksSptView</code>.
	 */
	public void getLastImage() {
		fireGetLast();
	}
}