/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.jep.FableJep;
import fable.framework.toolbox.FabioFileException;
import fable.framework.toolbox.ToolBox;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class FabioFile
implements Comparable<Object>,
IPropertyChangeListener {
    private Semaphore semaphore = new Semaphore(1);
    public boolean headerRead = false;
    public boolean imageRead = false;
    private HashMap<String, String> header;
    private String fullFileName;
    private String fileName;
    private Vector<String> vKeysInHeader;
    private int width;
    private int height;
    private float minimum = Float.MAX_VALUE;
    private float maximum = Float.MIN_VALUE;
    private float sum = 0.0f;
    private float mean = Float.MIN_VALUE;
    private float stddev = Float.MIN_VALUE;
    private int floatImageBufferI = 0;
    private long timeToReadImage = 0L;
    private String stem;
    private String fileNumber;
    ImageLoader loader;
    ImageData[] imageDataArray;
    Logger logger = Logger.getLogger(FabioFile.class);
    private int index;
    private boolean flag = true;
    private static float[][] floatImageBuffer = new float[10][];
    private static int floatImageBufferPointer = 0;
    private static String[] fileImageBuffer = new String[10];
    private String comparatorKey = "filename";
    private int comparatorDir = 1024;
    private int comparedResult;

    public FabioFile(String _fullFileName) throws FabioFileException {
        if (!new File(_fullFileName).exists()) {
            throw new FabioFileException(this.getClass().getName(), "FabioFile", "File not found: " + _fullFileName);
        }
        this.headerRead = false;
        this.header = new HashMap();
        this.vKeysInHeader = new Vector();
        this.fullFileName = _fullFileName;
        String[] split = this.fullFileName.split("[\\\\/]");
        this.fileName = this.fullFileName;
        if (split.length > 1) {
            this.fileName = split[split.length - 1];
        }
    }

    public synchronized void acquire() {
        this.semaphore.acquireUninterruptibly();
    }

    public synchronized void release() {
        this.semaphore.release();
    }

    private void importFabioModules(Jep jep) throws JepException {
        FableJep.jepImportModules(jep, "sys");
        FableJep.jepImportModules(jep, "numpy");
        FableJep.jepImportModules(jep, "PIL");
        FableJep.jepImportModules(jep, "fabio.openimage");
    }

    public void setFullFileName(String fullfilename) {
        this.fullFileName = fullfilename;
    }

    public String getFullFileName() {
        return this.fullFileName;
    }

    public String toString() {
        if (!this.headerRead) {
            try {
                this.loadHeader();
            }
            catch (FabioFileException fabioFileException) {}
        }
        String myString = "{ \\n";
        Set<Map.Entry<String, String>> mySet = this.header.entrySet();
        for (Map.Entry<String, String> entry : mySet) {
            myString = String.valueOf(myString) + entry.getKey() + "=" + entry.getValue() + ";\\n";
        }
        myString = String.valueOf(myString) + "} \\n";
        return myString;
    }

    public void loadHeader() throws FabioFileException {
        if (!this.headerRead) {
            try {
                this.loadHeader(FableJep.getFableJep());
            }
            catch (JepException e) {
                throw new FabioFileException(this.getClass().getName(), "loadHeader" + this.fullFileName, e.getMessage());
            }
        }
    }

    public synchronized void loadHeader(FableJep fableJep) throws FabioFileException {
        if (!this.headerRead) {
            this.acquire();
            File f = new File(this.fullFileName);
            if (f.exists()) {
                try {
                    this.importFabioModules(fableJep.getJep());
                    fableJep.set("filename", this.fullFileName);
                    fableJep.eval("im = fabio.openimage.openheader(filename)");
                    fableJep.eval("keys = im.header.keys()");
                    fableJep.eval("vals = im.header.values()");
                    fableJep.eval("res = len(keys)");
                    int n = (Integer)fableJep.getValue("res");
                    this.header = new HashMap();
                    int i = 0;
                    while (i < n) {
                        fableJep.set("i", i);
                        fableJep.eval("res = str(keys[i])");
                        String key = (String)fableJep.getValue("res");
                        fableJep.eval("res = str(vals[i])");
                        String val = (String)fableJep.getValue("res");
                        this.header.put(key, val);
                        this.vKeysInHeader.add(key);
                        ++i;
                    }
                    this.addHeaderInfo("name", this.fileName);
                    this.addHeaderInfo("#", "" + this.index);
                    this.headerRead = true;
                }
                catch (JepException e) {
                    this.release();
                    this.logger.error((Object)e.getMessage());
                    throw new FabioFileException(this.getClass().getName(), "loadHeader" + this.fullFileName, e.getMessage());
                }
            } else {
                this.release();
                throw new FabioFileException(this.getClass().getName(), "loadHeader", "File not found" + this.fullFileName);
            }
            this.release();
        }
    }

    public void addHeaderInfo(String key, String value) {
        this.header.put(key, value);
    }

    public String[] getKeys() throws FabioFileException, JepException {
        if (!this.headerRead) {
            this.loadHeader();
        }
        Set<String> mySet = this.header.keySet();
        String[] keys = mySet.toArray(new String[mySet.size()]);
        ToolBox.quicksort(keys, 0, keys.length);
        return keys;
    }

    public Vector<String> getKeysAsListedInHeader() throws FabioFileException, JepException {
        if (!this.headerRead) {
            this.loadHeader();
        }
        return this.vKeysInHeader;
    }

    public String getValue(String key) throws FabioFileException {
        if (!this.headerRead) {
            this.loadHeader();
        }
        String myValue = "";
        if (!this.header.containsKey(key)) {
            throw new FabioFileException(this.getClass().getName(), "getValue()", "The key " + key + " has not be found in the header for the file " + this.fileName);
        }
        myValue = this.header.get(key);
        return myValue;
    }

    public void addIndex(int index) {
        this.index = index;
    }

    public String getFullFilename() {
        return this.fullFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getTimeToReadImage() {
        return this.timeToReadImage;
    }

    /*
     * Unable to fully structure code
     */
    public String getStems() {
        if (this.stem == null) {
            block7: {
                s = null;
                splitter = this.fileName.split("\\.");
                s = this.fileName;
                if (splitter != null && splitter.length >= 2) {
                    ext = splitter[1];
                    try {
                        Integer.valueOf(ext);
                        index = this.fileName.indexOf(".");
                        s = this.fileName.substring(0, index);
                        break block7;
                    }
                    catch (NumberFormatException v0) {
                        j = splitter[0].length() - 1;
                        ** while (j > 1)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Integer.valueOf(splitter[0].substring(j - 1, j));
                            --j;
                        }
                        catch (NumberFormatException v1) {
                            s = splitter[0].substring(0, j);
                            j = 0;
                        }
                        continue;
                    }
                }
            }
            this.stem = s;
        }
        return this.stem;
    }

    /*
     * Unable to fully structure code
     */
    public String getFileNumber() {
        if (this.fileNumber == null) {
            block7: {
                s = null;
                splitter = this.fileName.split("\\.");
                s = this.fileName;
                if (splitter != null && splitter.length >= 2) {
                    ext = splitter[1];
                    try {
                        Integer.valueOf(ext);
                        s = ext;
                        break block7;
                    }
                    catch (NumberFormatException v0) {
                        j = splitter[0].length() - 1;
                        ** while (j > 1)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Integer.valueOf(splitter[0].substring(j - 1, j));
                            --j;
                        }
                        catch (NumberFormatException v1) {
                            s = splitter[0].substring(j, splitter[0].length());
                            j = 0;
                        }
                        continue;
                    }
                }
            }
            this.fileNumber = s;
        }
        return this.fileNumber;
    }

    public int getWidth() throws JepException {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.width;
    }

    public int getHeight() throws JepException {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.height;
    }

    public int getBytesPerPixel() {
        return 2;
    }

    public void readImage() throws JepException {
        this.readImageAsFloat();
    }

    public void readImageAsFloat() throws JepException {
        this.readImageAsFloat(FableJep.getFableJep());
    }

    public synchronized void readImageAsFloat(FableJep fableJep) {
        boolean fileCached = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            fileCached = true;
        }
        this.timeToReadImage = 0L;
        if (!fileCached) {
            try {
                long before = System.currentTimeMillis();
                this.importFabioModules(fableJep.getJep());
                fableJep.set("filename", this.fullFileName);
                fableJep.eval("im = fabio.openimage.openimage(filename)");
                fableJep.eval("res = im.data.astype(numpy.float32).tostring()");
                FabioFile.floatImageBuffer[FabioFile.floatImageBufferPointer] = fableJep.getValue_floatarray("res");
                this.floatImageBufferI = floatImageBufferPointer;
                FabioFile.fileImageBuffer[FabioFile.floatImageBufferPointer] = this.fullFileName;
                this.incrementBufferPointer();
                fableJep.eval("res = im.dim1");
                this.width = (Integer)fableJep.getValue("res");
                fableJep.eval("res = im.dim2");
                this.height = (Integer)fableJep.getValue("res");
                if (this.minimum == Float.MAX_VALUE || this.maximum == Float.MIN_VALUE) {
                    long before_get = System.currentTimeMillis();
                    this.sum = 0.0f;
                    int i = 0;
                    while (i < floatImageBuffer[this.floatImageBufferI].length) {
                        this.sum += floatImageBuffer[this.floatImageBufferI][i];
                        if (floatImageBuffer[this.floatImageBufferI][i] < this.minimum) {
                            this.minimum = floatImageBuffer[this.floatImageBufferI][i];
                        }
                        if (floatImageBuffer[this.floatImageBufferI][i] > this.maximum) {
                            this.maximum = floatImageBuffer[this.floatImageBufferI][i];
                        }
                        ++i;
                    }
                    this.mean = this.sum / (float)floatImageBuffer[this.floatImageBufferI].length;
                    long cfr_ignored_0 = System.currentTimeMillis() - before_get;
                }
                this.timeToReadImage = System.currentTimeMillis() - before;
                this.imageRead = true;
            }
            catch (JepException j) {
                j.printStackTrace();
            }
        }
    }

    private void incrementBufferPointer() {
        if (++floatImageBufferPointer >= floatImageBuffer.length) {
            floatImageBufferPointer = 0;
        }
    }

    public float[] getImageAsFloat() throws JepException {
        boolean fileCached = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            fileCached = true;
        }
        this.timeToReadImage = 0L;
        if (!fileCached) {
            this.readImageAsFloat();
        }
        return floatImageBuffer[this.floatImageBufferI];
    }

    public float[] getImageAsFloat(FableJep jep) {
        boolean fileCached = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            fileCached = true;
        }
        this.timeToReadImage = 0L;
        if (!fileCached) {
            this.readImageAsFloat(jep);
        }
        return floatImageBuffer[this.floatImageBufferI];
    }

    public int[] getImageAsInt() throws JepException {
        boolean fileCached = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            fileCached = true;
        }
        this.timeToReadImage = 0L;
        if (!fileCached) {
            this.readImageAsFloat();
        }
        int[] _imageAsInt = new int[this.getWidth() * this.getHeight()];
        int i = 0;
        while (i < floatImageBuffer[this.floatImageBufferI].length) {
            _imageAsInt[i] = (int)floatImageBuffer[this.floatImageBufferI][i];
            ++i;
        }
        return _imageAsInt;
    }

    public float getMinimum() throws JepException {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.minimum;
    }

    public float getMaximum() throws JepException {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.maximum;
    }

    public float getMean() throws JepException {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.mean;
    }

    public void setFlag(boolean b) {
        this.flag = b;
    }

    public boolean getFlag() {
        return this.flag;
    }

    @Override
    public int compareTo(Object other) {
        try {
            String valueOther = ((FabioFile)other).getValue(this.comparatorKey);
            String valueThis = this.getValue(this.comparatorKey);
            this.comparedResult = this.comparatorDir == 128 ? valueOther.compareTo(valueThis) : valueThis.compareTo(valueOther);
        }
        catch (FabioFileException e) {
            this.logger.error((Object)e.getMessage());
        }
        return this.comparedResult;
    }

    public int compareTo(String key, Object other) {
        this.comparatorKey = key;
        return this.compareTo(other);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("comparator")) {
            this.comparatorKey = (String)event.getNewValue();
        } else if (event.getProperty().equals("dir")) {
            this.comparatorDir = (Integer)event.getNewValue();
        }
    }
}

