/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.DeltaProcessingState;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class ExternalFoldersManager {
    private static final boolean DEBUG = false;
    private static final String EXTERNAL_PROJECT_NAME = ".org.eclipse.jdt.core.external.folders";
    private static final String LINKED_FOLDER_NAME = ".link";
    private HashMap folders;
    private int counter = 0;

    public static HashSet getExternalFolders(IClasspathEntry[] classpath) {
        if (classpath == null) {
            return null;
        }
        HashSet<IPath> folders = null;
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 1) {
                IPath attachmentPath;
                IPath entryPath = entry.getPath();
                if (ExternalFoldersManager.isExternalFolderPath(entryPath)) {
                    if (folders == null) {
                        folders = new HashSet<IPath>();
                    }
                    folders.add(entryPath);
                }
                if (ExternalFoldersManager.isExternalFolderPath(attachmentPath = entry.getSourceAttachmentPath())) {
                    if (folders == null) {
                        folders = new HashSet();
                    }
                    folders.add(attachmentPath);
                }
            }
            ++i;
        }
        return folders;
    }

    public static boolean isExternalFolderPath(IPath externalPath) {
        if (externalPath == null) {
            return false;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().getProject(externalPath.segment(0)).exists()) {
            return false;
        }
        File externalFolder = externalPath.toFile();
        if (externalFolder.isFile()) {
            return false;
        }
        return externalPath.getFileExtension() == null || externalFolder.exists();
    }

    public static boolean isInternalPathForExternalFolder(IPath resourcePath) {
        return EXTERNAL_PROJECT_NAME.equals(resourcePath.segment(0));
    }

    public IFolder addFolder(IPath externalFolderPath) {
        return this.addFolder(externalFolderPath, this.getExternalFoldersProject());
    }

    private synchronized IFolder addFolder(IPath externalFolderPath, IProject externalFoldersProject) {
        IFolder result;
        HashMap knownFolders = this.getFolders();
        Object existing = knownFolders.get(externalFolderPath);
        if (existing != null) {
            return (IFolder)existing;
        }
        while ((result = externalFoldersProject.getFolder(LINKED_FOLDER_NAME + this.counter++)).exists()) {
        }
        knownFolders.put(externalFolderPath, result);
        return result;
    }

    public IFolder createLinkFolder(IPath externalFolderPath, boolean refreshIfExistAlready, IProgressMonitor monitor) throws CoreException {
        IProject externalFoldersProject = this.createExternalFoldersProject(monitor);
        IFolder result = this.addFolder(externalFolderPath, externalFoldersProject);
        if (!result.exists()) {
            result.createLink(externalFolderPath, 16, monitor);
        } else if (refreshIfExistAlready) {
            result.refreshLocal(2, monitor);
        }
        return result;
    }

    public synchronized void cleanUp(IProgressMonitor monitor) throws CoreException {
        DeltaProcessingState state = JavaModelManager.getDeltaState();
        HashMap roots = state.roots;
        HashMap sourceAttachments = state.sourceAttachments;
        if (roots == null && sourceAttachments == null) {
            return;
        }
        HashMap knownFolders = this.getFolders();
        Iterator iterator = knownFolders.keySet().iterator();
        while (iterator.hasNext()) {
            IFolder folder;
            IPath path = (IPath)iterator.next();
            if (roots == null || roots.containsKey(path) || sourceAttachments == null || sourceAttachments.containsKey(path) || (folder = (IFolder)knownFolders.get(path)) == null) continue;
            folder.delete(true, monitor);
        }
        IProject project = this.getExternalFoldersProject();
        if (project.isAccessible() && project.members().length == 1) {
            project.delete(true, monitor);
        }
    }

    public IProject getExternalFoldersProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(EXTERNAL_PROJECT_NAME);
    }

    private IProject createExternalFoldersProject(IProgressMonitor monitor) {
        IProject project = this.getExternalFoldersProject();
        if (!project.isAccessible()) {
            try {
                if (!project.exists()) {
                    IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                    IPath stateLocation = JavaCore.getPlugin().getStateLocation();
                    desc.setLocation(stateLocation.append(EXTERNAL_PROJECT_NAME));
                    project.create(desc, 4096, monitor);
                }
                try {
                    project.open(monitor);
                }
                catch (CoreException coreException) {
                    IPath stateLocation = JavaCore.getPlugin().getStateLocation();
                    IPath projectPath = stateLocation.append(EXTERNAL_PROJECT_NAME);
                    projectPath.toFile().mkdirs();
                    FileOutputStream output = new FileOutputStream(projectPath.append(".project").toOSString());
                    try {
                        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>.org.eclipse.jdt.core.external.folders</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t</buildSpec>\n\t<natures>\n\t</natures>\n</projectDescription>".getBytes());
                    }
                    finally {
                        output.close();
                    }
                    project.open(null);
                }
            }
            catch (CoreException e) {
                Util.log(e, "Problem creating hidden project for external folders");
                return project;
            }
            catch (IOException e) {
                Util.log(e, "Problem creating hidden project for external folders");
                return project;
            }
        }
        return project;
    }

    public synchronized IFolder getFolder(IPath externalFolderPath) {
        return (IFolder)this.getFolders().get(externalFolderPath);
    }

    private HashMap getFolders() {
        if (this.folders == null) {
            this.folders = new HashMap();
            IProject project = this.getExternalFoldersProject();
            if (project.isAccessible()) {
                try {
                    IResource[] members = project.members();
                    int i = 0;
                    int length = members.length;
                    while (i < length) {
                        IResource member = members[i];
                        if (member.getType() == 2 && member.isLinked() && member.getName().startsWith(LINKED_FOLDER_NAME)) {
                            IPath externalFolderPath = member.getLocation();
                            this.folders.put(externalFolderPath, member);
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    Util.log(e, "Exception while initializing external folders");
                }
            }
        }
        return this.folders;
    }

    public void refreshReferences(IProject source, IProgressMonitor monitor) {
        IProject externalProject = this.getExternalFoldersProject();
        if (source.equals((Object)externalProject)) {
            return;
        }
        if (!JavaProject.hasJavaNature(source)) {
            return;
        }
        try {
            HashSet externalFolders = ExternalFoldersManager.getExternalFolders(((JavaProject)JavaCore.create(source)).getResolvedClasspath());
            if (externalFolders == null) {
                return;
            }
            final Iterator iterator = externalFolders.iterator();
            Job refreshJob = new Job(Messages.refreshing_external_folders){

                public boolean belongsTo(Object family) {
                    return family == ResourcesPlugin.FAMILY_MANUAL_REFRESH;
                }

                protected IStatus run(IProgressMonitor pm) {
                    try {
                        while (iterator.hasNext()) {
                            IPath externalPath = (IPath)iterator.next();
                            IFolder folder = ExternalFoldersManager.this.getFolder(externalPath);
                            if (folder == null) continue;
                            folder.refreshLocal(2, pm);
                        }
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            refreshJob.schedule();
        }
        catch (CoreException e) {
            Util.log(e, "Exception while refreshing external project");
        }
    }

    public synchronized IFolder removeFolder(IPath externalFolderPath) {
        return (IFolder)this.getFolders().remove(externalFolderPath);
    }
}

