/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.AnnotationInfo;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.ImportContainer;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.ImportDeclarationElementInfo;
import org.eclipse.jdt.internal.core.Initializer;
import org.eclipse.jdt.internal.core.InitializerElementInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.MemberValuePair;
import org.eclipse.jdt.internal.core.PackageDeclaration;
import org.eclipse.jdt.internal.core.SourceAnnotationMethodInfo;
import org.eclipse.jdt.internal.core.SourceConstructorInfo;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.SourceMethodInfo;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.SourceRefElementInfo;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.TypeParameterElementInfo;
import org.eclipse.jdt.internal.core.util.ReferenceInfoAdapter;
import org.eclipse.jdt.internal.core.util.Util;

public class CompilationUnitStructureRequestor
extends ReferenceInfoAdapter
implements ISourceElementRequestor {
    protected ICompilationUnit unit;
    protected CompilationUnitElementInfo unitInfo;
    protected JavaElementInfo importContainerInfo = null;
    protected Map newElements;
    protected Stack infoStack;
    protected HashMap children;
    protected Stack handleStack;
    protected int referenceCount = 0;
    protected boolean hasSyntaxErrors = false;
    protected Parser parser;
    protected static byte[] NO_BYTES = new byte[0];
    protected HashtableOfObject fieldRefCache;
    protected HashtableOfObject messageRefCache;
    protected HashtableOfObject typeRefCache;
    protected HashtableOfObject unknownRefCache;

    protected CompilationUnitStructureRequestor(ICompilationUnit unit, CompilationUnitElementInfo unitInfo, Map newElements) {
        this.unit = unit;
        this.unitInfo = unitInfo;
        this.newElements = newElements;
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[][] tokens, boolean onDemand, int modifiers) {
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        if (parentHandle.getElementType() != 5) {
            Assert.isTrue((boolean)false);
        }
        ICompilationUnit parentCU = (ICompilationUnit)((Object)parentHandle);
        ImportContainer importContainer = this.createImportContainer(parentCU);
        if (this.importContainerInfo == null) {
            this.importContainerInfo = new JavaElementInfo();
            JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
            this.addToChildren(parentInfo, importContainer);
            this.newElements.put(importContainer, this.importContainerInfo);
        }
        String elementName = JavaModelManager.getJavaModelManager().intern(new String(CharOperation.concatWith(tokens, '.')));
        ImportDeclaration handle = this.createImportDeclaration(importContainer, elementName, onDemand);
        this.resolveDuplicates(handle);
        ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        info.setFlags(modifiers);
        this.addToChildren(this.importContainerInfo, handle);
        this.newElements.put(handle, info);
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptPackage(ImportReference importReference) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        PackageDeclaration handle = null;
        if (parentHandle.getElementType() == 5) {
            char[] name = CharOperation.concatWith(importReference.getImportName(), '.');
            handle = this.createPackageDeclaration(parentHandle, new String(name));
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(handle);
        AnnotatableInfo info = new AnnotatableInfo();
        info.setSourceRangeStart(importReference.declarationSourceStart);
        info.setSourceRangeEnd(importReference.declarationSourceEnd);
        this.addToChildren(parentInfo, handle);
        this.newElements.put(handle, info);
        if (importReference.annotations != null) {
            int i = 0;
            int length = importReference.annotations.length;
            while (i < length) {
                org.eclipse.jdt.internal.compiler.ast.Annotation annotation = importReference.annotations[i];
                this.enterAnnotation(annotation, info, handle);
                this.exitMember(annotation.declarationSourceEnd);
                ++i;
            }
        }
    }

    public void acceptProblem(CategorizedProblem problem) {
        if ((problem.getID() & 0x40000000) != 0) {
            this.hasSyntaxErrors = true;
        }
    }

    private void addToChildren(JavaElementInfo parentInfo, JavaElement handle) {
        ArrayList<JavaElement> childrenList = (ArrayList<JavaElement>)this.children.get(parentInfo);
        if (childrenList == null) {
            childrenList = new ArrayList<JavaElement>();
            this.children.put(parentInfo, childrenList);
        }
        childrenList.add(handle);
    }

    protected Annotation createAnnotation(JavaElement parent, String name) {
        return new Annotation(parent, name);
    }

    protected SourceField createField(JavaElement parent, ISourceElementRequestor.FieldInfo fieldInfo) {
        String fieldName = JavaModelManager.getJavaModelManager().intern(new String(fieldInfo.name));
        return new SourceField(parent, fieldName);
    }

    protected ImportContainer createImportContainer(ICompilationUnit parent) {
        return (ImportContainer)parent.getImportContainer();
    }

    protected ImportDeclaration createImportDeclaration(ImportContainer parent, String name, boolean onDemand) {
        return new ImportDeclaration(parent, name, onDemand);
    }

    protected Initializer createInitializer(JavaElement parent) {
        return new Initializer(parent, 1);
    }

    protected SourceMethod createMethod(JavaElement parent, ISourceElementRequestor.MethodInfo methodInfo) {
        String selector = JavaModelManager.getJavaModelManager().intern(new String(methodInfo.name));
        String[] parameterTypeSigs = CompilationUnitStructureRequestor.convertTypeNamesToSigs(methodInfo.parameterTypes);
        return new SourceMethod(parent, selector, parameterTypeSigs);
    }

    protected PackageDeclaration createPackageDeclaration(JavaElement parent, String name) {
        return new PackageDeclaration((CompilationUnit)parent, name);
    }

    protected SourceType createType(JavaElement parent, ISourceElementRequestor.TypeInfo typeInfo) {
        String nameString = new String(typeInfo.name);
        return new SourceType(parent, nameString);
    }

    protected TypeParameter createTypeParameter(JavaElement parent, String name) {
        return new TypeParameter(parent, name);
    }

    protected static String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return CharOperation.NO_STRINGS;
        }
        int n = typeNames.length;
        if (n == 0) {
            return CharOperation.NO_STRINGS;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            typeSigs[i] = manager.intern(Signature.createTypeSignature(typeNames[i], false));
            ++i;
        }
        return typeSigs;
    }

    protected IAnnotation enterAnnotation(org.eclipse.jdt.internal.compiler.ast.Annotation annotation, AnnotatableInfo parentInfo, JavaElement parentHandle) {
        String nameString = new String(CharOperation.concatWith(annotation.type.getTypeName(), '.'));
        Annotation handle = this.createAnnotation(parentHandle, nameString);
        this.resolveDuplicates(handle);
        AnnotationInfo info = new AnnotationInfo();
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
        info.setSourceRangeStart(annotation.sourceStart());
        info.nameStart = annotation.type.sourceStart();
        info.nameEnd = annotation.type.sourceEnd();
        org.eclipse.jdt.internal.compiler.ast.MemberValuePair[] memberValuePairs = annotation.memberValuePairs();
        int membersLength = memberValuePairs.length;
        info.members = membersLength == 0 ? Annotation.NO_MEMBER_VALUE_PAIRS : this.getMemberValuePairs(memberValuePairs);
        if (parentInfo != null) {
            IAnnotation[] annotations = parentInfo.annotations;
            int length = annotations.length;
            IAnnotation[] iAnnotationArray = annotations;
            annotations = new IAnnotation[length + 1];
            System.arraycopy(iAnnotationArray, 0, annotations, 0, length);
            annotations[length] = handle;
            parentInfo.annotations = annotations;
        }
        return handle;
    }

    public void enterCompilationUnit() {
        this.infoStack = new Stack();
        this.children = new HashMap();
        this.handleStack = new Stack();
        this.infoStack.push(this.unitInfo);
        this.handleStack.push(this.unit);
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterMethod(methodInfo);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        SourceTypeElementInfo parentInfo = (SourceTypeElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceField handle = null;
        if (parentHandle.getElementType() == 7) {
            handle = this.createField(parentHandle, fieldInfo);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setNameSourceStart(fieldInfo.nameSourceStart);
        info.setNameSourceEnd(fieldInfo.nameSourceEnd);
        info.setSourceRangeStart(fieldInfo.declarationStart);
        info.setFlags(fieldInfo.modifiers);
        char[] typeName = JavaModelManager.getJavaModelManager().intern(fieldInfo.type);
        info.setTypeName(typeName);
        this.addToChildren(parentInfo, handle);
        parentInfo.addCategories(handle, fieldInfo.categories);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
        if (fieldInfo.annotations != null) {
            int length = fieldInfo.annotations.length;
            this.unitInfo.annotationNumber += length;
            int i = 0;
            while (i < length) {
                org.eclipse.jdt.internal.compiler.ast.Annotation annotation = fieldInfo.annotations[i];
                this.enterAnnotation(annotation, info, handle);
                this.exitMember(annotation.declarationSourceEnd);
                ++i;
            }
        }
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        Initializer handle = null;
        if (parentHandle.getElementType() == 7) {
            handle = this.createInitializer(parentHandle);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(handle);
        InitializerElementInfo info = new InitializerElementInfo();
        info.setSourceRangeStart(declarationSourceStart);
        info.setFlags(modifiers);
        this.addToChildren(parentInfo, handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        char[] cArray;
        SourceTypeElementInfo parentInfo = (SourceTypeElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceMethod handle = null;
        if (methodInfo.parameterTypes == null) {
            methodInfo.parameterTypes = CharOperation.NO_CHAR_CHAR;
        }
        if (methodInfo.parameterNames == null) {
            methodInfo.parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        if (methodInfo.exceptionTypes == null) {
            methodInfo.exceptionTypes = CharOperation.NO_CHAR_CHAR;
        }
        if (parentHandle.getElementType() == 7) {
            handle = this.createMethod(parentHandle, methodInfo);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(handle);
        SourceMethodElementInfo info = methodInfo.isConstructor ? new SourceConstructorInfo() : (methodInfo.isAnnotation ? new SourceAnnotationMethodInfo() : new SourceMethodInfo());
        info.setSourceRangeStart(methodInfo.declarationStart);
        int flags = methodInfo.modifiers;
        info.setNameSourceStart(methodInfo.nameSourceStart);
        info.setNameSourceEnd(methodInfo.nameSourceEnd);
        info.setFlags(flags);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        char[][] parameterNames = methodInfo.parameterNames;
        int i = 0;
        int length = parameterNames.length;
        while (i < length) {
            parameterNames[i] = manager.intern(parameterNames[i]);
            ++i;
        }
        info.setArgumentNames(parameterNames);
        if (methodInfo.returnType == null) {
            char[] cArray2 = new char[4];
            cArray2[0] = 118;
            cArray2[1] = 111;
            cArray2[2] = 105;
            cArray = cArray2;
            cArray2[3] = 100;
        } else {
            cArray = methodInfo.returnType;
        }
        char[] returnType = cArray;
        info.setReturnType(manager.intern(returnType));
        char[][] exceptionTypes = methodInfo.exceptionTypes;
        info.setExceptionTypeNames(exceptionTypes);
        int i2 = 0;
        int length2 = exceptionTypes.length;
        while (i2 < length2) {
            exceptionTypes[i2] = manager.intern(exceptionTypes[i2]);
            ++i2;
        }
        this.addToChildren(parentInfo, handle);
        parentInfo.addCategories(handle, methodInfo.categories);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
        if (methodInfo.typeParameters != null) {
            i2 = 0;
            length2 = methodInfo.typeParameters.length;
            while (i2 < length2) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = methodInfo.typeParameters[i2];
                this.enterTypeParameter(typeParameterInfo);
                this.exitMember(typeParameterInfo.declarationEnd);
                ++i2;
            }
        }
        if (methodInfo.annotations != null) {
            int length3 = methodInfo.annotations.length;
            this.unitInfo.annotationNumber += length3;
            int i3 = 0;
            while (i3 < length3) {
                org.eclipse.jdt.internal.compiler.ast.Annotation annotation = methodInfo.annotations[i3];
                this.enterAnnotation(annotation, info, handle);
                this.exitMember(annotation.declarationSourceEnd);
                ++i3;
            }
        }
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceType handle = this.createType(parentHandle, typeInfo);
        this.resolveDuplicates(handle);
        SourceTypeElementInfo info = typeInfo.anonymousMember ? new SourceTypeElementInfo(){

            public boolean isAnonymousMember() {
                return true;
            }
        } : new SourceTypeElementInfo();
        info.setHandle(handle);
        info.setSourceRangeStart(typeInfo.declarationStart);
        info.setFlags(typeInfo.modifiers);
        info.setNameSourceStart(typeInfo.nameSourceStart);
        info.setNameSourceEnd(typeInfo.nameSourceEnd);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        char[] superclass = typeInfo.superclass;
        info.setSuperclassName(superclass == null ? null : manager.intern(superclass));
        char[][] superinterfaces = typeInfo.superinterfaces;
        int i = 0;
        int length = superinterfaces == null ? 0 : superinterfaces.length;
        while (i < length) {
            superinterfaces[i] = manager.intern(superinterfaces[i]);
            ++i;
        }
        info.setSuperInterfaceNames(superinterfaces);
        info.addCategories(handle, typeInfo.categories);
        if (parentHandle.getElementType() == 7) {
            ((SourceTypeElementInfo)parentInfo).addCategories(handle, typeInfo.categories);
        }
        this.addToChildren(parentInfo, handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
        if (typeInfo.typeParameters != null) {
            i = 0;
            length = typeInfo.typeParameters.length;
            while (i < length) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[i];
                this.enterTypeParameter(typeParameterInfo);
                this.exitMember(typeParameterInfo.declarationEnd);
                ++i;
            }
        }
        if (typeInfo.annotations != null) {
            int length2 = typeInfo.annotations.length;
            this.unitInfo.annotationNumber += length2;
            int i2 = 0;
            while (i2 < length2) {
                org.eclipse.jdt.internal.compiler.ast.Annotation annotation = typeInfo.annotations[i2];
                this.enterAnnotation(annotation, info, handle);
                this.exitMember(annotation.declarationSourceEnd);
                ++i2;
            }
        }
    }

    protected void enterTypeParameter(ISourceElementRequestor.TypeParameterInfo typeParameterInfo) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        String nameString = new String(typeParameterInfo.name);
        TypeParameter handle = this.createTypeParameter(parentHandle, nameString);
        this.resolveDuplicates(handle);
        TypeParameterElementInfo info = new TypeParameterElementInfo();
        info.setSourceRangeStart(typeParameterInfo.declarationStart);
        info.nameStart = typeParameterInfo.nameSourceStart;
        info.nameEnd = typeParameterInfo.nameSourceEnd;
        info.bounds = typeParameterInfo.bounds;
        if (parentInfo instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)parentInfo;
            ITypeParameter[] typeParameters = elementInfo.typeParameters;
            int length = typeParameters.length;
            ITypeParameter[] iTypeParameterArray = typeParameters;
            typeParameters = new ITypeParameter[length + 1];
            System.arraycopy(iTypeParameterArray, 0, typeParameters, 0, length);
            typeParameters[length] = handle;
            elementInfo.typeParameters = typeParameters;
        } else {
            SourceMethodElementInfo elementInfo = (SourceMethodElementInfo)parentInfo;
            ITypeParameter[] typeParameters = elementInfo.typeParameters;
            int length = typeParameters.length;
            ITypeParameter[] iTypeParameterArray = typeParameters;
            typeParameters = new ITypeParameter[length + 1];
            System.arraycopy(iTypeParameterArray, 0, typeParameters, 0, length);
            typeParameters[length] = handle;
            elementInfo.typeParameters = typeParameters;
        }
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void exitCompilationUnit(int declarationEnd) {
        if (this.importContainerInfo != null) {
            this.setChildren(this.importContainerInfo);
        }
        this.setChildren(this.unitInfo);
        this.unitInfo.setSourceLength(declarationEnd + 1);
        this.unitInfo.setIsStructureKnown(!this.hasSyntaxErrors);
    }

    public void exitConstructor(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        int length;
        Object typeInfo;
        int flags;
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationSourceEnd);
        this.setChildren(info);
        if (initializationStart != -1 && (Flags.isStatic(flags = info.flags) && Flags.isFinal(flags) || (typeInfo = this.infoStack.peek()) instanceof SourceTypeElementInfo && Flags.isInterface(((SourceTypeElementInfo)typeInfo).flags)) && (length = declarationEnd - initializationStart) > 0) {
            char[] initializer = new char[length];
            System.arraycopy(this.parser.scanner.source, initializationStart, initializer, 0, length);
            info.initializationSource = initializer;
        }
        this.handleStack.pop();
    }

    public void exitInitializer(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        SourceRefElementInfo info = (SourceRefElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.setChildren(info);
        this.handleStack.pop();
    }

    public void exitMethod(int declarationEnd, Expression defaultValue) {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.setChildren(info);
        if (info.isAnnotationMethod() && defaultValue != null) {
            SourceAnnotationMethodInfo annotationMethodInfo = (SourceAnnotationMethodInfo)info;
            annotationMethodInfo.defaultValueStart = defaultValue.sourceStart;
            annotationMethodInfo.defaultValueEnd = defaultValue.sourceEnd;
            JavaElement element = (JavaElement)this.handleStack.peek();
            MemberValuePair defaultMemberValuePair = new MemberValuePair(element.getElementName());
            defaultMemberValuePair.value = this.getMemberValue(defaultMemberValuePair, defaultValue);
            annotationMethodInfo.defaultValue = defaultMemberValuePair;
        }
        this.handleStack.pop();
    }

    public void exitType(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void resolveDuplicates(SourceRefElement handle) {
        while (this.newElements.containsKey(handle)) {
            ++handle.occurrenceCount;
        }
    }

    protected IMemberValuePair getMemberValuePair(org.eclipse.jdt.internal.compiler.ast.MemberValuePair memberValuePair) {
        String memberName = new String(memberValuePair.name);
        MemberValuePair result = new MemberValuePair(memberName);
        result.value = this.getMemberValue(result, memberValuePair.value);
        return result;
    }

    protected IMemberValuePair[] getMemberValuePairs(org.eclipse.jdt.internal.compiler.ast.MemberValuePair[] memberValuePairs) {
        int membersLength = memberValuePairs.length;
        IMemberValuePair[] members = new IMemberValuePair[membersLength];
        int j = 0;
        while (j < membersLength) {
            members[j] = this.getMemberValuePair(memberValuePairs[j]);
            ++j;
        }
        return members;
    }

    protected Object getMemberValue(MemberValuePair memberValuePair, Expression expression) {
        if (expression instanceof NullLiteral) {
            return null;
        }
        if (expression instanceof Literal) {
            ((Literal)expression).computeConstant();
            return Util.getAnnotationMemberValue(memberValuePair, expression.constant);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.Annotation) {
            org.eclipse.jdt.internal.compiler.ast.Annotation annotation = (org.eclipse.jdt.internal.compiler.ast.Annotation)expression;
            IAnnotation handle = this.enterAnnotation(annotation, null, (JavaElement)this.handleStack.peek());
            this.exitMember(annotation.declarationSourceEnd);
            memberValuePair.valueKind = 10;
            return handle;
        }
        if (expression instanceof ClassLiteralAccess) {
            ClassLiteralAccess classLiteral = (ClassLiteralAccess)expression;
            char[] name = CharOperation.concatWith(classLiteral.type.getTypeName(), '.');
            memberValuePair.valueKind = 11;
            return new String(name);
        }
        if (expression instanceof QualifiedNameReference) {
            char[] qualifiedName = CharOperation.concatWith(((QualifiedNameReference)expression).tokens, '.');
            memberValuePair.valueKind = 12;
            return new String(qualifiedName);
        }
        if (expression instanceof SingleNameReference) {
            char[] simpleName = ((SingleNameReference)expression).token;
            if (simpleName == RecoveryScanner.FAKE_IDENTIFIER) {
                memberValuePair.valueKind = 14;
                return null;
            }
            memberValuePair.valueKind = 13;
            return new String(simpleName);
        }
        if (expression instanceof ArrayInitializer) {
            memberValuePair.valueKind = -1;
            Expression[] expressions = ((ArrayInitializer)expression).expressions;
            int length = expressions == null ? 0 : expressions.length;
            Object[] values = new Object[length];
            int i = 0;
            while (i < length) {
                int previousValueKind = memberValuePair.valueKind;
                Object value = this.getMemberValue(memberValuePair, expressions[i]);
                if (previousValueKind != -1 && memberValuePair.valueKind != previousValueKind) {
                    memberValuePair.valueKind = 14;
                }
                values[i] = value;
                ++i;
            }
            if (memberValuePair.valueKind == -1) {
                memberValuePair.valueKind = 14;
            }
            return values;
        }
        return null;
    }

    private void setChildren(JavaElementInfo info) {
        ArrayList childrenList = (ArrayList)this.children.get(info);
        if (childrenList != null) {
            int length = childrenList.size();
            IJavaElement[] elements = new IJavaElement[length];
            childrenList.toArray(elements);
            info.children = elements;
        }
    }
}

