/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HelpTray
extends DialogTray
implements IPageChangedListener {
    public static final int MINIMUM_HEIGHT = 450;
    private static final int DEFAULT_WIDTH = 210;
    private int originalHeight;
    private int heightAdded;
    private FormToolkit toolkit;
    private ReusableHelpPart helpPart;
    private Shell shell;
    private IContributionItem closeAction;
    private Image normal;
    private Image hover;

    private void createActions() {
        this.createImages();
        this.closeAction = new ContributionItem(){

            public void fill(ToolBar parent, int index) {
                ToolItem item = new ToolItem(parent, 8);
                item.setImage(HelpTray.this.normal);
                item.setHotImage(HelpTray.this.hover);
                item.setToolTipText(Messages.ReusableHelpPart_closeAction_tooltip);
                item.addListener(13, new Listener(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void handleEvent(Event event) {
                        TrayDialog dialog = (TrayDialog)HelpTray.access$2(1.access$0(this.this$1)).getData();
                        dialog.closeTray();
                        HelpTray.access$2(1.access$0(this.this$1)).setFocus();
                    }
                });
            }

            static /* synthetic */ HelpTray access$0(1 var0) {
                return var0.HelpTray.this;
            }
        };
    }

    protected Control createContents(Composite parent) {
        this.ensureMinimumHeight(parent.getShell());
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        this.toolkit.getColors().initializeSectionToolBarColors();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        container.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                HelpTray.this.dispose();
            }
        });
        ToolBarManager tbm = new ToolBarManager(0x800000);
        tbm.createControl(container);
        GridData gd = new GridData(128);
        gd.grabExcessHorizontalSpace = true;
        tbm.getControl().setLayoutData((Object)gd);
        Label separator = new Label(container, 258);
        gd = new GridData(256);
        gd.heightHint = 1;
        separator.setLayoutData((Object)gd);
        this.helpPart = new ReusableHelpPart((IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        this.helpPart.init(null, (IToolBarManager)tbm, null, null);
        this.helpPart.setDefaultContextHelpText(Messages.HelpView_defaultText);
        this.helpPart.createControl(container, this.toolkit);
        gd = new GridData(1808);
        gd.widthHint = 210;
        this.helpPart.getControl().setLayoutData((Object)gd);
        this.createActions();
        tbm.add(this.closeAction);
        this.shell = parent.getShell();
        this.hookPageChangeListener((Composite)this.shell);
        this.helpPart.getControl().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                HelpTray.this.unhookPageChangeListener((Composite)HelpTray.this.shell);
            }
        });
        return container;
    }

    private void createImages() {
        Display display = Display.getCurrent();
        int[] shape = new int[]{3, 3, 5, 3, 7, 5, 8, 5, 10, 3, 12, 3, 12, 5, 10, 7, 10, 8, 12, 10, 12, 12, 10, 12, 8, 10, 7, 10, 5, 12, 3, 12, 3, 10, 5, 8, 5, 7, 3, 5};
        Color border = display.getSystemColor(17);
        Color background = display.getSystemColor(25);
        Color backgroundHot = new Color((Device)display, new RGB(252, 160, 160));
        Color transparent = display.getSystemColor(11);
        PaletteData palette = new PaletteData(new RGB[]{transparent.getRGB(), border.getRGB(), background.getRGB(), backgroundHot.getRGB()});
        ImageData data = new ImageData(16, 16, 8, palette);
        data.transparentPixel = 0;
        this.normal = new Image((Device)display, data);
        this.normal.setBackground(transparent);
        GC gc = new GC((Drawable)this.normal);
        gc.setBackground(background);
        gc.fillPolygon(shape);
        gc.setForeground(border);
        gc.drawPolygon(shape);
        gc.dispose();
        this.hover = new Image((Device)display, data);
        this.hover.setBackground(transparent);
        gc = new GC((Drawable)this.hover);
        gc.setBackground(backgroundHot);
        gc.fillPolygon(shape);
        gc.setForeground(border);
        gc.drawPolygon(shape);
        gc.dispose();
        backgroundHot.dispose();
    }

    private void dispose() {
        this.normal.dispose();
        this.hover.dispose();
        this.toolkit.dispose();
        this.helpPart.dispose();
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                HelpTray.this.shell.removeListener(11, (Listener)this);
                Point p = HelpTray.this.shell.getSize();
                if (HelpTray.this.heightAdded > 0 && p.y > HelpTray.this.originalHeight) {
                    p.y = Math.max(p.y - HelpTray.this.heightAdded, HelpTray.this.originalHeight);
                    HelpTray.this.shell.setSize(p);
                }
            }
        });
    }

    private void ensureMinimumHeight(Shell shell) {
        Point p = shell.getSize();
        this.originalHeight = p.y;
        if (p.y < 450) {
            this.heightAdded = 450 - p.y;
            p.y = 450;
            shell.setSize(p);
        } else {
            this.heightAdded = 0;
        }
    }

    public ReusableHelpPart getHelpPart() {
        return this.helpPart;
    }

    private void hookPageChangeListener(Composite parent) {
        Object data = parent.getData();
        if (data instanceof IPageChangeProvider) {
            ((IPageChangeProvider)data).addPageChangedListener((IPageChangedListener)this);
        }
    }

    public static boolean isAppropriateFor(Shell shell) {
        if (shell != null && !shell.isDisposed() && shell.isVisible()) {
            Object data = shell.getData();
            return data instanceof TrayDialog && (shell.getSize().y >= 450 || (shell.getStyle() & 0x10) != 0);
        }
        return false;
    }

    public void pageChanged(PageChangedEvent event) {
        Object page = event.getSelectedPage();
        Control c = null;
        if (page instanceof IDialogPage) {
            c = ((IDialogPage)page).getControl();
        } else {
            TabFolder folder;
            TabItem[] selection;
            c = this.shell.getDisplay().getFocusControl();
            if (c instanceof TabFolder && (selection = (folder = (TabFolder)c).getSelection()).length == 1) {
                c = selection[0].getControl();
            }
        }
        this.helpPart.update(null, null, null, c, false);
    }

    private void unhookPageChangeListener(Composite parent) {
        Object data = parent.getData();
        if (data instanceof IPageChangeProvider) {
            ((IPageChangeProvider)data).removePageChangedListener((IPageChangedListener)this);
        }
    }
}

